/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.singleton.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.collective.singleton.SingletonServiceMessengerMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.collective.member.security.SingletonAuthorizer;
import com.ibm.ws.collective.singleton.ServiceEndpointIdentityImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collective.singleton.ServiceEndpointIdentity;
import com.ibm.wsspi.collective.singleton.SingletonService;
import com.ibm.wsspi.collective.singleton.extender.SingletonServiceExtender;
import com.ibm.wsspi.collective.singleton.messaging.Message;
import com.ibm.wsspi.collective.singleton.messaging.StringMessage;
import com.ibm.wsspi.collective.singleton.provider.Participant;
import com.ibm.wsspi.collective.singleton.provider.SingletonServiceManagerProvider;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.kernel.service.utils.ServerQuiesceListener;
import com.ibm.wsspi.ssl.SSLConfiguration;
import java.security.AccessControlException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={SingletonServiceMessengerMBean.class, DynamicMBean.class, ServerQuiesceListener.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "jmx.objectname=WebSphere:feature=collectiveMember,type=SingletonServiceMessenger,name=SingletonServiceMessenger"})
public class SingletonServiceMessengerMBeanImpl
extends StandardMBean
implements SingletonServiceMessengerMBean,
ServerQuiesceListener {
    private static final TraceComponent tc = Tr.register(SingletonServiceMessengerMBeanImpl.class);
    static final String SSL_CONFIG_ID = "controllerConnectionConfig";
    private SingletonServiceManagerProvider singletonServiceManager = null;
    private SingletonAuthorizer authorizer = null;
    private SSLConfiguration sslConfig = null;
    private ExecutorService executorService = null;
    private volatile boolean stopping = false;
    static final long serialVersionUID = 3547634317214376915L;

    public SingletonServiceMessengerMBeanImpl() throws NotCompliantMBeanException {
        super(SingletonServiceMessengerMBean.class);
    }

    @Reference(service=SingletonServiceManagerProvider.class)
    protected void setSingletonServiceManager(SingletonServiceManagerProvider singletonServiceManager) {
        this.singletonServiceManager = singletonServiceManager;
    }

    protected void unsetSingletonServiceManager(SingletonServiceManagerProvider singletonServiceManager) {
        if (this.singletonServiceManager == singletonServiceManager) {
            this.singletonServiceManager = null;
        }
    }

    @Reference(service=SingletonAuthorizer.class)
    protected void setSingletonAuthorizer(SingletonAuthorizer authorizer) {
        this.authorizer = authorizer;
    }

    protected void unsetSingletonAuthorizer(SingletonAuthorizer authorizer) {
        if (this.authorizer == authorizer) {
            this.authorizer = null;
        }
    }

    @Reference(service=SSLConfiguration.class, target="(id=controllerConnectionConfig)")
    protected void setSSLConfiguration(SSLConfiguration sslConfig) {
        this.sslConfig = sslConfig;
    }

    protected void unsetSSLConfiguration(SSLConfiguration sslConfig) {
        if (this.sslConfig == sslConfig) {
            this.sslConfig = null;
        }
    }

    @Reference(service=ExecutorService.class)
    protected void setExecutorService(ExecutorService svc) {
        this.executorService = svc;
    }

    protected void unsetExecutorService(ExecutorService svc) {
        if (this.executorService == svc) {
            this.executorService = null;
        }
    }

    @Activate
    protected void activate() {
        Tr.info((TraceComponent)tc, (String)"MESSENGER_MBEAN_ACTIVATED", (Object[])new Object[0]);
    }

    @Deactivate
    protected void deactivate() {
        Tr.info((TraceComponent)tc, (String)"MESSENGER_MBEAN_DEACTIVATED", (Object[])new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void deliverMessage(byte[] bytes, String type, String source, String destination, Properties properties) throws IllegalArgumentException {
        Message message = this.reconstructMessage(bytes, type, source, destination);
        ServiceEndpointIdentity destinationID = message.getDestination();
        this.isAuthorized(destinationID, "deliverMessage");
        String serviceName = destinationID.getServiceName();
        SingletonService.SingletonScope scope = destinationID.getServiceScope();
        if (this.stopping) {
            if (!tc.isDebugEnabled()) return;
            Tr.debug((TraceComponent)tc, (String)"Server is stopping.  Ignore incoming message.", (Object[])new Object[0]);
            return;
        }
        SingletonService service = this.getService(serviceName, scope);
        if (service != null) {
            Participant participant = service.getLocalParticipant();
            if (participant == null) {
                String msg = "The " + scope + " scoped service named " + serviceName + " has no registered participant";
                if (!tc.isEventEnabled()) throw new IllegalArgumentException(msg);
                Tr.event((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
                throw new IllegalArgumentException(msg);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("executing delivery task: scope = " + scope + ", service = " + service), (Object[])new Object[0]);
            }
            this.executorService.execute(new DeliveryTask(participant, message));
            return;
        }
        String msg = "The " + scope + " scoped service named " + serviceName + " does not exist";
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
        }
        if (!FrameworkState.isStopping()) throw new IllegalArgumentException(msg);
        throw new IllegalStateException(msg);
    }

    private SingletonService getService(String serviceName, SingletonService.SingletonScope scope) {
        Set services = this.singletonServiceManager.getServices(scope);
        SingletonServiceExtender service = null;
        for (SingletonServiceExtender s : services) {
            if (!s.getName().equals(serviceName)) continue;
            service = s;
            break;
        }
        return service;
    }

    private void isAuthorized(ServiceEndpointIdentity destinationIdentity, String operation) throws AccessControlException {
        if (this.authorizer == null) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Unable to get the SingletonAuthorizer, the service may be stopping or the server may be shutting down. In either case, access denied to: " + destinationIdentity), (Object[])new Object[0]);
            }
            String msg = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.collective.singleton.internal.resources.SingletonMessages", (String)"SINGLETON_AUTHORIZER_DENIED", (Object[])new Object[]{operation}, (String)"CWWKX1009E: The SingletonServiceMessenger MBean {0} operation cannot be completed. The SingletonAuthorizer is unreachable.");
            if (FrameworkState.isStopping()) {
                IllegalStateException ise = new IllegalStateException(msg);
                ise.fillInStackTrace();
                throw ise;
            }
            AccessControlException acl = new AccessControlException(msg);
            acl.fillInStackTrace();
            throw acl;
        }
        this.authorizer.isAuthorized(operation);
    }

    private Message reconstructMessage(byte[] bytes, String type, String source, String destination) throws IllegalArgumentException {
        StringMessage message = null;
        ServiceEndpointIdentity sourceId = this.getIdFromCanonicalForm(source);
        ServiceEndpointIdentity destinationId = this.getIdFromCanonicalForm(destination);
        this.validateDestination(destinationId);
        if (type == null) {
            throw new IllegalArgumentException("Received message has a null type");
        }
        if (!type.equalsIgnoreCase("String")) {
            throw new IllegalArgumentException("Received message type is not valid: " + type);
        }
        String s = new String(bytes);
        message = new StringMessage(sourceId, destinationId, s);
        return message;
    }

    private ServiceEndpointIdentity getIdFromCanonicalForm(String s) {
        ServiceEndpointIdentityImpl id = new ServiceEndpointIdentityImpl();
        id.fromCanonicalForm(s);
        return id;
    }

    private void validateDestination(ServiceEndpointIdentity destination) throws IllegalArgumentException {
    }

    public void serverStopping() {
        this.stopping = true;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    class DeliveryTask
    implements Runnable {
        Participant destination;
        Message message;
        static final long serialVersionUID = 3629896772489643566L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public DeliveryTask(Participant destination, Message message) {
            this.destination = destination;
            this.message = message;
        }

        @Override
        public void run() {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("delivering message for: scope = " + this.destination.getIdentity().getServiceScope() + ", service = " + this.destination.getIdentity().getServiceName()), (Object[])new Object[0]);
            }
            this.destination.receiveMessage(this.message);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(DeliveryTask.class);
        }
    }
}

