/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.singleton.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.collective.singleton.internal.MessengerConnectionHelper;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collective.singleton.ServiceEndpointIdentity;
import com.ibm.wsspi.collective.singleton.messaging.Message;
import com.ibm.wsspi.collective.singleton.messaging.Messenger;
import com.ibm.wsspi.collective.singleton.provider.SingletonServiceManagerProvider;
import com.ibm.wsspi.ssl.SSLSupport;
import java.io.IOException;
import java.util.Properties;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class MessengerImpl
implements Messenger {
    private static final TraceComponent tc = Tr.register(MessengerImpl.class);
    private static final int DEFAULT_READ_TIMEOUT_MILLISECONDS = 60000;
    private final int readTimeoutMillis = 60000;
    private SingletonServiceManagerProvider manager;
    private MessengerConnectionHelper helper;
    private SSLSupport sslSupport;
    static final long serialVersionUID = -2804623107599771418L;

    private MessengerConnectionHelper getHelper(String host, int port) {
        MessengerConnectionHelper newHelper;
        if (this.helper != null) {
            newHelper = this.helper;
        } else {
            JSSEHelper jsseHelper = this.manager.getSSLSupport().getJSSEHelper();
            newHelper = new MessengerConnectionHelper(jsseHelper, host, port, 60000, "controllerConnectionConfig");
        }
        return newHelper;
    }

    @FFDCIgnore(value={IOException.class})
    public boolean send(Message message) {
        boolean sent = true;
        if (message == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Message is null.", (Object[])new Object[0]);
            }
            return false;
        }
        String source = "";
        String destination = "";
        String host = "";
        int port = 0;
        try {
            ServiceEndpointIdentity destinationEP;
            ServiceEndpointIdentity sourceEPI = message.getSource();
            if (sourceEPI != null) {
                source = sourceEPI.toCanonicalForm();
            }
            if ((destinationEP = message.getDestination()) != null) {
                destination = destinationEP.toCanonicalForm();
                if (destination == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Destination is null.", (Object[])new Object[0]);
                    }
                    return false;
                }
                host = destinationEP.getHostName();
                if (host == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Host is null.", (Object[])new Object[0]);
                    }
                    return false;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Destination endpoint is null.", (Object[])new Object[0]);
                }
                return false;
            }
            port = destinationEP.getPort();
            byte[] payload = message.getBytes();
            if (payload == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Payload is null.", (Object[])new Object[0]);
                }
                return false;
            }
            String msgType = message.getType();
            if (msgType != "String") {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Message type is not supported.", (Object[])new Object[0]);
                }
                return false;
            }
            MessengerConnectionHelper helper = this.getHelper(host, port);
            Properties properties = new Properties();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("MessengerImpl.send to host:port=" + host + ":" + port + " source=" + source + " destination=" + destination + " type=" + msgType + " msg=" + new String(payload)), (Object[])new Object[0]);
            }
            Object[] params = new Object[]{payload, msgType, source, destination, properties};
            String[] signature = new String[]{"[B", "java.lang.String", "java.lang.String", "java.lang.String", "java.util.Properties"};
            helper.invoke("deliverMessage", params, signature);
            helper.disconnectRemoteConnection();
        }
        catch (IOException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Failed sending message. Error:" + e), (Object[])new Object[0]);
            }
            sent = false;
        }
        return sent;
    }

    protected void setSingletonServiceManager(SingletonServiceManagerProvider manager) {
        this.manager = manager;
    }

    protected void setMessengerConnectionHelper(MessengerConnectionHelper helper) {
        this.helper = helper;
    }

    protected void setSSLSupport(SSLSupport ssl) {
        this.sslSupport = ssl;
    }
}

