/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.member.internal.publisher;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MXBean;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class MBeanAttributeDiscovery {
    static final long serialVersionUID = -2567354107204098156L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    MBeanAttributeDiscovery() {
    }

    protected static List<Attribute> discoverAttributes(Object mbean) throws NotCompliantMBeanException {
        List<Attribute> retMe = null;
        if (mbean instanceof DynamicMBean) {
            retMe = MBeanAttributeDiscovery.discoverDynamicMBeanAttributes((DynamicMBean)mbean);
        } else {
            Class<?> mbeanIntf = MBeanAttributeDiscovery.getMBeanInterface(mbean.getClass());
            if (mbeanIntf == null) {
                mbeanIntf = MBeanAttributeDiscovery.getMXBeanInterface(mbean.getClass());
            }
            if (mbeanIntf != null) {
                retMe = MBeanAttributeDiscovery.discoverMBeanAttributes(mbean, mbeanIntf);
            }
        }
        if (retMe == null) {
            retMe = new ArrayList<Attribute>();
        }
        return retMe;
    }

    private static Class<?> getMBeanInterface(Class<?> mbeanClass) {
        Class<?>[] intfs;
        String mbeanClassName = mbeanClass.getName();
        for (Class<?> intf : intfs = mbeanClass.getInterfaces()) {
            if (!intf.getName().equals(mbeanClassName + "MBean")) continue;
            return intf;
        }
        Class<?> superclass = mbeanClass.getSuperclass();
        if (superclass != null) {
            return MBeanAttributeDiscovery.getMBeanInterface(superclass);
        }
        return null;
    }

    private static List<Attribute> discoverMBeanAttributes(Object mbean, Class<?> mbeanIntf) {
        List<Method> attrGetters = MBeanAttributeDiscovery.getAttributeGetterMethods(mbeanIntf);
        return MBeanAttributeDiscovery.getAttributesViaReflection(mbean, attrGetters);
    }

    /*
     * WARNING - void declaration
     */
    private static List<Attribute> getAttributesViaReflection(Object mbean, List<Method> attrGetters) {
        ArrayList<Attribute> retMe = new ArrayList<Attribute>();
        for (Method attrGetter : attrGetters) {
            try {
                String attrName = MBeanAttributeDiscovery.getAttributeNameFromGetter(attrGetter);
                Object attrValue = attrGetter.invoke(mbean, (Object[])null);
                retMe.add(new Attribute(attrName, attrValue));
            }
            catch (IllegalAccessException attrName) {
                void iae;
                FFDCFilter.processException((Throwable)attrName, (String)"com.ibm.ws.collective.member.internal.publisher.MBeanAttributeDiscovery", (String)"172", null, (Object[])new Object[]{mbean, attrGetters});
                throw new RuntimeException((Throwable)iae);
            }
            catch (InvocationTargetException iae) {
                void ite;
                FFDCFilter.processException((Throwable)iae, (String)"com.ibm.ws.collective.member.internal.publisher.MBeanAttributeDiscovery", (String)"175", null, (Object[])new Object[]{mbean, attrGetters});
                throw new RuntimeException((Throwable)ite);
            }
        }
        return retMe;
    }

    private static String getAttributeNameFromGetter(Method attrGetter) {
        String methodName = attrGetter.getName();
        return methodName.startsWith("get") ? methodName.substring(3) : methodName.substring(2);
    }

    private static List<Method> getAttributeGetterMethods(Class<?> mbeanIntf) {
        Method[] methods;
        ArrayList<Method> retMe = new ArrayList<Method>();
        for (Method method : methods = mbeanIntf.getMethods()) {
            if (!MBeanAttributeDiscovery.isGetterMethod(method)) continue;
            retMe.add(method);
        }
        return retMe;
    }

    private static boolean isGetterMethod(Method method) {
        String methodName = method.getName();
        return (methodName.startsWith("get") && !methodName.equals("get") || methodName.startsWith("is") && !methodName.equals("is")) && method.getParameterTypes().length == 0 && !method.getReturnType().equals(Void.TYPE);
    }

    private static Class<?> getMXBeanInterface(Class<?> mbeanClass) throws NotCompliantMBeanException {
        Class<?>[] intfs = mbeanClass.getInterfaces();
        Class<?> retMe = null;
        for (Class<?> intf : intfs) {
            if (!MBeanAttributeDiscovery.isMXBeanInterface(intf)) continue;
            retMe = MBeanAttributeDiscovery.pickSubClass(retMe, intf);
        }
        Class<?> superclass = mbeanClass.getSuperclass();
        if (superclass != null) {
            retMe = MBeanAttributeDiscovery.pickSubClass(retMe, MBeanAttributeDiscovery.getMXBeanInterface(superclass));
        }
        return retMe;
    }

    private static Class<?> pickSubClass(Class<?> clazz1, Class<?> clazz2) throws NotCompliantMBeanException {
        if (clazz1 == null) {
            return clazz2;
        }
        if (clazz2 == null) {
            return clazz1;
        }
        if (clazz1.isAssignableFrom(clazz2)) {
            return clazz2;
        }
        if (clazz2.isAssignableFrom(clazz1)) {
            return clazz1;
        }
        throw new NotCompliantMBeanException("Multiple MXBean interfaces that are not hierarchical");
    }

    private static boolean isMXBeanInterface(Class<?> intf) {
        MXBean anno;
        return intf.getName().endsWith("MXBean") && !intf.getName().equals("MXBean") ? (anno = intf.getAnnotation(MXBean.class)) == null || anno.value() : (anno = intf.getAnnotation(MXBean.class)) != null && anno.value();
    }

    private static List<Attribute> discoverDynamicMBeanAttributes(DynamicMBean mBean) {
        MBeanAttributeInfo[] mBeanAttributes;
        ArrayList<Attribute> retMe = new ArrayList<Attribute>();
        for (MBeanAttributeInfo attribute : mBeanAttributes = mBean.getMBeanInfo().getAttributes()) {
            if (!attribute.isReadable()) continue;
            String attributeName = attribute.getName();
            try {
                Object attributeValue = mBean.getAttribute(attributeName);
                retMe.add(new Attribute(attributeName, attributeValue));
            }
            catch (AttributeNotFoundException attributeValue) {
                FFDCFilter.processException((Throwable)attributeValue, (String)"com.ibm.ws.collective.member.internal.publisher.MBeanAttributeDiscovery", (String)"351", null, (Object[])new Object[]{mBean});
            }
            catch (MBeanException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.member.internal.publisher.MBeanAttributeDiscovery", (String)"353", null, (Object[])new Object[]{mBean});
            }
            catch (ReflectionException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.member.internal.publisher.MBeanAttributeDiscovery", (String)"355", null, (Object[])new Object[]{mBean});
            }
        }
        return retMe;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(MBeanAttributeDiscovery.class);
    }
}

