/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.member.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.collective.member.heartbeat.HeartBeatSender;
import com.ibm.ws.collective.member.heartbeat.RepositoryMemberHeartBeat;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={HeartBeatSender.class}, property={"service.vendor=IBM"})
public class HeartBeatSenderImpl
implements HeartBeatSender {
    private static final TraceComponent tc = Tr.register(HeartBeatSenderImpl.class);
    static final String KEY_EXECUTOR = "executor";
    private final AtomicServiceReference<ScheduledExecutorService> executorRef = new AtomicServiceReference("executor");
    private final Map<RepositoryMemberHeartBeat, ScheduledFuture<?>> futures = new HashMap();
    static final long serialVersionUID = 3556751969518059510L;

    @Reference(name="executor", service=ScheduledExecutorService.class)
    protected synchronized void setExecutor(ServiceReference<ScheduledExecutorService> ref) {
        this.executorRef.setReference(ref);
    }

    protected synchronized void unsetExecutor(ServiceReference<ScheduledExecutorService> ref) {
        this.cancelAllHeartBeats();
        this.executorRef.unsetReference(ref);
    }

    @Activate
    protected synchronized void activate(ComponentContext cc) {
        this.executorRef.activate(cc);
    }

    @Deactivate
    protected synchronized void deactivate(ComponentContext cc) {
        this.cancelAllHeartBeats();
        this.executorRef.deactivate(cc);
    }

    private void cancelAllHeartBeats() {
        for (RepositoryMemberHeartBeat repoMember : this.futures.keySet()) {
            this.cancelHeartBeat(repoMember);
        }
    }

    public synchronized boolean cancelHeartBeat(RepositoryMemberHeartBeat repositoryMember) {
        boolean retMe = false;
        ScheduledFuture<?> future = this.futures.remove(repositoryMember);
        if (future != null) {
            retMe = future.cancel(true);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Canceled heartbeat", (Object[])new Object[0]);
            }
        }
        return retMe;
    }

    public synchronized void startHeartBeat(RepositoryMemberHeartBeat repositoryMember, int heartBeatInterval) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Starting heartbeat for member on internal " + heartBeatInterval), (Object[])new Object[0]);
        }
        this.cancelHeartBeat(repositoryMember);
        HeartbeatSender task = new HeartbeatSender(repositoryMember);
        ScheduledFuture<?> future = this.getScheduledExecutorServiceService().scheduleWithFixedDelay(task, heartBeatInterval, heartBeatInterval, TimeUnit.SECONDS);
        this.futures.put(repositoryMember, future);
    }

    @Trivial
    private ScheduledExecutorService getScheduledExecutorServiceService() {
        ScheduledExecutorService service = (ScheduledExecutorService)this.executorRef.getService();
        if (service == null) {
            if (FrameworkState.isStopping()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Ignore that ScheduledExecutorServiceService is null because Framework is in the process of stopping or already stopped", (Object[])new Object[0]);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ScheduledExecutorServiceService is null and Framework is not in the process of stopping or already stopped", (Object[])new Object[0]);
                }
                IllegalStateException ise = new IllegalStateException("The ScheduledExecutorService service is not available - it was likely accessed after it was deactivated.");
                ise.fillInStackTrace();
                throw ise;
            }
        }
        return service;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    class HeartbeatSender
    implements Runnable {
        private final TraceComponent tc = Tr.register(HeartbeatSender.class);
        private final RepositoryMemberHeartBeat repositoryMember;
        private boolean needsToReregister = false;
        static final long serialVersionUID = 3268100038661908938L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        HeartbeatSender(RepositoryMemberHeartBeat repositoryMember) {
            this.repositoryMember = repositoryMember;
        }

        @FFDCIgnore(value={IOException.class, IllegalArgumentException.class, IllegalStateException.class})
        private boolean sendHeartBeat() {
            block11: {
                try {
                    this.repositoryMember.sendHeartBeat();
                }
                catch (IOException e) {
                    if (this.tc.isEventEnabled()) {
                        Tr.event((TraceComponent)this.tc, (String)"IOException while sending heart beat, this can happen if we have lost our connection to the controller", (Object[])new Object[]{e});
                    }
                }
                catch (IllegalArgumentException e) {
                    if (this.tc.isEventEnabled()) {
                        Tr.event((TraceComponent)this.tc, (String)"IllegalArgumentException while sending heart beat, this can happen if our heartbeats got interupted and we were marked dead. Time to re-register!", (Object[])new Object[]{e});
                    }
                    if (e.getMessage().contains("CWWKX9002E")) {
                        return true;
                    }
                }
                catch (IllegalStateException e) {
                    if (FrameworkState.isStopping()) {
                        if (this.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)this.tc, (String)"Ignoring IllegalStateException because server is stopping.", (Object[])new Object[0]);
                        }
                    } else {
                        FFDCFilter.processException((Throwable)e, (String)"HeartBeatSenderImpl.sendHeartBeat", (String)"225", (Object)this);
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.member.internal.HeartBeatSenderImpl$HeartbeatSender", (String)"227", (Object)this, (Object[])new Object[0]);
                    if (!this.tc.isEventEnabled()) break block11;
                    Tr.event((TraceComponent)this.tc, (String)"Unexpected Exception while sending heart beat", (Object[])new Object[]{e});
                }
            }
            return false;
        }

        @FFDCIgnore(value={IOException.class})
        private boolean reregisterWithRepository() {
            block5: {
                if (this.tc.isEventEnabled()) {
                    Tr.event((TraceComponent)this.tc, (String)"Re-registering as a member", (Object[])new Object[0]);
                }
                try {
                    this.repositoryMember.deregisterMember();
                    this.repositoryMember.registerMember();
                    return false;
                }
                catch (IOException e) {
                    if (this.tc.isEventEnabled()) {
                        Tr.event((TraceComponent)this.tc, (String)"IOException while attempting to re-register, this can happen if we have lost our connection to the controller", (Object[])new Object[]{e});
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.member.internal.HeartBeatSenderImpl$HeartbeatSender", (String)"256", (Object)this, (Object[])new Object[0]);
                    if (!this.tc.isEventEnabled()) break block5;
                    Tr.event((TraceComponent)this.tc, (String)"Unexpected Exception while sending heart beat", (Object[])new Object[]{e});
                }
            }
            return true;
        }

        @Override
        public void run() {
            if (this.tc.isEventEnabled()) {
                Tr.event((TraceComponent)this.tc, (String)"Sending heartbeat", (Object[])new Object[0]);
            }
            if (!this.needsToReregister) {
                this.needsToReregister = this.sendHeartBeat();
            }
            if (this.needsToReregister) {
                this.needsToReregister = this.reregisterWithRepository();
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(HeartbeatSender.class);
        }
    }
}

