/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.member;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DockerEnvironmentUtil {
    private static final TraceComponent tc = Tr.register(DockerEnvironmentUtil.class);
    private static final String DOCKER_PROP_FILE_NAME = "env.properties";
    private static String DOCKER_PROP_FILE_PATH = "/opt/ibm/docker/env.properties";
    public static final String DOCKER_CONTAINER_HOST_NAME = "containerHost";
    public static final String DOCKER_CONTAINER_NAME = "containerName";
    public static final String DOCKER_USER_DIR = "Docker";
    static final long serialVersionUID = -6001044182128356519L;

    public static boolean isMemberInDockerEnvironment() {
        final File dockerPropFile = new File(DOCKER_PROP_FILE_PATH);
        Object propFileExist = AccessController.doPrivileged(new PrivilegedAction<Object>(){
            static final long serialVersionUID = 5135067806734232230L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            @Trivial
            @FFDCIgnore(value={SecurityException.class})
            public Object run() {
                try {
                    return dockerPropFile.exists();
                }
                catch (SecurityException se) {
                    return se;
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        if (propFileExist instanceof SecurityException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Failed to read " + DOCKER_PROP_FILE_PATH + ": " + ((SecurityException)propFileExist).getMessage()), (Object[])new Object[0]);
            }
            return false;
        }
        return (Boolean)propFileExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={FileNotFoundException.class, IOException.class})
    public static String getContainerPropertyFromEnvironment(String propName) {
        FileInputStream fis = null;
        Properties fileProperties = new Properties();
        String propValue = null;
        try {
            fis = new FileInputStream(DOCKER_PROP_FILE_PATH);
            fileProperties.load(fis);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(DockerEnvironmentUtil.class, (TraceComponent)tc, (String)"Loaded Docker env.properties", (Object[])new Object[0]);
            }
        }
        catch (FileNotFoundException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(DockerEnvironmentUtil.class, (TraceComponent)tc, (String)"Docker env.properties not found", (Object[])new Object[0]);
            }
        }
        catch (IOException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(DockerEnvironmentUtil.class, (TraceComponent)tc, (String)("Docker env.properties failed to open: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        finally {
            block21: {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block21;
                        Tr.debug(DockerEnvironmentUtil.class, (TraceComponent)tc, (String)("Docker env.properties failed to close: " + e.getMessage()), (Object[])new Object[0]);
                    }
                }
            }
        }
        if ((propValue = fileProperties.getProperty(propName)) != null) {
            propValue = propValue.trim();
        }
        return propValue;
    }
}

