/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.logging;

import com.ibm.wsspi.webcontainer.logging.LoggerHelper;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;

public class LoggerFactory {
    private static boolean override;
    private static ClassLoader classloader;
    private static String classname;
    private static LoggerFactory helper;
    public static final String MESSAGES = "com.ibm.ws.webcontainer.resources.Messages";

    private LoggerFactory() {
    }

    public static synchronized LoggerFactory getInstance() {
        if (helper != null) {
            return helper;
        }
        if (override) {
            try {
                helper = (LoggerFactory)Class.forName(classname, false, LoggerFactory.getClassLoader()).newInstance();
            }
            catch (ClassNotFoundException e) {
                helper = new LoggerFactory();
            }
            catch (IllegalAccessException e) {
                helper = new LoggerFactory();
            }
            catch (InstantiationException e) {
                helper = new LoggerFactory();
            }
            return helper;
        }
        helper = new LoggerFactory();
        return helper;
    }

    public Logger getLogger(final String name, final String bundle) {
        return AccessController.doPrivileged(new PrivilegedAction<Logger>(){

            @Override
            public Logger run() {
                return Logger.getLogger(name, bundle);
            }
        });
    }

    public Logger getLogger(String name) {
        return this.getLogger(name, MESSAGES);
    }

    public static ClassLoader getClassLoader() {
        return classloader == null ? LoggerHelper.class.getClassLoader() : classloader;
    }

    public static void setClassloader(ClassLoader loader) {
        classloader = loader;
    }

    public static void setClassname(String name) {
        classname = name;
    }

    public static void setOverride(boolean value) {
        override = value;
    }
}

