/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.annotation;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webcontainer.osgi.webapp.WebApp;
import com.ibm.wsspi.webcontainer.annotation.AnnotationHelper;
import com.ibm.wsspi.webcontainer.facade.ServletContextFacade;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;

public class AnnotationHelperManager {
    private static Map<ServletContext, AnnotationHelperManager> servletContextToAnnotationHelperManagerMap = new Hashtable<ServletContext, AnnotationHelperManager>();
    protected static final Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.annotation");
    protected static final String CLASS_NAME = "com.ibm.wsspi.webcontainer.annotation.AnnotationHelperManager";
    private WebApp wApp;
    private AnnotationHelper aHelper;

    public static void addInstance(ServletContext context, AnnotationHelperManager annoHelperMgr) {
        servletContextToAnnotationHelperManagerMap.put(context, annoHelperMgr);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addInstance", "added instance with key: " + context);
        }
    }

    public static void removeInstance(ServletContext context) {
        servletContextToAnnotationHelperManagerMap.remove(context);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "removeInstance", "remove instance with key: " + context);
        }
    }

    public AnnotationHelperManager(ServletContext iApp) {
        block2: {
            this.wApp = null;
            this.aHelper = null;
            try {
                this.wApp = (WebApp)iApp;
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block2;
                logger.logp(Level.FINE, CLASS_NAME, "constructor", "can set up webApp in AnnotationHelperManager constructor.  Exception: " + e);
            }
        }
    }

    public static synchronized AnnotationHelperManager getInstance(ServletContext context) {
        IServletContext servletContext = AnnotationHelperManager.unwrapServletContext(context);
        AnnotationHelperManager instance = servletContextToAnnotationHelperManagerMap.get(servletContext);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getInstance", "context: " + context + "  gave AHM instance --> [" + instance + "]");
        }
        return instance;
    }

    private static IServletContext unwrapServletContext(ServletContext context) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "unwrapServletContext", "original context->" + context);
        }
        while (context instanceof ServletContextFacade) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "unwrapServletContext", "nested context->" + context);
            }
            context = ((ServletContextFacade)context).getIServletContext();
        }
        return (IServletContext)context;
    }

    public synchronized AnnotationHelper getAnnotationHelper() {
        if (this.aHelper == null) {
            this.aHelper = new AnnotationHelper(this.wApp);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getAnnotationHelper", "created new annotation helper instance --> [" + this.aHelper + "]");
            }
        }
        return this.aHelper;
    }

    public static void verifyClassIsLoaded() {
    }
}

