/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.util;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.FileSystem;
import com.ibm.ws.util.WSUtil;
import com.ibm.ws.webcontainer.util.EDRPathEntry;
import com.ibm.ws.webcontainer.util.EntryResource;
import com.ibm.ws.webcontainer.util.ExtDocRootFile;
import com.ibm.ws.webcontainer.util.FileResource;
import com.ibm.ws.webcontainer.util.ZipFileResource;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletContext;

public class ExtendedDocumentRootUtils {
    private static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.util");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.util.ExtendedDocumentRootUtils";
    private static boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
    private List<EDRPathEntry> searchPath = new ArrayList<EDRPathEntry>();
    private boolean useContentLength = false;
    private Container earContainer = null;
    private ExtDocRootFile extDocRootFile;

    public ExtDocRootFile getExtDocRootFile() {
        return this.extDocRootFile;
    }

    public ExtendedDocumentRootUtils(ServletContext ctxt, String extendedDocumentRoot) {
        if (extendedDocumentRoot != null) {
            Container moduleContainer;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "ExtendedDocumentRootUtils", "extendedDocumentRoot --> " + extendedDocumentRoot);
            }
            boolean containerWithoutEar = false;
            if (ctxt instanceof WebApp && (moduleContainer = ((WebApp)ctxt).getModuleContainer()) != null) {
                this.earContainer = moduleContainer.getEnclosingContainer();
                if (this.earContainer == null) {
                    containerWithoutEar = true;
                }
            }
            this.createSearchPath(ctxt, extendedDocumentRoot, containerWithoutEar);
        }
    }

    public ExtendedDocumentRootUtils(String baseDir, String extendedDocumentRoot) {
        if (extendedDocumentRoot != null) {
            if (baseDir != null && !(baseDir = baseDir.replace('\\', '/')).endsWith("/")) {
                baseDir = baseDir + "/";
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "ExtendedDocumentRootUtils", "baseDir --> ", baseDir);
                logger.logp(Level.FINE, CLASS_NAME, "ExtendedDocumentRootUtils", "extendedDocumentRoot --> " + extendedDocumentRoot);
            }
            this.createSearchPath(baseDir, extendedDocumentRoot, false);
        }
    }

    public boolean searchPathExists() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            String result = !this.searchPath.isEmpty() ? "true" : "false";
            logger.logp(Level.FINE, CLASS_NAME, "searchPathExists", " ", result);
        }
        return !this.searchPath.isEmpty();
    }

    private void createSearchPath(ServletContext ctx, String extendedDocumentRoot, boolean containerWithoutEar) {
        if (this.earContainer != null) {
            this.createSearchPath("", extendedDocumentRoot, false);
            return;
        }
        if (containerWithoutEar) {
            this.createSearchPath("", extendedDocumentRoot, containerWithoutEar);
            return;
        }
        String baseDir = ctx.getRealPath("/../");
        this.createSearchPath(baseDir, extendedDocumentRoot, false);
    }

    private void createSearchPath(String baseDir, String extendedDocumentRoot, boolean containerWithoutEar) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "createSearchPath", "baseDir --> " + baseDir);
            logger.logp(Level.FINE, CLASS_NAME, "createSearchPath", "extendedDocumentRoot --> " + extendedDocumentRoot);
        }
        StringTokenizer st = new StringTokenizer(extendedDocumentRoot, ",");
        while (st.hasMoreTokens()) {
            try {
                String currentSearchLocation = st.nextToken().trim();
                if (currentSearchLocation == null) continue;
                if (isWindows && currentSearchLocation.indexOf(":") == 1 || currentSearchLocation.startsWith("/")) {
                    File f = new File(currentSearchLocation);
                    EDRPathEntry entry = new EDRPathEntry(f.toString(), false);
                    this.searchPath.add(entry);
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                    logger.logp(Level.FINE, CLASS_NAME, "createSearchPath", "add to searchPath --> " + f.toString());
                    continue;
                }
                if (this.earContainer == null && containerWithoutEar) continue;
                if (this.earContainer != null) {
                    EDRPathEntry entry = new EDRPathEntry(currentSearchLocation, true);
                    this.searchPath.add(entry);
                    continue;
                }
                File realPath = new File(baseDir + currentSearchLocation);
                String canonicalPath = realPath.getCanonicalPath();
                EDRPathEntry entry = new EDRPathEntry(canonicalPath, false);
                this.searchPath.add(entry);
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                logger.logp(Level.FINE, CLASS_NAME, "createSearchPath", "add to searchPath --> " + canonicalPath);
            }
            catch (IOException io) {
                logger.logp(Level.SEVERE, CLASS_NAME, "createSearchPath", "exception.creating.search.path", io);
            }
        }
    }

    private String[] parseOnExtension(String input, String extension) {
        int endIndex;
        String inLower = input.toLowerCase();
        if (inLower.indexOf(extension) < 0) {
            return null;
        }
        String parser1 = "." + extension + "/";
        if (inLower.indexOf(parser1) >= 0) {
            return input.split("/");
        }
        String parser2 = "." + extension;
        int i = inLower.indexOf(parser2);
        if (i >= 0 && i == (endIndex = inLower.length() - parser2.length())) {
            return input.split("/");
        }
        return null;
    }

    public void handleExtendedDocumentRoots(String filename) throws FileNotFoundException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "handleExtendedDocumentRoots", "filename --> " + filename);
        }
        boolean foundMatch = false;
        block6: for (EDRPathEntry pathEntry : this.searchPath) {
            String currDocumentRoot;
            File currFile;
            String _path = pathEntry.getPath();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "handleExtendedDocumentRoots", "looking at entry:", _path);
            }
            if (pathEntry.inContainer() && this.earContainer != null) {
                Entry subContainerEntry = null;
                String[] sections = this.parseOnExtension(_path, "war");
                if (sections != null) {
                    Container currentContainer = this.earContainer;
                    Entry currentEntry = null;
                    for (int j = 0; j < sections.length; ++j) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "handleExtendedDocumentRoots", "looking at section:", sections[j]);
                        }
                        if ((currentEntry = currentContainer.getEntry(sections[j])) == null) continue block6;
                        try {
                            Container currentEntryContainer;
                            currentContainer = currentEntryContainer = (Container)currentEntry.adapt(Container.class);
                            continue;
                        }
                        catch (UnableToAdaptException e) {
                            continue block6;
                        }
                    }
                    subContainerEntry = currentEntry;
                } else {
                    subContainerEntry = this.earContainer.getEntry(_path);
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "handleExtendedDocumentRoots", "working with subContainerEntry of: ", subContainerEntry);
                }
                if (subContainerEntry == null) continue;
                try {
                    Entry potentialMatch;
                    Container subContainer = (Container)subContainerEntry.adapt(Container.class);
                    if (filename.startsWith("/")) {
                        filename = filename.substring(1);
                    }
                    if ((potentialMatch = subContainer.getEntry(filename)) == null) continue;
                    foundMatch = true;
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "handleExtendedDocumentRoots", "found match in container --> " + potentialMatch);
                    }
                    this.extDocRootFile = new EntryResource(potentialMatch);
                    break;
                }
                catch (UnableToAdaptException e) {
                    continue;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "handleExtendedDocumentRoots", "Path entry not in container");
            }
            if ((currFile = new File(currDocumentRoot = pathEntry.getPath())).isDirectory()) {
                File tmpFile = new File(currFile, filename);
                if (!tmpFile.exists()) continue;
                foundMatch = true;
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "handleExtendedDocumentRoots", "found match in directory --> " + tmpFile.toString());
                }
                this.handleCaseSensitivityCheck(tmpFile.toString(), filename);
                this.extDocRootFile = new FileResource(tmpFile);
                this.useContentLength = true;
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break;
                logger.logp(Level.FINE, CLASS_NAME, "handleExtendedDocumentRoots", "useContentLength --> " + this.useContentLength);
                break;
            }
            if (!currFile.exists()) continue;
            ZipFile zip = new ZipFile(currFile);
            ZipEntry zEntry = zip.getEntry(filename.substring(1).replace('\\', '/'));
            if (zEntry != null) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "handleExtendedDocumentRoots", "found match in zip or jar file --> " + currFile.toString());
                }
                foundMatch = true;
                String fullURL = "jar:" + currFile.toURI().toURL().toString() + "!" + filename.replace('\\', '/');
                URL url = null;
                try {
                    url = new URL(fullURL);
                }
                catch (MalformedURLException e) {
                    logger.logp(Level.FINE, CLASS_NAME, "handleExtendedDocumentRoots", "MalformedURLException for URL : " + fullURL);
                }
                this.extDocRootFile = new ZipFileResource(currFile, zEntry.getName(), url);
                zip.close();
                break;
            }
            zip.close();
        }
        if (!foundMatch) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "handleExtendedDocumentRoots", "unable to locate resource --> " + filename);
            }
            throw new FileNotFoundException(filename);
        }
    }

    public InputStream getInputStream() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getInputStream", "getInputStream for ExtendedDocumentRoot this -->" + this);
        }
        try {
            return this.extDocRootFile.getIS();
        }
        catch (Exception e) {
            return null;
        }
    }

    public long getLastModifiedMatchedFile() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getLastModifiedMatchedFile", "file --> [" + (this.extDocRootFile == null ? 0L : this.extDocRootFile.getLastModified()) + "]");
        }
        return this.extDocRootFile == null ? 0L : this.extDocRootFile.getLastModified();
    }

    public boolean useContentLength() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "useContentLength", "length --> [" + this.useContentLength + "]");
        }
        return this.useContentLength;
    }

    public ZipFile getMatchedZipFile() {
        if (this.extDocRootFile instanceof ZipFileResource) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getMatchedZipFile", "is zip file");
            }
            return ((ZipFileResource)this.extDocRootFile).getZipFile();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getMatchedZipFile", "not zip file");
        }
        return null;
    }

    public ZipEntry getMatchedEntry() {
        if (this.extDocRootFile instanceof ZipFileResource) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getMatchedEntry", "is zip file");
            }
            return ((ZipFileResource)this.extDocRootFile).getZipEntry();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getMatchedEntry", "not zip file");
        }
        return null;
    }

    public Set<String> getResourcePaths(String filename) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "getResourcePaths", filename);
        }
        HashSet<String> paths = new HashSet<String>();
        boolean isRootDirectory = (filename = WSUtil.resolveURI((String)filename.trim())).equals("/");
        if (!isRootDirectory && filename.startsWith("/")) {
            filename = filename.substring(1);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getResourcePaths", "resolved fileName : " + filename);
        }
        for (EDRPathEntry edrEntry : this.searchPath) {
            if (edrEntry.inContainer() && this.earContainer != null) {
                Entry subContainerEntry = this.earContainer.getEntry(edrEntry.getPath());
                if (subContainerEntry == null) continue;
                try {
                    Container subContainer = (Container)subContainerEntry.adapt(Container.class);
                    Container resourceContainer = null;
                    if (filename.equals("/")) {
                        resourceContainer = subContainer;
                    } else {
                        Entry resourceEntry = subContainer.getEntry(filename);
                        if (resourceEntry != null) {
                            resourceContainer = (Container)resourceEntry.adapt(Container.class);
                        }
                    }
                    if (null == resourceContainer) continue;
                    for (Entry entry : resourceContainer) {
                        boolean isDir;
                        String path = entry.getPath();
                        Container directory = (Container)entry.adapt(Container.class);
                        boolean bl = isDir = entry.getSize() == 0L && directory != null;
                        if (isDir && !path.endsWith("/")) {
                            path = path + "/";
                        }
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "getResourcePaths", "EDR {0}", edrEntry.toString());
                            logger.logp(Level.FINE, CLASS_NAME, "getResourcePaths", "ENTRY {0} isDir {1}", new Object[]{entry.getPath(), isDir});
                        }
                        if (edrEntry.inContainer() && path.contains(edrEntry.getPath())) {
                            path = path.substring(edrEntry.getPath().length() + 1);
                        }
                        paths.add(path);
                        if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                        logger.logp(Level.FINE, CLASS_NAME, "getResourcePaths", "added " + path);
                    }
                    continue;
                }
                catch (UnableToAdaptException e) {
                    continue;
                }
            }
            String currDocumentRoot = edrEntry.getPath();
            File currFile = new File(currDocumentRoot);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getResourcePaths", "check document root : " + currDocumentRoot);
            }
            if (currFile.isDirectory()) {
                String searchName = filename;
                while (searchName.endsWith("/")) {
                    searchName = searchName.substring(0, searchName.length() - 1);
                }
                File tmpFile = null;
                tmpFile = !isRootDirectory ? new File(currFile, searchName) : currFile;
                if (!tmpFile.isDirectory()) continue;
                try {
                    File[] fileList;
                    if (!isRootDirectory) {
                        this.handleCaseSensitivityCheck(tmpFile.toString(), searchName);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "getResourcePaths", "found match in directory --> " + tmpFile.toString());
                    }
                    if ((fileList = tmpFile.listFiles()) == null) continue;
                    for (int i = 0; i < fileList.length; ++i) {
                        String resourcePath = fileList[i].getPath();
                        resourcePath = resourcePath.substring(currFile.toString().length());
                        resourcePath = resourcePath.replace('\\', '/');
                        if (fileList[i].isDirectory() && !resourcePath.endsWith("/")) {
                            resourcePath = resourcePath + "/";
                        }
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "getResourcePaths", "add path --> " + resourcePath);
                        }
                        paths.add(resourcePath);
                    }
                    continue;
                }
                catch (Exception e) {
                    continue;
                }
            }
            if (currFile.exists()) {
                try {
                    ZipFile zip = new ZipFile(currFile);
                    ZipEntry zipEntry = null;
                    String rootEntry = null;
                    if (!isRootDirectory) {
                        if (!filename.endsWith("/")) {
                            filename = filename + "/";
                        }
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "getResourcePaths", "get Zip entry for  --> " + filename);
                        }
                        if ((zipEntry = zip.getEntry(filename)) != null && zipEntry.isDirectory()) {
                            rootEntry = zipEntry.toString();
                        }
                    } else {
                        rootEntry = "";
                    }
                    if (rootEntry != null) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "getResourcePaths", "found match in zip file --> " + currFile.toString());
                        }
                        Enumeration<? extends ZipEntry> zipEntries = zip.entries();
                        while (zipEntries.hasMoreElements()) {
                            int slashIndex;
                            ZipEntry currentZipEntry = zipEntries.nextElement();
                            String currentEntry = currentZipEntry.toString();
                            if (!currentEntry.startsWith(rootEntry)) continue;
                            String subEntry = currentEntry.substring(rootEntry.length()).replace('\\', '/');
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "getResourcePaths", "check -->" + subEntry);
                            }
                            if (subEntry.equals("") || (slashIndex = subEntry.indexOf("/")) != -1 && slashIndex != subEntry.length() - 1) continue;
                            if (currentZipEntry.isDirectory() && !currentEntry.endsWith("/")) {
                                currentEntry = currentEntry + "/";
                            }
                            if (!currentEntry.startsWith("/")) {
                                currentEntry = "/" + currentEntry;
                            }
                            paths.add(currentEntry);
                            if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                            logger.logp(Level.FINE, CLASS_NAME, "getResourcePaths", "add path --> " + currentEntry);
                        }
                    }
                    zip.close();
                }
                catch (Exception e) {}
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
            logger.logp(Level.FINE, CLASS_NAME, "getResourcePaths", "EDR not not found --> " + currFile.toString());
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "getResourcePaths", paths);
        }
        return paths;
    }

    private void handleCaseSensitivityCheck(String path, String strippedPathInfo) throws FileNotFoundException, IOException {
        if (FileSystem.isCaseInsensitive) {
            File caseFile;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "handleCaseSensitivityCheck", "file system is case insensitive");
            }
            if (!FileSystem.uriCaseCheck((File)(caseFile = new File(path)), (String)strippedPathInfo)) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "handleCaseSensitivityCheck", "failed for --> [" + path + "]");
                }
                throw new FileNotFoundException(path);
            }
        }
    }
}

