/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.util.InvalidCacheTargetException;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.collaborator.CollaboratorHelper;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.servlet.ServletReferenceListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CacheServletWrapper
implements RequestProcessor,
ServletReferenceListener {
    protected static final Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.servlet");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.servlet.CacheServletWrapper";
    private String _servletPath;
    private String _pathInfo;
    private volatile IServletWrapper cacheTarget;
    private String cacheKeyStr;
    private WebApp webapp;
    private String requestUri;
    private boolean invalidated = false;

    public CacheServletWrapper(IServletWrapper wrapper, HttpServletRequest req, String cacheKey, WebApp webapp) {
        this.cacheTarget = wrapper;
        this.cacheTarget.addServletReferenceListener(this);
        this._pathInfo = req.getPathInfo();
        this._servletPath = req.getServletPath();
        this.requestUri = req.getRequestURI();
        this.cacheKeyStr = cacheKey;
        this.webapp = webapp;
    }

    @Override
    public void handleRequest(ServletRequest req, ServletResponse res) throws Exception {
        block6: {
            IServletWrapper target = this.cacheTarget;
            if (target != null) {
                try {
                    this.webapp.getFilterManager().invokeFilters((ServletRequest)((HttpServletRequest)req), (ServletResponse)((HttpServletResponse)res), this.webapp, target, CollaboratorHelper.allCollabEnum);
                }
                catch (Throwable th) {
                    if (com.ibm.ws.webcontainer.osgi.WebContainer.getServletContainerSpecLevel() >= 31 && th instanceof IOException && th.getMessage() != null && th.getMessage().contains("SRVE0918E")) {
                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "donothandleexception SRVE0918E");
                        return;
                    }
                    WebApp webapp = this.webapp;
                    if (webapp == null) {
                        FFDCFilter.processException((Throwable)th, (String)this.getClass().getName(), (String)"83");
                        break block6;
                    }
                    webapp.handleException(th, req, res, this);
                }
            } else {
                throw InvalidCacheTargetException.instance();
            }
        }
    }

    public String getPathInfo() {
        return this._pathInfo;
    }

    public String getServletPath() {
        return this._servletPath;
    }

    public void setPathInfo(String string) {
        this._pathInfo = string;
    }

    public void setServletPath(String string) {
        this._servletPath = string;
    }

    public WebApp getWebApp() {
        if (this.cacheTarget != null) {
            return this.webapp;
        }
        throw InvalidCacheTargetException.instance();
    }

    @Override
    public synchronized void invalidate() {
        if (!this.invalidated) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "invalidate", "first invalidate");
            }
            WebContainer.removeFromCache(this.cacheKeyStr);
            this.invalidated = true;
        } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "invalidate", "additional invalidate");
        }
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public String getCacheKeyString() {
        return this.cacheKeyStr;
    }

    public IServletWrapper getCacheTarget() {
        return this.cacheTarget;
    }

    public String toString() {
        String s = this.webapp == null ? " Webapp nulled::  " + this.webapp + "  " + " ServletPath:: " + this._servletPath + "  " + " CacheKey ::" + this.cacheKeyStr + "  " + " _pathInfo::" + this._pathInfo + "  " + " requestUri ::" + this.requestUri + "  " : " Webapp::  " + this.webapp + "  " + " ServletPath:: " + this._servletPath + "  " + " CacheKey ::" + this.cacheKeyStr + "  " + " _pathInfo::" + this._pathInfo + "  " + " requestUri ::" + this.requestUri + "  " + "ApplicationName::" + this.webapp.getApplicationName() + "  " + "WebAppContxtPath::" + this.webapp.getContextPath();
        return s;
    }

    @Override
    public boolean isInternal() {
        return this.cacheTarget.isInternal();
    }

    @Override
    public String getName() {
        return this.cacheTarget.getServletName();
    }
}

