/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.extension;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.util.FileSystem;
import com.ibm.ws.util.WSUtil;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.exception.IncludeFileNotFoundException;
import com.ibm.ws.webcontainer.extension.WebExtensionProcessor;
import com.ibm.ws.webcontainer.osgi.interceptor.RegisterRequestInterceptor;
import com.ibm.ws.webcontainer.osgi.servlet.EntryServletWrapper;
import com.ibm.ws.webcontainer.servlet.FileServletWrapper;
import com.ibm.ws.webcontainer.servlet.ZipFileServletWrapper;
import com.ibm.ws.webcontainer.util.DocumentRootUtils;
import com.ibm.ws.webcontainer.util.EntryResource;
import com.ibm.ws.webcontainer.util.ZipFileResource;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer.webapp.WebAppErrorReport;
import com.ibm.ws.webcontainer.webapp.WebGroup;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.webcontainer.IPlatformHelper;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import com.ibm.wsspi.webcontainer.collaborator.ICollaboratorHelper;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppNameSpaceCollaborator;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppSecurityCollaborator;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.metadata.WebComponentMetaData;
import com.ibm.wsspi.webcontainer.security.SecurityViolationException;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.util.FFDCWrapper;
import com.ibm.wsspi.webcontainer.util.ServletUtil;
import com.ibm.wsspi.webcontainer.util.URIMatcher;
import com.ibm.wsspi.webcontainer.webapp.NamespaceInvoker;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class DefaultExtensionProcessor
extends WebExtensionProcessor
implements NamespaceInvoker,
Servlet {
    public static final String PARAM_DEFAULT_PAGE = "default.page";
    public static final String PARAM_BUFFER_SIZE = "bufferSize";
    public static final String WEB_INF_DIR = "WEB-INF/";
    public static final String META_INF_DIR = "META-INF/";
    private static TraceNLS nls = TraceNLS.getTraceNLS(DefaultExtensionProcessor.class, (String)"com.ibm.ws.webcontainer.resources.Messages");
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.extension");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.extension.DefaultExtensionProcessor";
    private int defaultBufferSize = 4096;
    private String esiControl = null;
    String extendedDocumentRoot = null;
    String preFragmentExtendedDocumentRoot = null;
    private static final String DEFAULT_MAPPING = "/*";
    protected List patternList = new ArrayList();
    private static int optimizeFileServingSizeGlobal = -1;
    private int optimizeFileServingSize = 1000000;
    private static boolean useOriginalRequestState = WCCustomProperties.USE_ORIGINAL_REQUEST_STATE;
    private static boolean handlingRequestWithOverridenPath = WCCustomProperties.HANDLING_REQUEST_WITH_OVERRIDDEN_PATH;
    private static final List DEFAULT_DENY_EXTENSIONS = new ArrayList();
    protected URIMatcher denyPatterns = null;
    protected boolean redirectToWelcomeFile = false;
    protected WebComponentMetaData cmd;
    protected IPlatformHelper platformHelper;
    private Map params;
    protected List welcomeFileList;
    protected WebApp _webapp;
    private ICollaboratorHelper collabHelper;
    private IWebAppNameSpaceCollaborator webAppNameSpaceCollab;
    private IWebAppSecurityCollaborator secCollab;
    private boolean exposeWebInfOnDispatch;

    public DefaultExtensionProcessor(IServletContext webapp, HashMap params) {
        super(webapp);
        this._webapp = (WebApp)webapp;
        this.params = params;
        this.collabHelper = this._webapp.getCollaboratorHelper();
        this.webAppNameSpaceCollab = this.collabHelper.getWebAppNameSpaceCollaborator();
        this.secCollab = this.collabHelper.getSecurityCollaborator();
        this.platformHelper = WebContainer.getWebContainer().getPlatformHelper();
        this.welcomeFileList = (List)webapp.getAttribute(WebApp.WELCOME_FILE_LIST);
        this.init();
    }

    private void init() {
        List list;
        String fileServingExtensionsDenied;
        String stringBufferSize;
        this.exposeWebInfOnDispatch = WCCustomProperties.EXPOSE_WEB_INF_ON_DISPATCH;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "init", "exposeWebInfOnDispatch ---> true");
        }
        if ((stringBufferSize = this.getInitParameter(PARAM_BUFFER_SIZE)) != null) {
            try {
                int tempBufferSize;
                this.defaultBufferSize = tempBufferSize = Integer.parseInt(stringBufferSize);
            }
            catch (NumberFormatException ex) {
                FFDCWrapper.processException(ex, "com.ibm.ws.webcontainer.servlet.SimpleFileServlet.init", "65", this);
            }
        }
        this.extendedDocumentRoot = this.getInitParameter("extendedDocumentRoot");
        this.preFragmentExtendedDocumentRoot = this.getInitParameter("preFragmentExtendedDocumentRoot");
        String fileServingExtensions = this.getInitParameter("file.serving.patterns.allow");
        if (fileServingExtensions != null) {
            this.patternList = this.parseFileServingExtensions(fileServingExtensions);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "init", "URI patterns for FileServing =[" + this.patternList + "]");
            }
        } else {
            this.patternList.add(DEFAULT_MAPPING);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "init", "Default URI pattern for FileServing =[" + this.patternList + "]");
            }
        }
        if ((fileServingExtensionsDenied = this.getInitParameter("file.serving.patterns.deny")) != null) {
            list = this.parseFileServingExtensions(fileServingExtensionsDenied);
            list.addAll(DEFAULT_DENY_EXTENSIONS);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "init", "Denied URI patterns for FileServing =[" + list + "]");
            }
            this.denyPatterns = this.createURIMatcher(list);
        } else {
            list = DEFAULT_DENY_EXTENSIONS;
            this.denyPatterns = this.createURIMatcher(list);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "init", "Default denied patterns for FileServing =[" + list + "]");
            }
        }
        String esiTimeout = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperties().getProperty("com.ibm.servlet.file.esi.timeOut", "300");
            }
        });
        if (!esiTimeout.equals("0")) {
            this.esiControl = "max-age=" + esiTimeout + "," + "cacheid=\"URL\"," + "content=\"ESI/1.0+\"";
        }
        this.esiControl = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperties().getProperty("com.ibm.servlet.file.esi.control", DefaultExtensionProcessor.this.esiControl);
            }
        });
        String redirectToWelcomeFileStr = this.getInitParameter("redirectToWelcomeFile");
        if (redirectToWelcomeFileStr != null) {
            this.redirectToWelcomeFile = redirectToWelcomeFileStr.equalsIgnoreCase("true");
        }
        this.optimizeFileServingSize = this.getFileServingIntegerAttribute("com.ibm.ws.webcontainer.optimizefileservingsize", optimizeFileServingSizeGlobal);
    }

    private int getFileServingIntegerAttribute(String attributeKey, int defaultValue) {
        int integerAttribute;
        block5: {
            integerAttribute = defaultValue;
            try {
                String integerAttributeStr;
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getFileServingIntegerAttribute", "attributeKey->" + attributeKey);
                }
                if ((integerAttributeStr = this.getInitParameter(attributeKey)) != null) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "getFileServingIntegerAttribute", "integerAttributeStr->" + integerAttributeStr);
                    }
                    integerAttribute = Integer.valueOf(integerAttributeStr);
                }
            }
            catch (NumberFormatException nfe) {
                FFDCWrapper.processException(nfe, "com.ibm.ws.webcontainer.extension.DefaultExtensionProcessor.init", "65", this);
                if (!logger.isLoggable(Level.SEVERE)) break block5;
                logger.logp(Level.SEVERE, CLASS_NAME, "getFileServingIntegerAttribute", "NumberFormatException.for.file.size.at.which.you.switch.to.optimized.file.serving");
            }
        }
        return integerAttribute;
    }

    private String getInitParameter(String param) {
        return (String)this.params.get(param);
    }

    @Override
    public String getName() {
        return CLASS_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleRequest(ServletRequest request, ServletResponse response) throws Exception {
        RequestDispatcher dirBrowse;
        String welcomeFileForwardUri;
        String welcomeFileRedirectUri;
        String fileSystemPath;
        WebApp context;
        FileNotFoundException fnf;
        String pathInfo;
        HttpServletResponse resp;
        HttpServletRequest req;
        Object token;
        block155: {
            String page;
            Iterator e;
            String queryString;
            StringBuffer path;
            block156: {
                token = null;
                req = (HttpServletRequest)request;
                resp = (HttpServletResponse)response;
                HttpServletRequest httpRequest = null;
                path = null;
                WebAppDispatcherContext dispatchContext = null;
                pathInfo = null;
                fnf = null;
                try {
                    Java2SecurityFile caseFile;
                    WebContainerRequestState reqStateSaveRequest;
                    IExtendedRequest wasreq = null;
                    if (useOriginalRequestState && (reqStateSaveRequest = WebContainerRequestState.getInstance(false)) != null && (httpRequest = (HttpServletRequest)reqStateSaveRequest.getAttribute("unFilteredRequestObject")) != null) {
                        wasreq = ServletUtil.unwrapRequest((ServletRequest)httpRequest);
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.entering(CLASS_NAME, "handleRequest : useOriginalRequestState request--->" + httpRequest.getRequestURI() + "<---");
                        }
                    }
                    if (httpRequest == null) {
                        httpRequest = (HttpServletRequest)request;
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.entering(CLASS_NAME, "handleRequest : request--->" + httpRequest.getRequestURI() + "<---");
                        }
                        wasreq = ServletUtil.unwrapRequest(request);
                    }
                    dispatchContext = (WebAppDispatcherContext)wasreq.getWebAppDispatcherContext();
                    token = ThreadIdentityManager.runAsServer();
                    boolean isInclude = false;
                    context = this._webapp;
                    fileSystemPath = null;
                    path = new StringBuffer();
                    String servletPath = null;
                    if (httpRequest.getAttribute("javax.servlet.include.request_uri") != null) {
                        isInclude = true;
                        servletPath = (String)httpRequest.getAttribute("javax.servlet.include.servlet_path");
                        pathInfo = (String)httpRequest.getAttribute("javax.servlet.include.path_info");
                    } else if (dispatchContext != null && !handlingRequestWithOverridenPath) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "relative uri -->[" + dispatchContext.getRelativeUri() + "]");
                        }
                        if ((servletPath = dispatchContext.getServletPath()) != null) {
                            servletPath = WebGroup.stripURL(servletPath, false);
                        }
                        if ((pathInfo = dispatchContext.getPathInfo()) != null) {
                            pathInfo = WebGroup.stripURL(pathInfo, false);
                        }
                        if (pathInfo == "") {
                            pathInfo = null;
                        }
                    } else {
                        servletPath = httpRequest.getServletPath();
                        pathInfo = httpRequest.getPathInfo();
                    }
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "servletPath [" + servletPath + "] pathInfo [" + pathInfo + "]");
                    }
                    path.append(servletPath);
                    if (pathInfo != null) {
                        int semicolon = pathInfo.indexOf(59);
                        if (semicolon != -1) {
                            pathInfo = pathInfo.substring(0, semicolon);
                        }
                        path.append(pathInfo);
                    }
                    String temporaryPath = WSUtil.resolveURI((String)path.toString());
                    String upperMatchString = temporaryPath.toUpperCase();
                    boolean forbidden = false;
                    if (!this.exposeWebInfOnDispatch && (upperMatchString.startsWith("/WEB-INF/") || upperMatchString.equals("/WEB-INF"))) {
                        forbidden = true;
                    } else if (upperMatchString.startsWith("/META-INF/") || upperMatchString.equals("/META-INF")) {
                        forbidden = true;
                    }
                    if (forbidden) {
                        int statusCode = temporaryPath.equals(path.toString()) ? 403 : 404;
                        resp.sendError(statusCode, MessageFormat.format(nls.getString("File.not.found", "File not found: {0}"), path.toString()));
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.exiting(CLASS_NAME, "handleRequest", "Forbidden-WEB-INF/META-INF");
                        }
                        ThreadIdentityManager.reset((Object)token);
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                        }
                        if (fnf == null) return;
                        throw fnf;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", " after resolving the uri: path ---> " + path);
                    }
                    Container webModuleContainer = this._webapp.getModuleContainer();
                    fileSystemPath = path.toString();
                    if (!this.isValidFilePath(fileSystemPath)) {
                        resp.sendError(403, nls.getString("File.name.contains.illegal.character", "File path contains illegal character."));
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.exiting(CLASS_NAME, "handleRequest", "Forbidden-invalid file path");
                        }
                        ThreadIdentityManager.reset((Object)token);
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                        }
                        if (fnf == null) return;
                        throw fnf;
                    }
                    Object matchedURI = this.denyPatterns.match(path.toString());
                    if (matchedURI != null) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Attempted to serve URI that matches denied URL pattern URI =[" + path.toString() + "] matched [" + matchedURI + "]");
                        }
                        resp.sendError(403, MessageFormat.format(nls.getString("File.not.found", "File not found: {0}"), path.toString()));
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.exiting(CLASS_NAME, "handleRequest", "Forbidden-denied pattern");
                        }
                        ThreadIdentityManager.reset((Object)token);
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                        }
                        if (fnf == null) return;
                        throw fnf;
                    }
                    boolean fileIsDirectoryInDocumentRoot = false;
                    File file = null;
                    Entry entry = null;
                    boolean requestForRoot = false;
                    if (fileSystemPath.equals("/")) {
                        requestForRoot = true;
                    } else {
                        entry = webModuleContainer.getEntry(fileSystemPath);
                    }
                    if (file != null && !file.exists() || webModuleContainer != null && entry == null && !requestForRoot) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "file does not exist --> " + path);
                        }
                        DocumentRootUtils docRoot = new DocumentRootUtils((ServletContext)context, this.extendedDocumentRoot, this.preFragmentExtendedDocumentRoot);
                        try {
                            docRoot.handleDocumentRoots(path.toString());
                        }
                        catch (FileNotFoundException fnfe) {
                            throw new FileNotFoundException(MessageFormat.format(nls.getString("File.not.found", "File not found: {0}"), path));
                        }
                        if (docRoot.isDirectory()) {
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.exiting(CLASS_NAME, "handleRequest", "matchedfile is a directory");
                            }
                            if (!docRoot.isMatchedFromEDR() || WCCustomProperties.ALLOW_PARTIAL_URL_TO_EDR) {
                                fileIsDirectoryInDocumentRoot = true;
                            }
                        } else {
                            if (this.isRequestForbidden(path)) {
                                resp.sendError(403, MessageFormat.format(nls.getString("File.not.found", "File not found: {0}"), httpRequest.getPathInfo()));
                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                    logger.exiting(CLASS_NAME, "handleRequest", "Forbidden-Extended doc root endsWith");
                                }
                                ThreadIdentityManager.reset((Object)token);
                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                                }
                                if (fnf == null) return;
                                throw fnf;
                            }
                            ZipFileResource zipFileResource = docRoot.getMatchedZipFileResource();
                            if (zipFileResource != null) {
                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "zip file found: Use ZipFileServletWrapper");
                                }
                                this.handleZipFileWrapper(req, httpRequest, resp, path, dispatchContext, zipFileResource);
                                ThreadIdentityManager.reset((Object)token);
                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                                }
                                if (fnf == null) return;
                                throw fnf;
                            }
                            EntryResource entryResource = docRoot.getMatchedEntryResource();
                            if (entryResource != null) {
                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "entry is found: Use EntryServletWrapper");
                                }
                                EntryServletWrapper ewrapper = new EntryServletWrapper(this._webapp, this, entryResource.getEntry());
                                ewrapper.handleRequest((ServletRequest)req, (ServletResponse)resp);
                                if (!this._webapp.isCachingEnabled()) {
                                    if (!this._webapp.getConfiguration().isDisableStaticMappingCache()) {
                                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "ewrapper addMappingTarget URI -> " + path);
                                        }
                                        this._webapp.addMappingTarget(path.toString(), ewrapper);
                                    }
                                    if (!dispatchContext.isInclude() && !dispatchContext.isForward()) {
                                        WebContainer.addToCache(httpRequest, ewrapper, this._webapp);
                                    }
                                }
                                ThreadIdentityManager.reset((Object)token);
                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                                }
                                if (fnf == null) return;
                                throw fnf;
                            }
                            File matchedFile = docRoot.getMatchedFile();
                            if (matchedFile != null) {
                                FileServletWrapper fwrapper = this.getStaticFileWrapper(this._webapp, this, matchedFile);
                                fwrapper.handleRequest((ServletRequest)req, (ServletResponse)resp);
                                if (!this._webapp.isCachingEnabled()) {
                                    try {
                                        if (!this._webapp.getConfiguration().isDisableStaticMappingCache()) {
                                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "fwrapper addMappingTarget URI -> " + path);
                                            }
                                            this._webapp.addMappingTarget(path.toString(), fwrapper);
                                        }
                                        if (!dispatchContext.isInclude() && !dispatchContext.isForward()) {
                                            WebContainer.addToCache(httpRequest, fwrapper, this._webapp);
                                        }
                                    }
                                    catch (Exception e2) {
                                        // empty catch block
                                    }
                                }
                                ThreadIdentityManager.reset((Object)token);
                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                                }
                                if (fnf == null) return;
                                throw fnf;
                            }
                        }
                        if (!fileIsDirectoryInDocumentRoot) {
                            throw new FileNotFoundException(MessageFormat.format(nls.getString("File.not.found", "File not found: {0}"), path));
                        }
                    }
                    boolean isContainerDirectory = false;
                    Container directory = null;
                    if (webModuleContainer != null) {
                        if (requestForRoot) {
                            directory = webModuleContainer;
                        } else if (entry != null) {
                            directory = (Container)entry.adapt(Container.class);
                        }
                        boolean bl = isContainerDirectory = requestForRoot || fileIsDirectoryInDocumentRoot || entry.getSize() == 0L && directory != null && !directory.isRoot();
                    }
                    if (file != null && file.isDirectory() || fileIsDirectoryInDocumentRoot || isContainerDirectory) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            if (file != null) {
                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "file is a directory --> " + file.getPath());
                            } else if (entry != null) {
                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "entry path --> " + entry.getPath());
                            } else {
                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "file is null");
                            }
                        }
                        String requestString = this.getURLWithRequestURIEncoded(httpRequest).toString();
                        if (WCCustomProperties.IGNORE_SEMICOLON_ON_REDIRECT_TO_WELCOME_PAGE) {
                            String requestURI = req.getRequestURI();
                            int indexAfterContextRoot = requestURI.indexOf(context.getContextPath()) + context.getContextPath().length();
                            if (!context.getContextPath().equals("/")) {
                                ++indexAfterContextRoot;
                            }
                            if (indexAfterContextRoot < requestURI.length() && requestURI.charAt(indexAfterContextRoot) == ';') {
                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Removing semi-colon");
                                }
                                requestString = requestString.substring(0, requestString.indexOf(";"));
                            }
                        }
                        queryString = httpRequest.getQueryString();
                        if (!requestString.endsWith("/") && !isInclude) {
                            String tmpURL = requestString + "/";
                            if (queryString != null) {
                                tmpURL = tmpURL + "?" + queryString;
                            }
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "sendRedirect -->" + tmpURL);
                            }
                            resp.sendRedirect(resp.encodeRedirectURL(tmpURL));
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.exiting(CLASS_NAME, "handleRequest", "redirect to context root");
                            }
                            ThreadIdentityManager.reset((Object)token);
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                            }
                            if (fnf == null) return;
                            throw fnf;
                        }
                        welcomeFileRedirectUri = null;
                        welcomeFileForwardUri = null;
                        if (this.welcomeFileList == null || this.welcomeFileList.size() == 0) break block155;
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Check welcome file list");
                        }
                        e = this.welcomeFileList.iterator();
                        page = null;
                        break block156;
                    }
                    if (this.isRequestForbidden(path)) {
                        resp.sendError(403, MessageFormat.format(nls.getString("File.not.found", "File not found: {0}"), pathInfo));
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.exiting(CLASS_NAME, "handleRequest", "handleRequest --> Forbidden-endsWith");
                        }
                        ThreadIdentityManager.reset((Object)token);
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                        }
                        if (fnf == null) return;
                        throw fnf;
                    }
                    if (webModuleContainer == null && FileSystem.isCaseInsensitive && !FileSystem.uriCaseCheck((File)(caseFile = new Java2SecurityFile(fileSystemPath)), (String)path.toString())) {
                        if (!TraceComponent.isAnyTracingEnabled()) throw new FileNotFoundException(path.toString());
                        if (!logger.isLoggable(Level.FINE)) throw new FileNotFoundException(path.toString());
                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest --> Case sensitivity check - throw FileNotFoundException");
                        throw new FileNotFoundException(path.toString());
                    }
                    FileServletWrapper fwrapper = null;
                    fwrapper = file != null ? this.getStaticFileWrapper(this._webapp, this, file) : this.getEntryWrapper(this._webapp, this, entry);
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Use FileServletWrapper");
                    }
                    fwrapper.handleRequest((ServletRequest)req, (ServletResponse)resp);
                    if (!this._webapp.isCachingEnabled()) {
                        try {
                            if (!this._webapp.getConfiguration().isDisableStaticMappingCache()) {
                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "FileServletWrapper addMappingTarget URI -> " + path);
                                }
                                this._webapp.addMappingTarget(path.toString(), fwrapper);
                            }
                            if (!dispatchContext.isInclude() && !dispatchContext.isForward()) {
                                WebContainer.addToCache(httpRequest, fwrapper, this._webapp);
                            }
                        }
                        catch (Exception e3) {
                            // empty catch block
                        }
                    }
                    ThreadIdentityManager.reset((Object)token);
                }
                catch (FileNotFoundException e4) {
                    block157: {
                        block158: {
                            if (RegisterRequestInterceptor.notifyRequestInterceptors("OnFileNotFound", req, resp)) {
                            }
                            if (WCCustomProperties.THROW_404_IN_PREFERENCE_TO_403 || !this.isDirectoryTraverse(path)) break block157;
                            resp.sendError(403, MessageFormat.format(nls.getString("File.not.found", "File not found: {0}"), pathInfo));
                            if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block158;
                            logger.exiting(CLASS_NAME, "handleRequest", "Forbidden-file does not exist");
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                        }
                        ThreadIdentityManager.reset((Object)token);
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                        }
                        if (fnf == null) return;
                        throw fnf;
                    }
                    WebAppErrorReport errorReport = new WebAppErrorReport(MessageFormat.format(nls.getString("File.not.found", "File not found: {0}"), e4.getMessage()), e4);
                    logger.logp(Level.WARNING, CLASS_NAME, "handleRequest", e4.getMessage());
                    errorReport.setErrorCode(404);
                    errorReport.setTargetServletName("DefaultExtensionProcessor");
                    if (!WCCustomProperties.MODIFIED_FNF_BEHAVIOR) {
                        FFDCWrapper.processException(e4, "com.ibm.ws.webcontainer.extension.DefaultExtensionProcessor.handleRequest", "573", this);
                        try {
                            this._webapp.sendError(req, resp, errorReport);
                        }
                        catch (Exception ex) {
                        }
                    }
                    if (!WCCustomProperties.SERVLET_30_FNF_BEHAVIOR || request.getDispatcherType() != DispatcherType.INCLUDE) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "dispatch type is not include, throw normal FNF");
                        }
                        fnf = e4;
                        resp.setStatus(404);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "throwing IncludeFileNotFoundException");
                    }
                    fnf = new IncludeFileNotFoundException(e4.getMessage());
                    catch (SecurityViolationException e5) {
                        String strPath = null;
                        if (path == null) return;
                        strPath = path.toString();
                        this.collabHelper.processSecurityPreInvokeException(e5, this, httpRequest, resp, dispatchContext, this._webapp, strPath);
                        return;
                    }
                }
                finally {
                    ThreadIdentityManager.reset(token);
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                    }
                    if (fnf != null) {
                        throw fnf;
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                }
                if (fnf == null) return;
                throw fnf;
            }
            while (e.hasNext()) {
                boolean available;
                RequestProcessor rp;
                page = (String)e.next();
                if (page.charAt(0) == '/') {
                    page = page.substring(1);
                }
                if ((rp = this._webapp.getRequestMapper().map(path.toString() + page)) == null) {
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "No request processor found for welcome file:" + path.toString() + page);
                    continue;
                }
                if (rp instanceof WebExtensionProcessor) {
                    available = ((WebExtensionProcessor)rp).isAvailable(path.toString() + page);
                    if (!available) {
                        if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "No web extension processor found for welcome file:" + path.toString() + page);
                        continue;
                    }
                } else if (rp instanceof IServletWrapper && !(available = ((IServletWrapper)rp).isAvailable())) {
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "No servlet wrapper found for welcome file:" + path.toString() + page);
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Process welcome file: path: " + path.toString() + ", page: " + page);
                }
                if (this.redirectToWelcomeFile) {
                    String redirectURI;
                    String rPath;
                    String qString = "";
                    if (queryString != null) {
                        qString = "?" + queryString;
                    }
                    if ((rPath = this.removeLeadingSlashes(path.toString())) == null) {
                        rPath = "";
                    }
                    if (com.ibm.ws.webcontainer.osgi.WebContainer.getServletContainerSpecLevel() >= 31 || WCCustomProperties.REDIRECT_WITH_PATH_INFO) {
                        redirectURI = page + qString;
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Process welcome file: redirecting with pathInfo: " + redirectURI);
                        }
                    } else {
                        redirectURI = rPath + page + qString;
                    }
                    req.setAttribute("com.ibm.ws.webcontainer.welcomefile.redirecturl", (Object)redirectURI);
                    welcomeFileRedirectUri = redirectURI;
                    break;
                }
                String uri = path.toString() + page;
                if (WCCustomProperties.PROVIDE_QSTRING_TO_WELCOME_FILE && queryString != null) {
                    uri = uri + "?" + queryString;
                }
                req.setAttribute("com.ibm.ws.webcontainer.welcomefile.url", (Object)uri);
                welcomeFileForwardUri = uri;
                break;
            }
        }
        if (welcomeFileRedirectUri != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "sendRedirect to Welcome File:" + welcomeFileRedirectUri);
            }
            resp.sendRedirect(resp.encodeRedirectURL(welcomeFileRedirectUri));
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "handleRequest");
            }
            ThreadIdentityManager.reset((Object)token);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
            }
            if (fnf == null) return;
            throw fnf;
        }
        if (welcomeFileForwardUri != null) {
            RequestDispatcher rd = context.getRequestDispatcher(welcomeFileForwardUri);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "forward :" + welcomeFileForwardUri);
            }
            rd.forward((ServletRequest)req, (ServletResponse)resp);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "handleRequest");
            }
            ThreadIdentityManager.reset((Object)token);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
            }
            if (fnf == null) return;
            throw fnf;
        }
        if (this._webapp.getConfiguration().isDirectoryBrowsingEnabled() && (dirBrowse = context.getRequestDispatcher(WebApp.DIR_BROWSING_MAPPING)) != null) {
            req.setAttribute("com.ibm.servlet.engine.webapp.dir.browsing.path", (Object)fileSystemPath);
            req.setAttribute("com.ibm.servlet.engine.webapp.dir.browsing.uri", (Object)req.getRequestURI());
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Directory Browse" + fileSystemPath);
            }
            dirBrowse.forward((ServletRequest)req, (ServletResponse)resp);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "handleRequest");
            }
            ThreadIdentityManager.reset((Object)token);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
            }
            if (fnf == null) return;
            throw fnf;
        }
        if (!resp.isCommitted()) {
            resp.sendError(404, MessageFormat.format(nls.getString("File.not.found", "File not found"), pathInfo));
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "handleRequest", "handleRequest ---> File not found");
            }
        } else {
            logger.exiting("handleRequest", "handleRequest");
        }
        ThreadIdentityManager.reset((Object)token);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
        }
        if (fnf == null) return;
        throw fnf;
    }

    private void handleZipFileWrapper(HttpServletRequest req, HttpServletRequest httpRequest, HttpServletResponse resp, StringBuffer path, WebAppDispatcherContext dispatchContext, ZipFileResource metaInfResourceFile) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "handleZipFileWrapper");
        }
        ZipFileServletWrapper zfwrapper = this.getZipFileWrapper(this._webapp, this, metaInfResourceFile);
        zfwrapper.handleRequest((ServletRequest)req, (ServletResponse)resp);
        if (!this._webapp.isCachingEnabled()) {
            try {
                if (!this._webapp.getConfiguration().isDisableStaticMappingCache()) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "handleZipFileWrapper", "addMappingTarget URI -> " + path);
                    }
                    this._webapp.addMappingTarget(path.toString(), zfwrapper);
                }
                if (!dispatchContext.isInclude() && !dispatchContext.isForward()) {
                    WebContainer.addToCache(httpRequest, zfwrapper, this._webapp);
                }
            }
            catch (Exception e) {
                logger.logp(Level.WARNING, CLASS_NAME, "handleZipFileWrapper", "default.extension.exception.adding.mapping.target");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "handleZipFileWrapper");
        }
    }

    protected abstract FileServletWrapper getStaticFileWrapper(IServletContext var1, DefaultExtensionProcessor var2, File var3);

    protected abstract ZipFileServletWrapper getZipFileWrapper(IServletContext var1, DefaultExtensionProcessor var2, ZipFileResource var3);

    protected abstract FileServletWrapper getEntryWrapper(IServletContext var1, DefaultExtensionProcessor var2, Entry var3);

    protected boolean isValidFilePath(String filePath) {
        if (filePath == null) {
            return false;
        }
        int len = filePath.length();
        for (int i = 0; i < len; ++i) {
            if (filePath.charAt(i) >= ' ') continue;
            return false;
        }
        return true;
    }

    public String removeLeadingSlashes(String src) {
        String result = null;
        int i = 0;
        boolean done = false;
        if (src == null) {
            return null;
        }
        int len = src.length();
        while (!done && i < len) {
            if (src.charAt(i) == '/') {
                ++i;
                continue;
            }
            done = true;
        }
        if (done) {
            result = src.substring(i);
        }
        return result;
    }

    protected StringBuffer getURLWithRequestURIEncoded(HttpServletRequest req) {
        StringBuffer url = new StringBuffer();
        String scheme = req.getScheme();
        int port = req.getServerPort();
        String urlPath = null;
        try {
            urlPath = new String(req.getRequestURI().getBytes("utf-8"), "iso-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            urlPath = req.getRequestURI();
        }
        url.append(scheme);
        url.append("://");
        url.append(req.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(req.getServerPort());
        }
        url.append(urlPath);
        return url;
    }

    public String getEsiControl() {
        return this.esiControl;
    }

    public int getDefaultBufferSize() {
        return this.defaultBufferSize;
    }

    @Override
    public List getPatternList() {
        return this.patternList;
    }

    private List parseFileServingExtensions(String exts) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(exts, ": ;");
        while (st.hasMoreTokens()) {
            String ext = st.nextToken();
            if (ext.equals("/")) {
                ext = DEFAULT_MAPPING;
            }
            if (this.patternList.contains(ext)) continue;
            list.add(ext);
        }
        return list;
    }

    public URIMatcher createURIMatcher(List list) {
        URIMatcher uriMatcher = new URIMatcher(true);
        for (String currPattern : list) {
            if (currPattern.startsWith("*.")) {
                try {
                    uriMatcher.put(currPattern, currPattern + " _base pattern");
                    uriMatcher.put(currPattern + "/", currPattern + " _base pattern 2");
                }
                catch (Exception e) {
                    logger.logp(Level.SEVERE, CLASS_NAME, "createURIMatcher", "mapping.clash.occurred", new Object[]{currPattern});
                    logger.throwing(CLASS_NAME, "createURIMatcher", e);
                }
                continue;
            }
            try {
                uriMatcher.put(currPattern, currPattern + " _base pattern");
            }
            catch (Exception e) {
                logger.logp(Level.SEVERE, CLASS_NAME, "createURIMatcher", "mapping.clash.occurred", new Object[]{currPattern});
                logger.throwing(CLASS_NAME, "createURIMatcher", e);
            }
        }
        return uriMatcher;
    }

    @Override
    public boolean isAvailable(String resource) {
        Java2SecurityFile caseFile;
        Container c = this._webapp.getModuleContainer();
        if (c != null) {
            Entry entry = c.getEntry(resource);
            if (entry != null) {
                return true;
            }
            return this.isAvailableInDocumentRoot(resource, WCCustomProperties.SERVE_WELCOME_FILE_FROM_EDR);
        }
        String tempFileString = this._webapp.getRealPath(resource);
        boolean available = false;
        if (tempFileString != null && (available = ((File)(caseFile = new Java2SecurityFile(tempFileString))).exists()) && FileSystem.isCaseInsensitive) {
            try {
                available = FileSystem.uriCaseCheck((File)caseFile, (String)resource);
            }
            catch (IOException io) {
                available = false;
            }
        }
        if (!available) {
            available = this.isAvailableInDocumentRoot(resource, WCCustomProperties.SERVE_WELCOME_FILE_FROM_EDR);
        }
        return available;
    }

    public boolean isAvailableInDocumentRoot(String resource, boolean searchEDR) {
        boolean available;
        block8: {
            available = false;
            try {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "isAvailable()", "File not found in WAR directorr so check DocumetRoots");
                }
                DocumentRootUtils docRoot = new DocumentRootUtils((ServletContext)this._webapp, this.extendedDocumentRoot, this.preFragmentExtendedDocumentRoot);
                docRoot.handleDocumentRoots(resource, this.preFragmentExtendedDocumentRoot != null, !WCCustomProperties.SKIP_META_INF_RESOURCES_PROCESSING, searchEDR);
                EntryResource entryr = docRoot.getMatchedEntryResource();
                if (entryr != null && entryr.getEntry() != null) {
                    return true;
                }
                String filePath = docRoot.getFilePath();
                if (filePath != null) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "isAvailable()", "Match found in DocumetRootd");
                    }
                    Java2SecurityFile caseFile = new Java2SecurityFile(filePath);
                    available = ((File)caseFile).exists();
                }
            }
            catch (FileNotFoundException fne) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "isAvailable()", "FileNotFoundException caught");
                }
            }
            catch (IOException ioe) {
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block8;
                logger.logp(Level.FINE, CLASS_NAME, "isAvailable()", "IOException caught");
            }
        }
        return available;
    }

    @Override
    public IServletWrapper createServletWrapper(IServletConfig config) throws Exception {
        File wrapperedFile;
        String filename = this._webapp.getRealPath(config.getFileName());
        if (filename != null && (wrapperedFile = new File(filename)).exists()) {
            return this.getStaticFileWrapper(this._webapp, this, wrapperedFile);
        }
        return null;
    }

    @Override
    public WebComponentMetaData getMetaData() {
        return this.cmd;
    }

    private boolean isRequestForbidden(StringBuffer path) {
        boolean requestIsForbidden = false;
        String matchString = path.toString();
        if (WCCustomProperties.ALLOW_DOTS_IN_NAME) {
            if (matchString.indexOf("..") > -1 && (matchString.indexOf("/../") > -1 || matchString.indexOf("\\..\\") > -1 || matchString.startsWith("../") || matchString.endsWith("/..") || matchString.startsWith("..\\") || matchString.endsWith("\\.."))) {
                requestIsForbidden = true;
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "isRequestForbidden", "bad path :" + matchString);
                }
            }
            if (!requestIsForbidden && (matchString.endsWith("\\") || matchString.endsWith(".") || matchString.endsWith("/"))) {
                requestIsForbidden = true;
            }
        } else if (matchString.lastIndexOf("..") != -1 && !matchString.startsWith("/...") || matchString.endsWith("\\") || matchString.endsWith(".") || matchString.endsWith("/")) {
            requestIsForbidden = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isRequestForbidden", "returning :" + requestIsForbidden + ", matchstring :" + matchString);
        }
        return requestIsForbidden;
    }

    private boolean isDirectoryTraverse(StringBuffer path) {
        boolean directoryTraverse = false;
        String matchString = path.toString();
        if (WCCustomProperties.ALLOW_DOTS_IN_NAME) {
            if (matchString.indexOf("..") > -1 && (matchString.indexOf("/../") > -1 || matchString.indexOf("\\..\\") > -1 || matchString.startsWith("../") || matchString.endsWith("/..") || matchString.startsWith("..\\") || matchString.endsWith("\\.."))) {
                directoryTraverse = true;
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "isDirectoryTraverse", "bad path :" + matchString);
                }
            }
        } else if (matchString.lastIndexOf("..") != -1 && !matchString.startsWith("/...")) {
            directoryTraverse = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isDirectoryTraverse", "returning" + directoryTraverse + " , matchstring :" + matchString);
        }
        return directoryTraverse;
    }

    @Override
    public void nameSpacePostInvoke() {
        this.webAppNameSpaceCollab.postInvoke();
    }

    @Override
    public void nameSpacePreInvoke() {
        this.webAppNameSpaceCollab.preInvoke(this.getMetaData());
    }

    public int getOptimizeFileServingSize() {
        return this.optimizeFileServingSize;
    }

    public void destroy() {
    }

    public ServletConfig getServletConfig() {
        return null;
    }

    public String getServletInfo() {
        return null;
    }

    public void init(ServletConfig arg0) throws ServletException {
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        try {
            this.handleRequest(request, response);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    @Override
    public IServletWrapper getServletWrapper(ServletRequest request, ServletResponse response) {
        return null;
    }

    static {
        DEFAULT_DENY_EXTENSIONS.add("*.jsp");
        DEFAULT_DENY_EXTENSIONS.add("*.jsv");
        DEFAULT_DENY_EXTENSIONS.add("*.jsw");
        DEFAULT_DENY_EXTENSIONS.add("*.jspx");
        try {
            String sizeStr = WCCustomProperties.OPTIMIZE_FILE_SERVING_SIZE_GLOBAL;
            if (sizeStr != null) {
                optimizeFileServingSizeGlobal = Integer.valueOf(WCCustomProperties.OPTIMIZE_FILE_SERVING_SIZE_GLOBAL);
            }
        }
        catch (NumberFormatException nfe) {
            FFDCWrapper.processException(nfe, "com.ibm.ws.webcontainer.extension.DefaultExtensionProcessor.<init>", "65");
        }
    }

    private class Java2SecurityFile
    extends File {
        private static final long serialVersionUID = 1L;

        public Java2SecurityFile(File parent, String child) {
            super(parent, child);
        }

        public Java2SecurityFile(String pathname) {
            super(pathname);
        }

        public Java2SecurityFile(String parent, String child) {
            super(parent, child);
        }

        public Java2SecurityFile(URI uri) {
            super(uri);
        }

        @Override
        public boolean canRead() {
            if (System.getSecurityManager() != null) {
                Java2SecurityFile internalFile = this;
                Boolean returnType = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new Boolean(Java2SecurityFile.this._canRead());
                    }
                });
                return returnType;
            }
            return super.canRead();
        }

        public boolean _canRead() {
            return super.canRead();
        }

        @Override
        public boolean canWrite() {
            if (System.getSecurityManager() != null) {
                Java2SecurityFile internalFile = this;
                Boolean returnType = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new Boolean(Java2SecurityFile.this._canWrite());
                    }
                });
                return returnType;
            }
            return super.canWrite();
        }

        public boolean _canWrite() {
            return super.canWrite();
        }

        @Override
        public boolean delete() {
            if (System.getSecurityManager() != null) {
                Java2SecurityFile internalFile = this;
                Boolean returnType = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new Boolean(Java2SecurityFile.this._delete());
                    }
                });
                return returnType;
            }
            return super.delete();
        }

        public boolean _delete() {
            return super.delete();
        }

        @Override
        public void deleteOnExit() {
            if (System.getSecurityManager() != null) {
                Java2SecurityFile internalFile = this;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Java2SecurityFile.this._deleteOnExit();
                        return null;
                    }
                });
            } else {
                super.deleteOnExit();
            }
        }

        public void _deleteOnExit() {
            super.deleteOnExit();
        }

        @Override
        public boolean exists() {
            if (System.getSecurityManager() != null) {
                Java2SecurityFile internalFile = this;
                Boolean returnType = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new Boolean(Java2SecurityFile.this._exists());
                    }
                });
                return returnType;
            }
            return super.exists();
        }

        public boolean _exists() {
            return super.exists();
        }

        @Override
        public boolean isDirectory() {
            if (System.getSecurityManager() != null) {
                Java2SecurityFile internalFile = this;
                Boolean returnType = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new Boolean(Java2SecurityFile.this._isDirectory());
                    }
                });
                return returnType;
            }
            return super.isDirectory();
        }

        public boolean _isDirectory() {
            return super.isDirectory();
        }

        @Override
        public boolean isFile() {
            if (System.getSecurityManager() != null) {
                Java2SecurityFile internalFile = this;
                Boolean returnType = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new Boolean(Java2SecurityFile.this._isFile());
                    }
                });
                return returnType;
            }
            return super.isFile();
        }

        public boolean _isFile() {
            return super.isFile();
        }

        @Override
        public boolean isHidden() {
            if (System.getSecurityManager() != null) {
                Java2SecurityFile internalFile = this;
                Boolean returnType = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new Boolean(Java2SecurityFile.this._isHidden());
                    }
                });
                return returnType;
            }
            return super.isHidden();
        }

        public boolean _isHidden() {
            return super.isHidden();
        }
    }
}

