/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.internal.jaas;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationData;
import com.ibm.ws.security.authentication.AuthenticationService;
import com.ibm.ws.security.authentication.CertificateAuthenticator;
import com.ibm.ws.security.authentication.collective.CollectiveAuthenticationPlugin;
import com.ibm.ws.security.authentication.internal.JAASService;
import com.ibm.ws.security.authentication.internal.jaas.JAASConfigurationImpl;
import com.ibm.ws.security.credentials.CredentialsService;
import com.ibm.ws.security.jaas.common.JAASChangeNotifier;
import com.ibm.ws.security.jaas.common.JAASConfigurationFactory;
import com.ibm.ws.security.jaas.common.JAASLoginContextEntry;
import com.ibm.ws.security.jaas.common.callback.AuthenticationDataCallbackHandler;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.registry.UserRegistryService;
import com.ibm.ws.security.token.TokenManager;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class JAASServiceImpl
implements JAASService {
    static final TraceComponent tc = Tr.register(JAASServiceImpl.class);
    public static final String KEY_USER_REGISTRY_SERVICE = "userRegistryService";
    public static final String KEY_CREDENTIALS_SERVICE = "credentialsService";
    public static final String KEY_TOKEN_MANAGER = "tokenManager";
    public static final String KEY_JAAS_LOGIN_CONTEXT_ENTRY = "JaasLoginContextEntry";
    public static final String KEY_JAAS_LOGIN_MODULE_CONFIG = "jaasLoginModuleConfig";
    public static final String KEY_JAAS_CONFIG_FACTORY = "jaasConfigurationFactory";
    public static final String KEY_COLLECTIVE_AUTHENTICATON_PLUGIN = "collectiveAuthenticationPlugin";
    static final String KEY_CHANGE_SERVICE = "jaasChangeNotifier";
    static final String KEY_ID = "id";
    static final String KEY_COMPONENT_NAME = "component.name";
    public static final String KEY_CERT_AUTHENTICATOR = "certificateAuthenticator";
    private static final AtomicServiceReference<TokenManager> tokenManager = new AtomicServiceReference("tokenManager");
    private static final AtomicServiceReference<CredentialsService> credentialService = new AtomicServiceReference("credentialsService");
    private static final AtomicServiceReference<UserRegistryService> userRegistryService = new AtomicServiceReference("userRegistryService");
    private static final AtomicServiceReference<CollectiveAuthenticationPlugin> collectiveAuthenticationPlugin = new AtomicServiceReference("collectiveAuthenticationPlugin");
    private static final AtomicServiceReference<JAASConfigurationFactory> jaasConfigurationFactoryRef = new AtomicServiceReference("jaasConfigurationFactory");
    public ConcurrentServiceReferenceMap<String, JAASLoginContextEntry> jaasLoginContextEntries = new ConcurrentServiceReferenceMap("JaasLoginContextEntry");
    private final AtomicServiceReference<JAASChangeNotifier> jaasChangeNotifierService = new AtomicServiceReference("jaasChangeNotifier");
    public static ConcurrentServiceReferenceMap<String, CertificateAuthenticator> certificateAuthenticators = new ConcurrentServiceReferenceMap("certificateAuthenticator");
    protected ComponentContext cc;
    protected Map<String, Object> properties;
    private JAASConfigurationFactory jaasConfigurationFactory;
    private static AuthenticationService authenticationService;
    static final long serialVersionUID = -1451107185686643881L;

    @Reference(service=CollectiveAuthenticationPlugin.class, name="collectiveAuthenticationPlugin", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setCollectiveAuthenticationPlugin(ServiceReference<CollectiveAuthenticationPlugin> ref) {
        collectiveAuthenticationPlugin.setReference(ref);
    }

    public void unsetCollectiveAuthenticationPlugin(ServiceReference<CollectiveAuthenticationPlugin> ref) {
        collectiveAuthenticationPlugin.unsetReference(ref);
    }

    public static CollectiveAuthenticationPlugin getCollectiveAuthenticationPlugin() {
        return (CollectiveAuthenticationPlugin)collectiveAuthenticationPlugin.getService();
    }

    @Reference(service=UserRegistryService.class, name="userRegistryService")
    public void setUserRegistryService(ServiceReference<UserRegistryService> ref) {
        userRegistryService.setReference(ref);
    }

    public void unsetUserRegistryService(ServiceReference<UserRegistryService> ref) {
        userRegistryService.unsetReference(ref);
    }

    public static UserRegistry getUserRegistry() throws RegistryException {
        UserRegistryService urs = (UserRegistryService)userRegistryService.getService();
        return urs.getUserRegistry();
    }

    @Reference(service=TokenManager.class, name="tokenManager")
    public void setTokenManager(ServiceReference<TokenManager> ref) {
        tokenManager.setReference(ref);
    }

    public static TokenManager getTokenManager() {
        return (TokenManager)tokenManager.getService();
    }

    public void unsetTokenManager(ServiceReference<TokenManager> ref) {
        tokenManager.unsetReference(ref);
    }

    @Reference(service=CredentialsService.class, name="credentialsService")
    public void setCredentialsService(ServiceReference<CredentialsService> ref) {
        credentialService.setReference(ref);
    }

    public void unsetCredentialsService(ServiceReference<CredentialsService> ref) {
        credentialService.unsetReference(ref);
    }

    public static CredentialsService getCredentialsService() {
        return (CredentialsService)credentialService.getService();
    }

    public static void setAuthenticationService(AuthenticationService authService) {
        authenticationService = authService;
    }

    public static AuthenticationService getAuthenticationService() {
        return authenticationService;
    }

    public static void unsetAuthenticationService(AuthenticationService authService) {
        if (authenticationService == authService) {
            authenticationService = null;
        }
    }

    @Reference(service=JAASLoginContextEntry.class, name="JaasLoginContextEntry", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setJaasLoginContextEntry(ServiceReference<JAASLoginContextEntry> ref) {
        this.processContextEntry(ref);
    }

    protected void updatedJaasLoginContextEntry(ServiceReference<JAASLoginContextEntry> ref) {
        this.processContextEntry(ref);
    }

    protected void unsetJaasLoginContextEntry(ServiceReference<JAASLoginContextEntry> ref) {
        String id = (String)ref.getProperty(KEY_ID);
        if (this.jaasLoginContextEntries.removeReference((Object)id, ref)) {
            this.modified(this.properties);
        }
    }

    @Reference(service=CertificateAuthenticator.class, name="certificateAuthenticator", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setCertificateAuthenticator(ServiceReference<CertificateAuthenticator> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CertificateAuthenticator key: " + ref.getProperty(KEY_COMPONENT_NAME)), (Object[])new Object[0]);
        }
        certificateAuthenticators.putReference((Object)ref.getProperty(KEY_COMPONENT_NAME).toString(), ref);
    }

    protected void unsetCertificateAuthenticator(ServiceReference<CertificateAuthenticator> ref) {
        certificateAuthenticators.removeReference((Object)ref.getProperty(KEY_COMPONENT_NAME).toString(), ref);
    }

    public static ConcurrentServiceReferenceMap<String, CertificateAuthenticator> getCertificateAuthenticators() {
        return certificateAuthenticators;
    }

    private void processContextEntry(ServiceReference<JAASLoginContextEntry> ref) {
        String id = (String)ref.getProperty(KEY_ID);
        String[] modulePids = (String[])ref.getProperty("loginModuleRef");
        boolean changedEntryContext = false;
        if (modulePids == null || modulePids.length == 0) {
            if (JAASConfigurationImpl.defaultEntryIds.contains(id)) {
                this.jaasLoginContextEntries.putReference((Object)id, ref);
                changedEntryContext = true;
            } else {
                Tr.error((TraceComponent)tc, (String)"JAAS_LOGIN_CONTEXT_ENTRY_HAS_NO_LOGIN_MODULE", (Object[])new Object[]{id});
                changedEntryContext |= this.jaasLoginContextEntries.removeReference((Object)id, ref);
            }
        } else {
            this.jaasLoginContextEntries.putReference((Object)id, ref);
            changedEntryContext = true;
        }
        if (changedEntryContext) {
            this.modified(this.properties);
        }
    }

    @Reference(service=JAASChangeNotifier.class, name="jaasChangeNotifier")
    protected void setJaasChangeNotifier(ServiceReference<JAASChangeNotifier> jaasChangeNotifierRef) {
        this.jaasChangeNotifierService.setReference(jaasChangeNotifierRef);
    }

    protected void unsetJaasChangeNotifier(ServiceReference<JAASChangeNotifier> jaasChangeNotifierRef) {
        this.jaasChangeNotifierService.unsetReference(jaasChangeNotifierRef);
    }

    @Reference(service=JAASConfigurationFactory.class, name="jaasConfigurationFactory")
    public void setJaasConfigurationFactory(ServiceReference<JAASConfigurationFactory> ref) {
        jaasConfigurationFactoryRef.setReference(ref);
    }

    public void unsetJaasConfigurationFactory(ServiceReference<JAASConfigurationFactory> ref) {
        jaasConfigurationFactoryRef.unsetReference(ref);
    }

    @Activate
    public void activate(ComponentContext cc, Map<String, Object> properties) {
        this.jaasLoginContextEntries.activate(cc);
        tokenManager.activate(cc);
        credentialService.activate(cc);
        userRegistryService.activate(cc);
        this.jaasChangeNotifierService.activate(cc);
        collectiveAuthenticationPlugin.activate(cc);
        jaasConfigurationFactoryRef.activate(cc);
        certificateAuthenticators.activate(cc);
        this.modified(properties);
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        this.properties = properties;
        this.jaasConfigurationFactory = (JAASConfigurationFactory)jaasConfigurationFactoryRef.getService();
        if (this.jaasConfigurationFactory != null) {
            this.jaasConfigurationFactory.installJAASConfiguration(this.jaasLoginContextEntries);
            this.configReady();
        }
    }

    @Deactivate
    public void deactivate(ComponentContext cc) {
        tokenManager.deactivate(cc);
        credentialService.deactivate(cc);
        userRegistryService.deactivate(cc);
        this.jaasLoginContextEntries.deactivate(cc);
        this.jaasChangeNotifierService.deactivate(cc);
        collectiveAuthenticationPlugin.deactivate(cc);
        jaasConfigurationFactoryRef.deactivate(cc);
        certificateAuthenticators.deactivate(cc);
        Configuration.setConfiguration(null);
    }

    @Override
    public Subject performLogin(String jaasEntryName, AuthenticationData authenticationData, Subject partialSubject) throws LoginException {
        CallbackHandler callbackHandler = this.createCallbackHandlerForAuthenticationData(authenticationData);
        return this.performLogin(jaasEntryName, callbackHandler, partialSubject);
    }

    @Override
    public Subject performLogin(String jaasEntryName, CallbackHandler callbackHandler, Subject partialSubject) throws LoginException {
        LoginContext loginContext = null;
        loginContext = this.doLoginContext(jaasEntryName, callbackHandler, partialSubject);
        return loginContext == null ? null : loginContext.getSubject();
    }

    private LoginContext doLoginContext(String jaasEntryName, CallbackHandler callbackHandler, Subject partialSubject) throws LoginException {
        LoginContext loginContext = this.createLoginContext(jaasEntryName, callbackHandler, partialSubject);
        loginContext.login();
        return loginContext;
    }

    public CallbackHandler createCallbackHandlerForAuthenticationData(AuthenticationData authenticationData) {
        return new AuthenticationDataCallbackHandler(authenticationData);
    }

    public LoginContext createLoginContext(String jaasEntryName, CallbackHandler callbackHandler, Subject partialSubject) throws LoginException {
        LoginContext loginContext = partialSubject != null ? new LoginContext(jaasEntryName, partialSubject, callbackHandler) : new LoginContext(jaasEntryName, callbackHandler);
        return loginContext;
    }

    public void configReady() {
        JAASChangeNotifier notifier;
        if (authenticationService != null && (notifier = (JAASChangeNotifier)this.jaasChangeNotifierService.getService()) != null) {
            notifier.notifyListeners();
        }
    }
}

