/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.internal.cache.keyproviders;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.websphere.security.auth.TokenExpiredException;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.cache.AuthCacheService;
import com.ibm.ws.security.authentication.cache.CacheContext;
import com.ibm.ws.security.authentication.cache.CacheKeyProvider;
import com.ibm.ws.security.authentication.internal.SSOTokenHelper;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.token.TokenManager;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Map;
import javax.security.auth.Subject;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CustomCacheKeyProvider
implements CacheKeyProvider {
    private static final String[] hashtableProperties;
    private static final AtomicServiceReference<TokenManager> tokenManager;
    private final SubjectHelper subjectHelper = new SubjectHelper();
    static final long serialVersionUID = -9157428249607103354L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void setTokenManager(ServiceReference<TokenManager> ref) {
        tokenManager.setReference(ref);
    }

    protected void unsetTokenManager(ServiceReference<TokenManager> ref) {
        tokenManager.setReference(ref);
    }

    protected void activate(ComponentContext cc, Map<String, Object> properties) {
        tokenManager.activate(cc);
    }

    protected void deactivate(ComponentContext cc) {
        tokenManager.deactivate(cc);
    }

    public Object provideKey(CacheContext context) {
        return this.getCustomCacheKey(context.getSubject());
    }

    @FFDCIgnore(value={InvalidTokenException.class, TokenExpiredException.class})
    public static String getCustomCacheKey(AuthCacheService authCacheService, byte[] ssoTokenBytes) throws AuthenticationException {
        String customCacheKey = null;
        TokenManager tokenManager = (TokenManager)CustomCacheKeyProvider.tokenManager.getService();
        if (tokenManager == null) {
            return null;
        }
        try {
            Token recreatedToken = tokenManager.recreateTokenFromBytes(ssoTokenBytes);
            String[] attrs = recreatedToken.getAttributes("com.ibm.wsspi.security.cred.cacheKey");
            if (attrs != null && attrs.length > 0) {
                customCacheKey = attrs[0];
            }
        }
        catch (InvalidTokenException e) {
            throw new AuthenticationException(e.getMessage());
        }
        catch (TokenExpiredException e) {
            throw new AuthenticationException(e.getMessage());
        }
        return customCacheKey;
    }

    private String getCustomCacheKey(final Subject subject) {
        String[] attrs;
        SingleSignonToken ssoToken;
        String customCacheKey = null;
        Hashtable customProperties = this.subjectHelper.getHashtableFromSubject(subject, hashtableProperties);
        if (customProperties != null) {
            customCacheKey = (String)customProperties.get("com.ibm.wsspi.security.cred.cacheKey");
        }
        if (customCacheKey == null && (ssoToken = AccessController.doPrivileged(new PrivilegedAction<SingleSignonToken>(){
            static final long serialVersionUID = -3718579988527352627L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public SingleSignonToken run() {
                return SSOTokenHelper.getSSOToken(subject);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        })) != null && (attrs = ssoToken.getAttributes("com.ibm.wsspi.security.cred.cacheKey")) != null) {
            customCacheKey = attrs[0];
        }
        return customCacheKey;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(CustomCacheKeyProvider.class);
        hashtableProperties = new String[]{"com.ibm.wsspi.security.cred.cacheKey"};
        tokenManager = new AtomicServiceReference("tokenManager");
    }
}

