/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resolver.internal;

import com.ibm.ws.repository.connections.RepositoryConnectionList;
import com.ibm.ws.repository.exceptions.RepositoryBackendException;
import com.ibm.ws.repository.resolver.internal.ResolutionFilter;
import com.ibm.ws.repository.resolver.internal.resource.FeatureResource;
import com.ibm.ws.repository.resolver.internal.resource.InstallableEntityRequirement;
import com.ibm.ws.repository.resolver.internal.resource.SampleResource;
import com.ibm.ws.repository.resources.EsaResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.HostedCapability;
import org.osgi.service.resolver.ResolveContext;

public class RepositoryResolveContext
extends ResolveContext {
    private final Collection<Resource> mandatoryResources;
    private final Collection<Resource> optionalResources;
    private final List<Resource> installedResources;
    private static final Map<Resource, Wiring> WIRINGS = Collections.emptyMap();
    private final Logger logger = Logger.getLogger(RepositoryResolveContext.class.getName());
    private final List<Resource> installedProducts;
    private final List<Resource> repoResources;
    private final Collection<Requirement> requirementsNotFound = new HashSet<Requirement>();
    private final RepositoryConnectionList loginInfo;
    private final Collection<ResolutionFilter> filters = new HashSet<ResolutionFilter>();

    public RepositoryResolveContext(Collection<Resource> mandatoryResources, Collection<Resource> optionalResources, List<Resource> installedProducts, List<Resource> installedResources, List<Resource> repoResources, RepositoryConnectionList loginInfo) {
        this.mandatoryResources = mandatoryResources;
        this.optionalResources = optionalResources;
        this.installedProducts = installedProducts;
        this.installedResources = installedResources;
        this.repoResources = repoResources;
        this.loginInfo = loginInfo;
    }

    public List<Capability> findProviders(Requirement requirement) {
        List<Capability> repoCapabilities;
        List<Capability> providers = this.findProviders(requirement, this.installedProducts);
        if (providers.isEmpty()) {
            providers = this.findProviders(requirement, this.installedResources);
        }
        if (providers.isEmpty() && this.allowResolvingToRepoCapabilities(requirement, repoCapabilities = this.findProviders(requirement, this.repoResources))) {
            providers = repoCapabilities;
        }
        if (providers.isEmpty()) {
            if (this.loginInfo != null && requirement instanceof InstallableEntityRequirement && this.allowResolvingToRepoCapabilities(requirement, providers)) {
                InstallableEntityRequirement installableEntityRequirement = (InstallableEntityRequirement)requirement;
                if ("osgi.subsystem.feature".equals(installableEntityRequirement.getType())) {
                    try {
                        Collection esaMassiveResources = this.loginInfo.getMatchingEsas(installableEntityRequirement.getNameAttribute().getFeatureFilterAttribute(), installableEntityRequirement.getName());
                        for (EsaResource esaMassiveResource : esaMassiveResources) {
                            FeatureResource featureResource = FeatureResource.createInstance(esaMassiveResource);
                            if (this.repoResources.contains(featureResource)) continue;
                            this.repoResources.add(featureResource);
                        }
                    }
                    catch (RepositoryBackendException e) {
                        // empty catch block
                    }
                    providers = this.findProviders(requirement, this.repoResources);
                } else if ("sample".equals(installableEntityRequirement.getType())) {
                    try {
                        Collection sampleMassiveResources = this.loginInfo.getMatchingSamples(installableEntityRequirement.getNameAttribute().getFeatureFilterAttribute(), installableEntityRequirement.getName());
                        for (com.ibm.ws.repository.resources.SampleResource sampleMassiveResource : sampleMassiveResources) {
                            SampleResource sampleResource = SampleResource.createInstance(sampleMassiveResource);
                            if (this.repoResources.contains(sampleResource)) continue;
                            this.repoResources.add(sampleResource);
                        }
                    }
                    catch (RepositoryBackendException e) {
                        // empty catch block
                    }
                    providers = this.findProviders(requirement, this.repoResources);
                }
            }
            if (providers.isEmpty()) {
                this.requirementsNotFound.add(requirement);
            }
        }
        return providers;
    }

    private boolean allowResolvingToRepoCapabilities(Requirement requirement, List<Capability> repoCapabilities) {
        boolean allowResolvingToRepoCapabilities = true;
        for (ResolutionFilter filter : this.filters) {
            if (filter.allowResolution(requirement, repoCapabilities)) continue;
            allowResolvingToRepoCapabilities = false;
            break;
        }
        return allowResolvingToRepoCapabilities;
    }

    private List<Capability> findProviders(Requirement requirement, List<Resource> providers) {
        ArrayList<Capability> result = new ArrayList<Capability>();
        for (Resource resource : providers) {
            for (Capability c : resource.getCapabilities(requirement.getNamespace())) {
                if (!this.match(requirement, c)) continue;
                result.add(c);
            }
        }
        return result;
    }

    private boolean match(Requirement requirement, Capability capability) {
        String requirementNamespace = requirement.getNamespace();
        String capabilityNamespace = capability.getNamespace();
        if (requirementNamespace != null ? !requirementNamespace.equals(capabilityNamespace) : capabilityNamespace != null) {
            return false;
        }
        String filterString = (String)requirement.getDirectives().get("filter");
        if (filterString != null) {
            try {
                Filter filter = FrameworkUtil.createFilter((String)filterString);
                if (!filter.matches(capability.getAttributes())) {
                    return false;
                }
            }
            catch (InvalidSyntaxException e) {
                this.logger.log(Level.SEVERE, "Error in the filter string \"" + filterString + "\":" + e.getMessage(), e);
                return false;
            }
        }
        return true;
    }

    public Collection<Resource> getMandatoryResources() {
        return this.mandatoryResources;
    }

    public Collection<Resource> getOptionalResources() {
        return this.optionalResources;
    }

    public Map<Resource, Wiring> getWirings() {
        return WIRINGS;
    }

    public int insertHostedCapability(List<Capability> caps, HostedCapability hc) {
        caps.add((Capability)hc);
        return caps.size() - 1;
    }

    public boolean isEffective(Requirement requirement) {
        return true;
    }

    public Collection<Requirement> getRequirementsNotFound() {
        return this.requirementsNotFound;
    }

    public void addFilter(ResolutionFilter filter) {
        this.filters.add(filter);
    }
}

