/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.client.rest.internal;

import com.ibm.ws.jmx.connector.client.rest.internal.ClientConstants;
import com.ibm.ws.jmx.connector.client.rest.internal.DynamicURL;
import com.ibm.ws.jmx.connector.client.rest.internal.NotificationListenerEntry;
import com.ibm.ws.jmx.connector.client.rest.internal.ObjectIdentityCache;
import com.ibm.ws.jmx.connector.client.rest.internal.RESTMBeanServerConnection;
import com.ibm.ws.jmx.connector.client.rest.internal.ServerNotificationListenerEntry;
import com.ibm.ws.jmx.connector.client.rest.internal.resources.RESTClientMessagesUtil;
import com.ibm.ws.jmx.connector.converter.JSONConverter;
import com.ibm.ws.jmx.connector.converter.NotificationTargetInformation;
import com.ibm.ws.jmx.connector.datatypes.NotificationArea;
import com.ibm.ws.jmx.connector.datatypes.NotificationRegistration;
import com.ibm.ws.jmx.connector.datatypes.NotificationSettings;
import com.ibm.ws.jmx.connector.datatypes.ServerNotificationRegistration;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.RuntimeOperationsException;
import javax.net.ssl.HttpsURLConnection;

class NotificationRegistry {
    private static final Logger logger = Logger.getLogger(NotificationRegistry.class.getName());
    private final RESTMBeanServerConnection serverConnection;
    private DynamicURL inboxURL;
    private DynamicURL registrationsURL;
    private DynamicURL serverRegistrationsURL;
    private DynamicURL notificationClientURL;
    private final Map<NotificationTargetInformation, ClientNotificationRegistration> registrationMap = Collections.synchronizedMap(new HashMap());
    private final List<ServerNotificationListenerEntry> serverRegistrationList = Collections.synchronizedList(new ArrayList());
    private ObjectIdentityCache identityCache;
    private final JSONConverter converter = JSONConverter.getConverter();

    NotificationRegistry(RESTMBeanServerConnection serverConnection) throws IOException {
        this.serverConnection = serverConnection;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "init", "Initializing registry " + RESTClientMessagesUtil.getObjID(this) + " within connection: " + serverConnection.getConnector().getConnectionId());
        }
        try {
            this.setupNotificationArea();
        }
        catch (IOException io) {
        }
        catch (Throwable t) {
            throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
        }
    }

    protected void setupNotificationArea() throws Throwable {
        String sourceMethod = "setupNotificationArea";
        URL notificationsURL = null;
        HttpsURLConnection connection = null;
        try {
            notificationsURL = this.serverConnection.getNotificationsURL();
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "setupNotificationArea", "[" + RESTClientMessagesUtil.getObjID(this) + "] About to call notificationURL: " + notificationsURL);
            }
            connection = this.serverConnection.getConnection(notificationsURL, ClientConstants.HttpMethod.POST, true);
            NotificationSettings ns = new NotificationSettings();
            ns.deliveryInterval = this.serverConnection.getConnector().getNotificationDeliveryInterval();
            ns.inboxExpiry = this.serverConnection.getConnector().getNotificationInboxExpiry();
            OutputStream output = connection.getOutputStream();
            this.converter.writeNotificationSettings(output, ns);
            output.flush();
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (IOException io) {
            throw this.serverConnection.getRequestErrorException("setupNotificationArea", io, notificationsURL);
        }
        int responseCode = connection.getResponseCode();
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "setupNotificationArea", "Received responseCode: " + responseCode);
        }
        switch (responseCode) {
            case 200: {
                JSONConverter converter = JSONConverter.getConverter();
                try {
                    NotificationArea area = converter.readNotificationArea(connection.getInputStream());
                    this.inboxURL = new DynamicURL(this.serverConnection.connector, area.inboxURL);
                    this.registrationsURL = new DynamicURL(this.serverConnection.connector, area.registrationsURL);
                    this.serverRegistrationsURL = new DynamicURL(this.serverConnection.connector, area.serverRegistrationsURL);
                    this.notificationClientURL = new DynamicURL(this.serverConnection.connector, area.clientURL);
                    if (!logger.isLoggable(Level.FINER)) break;
                    logger.logp(Level.FINER, logger.getName(), "setupNotificationArea", "Successfully setup inboxURL: " + this.inboxURL.getURL());
                    break;
                }
                catch (Exception e) {
                    throw this.serverConnection.getResponseErrorException("setupNotificationArea", e, notificationsURL);
                }
                finally {
                    JSONConverter.returnConverter(converter);
                }
            }
            case 404: {
                throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.url.not.found", new Object[0]));
            }
            case 400: 
            case 500: 
            case 503: {
                throw this.serverConnection.getServerThrowable("setupNotificationArea", connection);
            }
            case 401: 
            case 403: {
                throw this.serverConnection.getBadCredentialsException(responseCode, connection);
            }
            default: {
                throw this.serverConnection.getResponseCodeErrorException("setupNotificationArea", responseCode, connection);
            }
        }
    }

    synchronized void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "addNotificationListener", "[" + RESTClientMessagesUtil.getObjID(this) + "] objectName: " + name + " | listener: " + listener + " | filter: " + filter + " | handback: " + handback);
        }
        if (!this.serverConnection.isRegistered(name)) {
            throw new InstanceNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.instance.not.found", name));
        }
        NotificationTargetInformation nti = this.serverConnection.isServerLevelRouting() ? new NotificationTargetInformation(name, this.serverConnection.mapRouting) : new NotificationTargetInformation(name);
        NotificationListenerEntry set = new NotificationListenerEntry(listener, filter, handback);
        ClientNotificationRegistration localRegistration = this.registrationMap.get(nti);
        if (localRegistration == null) {
            localRegistration = new ClientNotificationRegistration(nti);
            this.registrationMap.put(nti, localRegistration);
        }
        localRegistration.addNotificationListenerEntry(set);
        this.serverConnection.setPollingMode(RESTMBeanServerConnection.PollingMode.NOTIFICATION);
    }

    synchronized void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "addNotificationListener", "[" + RESTClientMessagesUtil.getObjID(this) + "] objectName: " + name + " | listener: " + listener + " | filter: " + filter + " | handback: " + handback);
        }
        NotificationTargetInformation nti = this.serverConnection.isServerLevelRouting() ? new NotificationTargetInformation(name, this.serverConnection.mapRouting) : new NotificationTargetInformation(name);
        try {
            this.updateServerNotificationRegistration(nti, listener, filter, handback, ServerNotificationRegistration.Operation.Add);
            this.serverRegistrationList.add(new ServerNotificationListenerEntry(nti, listener, filter, handback));
        }
        catch (ListenerNotFoundException lnf) {
            throw new IOException(lnf);
        }
        this.serverConnection.setPollingMode(RESTMBeanServerConnection.PollingMode.NOTIFICATION);
    }

    synchronized void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "removeNotificationListener", "[" + RESTClientMessagesUtil.getObjID(this) + "] objectName: " + name + " | listener: " + listener);
        }
        NotificationTargetInformation nti = this.serverConnection.isServerLevelRouting() ? new NotificationTargetInformation(name, this.serverConnection.mapRouting) : new NotificationTargetInformation(name);
        this.updateServerNotificationRegistration(nti, listener, null, null, ServerNotificationRegistration.Operation.RemoveAll);
        Iterator<ServerNotificationListenerEntry> iterator = this.serverRegistrationList.iterator();
        while (iterator.hasNext()) {
            ServerNotificationListenerEntry entry = iterator.next();
            if (!entry.nti.equals(nti) || !entry.listener.equals(listener)) continue;
            iterator.remove();
        }
        this.cleanupIfEmpty();
    }

    synchronized void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "removeNotificationListener", "[" + RESTClientMessagesUtil.getObjID(this) + "] objectName: " + name + " | listener: " + listener + " | filter: " + filter + " | handback: " + handback);
        }
        NotificationTargetInformation nti = this.serverConnection.isServerLevelRouting() ? new NotificationTargetInformation(name, this.serverConnection.mapRouting) : new NotificationTargetInformation(name);
        this.updateServerNotificationRegistration(nti, listener, filter, handback, ServerNotificationRegistration.Operation.RemoveSpecific);
        this.serverRegistrationList.remove(new ServerNotificationListenerEntry(nti, listener, filter, handback));
        this.cleanupIfEmpty();
    }

    synchronized void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.removeNotificationListener(name, listener, null, null, true);
    }

    synchronized void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.removeNotificationListener(name, listener, filter, handback, false);
    }

    void close() {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "close", "Closing registry " + RESTClientMessagesUtil.getObjID(this));
        }
        if (this.serverConnection.isConnected()) {
            this.sendClosingSignal();
        }
        JSONConverter.returnConverter(this.converter);
    }

    private void sendClosingSignal() {
        URL clientURL = null;
        HttpsURLConnection connection = null;
        try {
            clientURL = this.serverConnection.serverVersion >= 4 ? this.getNotificationClientURL() : this.getInboxURL();
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "sendClosingSignal", "Making a call to delete inbox [" + clientURL + "] from [" + RESTClientMessagesUtil.getObjID(this) + "]");
            }
            connection = this.serverConnection.getConnection(clientURL, ClientConstants.HttpMethod.DELETE, true);
            connection.setReadTimeout(this.serverConnection.getConnector().getReadTimeout());
            int responseCode = 0;
            try {
                responseCode = connection.getResponseCode();
            }
            catch (ConnectException ce) {
                logger.logp(Level.FINE, logger.getName(), "sendClosingSignal", ce.getMessage(), ce);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "sendClosingSignal", "Response code: " + responseCode);
            }
        }
        catch (IOException io) {
            logger.logp(Level.FINE, logger.getName(), "sendClosingSignal", io.getMessage(), io);
        }
    }

    synchronized void connectionFailed(Throwable t) {
        this.serverConnection.connectionFailed(t);
    }

    private void updateServerNotificationRegistration(NotificationTargetInformation nti, ObjectName listener, NotificationFilter filter, Object handback, ServerNotificationRegistration.Operation operation) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        String sourceMethod = "updateServerNotificationRegistration";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "updateServerNotificationRegistration", "[" + RESTClientMessagesUtil.getObjID(this) + "] objectName: " + nti.getName() + " | listener: " + listener + " | filter: " + filter + " | handback: " + handback + " | operation: " + (Object)((Object)operation));
        }
        URL serverRegistrationsURL = null;
        HttpsURLConnection connection = null;
        try {
            serverRegistrationsURL = this.getServerRegistrationsURL();
            connection = this.serverConnection.getConnection(serverRegistrationsURL, ClientConstants.HttpMethod.POST, true, nti.getRoutingInformation());
            ServerNotificationRegistration snr = new ServerNotificationRegistration();
            snr.objectName = nti.getName();
            snr.listener = listener;
            if (operation == ServerNotificationRegistration.Operation.Add) {
                snr.filter = filter;
                snr.handback = handback;
            }
            if (operation != ServerNotificationRegistration.Operation.RemoveAll) {
                if (this.identityCache == null) {
                    this.identityCache = new ObjectIdentityCache();
                }
                snr.filterID = this.identityCache.getObjectIdentity(filter);
                snr.handbackID = this.identityCache.getObjectIdentity(handback);
            }
            snr.operation = operation;
            OutputStream output = connection.getOutputStream();
            this.converter.writeServerNotificationRegistration(output, snr);
            output.flush();
            output.close();
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (IOException io) {
            throw this.serverConnection.getRequestErrorException("updateServerNotificationRegistration", io, serverRegistrationsURL);
        }
        int responseCode = 0;
        try {
            responseCode = connection.getResponseCode();
        }
        catch (ConnectException ce) {
            this.serverConnection.recoverConnection(ce);
            throw ce;
        }
        switch (responseCode) {
            case 204: {
                break;
            }
            case 404: 
            case 410: {
                try {
                    throw this.serverConnection.getServerThrowable("updateServerNotificationRegistration", connection);
                }
                catch (IOException io) {
                    this.serverConnection.recoverConnection(io);
                    throw io;
                }
                catch (Throwable t) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                }
            }
            case 400: 
            case 500: {
                try {
                    throw this.converter.readThrowable(connection.getErrorStream());
                }
                catch (RuntimeOperationsException roe) {
                    throw roe;
                }
                catch (ListenerNotFoundException lnf) {
                    throw lnf;
                }
                catch (InstanceNotFoundException inf) {
                    throw inf;
                }
                catch (IOException io) {
                    throw io;
                }
                catch (ClassNotFoundException cnf) {
                    throw new IOException(cnf);
                }
                catch (Throwable t) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                }
            }
            case 401: 
            case 403: {
                throw this.serverConnection.getBadCredentialsException(responseCode, connection);
            }
            default: {
                throw this.serverConnection.getResponseCodeErrorException("updateServerNotificationRegistration", responseCode, connection);
            }
        }
    }

    private void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback, boolean matchListenerOnly) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "removeNotificationListener", "[" + RESTClientMessagesUtil.getObjID(this) + "] objectName: " + name + " | listener: " + listener + " | filter: " + filter + " | handback: " + handback + " | matchListenerOnly: " + matchListenerOnly);
        }
        if (!this.serverConnection.isRegistered(name)) {
            throw new InstanceNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.instance.not.found", name));
        }
        NotificationTargetInformation nti = this.serverConnection.isServerLevelRouting() ? new NotificationTargetInformation(name, this.serverConnection.mapRouting) : new NotificationTargetInformation(name);
        ClientNotificationRegistration localRegistration = this.registrationMap.get(nti);
        if (localRegistration == null) {
            throw new ListenerNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.listener.not.found", name));
        }
        localRegistration.removeNotificationListenerEntries(name, listener, filter, handback, matchListenerOnly);
        if (localRegistration.isEmpty()) {
            this.registrationMap.remove(nti);
        }
        this.cleanupIfEmpty();
    }

    private void cleanupIfEmpty() {
        if (this.registrationMap.isEmpty() && this.serverRegistrationList.isEmpty()) {
            this.serverConnection.discardNotificationRegistry();
        }
    }

    protected synchronized boolean restoreNotificationRegistrations(boolean sendRestoreNotification) {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "restoreNotificationRegistrations", "[" + RESTClientMessagesUtil.getObjID(this) + "]");
        }
        ArrayList<NotificationTargetInformation> clientRemovalList = new ArrayList<NotificationTargetInformation>();
        ArrayList<ServerNotificationListenerEntry> serverRemovalList = new ArrayList<ServerNotificationListenerEntry>();
        ArrayList<OperationsException> exceptions = null;
        for (Map.Entry<NotificationTargetInformation, ClientNotificationRegistration> entry : this.registrationMap.entrySet()) {
            try {
                entry.getValue().createNotificationRegistration();
            }
            catch (IOException io) {
                return false;
            }
            catch (InstanceNotFoundException inf) {
                if (exceptions == null) {
                    exceptions = new ArrayList<OperationsException>();
                }
                clientRemovalList.add(entry.getKey());
                exceptions.add(inf);
            }
        }
        for (ServerNotificationListenerEntry snl : this.serverRegistrationList) {
            try {
                this.updateServerNotificationRegistration(snl.nti, snl.listener, snl.filter, snl.handback, ServerNotificationRegistration.Operation.Add);
            }
            catch (IOException io) {
                return false;
            }
            catch (OperationsException oe) {
                if (exceptions == null) {
                    exceptions = new ArrayList();
                }
                serverRemovalList.add(snl);
                exceptions.add(oe);
            }
        }
        if (exceptions != null) {
            for (NotificationTargetInformation clientEntry : clientRemovalList) {
                this.registrationMap.remove(clientEntry);
            }
            for (ServerNotificationListenerEntry snl : serverRemovalList) {
                this.serverRegistrationList.remove(snl);
            }
        }
        if (sendRestoreNotification) {
            this.serverConnection.getConnector().connectionRestored(exceptions != null ? exceptions.toArray(new Exception[exceptions.size()]) : null);
        }
        return true;
    }

    protected URL getInboxURL() throws IOException {
        return this.inboxURL.getURL();
    }

    protected URL getNotificationClientURL() throws IOException {
        return this.notificationClientURL.getURL();
    }

    protected DynamicURL getRegistrationsURL() throws IOException {
        return this.registrationsURL;
    }

    protected URL getServerRegistrationsURL() throws IOException {
        return this.serverRegistrationsURL.getURL();
    }

    public Map<NotificationTargetInformation, ClientNotificationRegistration> getRegistrationMap() {
        return this.registrationMap;
    }

    class ClientNotificationRegistration {
        private final NotificationTargetInformation listenerKey;
        private DynamicURL registrationURL;
        private final List<NotificationListenerEntry> entries;
        private List<NotificationFilter> serverFilters;

        ClientNotificationRegistration(NotificationTargetInformation listenerKey) {
            this.listenerKey = listenerKey;
            this.entries = new ArrayList<NotificationListenerEntry>();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "ClientNotificationRegistrion init", "[" + RESTClientMessagesUtil.getObjID(NotificationRegistry.this) + "] | [" + RESTClientMessagesUtil.getObjID(this) + "] | objectName: " + listenerKey.getName());
            }
        }

        synchronized void addNotificationListenerEntry(NotificationListenerEntry entry) throws InstanceNotFoundException, IOException {
            boolean serverFiltersUpdated;
            boolean receiveAllNotifications;
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "addNotificationListenerEntry", "[" + RESTClientMessagesUtil.getObjID(this) + "]");
            }
            boolean bl = receiveAllNotifications = entry.filter == null || !NotificationRegistry.this.converter.isSupportedNotificationFilter(entry.filter);
            if (receiveAllNotifications) {
                if (this.serverFilters != null) {
                    this.serverFilters = null;
                    serverFiltersUpdated = true;
                } else {
                    serverFiltersUpdated = false;
                }
            } else if (this.serverFilters != null || this.entries.size() == 0) {
                if (this.serverFilters == null) {
                    this.serverFilters = new ArrayList<NotificationFilter>();
                }
                this.serverFilters.add(entry.filter);
                serverFiltersUpdated = true;
            } else {
                serverFiltersUpdated = false;
            }
            this.entries.add(entry);
            if (this.registrationURL == null) {
                this.createNotificationRegistration();
            } else if (serverFiltersUpdated) {
                this.updateNotificationRegistration();
            }
        }

        synchronized void removeNotificationListenerEntries(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback, boolean matchListenerOnly) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            boolean serverFiltersUpdated;
            boolean listenerFound = false;
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "removeNotificationListenerEntries", "[" + RESTClientMessagesUtil.getObjID(this) + "] | objectName: " + name + " | listener: " + listener + " | filter: " + filter + " | handback: " + handback + " | matchListenerOnly: " + matchListenerOnly);
            }
            Iterator<NotificationListenerEntry> entryIterator = this.entries.iterator();
            while (entryIterator.hasNext()) {
                NotificationListenerEntry entry = entryIterator.next();
                if (entry.listener != listener || !matchListenerOnly && (entry.filter != filter || entry.handback != handback)) continue;
                listenerFound = true;
                entryIterator.remove();
                if (matchListenerOnly) continue;
                break;
            }
            if (!listenerFound) {
                throw new ListenerNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.listener.not.found", name));
            }
            ArrayList<NotificationFilter> newServerFilters = null;
            for (NotificationListenerEntry entry : this.entries) {
                if (entry.filter == null || !NotificationRegistry.this.converter.isSupportedNotificationFilter(entry.filter)) {
                    newServerFilters = null;
                    break;
                }
                if (newServerFilters == null) {
                    newServerFilters = new ArrayList<NotificationFilter>();
                }
                newServerFilters.add(entry.filter);
            }
            if (this.serverFilters != null && !this.serverFilters.equals(newServerFilters) || this.serverFilters == null && newServerFilters != null) {
                serverFiltersUpdated = true;
                this.serverFilters = newServerFilters;
            } else {
                serverFiltersUpdated = false;
            }
            if (this.isEmpty()) {
                this.deleteNotificationRegistration();
            } else if (serverFiltersUpdated) {
                this.updateNotificationRegistration();
            }
        }

        private NotificationFilter[] getServerFilters() {
            if (this.serverFilters == null) {
                return null;
            }
            NotificationFilter[] serverFilterArray = new NotificationFilter[this.serverFilters.size()];
            return this.serverFilters.toArray(serverFilterArray);
        }

        private URL getRegistrationURL() throws IOException {
            return this.registrationURL.getURL();
        }

        boolean isEmpty() {
            return this.entries.isEmpty();
        }

        synchronized void handleNotification(Notification notification) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "handleNotification", "[" + RESTClientMessagesUtil.getObjID(this) + " | Notification: " + notification);
            }
            for (NotificationListenerEntry entry : this.entries) {
                entry.handleNotification(notification);
            }
        }

        synchronized void createNotificationRegistration() throws InstanceNotFoundException, IOException {
            String sourceMethod = "createNotificationRegistration";
            URL registrationsURL = null;
            HttpsURLConnection connection = null;
            try {
                registrationsURL = NotificationRegistry.this.getRegistrationsURL().getURL();
                connection = NotificationRegistry.this.serverConnection.getConnection(registrationsURL, ClientConstants.HttpMethod.POST, true, this.listenerKey.getRoutingInformation());
                NotificationRegistration nr = new NotificationRegistration();
                nr.objectName = this.listenerKey.getName();
                nr.filters = this.getServerFilters();
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, logger.getName(), "createNotificationRegistration", RESTClientMessagesUtil.getObjID(this));
                }
                OutputStream output = connection.getOutputStream();
                NotificationRegistry.this.converter.writeNotificationRegistration(output, nr);
                output.flush();
                output.close();
            }
            catch (ConnectException ce) {
                NotificationRegistry.this.serverConnection.recoverConnection(ce);
                throw ce;
            }
            catch (IOException io) {
                throw NotificationRegistry.this.serverConnection.getRequestErrorException("createNotificationRegistration", io, registrationsURL);
            }
            int responseCode = 0;
            try {
                responseCode = connection.getResponseCode();
            }
            catch (ConnectException ce) {
                NotificationRegistry.this.serverConnection.recoverConnection(ce);
                throw ce;
            }
            switch (responseCode) {
                case 200: {
                    try {
                        String url = NotificationRegistry.this.converter.readString(connection.getInputStream());
                        this.registrationURL = new DynamicURL(((NotificationRegistry)NotificationRegistry.this).serverConnection.connector, url);
                        break;
                    }
                    catch (Exception e) {
                        throw NotificationRegistry.this.serverConnection.getResponseErrorException("createNotificationRegistration", e, registrationsURL);
                    }
                }
                case 404: 
                case 410: {
                    IOException ioe = NotificationRegistry.this.serverConnection.getResponseCodeErrorException("createNotificationRegistration", responseCode, connection);
                    NotificationRegistry.this.serverConnection.recoverConnection(ioe);
                    throw ioe;
                }
                case 400: 
                case 500: {
                    try {
                        throw NotificationRegistry.this.serverConnection.getServerThrowable("createNotificationRegistration", connection);
                    }
                    catch (RuntimeOperationsException roe) {
                        throw roe;
                    }
                    catch (InstanceNotFoundException inf) {
                        throw inf;
                    }
                    catch (IOException io) {
                        throw io;
                    }
                    catch (ClassNotFoundException cnf) {
                        throw new IOException(cnf);
                    }
                    catch (Throwable t) {
                        throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                    }
                }
                case 401: 
                case 403: {
                    throw NotificationRegistry.this.serverConnection.getBadCredentialsException(responseCode, connection);
                }
                default: {
                    throw NotificationRegistry.this.serverConnection.getResponseCodeErrorException("createNotificationRegistration", responseCode, connection);
                }
            }
        }

        private void updateNotificationRegistration() throws InstanceNotFoundException, IOException {
            String sourceMethod = "updateNotificationRegistration";
            URL registrationURL = null;
            HttpsURLConnection connection = null;
            try {
                registrationURL = this.getRegistrationURL();
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, logger.getName(), "updateNotificationRegistration", RESTClientMessagesUtil.getObjID(this));
                }
                connection = NotificationRegistry.this.serverConnection.getConnection(registrationURL, ClientConstants.HttpMethod.PUT, true, this.listenerKey.getRoutingInformation());
                OutputStream output = connection.getOutputStream();
                NotificationRegistry.this.converter.writeNotificationFilters(output, this.getServerFilters());
                output.flush();
                output.close();
            }
            catch (ConnectException ce) {
                NotificationRegistry.this.serverConnection.recoverConnection(ce);
                throw ce;
            }
            catch (IOException io) {
                throw NotificationRegistry.this.serverConnection.getRequestErrorException("updateNotificationRegistration", io, registrationURL);
            }
            int responseCode = 0;
            try {
                responseCode = connection.getResponseCode();
            }
            catch (ConnectException ce) {
                NotificationRegistry.this.serverConnection.recoverConnection(ce);
                throw ce;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "updateNotificationRegistration", "response code: " + responseCode);
            }
            switch (responseCode) {
                case 204: {
                    break;
                }
                case 404: 
                case 410: {
                    IOException ioe = NotificationRegistry.this.serverConnection.getResponseCodeErrorException("updateNotificationRegistration", responseCode, connection);
                    NotificationRegistry.this.serverConnection.recoverConnection(ioe);
                    throw ioe;
                }
                case 400: 
                case 500: {
                    try {
                        throw NotificationRegistry.this.converter.readThrowable(connection.getErrorStream());
                    }
                    catch (InstanceNotFoundException inf) {
                        throw inf;
                    }
                    catch (IOException io) {
                        throw io;
                    }
                    catch (ClassNotFoundException cnf) {
                        throw new IOException(cnf);
                    }
                    catch (Throwable t) {
                        throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                    }
                }
                case 401: 
                case 403: {
                    throw NotificationRegistry.this.serverConnection.getBadCredentialsException(responseCode, connection);
                }
                default: {
                    throw NotificationRegistry.this.serverConnection.getResponseCodeErrorException("updateNotificationRegistration", responseCode, connection);
                }
            }
        }

        private void deleteNotificationRegistration() throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            String sourceMethod = "deleteNotificationRegistration";
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "deleteNotificationRegistration", RESTClientMessagesUtil.getObjID(this));
            }
            URL registrationURL = null;
            HttpsURLConnection connection = null;
            try {
                registrationURL = this.getRegistrationURL();
                connection = NotificationRegistry.this.serverConnection.getConnection(registrationURL, ClientConstants.HttpMethod.DELETE, true, this.listenerKey.getRoutingInformation());
            }
            catch (IOException io) {
                throw NotificationRegistry.this.serverConnection.getRequestErrorException("deleteNotificationRegistration", io, registrationURL);
            }
            int responseCode = 0;
            try {
                responseCode = connection.getResponseCode();
            }
            catch (ConnectException ce) {
                NotificationRegistry.this.serverConnection.recoverConnection(ce);
                throw ce;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "deleteNotificationRegistration", "Response code: " + responseCode);
            }
            switch (responseCode) {
                case 204: {
                    break;
                }
                case 404: 
                case 410: {
                    IOException ioe = NotificationRegistry.this.serverConnection.getResponseCodeErrorException("deleteNotificationRegistration", responseCode, connection);
                    NotificationRegistry.this.serverConnection.recoverConnection(ioe);
                    throw ioe;
                }
                case 400: 
                case 500: {
                    try {
                        throw NotificationRegistry.this.converter.readThrowable(connection.getInputStream());
                    }
                    catch (InstanceNotFoundException inf) {
                        throw inf;
                    }
                    catch (ListenerNotFoundException lnf) {
                        throw lnf;
                    }
                    catch (IOException io) {
                        throw io;
                    }
                    catch (Throwable t) {
                        throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                    }
                }
                case 401: 
                case 403: {
                    throw NotificationRegistry.this.serverConnection.getBadCredentialsException(responseCode, connection);
                }
                default: {
                    throw NotificationRegistry.this.serverConnection.getResponseCodeErrorException("deleteNotificationRegistration", responseCode, connection);
                }
            }
        }
    }
}

