/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.metadata;

import java.util.Set;
import java.util.TreeSet;
import org.apache.felix.scr.impl.helper.Logger;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.DSVersion;

public class ReferenceMetadata {
    public static final String CARDINALITY_0_1 = "0..1";
    public static final String CARDINALITY_0_N = "0..n";
    public static final String CARDINALITY_1_1 = "1..1";
    public static final String CARDINALITY_1_N = "1..n";
    private static final Set<String> CARDINALITY_VALID = new TreeSet<String>();
    public static final String POLICY_STATIC = "static";
    public static final String POLICY_DYNAMIC = "dynamic";
    private static final Set<String> POLICY_VALID;
    public static final String POLICY_OPTION_RELUCTANT = "reluctant";
    public static final String POLICY_OPTION_GREEDY = "greedy";
    private static final Set<String> POLICY_OPTION_VALID;
    private static final String FIELD_STRATEGY_UPDATE = "update";
    private static final String FIELD_STRATEGY_REPLACE = "replace";
    private static final Set<String> FIELD_STRATEGY_VALID;
    public static final String FIELD_VALUE_TYPE_SERVICE = "service";
    public static final String FIELD_VALUE_TYPE_PROPERTIES = "properties";
    public static final String FIELD_VALUE_TYPE_REFERENCE = "reference";
    public static final String FIELD_VALUE_TYPE_SERVICEOBJECTS = "serviceobjects";
    public static final String FIELD_VALUE_TYPE_TUPLE = "tuple";
    private static final Set<String> FIELD_VALUE_TYPE_VALID;
    private String m_name = null;
    private String m_interface = null;
    private String m_cardinality = null;
    private String m_target;
    private String m_bind = null;
    private String m_updated = null;
    private String m_unbind = null;
    private String m_field;
    private String m_field_option;
    private String m_field_collection_type;
    private String m_policy = null;
    private String m_policy_option = null;
    private String m_scopeName;
    private ReferenceScope m_scope = ReferenceScope.bundle;
    private boolean m_isStatic = true;
    private boolean m_isOptional = false;
    private boolean m_isMultiple = false;
    private boolean m_isReluctant = true;
    private boolean m_isReplace = true;
    private boolean m_validated = false;

    public void setName(String name) {
        if (this.m_validated) {
            return;
        }
        this.m_name = name;
    }

    public void setInterface(String interfaceName) {
        if (this.m_validated) {
            return;
        }
        this.m_interface = interfaceName;
    }

    public void setCardinality(String cardinality) {
        if (this.m_validated) {
            return;
        }
        this.m_cardinality = cardinality;
        this.m_isOptional = CARDINALITY_0_1.equals(cardinality) || CARDINALITY_0_N.equals(cardinality);
        this.m_isMultiple = CARDINALITY_0_N.equals(cardinality) || CARDINALITY_1_N.equals(cardinality);
    }

    public void setPolicy(String policy) {
        if (this.m_validated) {
            return;
        }
        this.m_policy = policy;
        this.m_isStatic = POLICY_STATIC.equals(policy);
    }

    public void setPolicyOption(String policyOption) {
        if (this.m_validated) {
            return;
        }
        this.m_policy_option = policyOption;
        this.m_isReluctant = POLICY_OPTION_RELUCTANT.equals(policyOption);
    }

    public void setTarget(String target) {
        if (this.m_validated) {
            return;
        }
        this.m_target = target == null || target.length() == 0 ? null : target;
    }

    public void setBind(String bind) {
        if (this.m_validated) {
            return;
        }
        this.m_bind = bind;
    }

    public void setUpdated(String updated) {
        if (this.m_validated) {
            return;
        }
        this.m_updated = updated;
    }

    public void setUnbind(String unbind) {
        if (this.m_validated) {
            return;
        }
        this.m_unbind = unbind;
    }

    public void setField(String field) {
        if (this.m_validated) {
            return;
        }
        this.m_field = field;
    }

    public void setFieldOption(String strategy) {
        if (this.m_validated) {
            return;
        }
        this.m_field_option = strategy;
        this.m_isReplace = FIELD_STRATEGY_REPLACE.equals(strategy);
    }

    public void setFieldCollectionType(String valuetype) {
        if (this.m_validated) {
            return;
        }
        this.m_field_collection_type = valuetype;
    }

    public void setScope(String scopeName) {
        if (this.m_validated) {
            return;
        }
        this.m_scopeName = scopeName;
    }

    public String getName() {
        return this.m_name;
    }

    public String getInterface() {
        return this.m_interface;
    }

    public String getCardinality() {
        return this.m_cardinality;
    }

    public String getPolicy() {
        return this.m_policy;
    }

    public String getPolicyOption() {
        return this.m_policy_option;
    }

    public String getTarget() {
        return this.m_target;
    }

    public String getBind() {
        return this.m_bind;
    }

    public String getUpdated() {
        return this.m_updated;
    }

    public String getUnbind() {
        return this.m_unbind;
    }

    public String getField() {
        return this.m_field;
    }

    public String getFieldOption() {
        return this.m_field_option;
    }

    public String getFieldCollectionType() {
        return this.m_field_collection_type;
    }

    public boolean isStatic() {
        return this.m_isStatic;
    }

    public boolean isOptional() {
        return this.m_isOptional;
    }

    public boolean isMultiple() {
        return this.m_isMultiple;
    }

    public boolean isReluctant() {
        return this.m_isReluctant;
    }

    public boolean isReplace() {
        return this.m_isReplace;
    }

    public String getTargetPropertyName() {
        return this.getName() + ".target";
    }

    public String getMinCardinalityName() {
        return this.getName() + ".cardinality.minimum";
    }

    public ReferenceScope getScope() {
        return this.m_scope;
    }

    void validate(ComponentMetadata componentMetadata, Logger logger) {
        DSVersion dsVersion = componentMetadata.getDSVersion();
        if (this.m_name == null) {
            if (!dsVersion.isDS11()) {
                throw componentMetadata.validationFailure("A name must be declared for the reference");
            }
            this.setName(this.getInterface());
        }
        if (this.m_interface == null) {
            throw componentMetadata.validationFailure("An interface must be declared for the reference");
        }
        if (this.m_cardinality == null) {
            this.setCardinality(CARDINALITY_1_1);
        } else if (!CARDINALITY_VALID.contains(this.m_cardinality)) {
            throw componentMetadata.validationFailure("Cardinality must be one of " + CARDINALITY_VALID);
        }
        if (this.m_policy == null) {
            this.setPolicy(POLICY_STATIC);
        } else if (!POLICY_VALID.contains(this.m_policy)) {
            throw componentMetadata.validationFailure("Policy must be one of " + POLICY_VALID);
        }
        if (this.m_policy_option == null) {
            this.setPolicyOption(POLICY_OPTION_RELUCTANT);
        } else {
            if (!POLICY_OPTION_VALID.contains(this.m_policy_option)) {
                throw componentMetadata.validationFailure("Policy option must be one of " + POLICY_OPTION_VALID);
            }
            if (!dsVersion.isDS12() && !POLICY_OPTION_RELUCTANT.equals(this.m_policy_option)) {
                throw componentMetadata.validationFailure("Policy option must be reluctant for DS < 1.2");
            }
        }
        if (this.m_scopeName != null) {
            if (!dsVersion.isDS13()) {
                throw componentMetadata.validationFailure("reference scope can be set only for DS >= 1.3");
            }
            try {
                this.m_scope = ReferenceScope.valueOf(this.m_scopeName);
            }
            catch (IllegalArgumentException e) {
                throw componentMetadata.validationFailure("reference scope must be 'bundle' or 'prototype' not " + this.m_scopeName);
            }
        }
        if (this.m_updated != null && !dsVersion.isDS12() && dsVersion != DSVersion.DS11Felix) {
            throw componentMetadata.validationFailure("updated method declaration requires DS 1.2 or later namespace ");
        }
        if (this.m_field != null) {
            if (!dsVersion.isDS13()) {
                throw componentMetadata.validationFailure("Field reference requires DS >= 1.3");
            }
            if (this.m_field_option == null) {
                this.setFieldOption(FIELD_STRATEGY_REPLACE);
            } else if (!FIELD_STRATEGY_VALID.contains(this.m_field_option)) {
                throw componentMetadata.validationFailure("Field strategy must be one of " + FIELD_STRATEGY_VALID);
            }
            if (!this.m_isMultiple && this.m_field_option.equals(FIELD_STRATEGY_UPDATE)) {
                throw componentMetadata.validationFailure("Field strategy update not allowed for unary field references.");
            }
            if (!this.m_isMultiple) {
                if (this.m_field_collection_type != null) {
                    throw componentMetadata.validationFailure("Field value type must not be set for unary field references.");
                }
            } else if (this.m_field_collection_type == null) {
                this.setFieldCollectionType(FIELD_VALUE_TYPE_SERVICE);
            } else if (!FIELD_VALUE_TYPE_VALID.contains(this.m_field_collection_type)) {
                throw componentMetadata.validationFailure("Field value type must be one of " + FIELD_VALUE_TYPE_VALID);
            }
        }
        this.m_validated = true;
    }

    public String getDebugInfo() {
        return this.getName() + "interface=" + this.getInterface() + ", filter=" + this.getTarget() + ", policy=" + this.getPolicy() + ", cardinality=" + this.getCardinality() + ", bind=" + this.getBind() + ", unbind=" + this.getUnbind() + ", updated=" + this.getUpdated() + ", field=" + this.getField() + ", field-option=" + this.getFieldOption() + ", field-collection-type=" + this.getFieldCollectionType();
    }

    static {
        CARDINALITY_VALID.add(CARDINALITY_0_1);
        CARDINALITY_VALID.add(CARDINALITY_0_N);
        CARDINALITY_VALID.add(CARDINALITY_1_1);
        CARDINALITY_VALID.add(CARDINALITY_1_N);
        POLICY_VALID = new TreeSet<String>();
        POLICY_VALID.add(POLICY_DYNAMIC);
        POLICY_VALID.add(POLICY_STATIC);
        POLICY_OPTION_VALID = new TreeSet<String>();
        POLICY_OPTION_VALID.add(POLICY_OPTION_RELUCTANT);
        POLICY_OPTION_VALID.add(POLICY_OPTION_GREEDY);
        FIELD_STRATEGY_VALID = new TreeSet<String>();
        FIELD_STRATEGY_VALID.add(FIELD_STRATEGY_REPLACE);
        FIELD_STRATEGY_VALID.add(FIELD_STRATEGY_UPDATE);
        FIELD_VALUE_TYPE_VALID = new TreeSet<String>();
        FIELD_VALUE_TYPE_VALID.add(FIELD_VALUE_TYPE_PROPERTIES);
        FIELD_VALUE_TYPE_VALID.add(FIELD_VALUE_TYPE_REFERENCE);
        FIELD_VALUE_TYPE_VALID.add(FIELD_VALUE_TYPE_SERVICE);
        FIELD_VALUE_TYPE_VALID.add(FIELD_VALUE_TYPE_SERVICEOBJECTS);
        FIELD_VALUE_TYPE_VALID.add(FIELD_VALUE_TYPE_TUPLE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReferenceScope {
        bundle,
        prototype,
        prototype_required;

    }
}

