/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.audit;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Map;
import java.util.TreeMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AuditEvent {
    private static final TraceComponent tc = Tr.register(AuditEvent.class);
    public static final TreeMap<String, Object> STD_OBSERVER = new TreeMap();
    public static final TreeMap<String, Object> STD_INITIATOR = new TreeMap();
    public static final TreeMap<String, Object> STD_TARGET = new TreeMap();
    public static final String OBSERVER = "observer";
    public static final String OBSERVER_ID = "observer.id";
    public static final String OBSERVER_NAME = "observer.name";
    public static final String OBSERVER_TYPEURI = "observer.typeURI";
    public static final String OBSERVER_HOST_ADDRESS = "observer.host.address";
    public static final String OBSERVER_HOST_AGENT = "observer.host.agent";
    public static final String TARGET = "target";
    public static final String TARGET_ID = "target.id";
    public static final String TARGET_NAME = "target.name";
    public static final String TARGET_TYPEURI = "target.typeURI";
    public static final String TARGET_HOST_ADDRESS = "target.host.address";
    public static final String TARGET_HOST_AGENT = "target.host.agent";
    public static final String TARGET_CREDENTIAL_TYPE = "target.credential.type";
    public static final String TARGET_CREDENTIAL_TOKEN = "target.credential.token";
    public static final String INITIATOR = "initiator";
    public static final String INITIATOR_ID = "initiator.id";
    public static final String INITIATOR_NAME = "initiator.name";
    public static final String INITIATOR_TYPEURI = "initiator.typeURI";
    public static final String INITIATOR_HOST_ADDRESS = "initiator.host.address";
    public static final String INITIATOR_HOST_AGENT = "initiator.host.agent";
    public static final String REASON = "reason";
    public static final String REASON_CODE = "reason.reasonCode";
    public static final String REASON_TYPE = "reason.reasonType";
    public static final String STD_ID = "websphere:" + AuditEvent.getServerID();
    public static final String SECURITY_AUTHN = "SECURITY_AUTHN";
    Map<String, Object> eventMap = new TreeMap<String, Object>();
    static final long serialVersionUID = -892132547554370195L;

    public AuditEvent() {
        this.setEventTime(this.getCurrentTime());
    }

    public String getCurrentTime() {
        return "2016-05-24T11:56:34.87Z";
    }

    public Map<String, Object> getInitiator() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.eventMap.entrySet()) {
            if (!entry.getKey().startsWith(INITIATOR)) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public void setInitiator(Map<String, Object> initiator) {
        this.eventMap.putAll(initiator);
    }

    public Map<String, Object> getObserver() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.eventMap.entrySet()) {
            if (!entry.getKey().startsWith(OBSERVER)) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public void setObserver(Map<String, Object> observer) {
        this.eventMap.putAll(observer);
    }

    public Map<String, Object> getTarget() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.eventMap.entrySet()) {
            if (!entry.getKey().startsWith(TARGET)) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public void setTarget(Map<String, Object> target) {
        this.eventMap.putAll(target);
    }

    public Map<String, Object> getReason() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.eventMap.entrySet()) {
            if (!entry.getKey().startsWith(REASON)) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public void setReason(Map<String, Object> reason) {
        this.eventMap.putAll(reason);
    }

    public Map<String, Object> getMap() {
        return this.eventMap;
    }

    public void setMap(Map<String, Object> map) {
        this.eventMap = map;
    }

    public String getOutcome() {
        return (String)this.eventMap.get("outcome");
    }

    public void setOutcome(String outcome) {
        this.eventMap.put("outcome", outcome);
    }

    public String getAction() {
        return (String)this.eventMap.get("action");
    }

    public void setAction(String action) {
        this.eventMap.put("action", action);
    }

    public String getType() {
        return (String)this.eventMap.get("eventType");
    }

    public void setType(String eventType) {
        this.eventMap.put("eventType", eventType);
    }

    public String getWASType() {
        return (String)this.eventMap.get("wasEventType");
    }

    public void setWASType(String wasEventType) {
        this.eventMap.put("wasEventType", wasEventType);
    }

    public String getEventTime() {
        return (String)this.eventMap.get("eventTime");
    }

    public void setEventTime(String eventTime) {
        this.eventMap.put("eventTime", eventTime);
    }

    public String getHashtag() {
        return (String)this.eventMap.get("hashTag");
    }

    public void setHashtag(String hash) {
        this.eventMap.put("hashTag", hash);
    }

    public Object get(String key) {
        return this.eventMap.get(key);
    }

    public void set(String key, Object value) {
        this.eventMap.put(key, value);
    }

    public void set(Map<String, Object> map) {
        this.eventMap.putAll(map);
    }

    private static Object getServerID() {
        return "myServer";
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        for (Map.Entry<String, Object> entry : this.eventMap.entrySet()) {
            buff.append("\n").append(entry.getKey()).append("    :    ").append(entry.getValue().toString());
        }
        return buff.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        STD_OBSERVER.put(OBSERVER_ID, STD_ID);
        STD_OBSERVER.put(OBSERVER_NAME, "SecurityService");
        STD_OBSERVER.put(OBSERVER_TYPEURI, "service/server");
        STD_TARGET.put(TARGET_ID, STD_ID);
        STD_TARGET.put(TARGET_TYPEURI, "service/application/web");
    }
}

