/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.main;

import com.ibm.ws.ras.instrument.internal.bci.FFDCClassAdapter;
import com.ibm.ws.ras.instrument.internal.bci.JSR47TracingClassAdapter;
import com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingClassAdapter;
import com.ibm.ws.ras.instrument.internal.introspect.TraceConfigClassVisitor;
import com.ibm.ws.ras.instrument.internal.main.AbstractInstrumentation;
import com.ibm.ws.ras.instrument.internal.model.ClassInfo;
import com.ibm.ws.ras.instrument.internal.model.InstrumentationOptions;
import com.ibm.ws.ras.instrument.internal.model.PackageInfo;
import com.ibm.ws.ras.instrument.internal.model.TraceType;
import com.ibm.ws.ras.instrument.internal.xml.TraceConfigFileParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.SerialVersionUIDAdder;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.TraceClassVisitor;

public class StaticTraceInstrumentation
extends AbstractInstrumentation {
    protected boolean introspectAnnotations = true;
    protected boolean instrumentWithFFDC = false;
    protected boolean computeFrames = false;
    protected TraceType traceType = TraceType.TR;
    protected TraceConfigFileParser configFileParser = new TraceConfigFileParser();
    protected InstrumentationOptions instrumentationOptions = new InstrumentationOptions();

    public void setInstrumentWithFFDC(boolean instrumentWithFFDC) {
        this.instrumentWithFFDC = instrumentWithFFDC;
    }

    public boolean getInstrumentWithFFDC() {
        return this.instrumentWithFFDC;
    }

    public void setTraceType(TraceType traceType) {
        this.traceType = traceType;
    }

    public TraceType getTraceType() {
        return this.traceType;
    }

    public void setComputeFrames(boolean computeFrames) {
        this.computeFrames = computeFrames;
    }

    public boolean isComputeFrames() {
        return this.computeFrames;
    }

    public InstrumentationOptions getInstrumentationOptions() {
        return this.instrumentationOptions;
    }

    public void setInstrumentationOptions(InstrumentationOptions instrumentationOptions) {
        this.instrumentationOptions = instrumentationOptions;
    }

    @Override
    protected final byte[] transform(InputStream classfileStream) throws IOException {
        ClassWriter writer;
        ClassConfigData classConfigData = this.processClassConfiguration(classfileStream);
        ClassInfo classInfo = classConfigData.getClassInfo();
        if (!this.getInstrumentationOptions().isPackageIncluded(classInfo.getPackageName())) {
            return null;
        }
        classInfo = this.mergeClassConfigInfo(classInfo);
        int classWriterOptions = this.isComputeFrames() ? 2 : 1;
        InputStream classInputStream = classConfigData.getClassInputStream();
        ClassReader reader = new ClassReader(classInputStream);
        Object visitor = writer = new ClassWriter(reader, classWriterOptions);
        if (this.isDebug()) {
            visitor = new CheckClassAdapter((ClassVisitor)visitor);
            visitor = new TraceClassVisitor((ClassVisitor)visitor, new PrintWriter(System.out));
        }
        switch (this.getTraceType()) {
            case JAVA_LOGGING: {
                visitor = new JSR47TracingClassAdapter((ClassVisitor)visitor, classInfo);
                break;
            }
            case TR: {
                visitor = new WebSphereTrTracingClassAdapter((ClassVisitor)visitor, classInfo);
            }
        }
        if (this.getInstrumentWithFFDC()) {
            visitor = new FFDCClassAdapter((ClassVisitor)visitor, classInfo);
        }
        visitor = new SerialVersionUIDAdder((ClassVisitor)visitor);
        try {
            reader.accept((ClassVisitor)visitor, this.isComputeFrames() ? 8 : 0);
        }
        catch (Throwable t) {
            IOException ioe = new IOException("Unable to instrument class stream with trace");
            ioe.initCause(t);
            throw ioe;
        }
        return writer.toByteArray();
    }

    protected ClassConfigData processClassConfiguration(InputStream inputStream) throws IOException {
        if (!this.introspectAnnotations) {
            return new ClassConfigData(inputStream);
        }
        ClassReader cr = new ClassReader(inputStream);
        ClassWriter cw = new ClassWriter(cr, 0);
        TraceConfigClassVisitor cv = new TraceConfigClassVisitor((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
        ClassInfo classInfo = cv.getClassInfo();
        ByteArrayInputStream classInputStream = new ByteArrayInputStream(cw.toByteArray());
        return new ClassConfigData(classInputStream, classInfo);
    }

    @Override
    public void processPackageInfo() throws IOException {
        if (!this.introspectAnnotations) {
            return;
        }
        super.processPackageInfo();
    }

    protected ClassInfo mergeClassConfigInfo(ClassInfo classInfo) {
        PackageInfo packageInfo = this.configFileParser.getPackageInfo(classInfo.getInternalPackageName());
        if (packageInfo == null) {
            packageInfo = this.getPackageInfo(classInfo.getInternalPackageName());
        }
        classInfo.updateDefaultValuesFromPackageInfo(packageInfo);
        ClassInfo ci = this.configFileParser.getClassInfo(classInfo.getInternalClassName());
        if (ci != null) {
            classInfo.overrideValuesFromExplicitClassInfo(ci);
        }
        return classInfo;
    }

    @Override
    public void processArguments(String[] args) throws IOException {
        int i;
        ArrayList<File> classFiles = new ArrayList<File>();
        ArrayList<File> jarFiles = new ArrayList<File>();
        String[] fileArgs = null;
        for (i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("--config")) {
                this.configFileParser = new TraceConfigFileParser(new File(args[++i]));
                this.configFileParser.parse();
                InstrumentationOptions options = this.configFileParser.getInstrumentationOptions();
                if (options.getAddFFDC()) {
                    this.setInstrumentWithFFDC(true);
                }
                this.setTraceType(options.getTraceType());
                this.setInstrumentationOptions(options);
                continue;
            }
            if (args[i].equalsIgnoreCase("--debug") || args[i].equals("-d")) {
                this.setDebug(true);
                continue;
            }
            if (args[i].equalsIgnoreCase("--tr")) {
                this.setTraceType(TraceType.TR);
                continue;
            }
            if (args[i].equalsIgnoreCase("--websphere")) {
                this.setTraceType(TraceType.TR);
                continue;
            }
            if (args[i].equalsIgnoreCase("--java-logging")) {
                this.setTraceType(TraceType.JAVA_LOGGING);
                continue;
            }
            if (args[i].equalsIgnoreCase("--jsr47")) {
                this.setTraceType(TraceType.JAVA_LOGGING);
                continue;
            }
            if (args[i].equalsIgnoreCase("--none")) {
                this.setTraceType(TraceType.NONE);
                continue;
            }
            if (args[i].equalsIgnoreCase("--no-trace")) {
                this.setTraceType(TraceType.NONE);
                continue;
            }
            if (args[i].equalsIgnoreCase("--ffdc")) {
                this.setInstrumentWithFFDC(true);
                continue;
            }
            if (args[i].equalsIgnoreCase("--compute-frames")) {
                this.setComputeFrames(true);
                continue;
            }
            fileArgs = new String[args.length - i];
            System.arraycopy(args, i, fileArgs, 0, fileArgs.length);
            break;
        }
        if (fileArgs == null || fileArgs.length == 0) {
            throw new IllegalArgumentException("Empty file lists are illegal");
        }
        for (i = 0; i < fileArgs.length; ++i) {
            File f = new File((String)fileArgs[i]);
            if (!f.exists()) {
                throw new IllegalArgumentException(f + " does not exist");
            }
            if (f.isDirectory()) {
                classFiles.addAll(this.getClassFiles(f, null));
                continue;
            }
            if (f.getName().endsWith(".class")) {
                classFiles.add(f);
                continue;
            }
            if (f.getName().endsWith(".jar")) {
                jarFiles.add(f);
                continue;
            }
            if (f.getName().endsWith(".zip")) {
                jarFiles.add(f);
                continue;
            }
            System.err.println(f + " is an unexpected file type; ignoring");
        }
        this.setClassFiles(classFiles);
        this.setJarFiles(jarFiles);
    }

    private static void printUsageMessage() {
        System.out.println("Description:");
        System.out.println("  StaticTraceInstrumentation can modify classes");
        System.out.println("  in place to add calls to a trace framework that will");
        System.out.println("  delegate to JSR47 logging or WebSphere Tr.");
        System.out.println("");
        System.out.println("Required arguments:");
        System.out.println("  The paths to one or more binary classes, jars, or");
        System.out.println("  directories to scan for classes and jars are required");
        System.out.println("  parameters.");
        System.out.println("");
        System.out.println("  Class files must have a .class extension.");
        System.out.println("  Jar files must have a .jar or a .zip extension.");
        System.out.println("  Directories are recursively scanned for .jar, .zip, and");
        System.out.println("  .class files to instrument.");
    }

    public static final void main(String[] args) throws Exception {
        if (args == null || args.length <= 0) {
            StaticTraceInstrumentation.printUsageMessage();
            return;
        }
        StaticTraceInstrumentation sti = new StaticTraceInstrumentation();
        sti.processArguments(args);
        sti.processPackageInfo();
        sti.executeInstrumentation();
    }

    private static final class ClassConfigData {
        InputStream classInputStream;
        ClassInfo classInfo;

        ClassConfigData(InputStream classInputStream) {
            this.classInputStream = classInputStream;
        }

        ClassConfigData(InputStream classInputStream, ClassInfo classInfo) {
            this.classInputStream = classInputStream;
            this.classInfo = classInfo;
        }

        ClassInfo getClassInfo() {
            return this.classInfo;
        }

        InputStream getClassInputStream() {
            return this.classInputStream;
        }
    }
}

