/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.osgi;

import com.ibm.ws.logging.internal.osgi.TrLogImpl;
import com.ibm.ws.logging.internal.osgi.TrLogServiceImpl;
import java.util.EventObject;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.log.LogService;

public class TrLogServiceFactory
implements ServiceFactory<LogService> {
    protected final ConcurrentHashMap<Bundle, TrLogServiceImpl> registeredServices;
    protected final TrLogImpl logImpl;
    protected final Listener eventListener;
    protected final Bundle systemBundle;

    TrLogServiceFactory(TrLogImpl logImpl, Bundle systemBundle) {
        this.logImpl = logImpl;
        this.systemBundle = systemBundle;
        this.eventListener = new Listener();
        this.registeredServices = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrLogServiceImpl getService(Bundle b) {
        TrLogServiceImpl impl;
        if (b == null) {
            b = this.systemBundle;
        }
        if ((impl = this.registeredServices.get(b)) == null) {
            TrLogServiceFactory trLogServiceFactory = this;
            synchronized (trLogServiceFactory) {
                impl = this.registeredServices.get(b);
                if (impl == null) {
                    impl = new TrLogServiceImpl(this.logImpl, b);
                    this.registeredServices.put(b, impl);
                }
            }
        }
        return impl;
    }

    public LogService getService(Bundle bundle, ServiceRegistration<LogService> registration) {
        TrLogServiceImpl impl = this.getService(bundle);
        return impl;
    }

    public void ungetService(Bundle bundle, ServiceRegistration<LogService> registration, LogService service) {
    }

    protected Listener getListener() {
        return this.eventListener;
    }

    protected class Listener
    implements FrameworkListener,
    SynchronousBundleListener,
    ServiceListener {
        protected Listener() {
        }

        public void serviceChanged(ServiceEvent event) {
            Bundle b = event.getServiceReference().getBundle();
            TrLogServiceImpl impl = TrLogServiceFactory.this.getService(b);
            String message = this.getServiceEventMessage(event.getType());
            int level = event.getType() == 2 ? 4 : 3;
            impl.log(event.getServiceReference(), level, -5, message, null, (EventObject)event);
        }

        public void bundleChanged(BundleEvent event) {
            Bundle b = event.getBundle();
            TrLogServiceImpl impl = TrLogServiceFactory.this.getService(b);
            String message = this.getBundleEventMessage(event.getType());
            impl.log(null, 3, -5, message, null, (EventObject)event);
            if (event.getType() == 16) {
                TrLogServiceFactory.this.registeredServices.remove(b);
            }
        }

        public void frameworkEvent(FrameworkEvent event) {
            TrLogServiceImpl impl = TrLogServiceFactory.this.getService(event.getBundle());
            String message = this.getFrameworkEventMessage(event.getType());
            int level = event.getType() == 2 ? 1 : 3;
            int trLevel = event.getType() == 2 ? 1 : -5;
            impl.log(null, level, trLevel, message, event.getThrowable(), (EventObject)event);
        }

        private String getBundleEventMessage(int type) {
            switch (type) {
                case 1: {
                    return "BundleEvent INSTALLED";
                }
                case 2: {
                    return "BundleEvent STARTED";
                }
                case 4: {
                    return "BundleEvent STOPPED";
                }
                case 8: {
                    return "BundleEvent UPDATED";
                }
                case 16: {
                    return "BundleEvent UNINSTALLED";
                }
                case 32: {
                    return "BundleEvent RESOLVED";
                }
                case 64: {
                    return "BundleEvent UNRESOLVED";
                }
                case 128: {
                    return "BundleEvent STARTING";
                }
                case 256: {
                    return "BundleEvent STOPPING";
                }
                case 512: {
                    return "BundleEvent LAZY_ACTIVATION";
                }
            }
            return "BundleEvent unknown type: " + type;
        }

        private String getFrameworkEventMessage(int type) {
            switch (type) {
                case 4: {
                    return "FrameworkEvent PACKAGES REFRESHED";
                }
                case 8: {
                    return "FrameworkEvent STARTLEVEL CHANGED";
                }
                case 1: {
                    return "FrameworkEvent STARTED";
                }
                case 2: {
                    return "FrameworkEvent ERROR";
                }
                case 16: {
                    return "FrameworkEvent WARNING";
                }
                case 32: {
                    return "FrameworkEvent INFO";
                }
            }
            return "FrameworkEvent unknown type: " + type;
        }

        private String getServiceEventMessage(int type) {
            switch (type) {
                case 2: {
                    return "ServiceEvent MODIFIED";
                }
                case 1: {
                    return "ServiceEvent REGISTERED";
                }
                case 4: {
                    return "ServiceEvent UNREGISTERING";
                }
            }
            return "ServiceEvent unknown type: " + type;
        }
    }
}

