/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.osgi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.logging.internal.osgi.TrLogEntry;
import com.ibm.ws.logging.internal.osgi.TrLogReaderServiceImpl;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.log.LogReaderService;

public class TrLogImpl
implements ServiceFactory<LogReaderService> {
    private static final TraceComponent myTc = Tr.register(TrLogImpl.class);
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(new TrLogThreadFactory("TrLogEvent"));
    private volatile EventAdmin eventService = null;
    private volatile boolean hasReaders = false;
    static final Enumeration<Object> EMPTY_ENUMERATION = new Enumeration<Object>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public Object nextElement() {
            return null;
        }
    };

    protected TrLogImpl() {
        if (TraceComponent.isAnyTracingEnabled() && myTc.isDebugEnabled()) {
            Tr.debug((TraceComponent)myTc, (String)"TrLogImpl created", (Object[])new Object[]{this});
        }
    }

    protected void stop() {
        if (TraceComponent.isAnyTracingEnabled() && myTc.isDebugEnabled()) {
            Tr.debug((TraceComponent)myTc, (String)"stopping TrLogImpl", (Object[])new Object[]{this});
        }
        this.executorService.shutdown();
        ReaderHolder.readers.clear();
    }

    protected void setEventAdmin(EventAdmin eventService) {
        this.eventService = eventService;
        if (TraceComponent.isAnyTracingEnabled() && myTc.isDebugEnabled()) {
            Tr.debug((TraceComponent)myTc, (String)"set event admin", (Object[])new Object[]{this, eventService});
        }
    }

    public void publishLogEntry(final TrLogEntry logEntry) {
        if (TraceComponent.isAnyTracingEnabled() && myTc.isDebugEnabled()) {
            Tr.debug((Object)logEntry.getBundle(), (TraceComponent)myTc, (String)"publishLogEntry", (Object[])new Object[]{this});
        }
        if (this.hasReaders || this.eventService != null) {
            List listeners;
            final EventAdmin localService = this.eventService;
            if (this.hasReaders) {
                listeners = new ArrayList();
                for (TrLogReaderServiceImpl impl : ReaderHolder.readers.values()) {
                    listeners.addAll(impl.getListeners());
                }
            } else {
                listeners = Collections.emptyList();
            }
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    logEntry.publish(listeners, localService);
                }
            });
        }
    }

    public synchronized LogReaderService getService(Bundle bundle, ServiceRegistration<LogReaderService> registration) {
        TrLogReaderServiceImpl result;
        this.hasReaders = true;
        TrLogReaderServiceImpl rService = new TrLogReaderServiceImpl(this);
        TrLogReaderServiceImpl tmp = ReaderHolder.readers.put(registration, rService);
        TrLogReaderServiceImpl trLogReaderServiceImpl = result = tmp == null ? rService : tmp;
        if (TraceComponent.isAnyTracingEnabled() && myTc.isDebugEnabled()) {
            Tr.debug((Object)bundle, (TraceComponent)myTc, (String)"getService", (Object[])new Object[]{this, result});
        }
        return result;
    }

    public synchronized void ungetService(Bundle bundle, ServiceRegistration<LogReaderService> registration, LogReaderService service) {
        if (TraceComponent.isAnyTracingEnabled() && myTc.isDebugEnabled()) {
            Tr.debug((Object)bundle, (TraceComponent)myTc, (String)"ungetService", (Object[])new Object[]{this, service});
        }
        ReaderHolder.readers.remove(registration);
        this.hasReaders = !ReaderHolder.readers.isEmpty();
    }

    public Enumeration<Object> getRecentEntries() {
        return EMPTY_ENUMERATION;
    }

    public boolean hasReaders() {
        return this.hasReaders;
    }

    public EventAdmin getEventAdmin() {
        return this.eventService;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[readers=" + this.hasReaders + ",eventService=" + this.eventService + "]";
    }

    protected static final class TrLogThreadFactory
    implements ThreadFactory {
        private final ThreadGroup threadGroup;

        TrLogThreadFactory(final String threadGroupName) {
            this.threadGroup = AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

                @Override
                public ThreadGroup run() {
                    return new ThreadGroup(threadGroupName);
                }
            });
        }

        @Override
        public Thread newThread(final Runnable runnable) {
            return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

                @Override
                public Thread run() {
                    Thread t = new Thread(TrLogThreadFactory.this.threadGroup, runnable);
                    t.setDaemon(true);
                    t.setName(TrLogThreadFactory.this.threadGroup.getName() + "-" + t.getName());
                    t.setPriority(5);
                    return t;
                }
            });
        }
    }

    static final class ReaderHolder {
        protected static final ConcurrentHashMap<ServiceRegistration<LogReaderService>, TrLogReaderServiceImpl> readers = new ConcurrentHashMap();

        ReaderHolder() {
        }
    }

    static enum LogEvent {
        ERROR("LOG_ERROR"),
        WARNING("LOG_WARNING"),
        INFO("LOG_INFO"),
        DEBUG("LOG_DEBUG"),
        OTHER("LOG_OTHER");

        private final String topic;

        private LogEvent(String message) {
            this.topic = "org/osgi/service/log/LogEntry/" + message;
        }

        public static String getTopic(int level) {
            switch (level) {
                case 1: {
                    return LogEvent.ERROR.topic;
                }
                case 2: {
                    return LogEvent.WARNING.topic;
                }
                case 3: {
                    return LogEvent.INFO.topic;
                }
                case 4: {
                    return LogEvent.DEBUG.topic;
                }
            }
            return LogEvent.OTHER.topic;
        }
    }
}

