/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.osgi;

import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.TraceComponentChangeListener;
import com.ibm.ws.logging.internal.osgi.LoggingConfigurationService;
import com.ibm.ws.logging.internal.osgi.MessageRouterConfigurator;
import com.ibm.ws.logging.internal.osgi.TrLogImpl;
import com.ibm.ws.logging.internal.osgi.TrLogServiceFactory;
import com.ibm.ws.logging.internal.osgi.TraceComponentChangeListenerTracker;
import com.ibm.ws.logging.internal.osgi.TraceRouterConfigurator;
import com.ibm.ws.ras.instrument.internal.main.AlpineRuntimeTransformer;
import java.lang.instrument.Instrumentation;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer<EventAdmin, EventAdmin> {
    private BundleContext bContext;
    private TrLogImpl logImpl;
    private TrLogServiceFactory logSvcFactory;
    private ServiceTracker<EventAdmin, EventAdmin> eventAdminTracker;
    private MessageRouterConfigurator msgRouter;
    private TraceRouterConfigurator traceRouter;
    private LoggingConfigurationService logCfgService;
    private Instrumentation inst;
    private RuntimeTransformerComponentListener runtimeTransformer = null;
    private static TraceComponentChangeListenerTracker listenerTracker = null;

    public void start(BundleContext context) throws Exception {
        this.bContext = context;
        this.logImpl = new TrLogImpl();
        context.registerService("org.osgi.service.log.LogReaderService", (Object)this.logImpl, this.getProperties());
        this.logSvcFactory = new TrLogServiceFactory(this.logImpl, context.getBundle(0L));
        context.registerService("org.osgi.service.log.LogService", (Object)this.logSvcFactory, this.getProperties());
        BundleContext sysContext = context.getBundle("System Bundle").getBundleContext();
        sysContext.addBundleListener((BundleListener)this.logSvcFactory.getListener());
        sysContext.addFrameworkListener((FrameworkListener)this.logSvcFactory.getListener());
        sysContext.addServiceListener((ServiceListener)this.logSvcFactory.getListener());
        this.eventAdminTracker = new ServiceTracker(context, EventAdmin.class, (ServiceTrackerCustomizer)this);
        this.eventAdminTracker.open();
        ServiceReference instReference = context.getServiceReference(Instrumentation.class);
        if (instReference != null) {
            this.inst = (Instrumentation)context.getService(instReference);
            AlpineRuntimeTransformer.setInstrumentation(this.inst);
        } else {
            AlpineRuntimeTransformer.setInstrumentation(null);
        }
        this.runtimeTransformer = new RuntimeTransformerComponentListener();
        TrConfigurator.addTraceComponentListener((TraceComponentChangeListener)this.runtimeTransformer);
        listenerTracker = new TraceComponentChangeListenerTracker(context);
        listenerTracker.open(true);
        this.logCfgService = new LoggingConfigurationService(context, this.inst != null);
        this.msgRouter = new MessageRouterConfigurator(context);
        this.traceRouter = new TraceRouterConfigurator(context);
    }

    public void stop(BundleContext context) throws Exception {
        this.eventAdminTracker.close();
        BundleContext sysContext = context.getBundle("System Bundle").getBundleContext();
        sysContext.removeServiceListener((ServiceListener)this.logSvcFactory.getListener());
        sysContext.removeFrameworkListener((FrameworkListener)this.logSvcFactory.getListener());
        sysContext.removeBundleListener((BundleListener)this.logSvcFactory.getListener());
        this.logImpl.stop();
        this.msgRouter.stop();
        this.traceRouter.stop();
        if (this.logCfgService != null) {
            this.logCfgService.stop();
            this.logCfgService = null;
        }
        TrConfigurator.removeTraceComponentListener((TraceComponentChangeListener)this.runtimeTransformer);
        listenerTracker.close();
    }

    public Dictionary<String, ?> getProperties() {
        Hashtable<String, Object> h = new Hashtable<String, Object>();
        h.put("service.vendor", "IBM");
        h.put("service.ranking", 1);
        return h;
    }

    public EventAdmin addingService(ServiceReference<EventAdmin> reference) {
        EventAdmin service = (EventAdmin)this.bContext.getService(reference);
        this.logImpl.setEventAdmin(service);
        return service;
    }

    public void modifiedService(ServiceReference<EventAdmin> reference, EventAdmin service) {
    }

    public void removedService(ServiceReference<EventAdmin> reference, EventAdmin service) {
        this.logImpl.setEventAdmin(null);
    }

    public static class RuntimeTransformerComponentListener
    implements TraceComponentChangeListener {
        public void traceComponentRegistered(TraceComponent tc) {
        }

        public void traceComponentUpdated(TraceComponent tc) {
            AlpineRuntimeTransformer.traceStateChanged(tc);
        }
    }
}

