/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.security.wim.exception.InvalidPropertyValueException;
import com.ibm.wsspi.security.wim.exception.InvalidUniqueNameException;
import com.ibm.wsspi.security.wim.exception.MissingMandatoryPropertyException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Entity;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class UniqueNameHelper {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2012";
    private static final TraceComponent tc = Tr.register(UniqueNameHelper.class);
    public static final String ENTITY_DN_SEPARATOR = ",";
    static final long serialVersionUID = -3899047360046897019L;

    @Trivial
    public static String isDN(String uniqueName) {
        if (uniqueName == null) {
            return null;
        }
        return UniqueNameHelper.getValidDN(uniqueName);
    }

    public static String formatUniqueName(String uniqueName) throws InvalidUniqueNameException {
        String validName = UniqueNameHelper.getValidUniqueName(uniqueName);
        if (validName == null) {
            if (tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)"INVALID_UNIQUE_NAME_SYNTAX", (Object[])WIMMessageHelper.generateMsgParms((Object)uniqueName));
            }
            throw new InvalidUniqueNameException("INVALID_UNIQUE_NAME_SYNTAX", Tr.formatMessage((TraceComponent)tc, (String)"INVALID_UNIQUE_NAME_SYNTAX", (Object[])WIMMessageHelper.generateMsgParms((Object)uniqueName)));
        }
        return validName;
    }

    @Trivial
    public static String getValidUniqueName(String uniqueName) {
        return UniqueNameHelper.getValidDN(uniqueName);
    }

    @FFDCIgnore(value={InvalidNameException.class})
    private static String getValidDN(String uniqueName) {
        LdapName name = null;
        try {
            name = new LdapName(uniqueName);
            return name.getPrefix(name.size()).toString();
        }
        catch (InvalidNameException e) {
            return null;
        }
    }

    public static String constructUniqueName(String[] RDNs, Entity entity, String parentDN, boolean throwExc) throws WIMException {
        boolean found = false;
        String uniqueName = null;
        String missingPropName = null;
        for (int i = 0; i < RDNs.length; ++i) {
            String[] localRDNs = UniqueNameHelper.getRDNs(RDNs[i]);
            int size = localRDNs.length;
            String[] RDNValues = new String[size];
            boolean findValue = true;
            for (int j = 0; j < size && findValue; ++j) {
                String thisRDN = localRDNs[j];
                String thisRDNValue = String.valueOf(entity.get(thisRDN));
                if (thisRDNValue == null || "null".equalsIgnoreCase(thisRDNValue)) {
                    findValue = false;
                    missingPropName = thisRDN;
                    continue;
                }
                if (thisRDNValue.trim().length() == 0) {
                    String qualifiedEntityType = entity.getTypeName();
                    throw new InvalidPropertyValueException("CAN_NOT_CONSTRUCT_UNIQUE_NAME", Tr.formatMessage((TraceComponent)tc, (String)"CAN_NOT_CONSTRUCT_UNIQUE_NAME", (Object[])WIMMessageHelper.generateMsgParms((Object)thisRDN, (Object)qualifiedEntityType)));
                }
                RDNValues[j] = thisRDNValue;
            }
            if (!findValue) continue;
            if (!found) {
                uniqueName = UniqueNameHelper.constructUniqueName(localRDNs, RDNValues, parentDN);
                found = true;
                continue;
            }
            if (!throwExc) continue;
            String qualifiedEntityType = entity.getTypeName();
            throw new InvalidUniqueNameException("CAN_NOT_CONSTRUCT_UNIQUE_NAME", Tr.formatMessage((TraceComponent)tc, (String)"CAN_NOT_CONSTRUCT_UNIQUE_NAME", (Object[])WIMMessageHelper.generateMsgParms((Object)RDNs[i], (Object)qualifiedEntityType)));
        }
        if (missingPropName != null && !found && throwExc) {
            throw new MissingMandatoryPropertyException("MISSING_MANDATORY_PROPERTY", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_MANDATORY_PROPERTY", (Object[])WIMMessageHelper.generateMsgParms(missingPropName)));
        }
        return uniqueName;
    }

    public static String constructUniqueName(String[] RDNs, String[] RDNValues, String parentDN) throws InvalidUniqueNameException {
        if (RDNs == null) {
            return null;
        }
        int length = RDNs.length;
        if (length != RDNValues.length || length == 0) {
            return null;
        }
        StringBuffer RDN = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (RDNValues[i] == null || RDNValues[i].length() == 0) continue;
            if (i != 0 && RDN.length() != 0) {
                RDN.append("+");
            }
            RDN.append(RDNs[i] + "=" + UniqueNameHelper.escapeAttributeValue(RDNValues[i]));
        }
        String DN = null;
        DN = parentDN.length() == 0 ? RDN.toString() : RDN.toString() + ENTITY_DN_SEPARATOR + parentDN;
        return UniqueNameHelper.formatUniqueName(DN);
    }

    private static String escapeAttributeValue(String value) {
        int trail;
        int lead;
        String escapees = ",=+<>#;\"\\";
        char[] chars = value.toCharArray();
        StringBuffer buf = new StringBuffer(2 * value.length());
        for (lead = 0; lead < chars.length && UniqueNameHelper.isWhitespace(chars[lead]); ++lead) {
        }
        for (trail = chars.length - 1; trail >= 0 && UniqueNameHelper.isWhitespace(chars[trail]); --trail) {
        }
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (i < lead || i > trail || ",=+<>#;\"\\".indexOf(c) >= 0) {
                buf.append('\\');
            }
            buf.append(c);
        }
        return new String(buf);
    }

    private static boolean isWhitespace(char c) {
        return c == ' ' || c == '\r';
    }

    public static String[] getRDNs(String rdnStr) {
        StringTokenizer st = new StringTokenizer(rdnStr, "+");
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String rdn = st.nextToken();
            list.add(rdn);
        }
        return list.toArray(new String[0]);
    }
}

