/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.ws.config.xml.internal.nester.Nester;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.RealmConfig;
import com.ibm.ws.security.wim.RealmConfigChangeListener;
import com.ibm.ws.security.wim.SupportedEntityConfig;
import com.ibm.ws.security.wim.util.StringUtil;
import com.ibm.ws.security.wim.util.UniqueNameHelper;
import com.ibm.wsspi.security.wim.exception.InvalidArgumentException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Group;
import com.ibm.wsspi.security.wim.model.PersonAccount;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPid={"com.ibm.ws.security.wim.core.config"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, service={ConfigManager.class}, property={"service.vendor=IBM", "com.ibm.ws.security.registry.type=WIM", "config.id=default-WIM"})
public class ConfigManager {
    private static final TraceComponent tc = Tr.register(ConfigManager.class);
    public static final String SUPPORTED_ENTITY_TYPE = "supportedEntityType";
    public static final String MAX_SEARCH_RESULTS = "maxSearchResults";
    public static final String SEARCH_TIME_OUT = "searchTimeout";
    public static final String RDN_PROPERTY = "rdnProperty";
    public static final String ENTITY_TYPE_NAME = "name";
    public static final String PRIMARY_REALM = "primaryRealm";
    public static final String REALM = "realm";
    public static final String REALM_NAME = "name";
    static final String KEY_CONFIG_ADMIN = "configurationAdmin";
    public static final String ENTITY_NAME = "name";
    public static final String DEFAULT_PARENT = "defaultParent";
    public static final String EXTENDED_PROPERTY = "extendedProperty";
    public static final String PROPERTY_NAME = "name";
    public static final String DATA_TYPE = "dataType";
    public static final String MULTI_VALUED = "multiValued";
    public static final String ENTITY_TYPE_NAMES = "entityType";
    public static final String DEFAULT_VALUE = "defaultValue";
    public static final String DEFAULT_ATTRIBUTE = "defaultAttribute";
    public static final Integer DEFAULT_MAX_SEARCH_RESULTS = new Integer(4500);
    public static final Integer DEFAULT_SEARCH_TIMEOUT = new Integer(600000);
    private static final Object PAGE_CACHE_SIZE = "pageCacheSize";
    private static final Integer DEFAULT_PAGE_CACHE_SIZE = new Integer(1000);
    private static final Object PAGE_CACHE_TIMEOUT = "pageCacheTimeout";
    private static final Long DEFAULT_PAGE_CACHE_TIMEOUT = new Long(30000L);
    private volatile Map<String, Object> originalConfig;
    private volatile Map<String, Object> config;
    private volatile Map<String, RealmConfig> realmNameToRealmConfigMap;
    private volatile Map<String, SupportedEntityConfig> entityTypeMap;
    private final ArrayList<RealmConfigChangeListener> listeners = new ArrayList();
    private Map<String, Map<String, String[]>> defaultEntityMap = null;
    static final long serialVersionUID = 9116500946872456363L;

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> properties) {
        this.originalConfig = properties;
        this.config = this.processConfig();
    }

    @Modified
    protected void modify(ComponentContext cc, Map<String, Object> newProperties) {
        this.originalConfig = newProperties;
        this.config = this.processConfig();
        if (this.listeners != null) {
            for (RealmConfigChangeListener listener : this.listeners) {
                listener.notifyRealmConfigChange();
            }
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc, Map<String, Object> newProperties) {
        this.originalConfig = null;
        this.config = null;
        this.listeners.clear();
    }

    public Map<String, Object> getConfigurationProperties() {
        return this.originalConfig;
    }

    public int getMaxSearchResults() {
        if (this.config.get(MAX_SEARCH_RESULTS) != null) {
            return (Integer)this.config.get(MAX_SEARCH_RESULTS);
        }
        return DEFAULT_MAX_SEARCH_RESULTS;
    }

    public int getSearchTimeOut() {
        if (this.config.get(SEARCH_TIME_OUT) != null) {
            long val = Long.parseLong(String.valueOf(this.config.get(SEARCH_TIME_OUT)));
            return (int)val;
        }
        return DEFAULT_SEARCH_TIMEOUT;
    }

    public String[] getRDNProperties(String entityTypeName) {
        SupportedEntityConfig entityConfig = this.entityTypeMap.get(entityTypeName);
        if (entityConfig != null) {
            return entityConfig.getRdnProperties();
        }
        return null;
    }

    public String[] getDefaultRDNProperties(String typeName) {
        Map<String, String[]> specificEntityMap;
        String[] rdnProps = null;
        if (this.defaultEntityMap == null) {
            this.initializeDefaultEntityMap();
        }
        if ((specificEntityMap = this.defaultEntityMap.get(typeName)) != null) {
            rdnProps = specificEntityMap.get(RDN_PROPERTY);
        }
        return rdnProps;
    }

    private void initializeDefaultEntityMap() {
        if (this.defaultEntityMap != null) {
            return;
        }
        this.defaultEntityMap = new HashMap<String, Map<String, String[]>>();
        HashMap<String, String[]> rdn = new HashMap<String, String[]>();
        String[] rdns = new String[]{"uid"};
        rdn.put(RDN_PROPERTY, rdns);
        this.defaultEntityMap.put("PersonAccount", rdn);
        rdn = new HashMap();
        rdns = new String[]{"cn"};
        rdn.put(RDN_PROPERTY, rdns);
        this.defaultEntityMap.put("Group", rdn);
    }

    public List<String> getSupportedEntityTypes() {
        return new ArrayList<String>(this.entityTypeMap.keySet());
    }

    Map<String, Object> processConfig() {
        Map<String, Object> properties = this.originalConfig;
        HashMap<String, Object> updatedConfig = new HashMap<String, Object>(properties);
        Map<String, List<Map<String, Object>>> nested = Nester.nest(properties, SUPPORTED_ENTITY_TYPE, REALM, PRIMARY_REALM, EXTENDED_PROPERTY);
        HashMap<String, SupportedEntityConfig> entityTypeMap = new HashMap<String, SupportedEntityConfig>();
        List<Map<String, Object>> supportedEntityTypes = nested.get(SUPPORTED_ENTITY_TYPE);
        for (Map<String, Object> supportedEntityType : supportedEntityTypes) {
            String entityTypeName = ((String[])supportedEntityType.get("name"))[0];
            String defaultParent = ((String[])supportedEntityType.get(DEFAULT_PARENT))[0];
            String[] rdnProperties = (String[])supportedEntityType.get(RDN_PROPERTY);
            entityTypeMap.put(entityTypeName, new SupportedEntityConfig(defaultParent, rdnProperties));
        }
        this.entityTypeMap = entityTypeMap;
        HashMap<String, RealmConfig> realmMap = new HashMap<String, RealmConfig>();
        List<Map<String, Object>> realms = nested.get(REALM);
        for (Map<String, Object> realm : realms) {
            String realmName = (String)realm.get("name");
            RealmConfig realmCfg = new RealmConfig(realm, false);
            realmMap.put(realmName, realmCfg);
        }
        List<Map<String, Object>> primaryRealmList = nested.get(PRIMARY_REALM);
        if (!primaryRealmList.isEmpty()) {
            Map<String, Object> primaryRealm = primaryRealmList.get(0);
            RealmConfig realmCfg = new RealmConfig(primaryRealm, true);
            String realmName = (String)primaryRealm.get("name");
            realmMap.put(realmName, realmCfg);
        }
        this.realmNameToRealmConfigMap = realmMap;
        PersonAccount.clearExtendedProperties();
        Group.clearExtendedProperties();
        List<Map<String, Object>> extendedProperties = nested.get(EXTENDED_PROPERTY);
        if (!extendedProperties.isEmpty()) {
            for (Map<String, Object> property : extendedProperties) {
                String propertyName = (String)property.get("name");
                String dataType = (String)property.get(DATA_TYPE);
                String entityTypeName = (String)property.get(ENTITY_TYPE_NAMES);
                String defaultValue = (String)property.get(DEFAULT_VALUE);
                Boolean multiValued = (Boolean)property.get(MULTI_VALUED);
                if (entityTypeName.equalsIgnoreCase("PersonAccount")) {
                    PersonAccount.addExtendedProperty((String)propertyName, (String)dataType, (boolean)multiValued, (Object)defaultValue);
                    continue;
                }
                if (entityTypeName.equalsIgnoreCase("Group")) {
                    Group.addExtendedProperty((String)propertyName, (String)dataType, (boolean)multiValued, (Object)defaultValue);
                    continue;
                }
                if (tc.isWarningEnabled()) {
                    Tr.warning((TraceComponent)tc, (String)"ENTITY_TYPE_NOT_SUPPORTED", (Object[])new Object[]{entityTypeName});
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("The extended property definition for " + entityTypeName + " is ignored as this is either an unknown entity type or extension is not supported for it."), (Object[])new Object[0]);
            }
            Group.reInitializePropertyNames();
            PersonAccount.reInitializePropertyNames();
        }
        return updatedConfig;
    }

    @Trivial
    public RealmConfig getRealmConfig(String realmName) {
        if (realmName != null) {
            return this.realmNameToRealmConfigMap.get(realmName);
        }
        return null;
    }

    public boolean isAllowOpIfRepoDown(String realmName) {
        boolean isAllowOpIfRepoDown = false;
        if (realmName != null && this.getRealmConfig(realmName) != null) {
            isAllowOpIfRepoDown = this.getRealmConfig(realmName).isAllowOpIfRepoDown();
        }
        return isAllowOpIfRepoDown;
    }

    public String getDefaultRealmName() {
        String defaultRealmName = null;
        for (RealmConfig realmCfg : this.realmNameToRealmConfigMap.values()) {
            if (!realmCfg.isDefaultRealm()) continue;
            defaultRealmName = realmCfg.getName();
            break;
        }
        return defaultRealmName;
    }

    @Trivial
    public RealmConfig getDefaultRealmConfig() {
        return this.getRealmConfig(this.getDefaultRealmName());
    }

    public boolean isUniqueNameInRealm(String uniqueName, String realmName) throws InvalidArgumentException {
        RealmConfig realmConfig = this.getRealmConfig(realmName);
        boolean inRealm = false;
        if (realmName == null || this.realmNameToRealmConfigMap.size() == 0) {
            inRealm = true;
        } else if (realmConfig != null && realmConfig.getParticipatingBaseEntries() != null) {
            this.validateRealmName(realmName);
            if (uniqueName != null) {
                uniqueName = UniqueNameHelper.getValidUniqueName(uniqueName);
                String[] baseEntryNames = realmConfig.getParticipatingBaseEntries();
                if (baseEntryNames != null) {
                    for (int i = 0; i < baseEntryNames.length && !inRealm; ++i) {
                        String baseEntry = baseEntryNames[i];
                        if (!StringUtil.endsWithIgnoreCase(uniqueName, baseEntry)) continue;
                        inRealm = true;
                    }
                }
            }
        }
        return inRealm;
    }

    private void validateRealmName(String realmName) throws InvalidArgumentException {
        Set<String> realms = this.getRealmNames();
        if (realmName != null && realms != null && !realms.contains(realmName)) {
            throw new InvalidArgumentException("INVALID_REALM_NAME", Tr.formatMessage((TraceComponent)tc, (String)"INVALID_REALM_NAME", (Object[])WIMMessageHelper.generateMsgParms((Object)realmName)));
        }
    }

    public String getDefaultDelimiter() {
        String delimiter = "/";
        if (this.getDefaultRealmConfig() != null) {
            delimiter = this.getDefaultRealmConfig().getDelimiter();
        }
        return delimiter;
    }

    public String getDelimiter(String realmName) {
        String delimiter = this.getDefaultDelimiter();
        if (realmName != null && this.getRealmConfig(realmName) != null) {
            delimiter = this.getRealmConfig(realmName).getDelimiter();
        }
        return delimiter;
    }

    public Set<String> getRealmNames() {
        return this.realmNameToRealmConfigMap.keySet();
    }

    public void registerRealmConfigChangeListener(RealmConfigChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public String getDefaultParentForEntityInRealm(String entType, String realmName) throws WIMException {
        String defaultParent = this.getDefaultParent(entType);
        if (realmName != null) {
            this.validateRealmName(realmName);
            String parent = null;
            RealmConfig realmConfig = this.getRealmConfig(realmName);
            Map<String, String> defaultParentsMap = realmConfig.getDefaultParentMapping();
            if (defaultParentsMap != null && (parent = defaultParentsMap.get(entType)) != null) {
                defaultParent = parent;
            }
            if (parent == null && !this.isUniqueNameInRealm(defaultParent, realmName)) {
                defaultParent = null;
            }
        }
        return defaultParent;
    }

    public String getDefaultParent(String entityTypeName) {
        SupportedEntityConfig entityConfig = this.entityTypeMap.get(entityTypeName);
        if (entityConfig != null) {
            return entityConfig.getDefaultParent();
        }
        return null;
    }

    public int getPageCacheSize() {
        if (this.config.get(PAGE_CACHE_SIZE) != null) {
            return (Integer)this.config.get(PAGE_CACHE_SIZE);
        }
        return DEFAULT_PAGE_CACHE_SIZE;
    }

    public long getPageCacheTimeOut() {
        if (this.config.get(PAGE_CACHE_TIMEOUT) != null) {
            return (Long)this.config.get(PAGE_CACHE_TIMEOUT);
        }
        return DEFAULT_PAGE_CACHE_TIMEOUT;
    }
}

