/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.diagnostics.zos.process;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.logging.IntrospectableService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ProcessInformation
implements IntrospectableService {
    static final long serialVersionUID = -7611080155386675596L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void activate() {
    }

    protected void deactivate() {
    }

    public String getName() {
        return "ProcessInformation";
    }

    public String getDescription() {
        return "Server process information from the 'ps' command";
    }

    public void introspect(OutputStream out) throws IOException {
        PrintWriter writer = new PrintWriter(out, true);
        writer.println("Server Process Information");
        writer.println("--------------------------");
        this.getProcessInformation(this.getPid(), writer);
        writer.println("\n\n-- Status Flags Legend --");
        writer.println("1:\tA single task using assembler callable services.");
        writer.println("A:\tMessage queue receive wait.");
        writer.println("B:\tMessage queue send wait.");
        writer.println("C:\tCommunication system kernel wait.");
        writer.println("D:\tSemaphore operation wait.");
        writer.println("E:\tQuiesce frozen.");
        writer.println("F:\tFile system kernel wait.");
        writer.println("G:\tMVS Pause wait.");
        writer.println("H:\tOne or more pthread created tasks (implies M as well).");
        writer.println("I:\tSwapped out.");
        writer.println("J:\tPthread created.");
        writer.println("K:\tOther kernel wait (for example, pause or sigsuspend).");
        writer.println("L:\tCanceled, parent has performed wait, and still session or process group leader.");
        writer.println("M:\tMultithread.");
        writer.println("N:\tMedium weight thread.");
        writer.println("O:\tAsynchronous thread.");
        writer.println("P:\tPtrace kernel wait.");
        writer.println("R:\tRunning (not kernel wait).");
        writer.println("S:\tSleeping.");
        writer.println("T:\tStopped.");
        writer.println("U:\tInitial process thread.");
        writer.println("V:\tThread is detached.");
        writer.println("W:\tWaiting for a child (wait or waitpid function is running).");
        writer.println("X:\tCreating a new process (fork function is running).");
        writer.println("Y:\tMVS wait.");
        writer.println("Z:\tCanceled and parent has not performed wait (Z for zombie).");
        writer.print("\n");
        writer.flush();
    }

    @FFDCIgnore(value={InterruptedException.class})
    private String getPid() throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("/bin/sh");
        args.add("-c");
        args.add("/bin/echo $PPID");
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        Process pidProcess = processBuilder.redirectErrorStream(true).start();
        InputStream pidInputStream = pidProcess.getInputStream();
        InputStreamReader pidInputStreamReader = new InputStreamReader(pidInputStream);
        BufferedReader pidReader = new BufferedReader(pidInputStreamReader);
        String pid = pidReader.readLine();
        while (pidReader.readLine() != null) {
        }
        pidReader.close();
        int returnCode = -1;
        try {
            returnCode = pidProcess.waitFor();
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        finally {
            pidProcess.getOutputStream().close();
            pidProcess.getErrorStream().close();
        }
        if (returnCode != 0 || !pid.matches("\\d+")) {
            throw new IOException("Unable to acquire process ID");
        }
        return pid;
    }

    /*
     * WARNING - void declaration
     */
    private void getProcessInformation(String pid, PrintWriter writer) throws IOException {
        String line;
        ArrayList<String> args = new ArrayList<String>();
        args.add("/bin/ps");
        args.add("-m");
        args.add("-o");
        args.add("pid,xtid,user,jobname,etime,time,vsz,vsz64,vszlmt64,thdcnt,xtcbaddr,state,syscall,lsyscall,tagdata");
        args.add("-p");
        args.add(pid);
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        Process psProcess = processBuilder.redirectErrorStream(true).start();
        InputStream psInputStream = psProcess.getInputStream();
        InputStreamReader psInputStreamReader = new InputStreamReader(psInputStream);
        BufferedReader psReader = new BufferedReader(psInputStreamReader);
        while ((line = psReader.readLine()) != null) {
            writer.println(line);
        }
        psReader.close();
        int returnCode = -1;
        try {
            returnCode = psProcess.waitFor();
        }
        catch (InterruptedException interruptedException) {
            void ie;
            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.diagnostics.zos.process.ProcessInformation", (String)"187", (Object)this, (Object[])new Object[]{pid, writer});
            throw new IOException((Throwable)ie);
        }
        finally {
            psProcess.getOutputStream().close();
            psProcess.getErrorStream().close();
        }
        if (returnCode != 0) {
            throw new IOException("Unable to get process info");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ProcessInformation.class);
    }
}

