/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.diagnostics.zos.network;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.logging.IntrospectableService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class NetstatInformation
implements IntrospectableService {
    static final long serialVersionUID = 1158341173728044480L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void activate() {
    }

    protected void deactivate() {
    }

    public String getName() {
        return "NetstatInformation";
    }

    public String getDescription() {
        return "Network connection status information from /bin/onetstat";
    }

    public void introspect(OutputStream out) throws IOException {
        PrintWriter writer = new PrintWriter(out, true);
        writer.println("Network Connection Information");
        writer.println("------------------------------");
        this.getNetstatInfo(writer);
        writer.flush();
    }

    /*
     * WARNING - void declaration
     */
    private void getNetstatInfo(PrintWriter writer) throws IOException {
        String line;
        ArrayList<String> args = new ArrayList<String>();
        args.add("/bin/onetstat");
        args.add("-b");
        args.add("IDLETIME");
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        Process netstatProcess = processBuilder.redirectErrorStream(true).start();
        InputStream netstatInputStream = netstatProcess.getInputStream();
        InputStreamReader netstatInputStreamReader = new InputStreamReader(netstatInputStream);
        BufferedReader netstatReader = new BufferedReader(netstatInputStreamReader);
        while ((line = netstatReader.readLine()) != null) {
            writer.println(line);
        }
        netstatReader.close();
        int returnCode = -1;
        try {
            returnCode = netstatProcess.waitFor();
        }
        catch (InterruptedException interruptedException) {
            void ie;
            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.diagnostics.zos.network.NetstatInformation", (String)"103", (Object)this, (Object[])new Object[]{writer});
            throw new IOException((Throwable)ie);
        }
        finally {
            netstatProcess.getOutputStream().close();
            netstatProcess.getErrorStream().close();
        }
        if (returnCode != 0) {
            throw new IOException("Unable to get netstat info");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(NetstatInformation.class);
    }
}

