/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.diagnostics.zos.dump;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.kernel.LibertyProcess;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.zos.core.command.processing.CommandHandler;
import com.ibm.ws.zos.core.command.processing.ModifyResults;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ServerDumpCommandHandler
implements CommandHandler {
    protected static final String NAME = "Server Dump Command Handler";
    protected static final List<String> HELP_TEXT;
    private static final String DUMP_COMMAND = "dump";
    private static final String DUMP_COMMAND_WITH_INCLUDE = "dump,include=";
    private static final int DUMP_COMMAND_WITH_INCLUDE_LENGTH;
    protected static final Set<String> VALID_DUMPS;
    protected LibertyProcess process = null;
    protected WsLocationAdmin locationAdmin = null;
    static final long serialVersionUID = -8934825779176278951L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void setLibertyProcess(LibertyProcess process) {
        this.process = process;
    }

    protected void unsetLibertyProcess(LibertyProcess process) {
        if (this.process == process) {
            this.process = null;
        }
    }

    protected void setLocationAdmin(WsLocationAdmin locationAdmin) {
        this.locationAdmin = locationAdmin;
    }

    protected void unsetLocationAdmin(WsLocationAdmin locationAdmin) {
        if (this.locationAdmin == locationAdmin) {
            this.locationAdmin = null;
        }
    }

    public List<String> getHelp() {
        return HELP_TEXT;
    }

    public String getName() {
        return NAME;
    }

    public void handleModify(String command, ModifyResults results) {
        ArrayList<String> responses = new ArrayList<String>();
        results.setResponsesContainMSGIDs(false);
        results.setResponses(responses);
        Set<String> dumps = this.getOptionalDumpSet(command);
        if (dumps == null) {
            results.setCompletionStatus(2);
        } else {
            String dumpFileName = this.process.createServerDump(dumps);
            if (dumpFileName != null) {
                responses.add("Server " + this.locationAdmin.getServerName() + " dump complete in " + dumpFileName + ".");
                results.setCompletionStatus(1);
            } else {
                responses.add("Error creating server dump, see server log for details.");
                results.setCompletionStatus(3);
            }
        }
    }

    private Set<String> getOptionalDumpSet(String command) {
        String[] requestedDumps;
        LinkedHashSet<String> dumps = new LinkedHashSet<String>();
        if (command == null) {
            return null;
        }
        if ((command = command.toLowerCase()).equals(DUMP_COMMAND)) {
            return dumps;
        }
        if (!command.startsWith(DUMP_COMMAND_WITH_INCLUDE)) {
            return null;
        }
        for (String requestedDump : requestedDumps = command.substring(DUMP_COMMAND_WITH_INCLUDE_LENGTH).split(",")) {
            if (!VALID_DUMPS.contains(requestedDump)) continue;
            dumps.add(requestedDump);
        }
        return dumps;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ServerDumpCommandHandler.class);
        HELP_TEXT = new ArrayList<String>();
        HELP_TEXT.add("Issue \"MODIFY <jobname.>identifier,dump[,include=javadump1,javadump2,...]\"");
        HELP_TEXT.add("  to request a server dump that can include optional java dumps");
        HELP_TEXT.add("  Valid values for java dumps are:");
        HELP_TEXT.add("    thread (javacore)");
        HELP_TEXT.add("    heap (JVM heap dump)");
        DUMP_COMMAND_WITH_INCLUDE_LENGTH = DUMP_COMMAND_WITH_INCLUDE.length();
        VALID_DUMPS = new LinkedHashSet<String>();
        VALID_DUMPS.addAll(Arrays.asList("thread", "heap"));
    }
}

