/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.security.token.Token;
import java.security.Permission;
import java.util.Enumeration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class AbstractTokenImpl
implements Token {
    private static final TraceComponent tc = Tr.register(AbstractTokenImpl.class);
    private static final WebSphereRuntimePermission UPDATE_TOKEN = new WebSphereRuntimePermission("updateToken");
    private static final WebSphereRuntimePermission GET_TOKEN = new WebSphereRuntimePermission("getToken");
    private com.ibm.wsspi.security.ltpa.Token token = null;
    private boolean isReadOnly = false;
    private final short version = 1;
    private long change_counter = 0L;
    static final long serialVersionUID = -2891285013823344683L;

    public void setToken(com.ibm.wsspi.security.ltpa.Token _token) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + UPDATE_TOKEN.toString()), (Object[])new Object[0]);
            }
            sm.checkPermission((Permission)UPDATE_TOKEN);
        }
        ++this.change_counter;
        this.token = _token;
    }

    public com.ibm.wsspi.security.ltpa.Token getToken() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + GET_TOKEN.toString()), (Object[])new Object[0]);
            }
            sm.checkPermission((Permission)GET_TOKEN);
        }
        return this.token;
    }

    @Override
    public boolean isValid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Checking validity of token " + this.getClass().getName()), (Object[])new Object[0]);
        }
        if (this.token != null) {
            long currentTime = System.currentTimeMillis();
            long expiration = this.getExpiration();
            long timeleft = expiration - currentTime;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Time left for token: " + timeleft), (Object[])new Object[0]);
            }
            if (timeleft > 0L) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"token is valid.", (Object[])new Object[0]);
                }
                return true;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"token is invalid.", (Object[])new Object[0]);
            }
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"token is null, returning invalid.", (Object[])new Object[0]);
        }
        return false;
    }

    @Override
    public long getExpiration() {
        if (this.token != null) {
            return this.token.getExpiration();
        }
        return -1L;
    }

    @Override
    public boolean isForwardable() {
        return true;
    }

    @Override
    public String getPrincipal() {
        String[] accessIDArray = this.getAttributes("u");
        if (accessIDArray != null && accessIDArray.length > 0) {
            return accessIDArray[0];
        }
        return null;
    }

    @Override
    public String getUniqueID() {
        String[] cacheKeyArray = this.getAttributes("com.ibm.wsspi.security.cred.cacheKey");
        if (cacheKeyArray != null && cacheKeyArray[0] != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found cache key in Authz token: " + cacheKeyArray[0]), (Object[])new Object[0]);
            }
            return cacheKeyArray[0];
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No unique cache key found in token.", (Object[])new Object[0]);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] getBytes() {
        if (this.token != null) {
            try {
                return this.token.getBytes();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.internal.AbstractTokenImpl", (String)"169", (Object)this, (Object[])new Object[0]);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)"Exception occurred getting bytes[] from token.", (Object[])new Object[]{e});
                }
                return null;
            }
        }
        return new byte[0];
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public short getVersion() {
        return 1;
    }

    public boolean isBasicAuth() {
        return false;
    }

    @Override
    public void setReadOnly() {
        this.isReadOnly = true;
    }

    @Override
    public String[] getAttributes(String key) {
        if (this.token != null) {
            return this.token.getAttributes(key);
        }
        return null;
    }

    @Override
    public String[] addAttribute(String key, String value) {
        SecurityManager sm;
        if ((key.startsWith("com.ibm.wsspi.security") || key.startsWith("com.ibm.websphere.security")) && (sm = System.getSecurityManager()) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + UPDATE_TOKEN.toString()), (Object[])new Object[0]);
            }
            sm.checkPermission((Permission)UPDATE_TOKEN);
        }
        if (!this.isReadOnly && this.token != null) {
            ++this.change_counter;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Setting attribute with key: " + key + ", value: " + value), (Object[])new Object[0]);
            }
            return this.token.addAttribute(key, value);
        }
        return null;
    }

    @Override
    public Enumeration getAttributeNames() {
        if (this.token != null) {
            return this.token.getAttributeNames();
        }
        return null;
    }

    @Override
    public abstract Object clone();
}

