/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.whiteboard;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.eba.wab.integrator.EbaProvider;
import com.ibm.ws.eba.wab.integrator.OSGiAppInfo;
import com.ibm.ws.http.whiteboard.HttpServiceContextRoot;
import com.ibm.ws.http.whiteboard.SubsystemServletContextHelperFactory;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.equinox.http.servlet.context.ContextPathCustomizer;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.service.subsystem.Subsystem;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ContextPathCustomizer.class}, property={"service.vendor=IBM"}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE)
public class SubsystemPathCustomizer
extends ContextPathCustomizer {
    private final ConcurrentMap<ServiceReference<Subsystem>, AtomicReference<SubsystemServletContextHelperFactory>> subsystemContexthelpers = new ConcurrentHashMap<ServiceReference<Subsystem>, AtomicReference<SubsystemServletContextHelperFactory>>();
    private BundleContext context;
    private BundleContext systemContext;
    private EbaProvider ebaProvider;
    private RegionDigraph digraph;
    private String whiteboardContextPathURI;
    static final String SHARED_SUBSYSTEM_NAME = "com.ibm.ws.esa.shared.bundle.subsystem";
    private static final String SHARED_SUBSYSTEM_TARGET_FILTER = "(subsystem.symbolicName=com.ibm.ws.esa.shared.bundle.subsystem)";
    static final long serialVersionUID = -3846777333637697443L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public String getDefaultContextSelectFilter(ServiceReference<?> httpWhiteBoardService) {
        SubsystemServletContextHelperFactory helper = this.getHelper(httpWhiteBoardService.getBundle());
        if (helper == null) {
            return null;
        }
        return "(service.id=" + helper.getProperty("service.id") + ")";
    }

    @Activate
    protected void activate(BundleContext bc) throws Exception {
        this.context = bc;
        this.systemContext = bc.getBundle("System Bundle").getBundleContext();
        for (Map.Entry entry : this.subsystemContexthelpers.entrySet()) {
            if (((AtomicReference)entry.getValue()).get() != null) continue;
            this.registerSubsystemContextHelper((AtomicReference)entry.getValue(), (ServiceReference<Subsystem>)((ServiceReference)entry.getKey()));
        }
    }

    protected void deactivate(BundleContext bc) throws Exception {
    }

    private void registerSubsystemContextHelper(AtomicReference<SubsystemServletContextHelperFactory> factoryRef, ServiceReference<Subsystem> subsystemRef) {
        if (this.context == null) {
            return;
        }
        Subsystem subsystem = (Subsystem)this.context.getService(subsystemRef);
        String subsystemContextPath = (String)subsystem.getSubsystemHeaders(null).get("Web-ContextPath");
        if (subsystemContextPath == null) {
            ApplicationInfo appInfo = this.ebaProvider.getApplicationInfo(subsystem.getBundleContext().getBundle());
            if (appInfo == null) {
                return;
            }
            subsystemContextPath = appInfo.getName();
            if (!subsystemContextPath.startsWith("/")) {
                subsystemContextPath = "/" + subsystemContextPath;
            }
        }
        SubsystemServletContextHelperFactory factory = new SubsystemServletContextHelperFactory(this.context, subsystemRef, this.whiteboardContextPathURI, subsystemContextPath);
        factoryRef.set(factory);
        factory.register();
    }

    private String getSubsystemContextPathPrefix(Bundle bundle) {
        SubsystemServletContextHelperFactory helper = this.getHelper(bundle);
        if (helper == null) {
            return null;
        }
        if (helper.getProperty("osgi.http.whiteboard.context.path") != null) {
            return (String)helper.getProperty("osgi.http.whiteboard.context.path");
        }
        return "httpservice";
    }

    private SubsystemServletContextHelperFactory getHelper(Bundle bundle) {
        Region region = this.digraph.getRegion(bundle);
        boolean isConsole = false;
        if (region != null && region.getName().endsWith("-appConsole")) {
            bundle = this.getSubsystemContextBundle(bundle);
            isConsole = true;
        }
        for (Map.Entry entry : this.subsystemContexthelpers.entrySet()) {
            if (((SubsystemServletContextHelperFactory)((AtomicReference)entry.getValue()).get()).getBundle(bundle.getBundleId()) == null) continue;
            SubsystemServletContextHelperFactory result = (SubsystemServletContextHelperFactory)((AtomicReference)entry.getValue()).get();
            if (isConsole && SHARED_SUBSYSTEM_NAME.equals(result.getSubsystem().getSymbolicName())) {
                result = result.getSharedConsoleHelper();
            }
            return result;
        }
        return null;
    }

    private Bundle getSubsystemContextBundle(Bundle bundle) {
        for (Bundle b : bundle.getBundleContext().getBundles()) {
            String bsn = b.getSymbolicName();
            if (bsn == null || !bsn.startsWith("org.osgi.service.subsystem.region.context.")) continue;
            return b;
        }
        return bundle;
    }

    @Override
    public String getContextPathPrefix(ServiceReference<ServletContextHelper> helper) {
        String result;
        Bundle initiatingBundle;
        Bundle b = helper.getBundle();
        Long id = (Long)helper.getProperty("equinox.legacy.http.context.initiating.id");
        if (id != null && (initiatingBundle = this.systemContext.getBundle(id.longValue())) != null) {
            b = initiatingBundle;
        }
        if ("/".equals(result = this.getSubsystemContextPathPrefix(b))) {
            return null;
        }
        return result;
    }

    @Reference(service=Subsystem.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, target="(subsystem.symbolicName=com.ibm.ws.esa.shared.bundle.subsystem)")
    protected void setSubsystem(ServiceReference<Subsystem> subsystem) {
        AtomicReference<SubsystemServletContextHelperFactory> factoryRef = new AtomicReference<SubsystemServletContextHelperFactory>();
        this.subsystemContexthelpers.put(subsystem, factoryRef);
        this.registerSubsystemContextHelper(factoryRef, subsystem);
    }

    protected void unsetSubsystem(ServiceReference<Subsystem> subsystem) {
        AtomicReference helper = (AtomicReference)this.subsystemContexthelpers.remove(subsystem);
        if (helper != null && helper.get() != null) {
            ((SubsystemServletContextHelperFactory)helper.get()).unregister();
        }
    }

    @Reference(service=OSGiAppInfo.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setOSGiAppInfo(ServiceReference<OSGiAppInfo> osgiAppInfo) {
        ServiceReference subsystemRef = (ServiceReference)osgiAppInfo.getProperty("com.ibm.ws.http.whiteboard.context.for.subsystem");
        if (!"osgi.subsystem.feature".equals(subsystemRef.getProperty("subsystem.type"))) {
            this.setSubsystem((ServiceReference<Subsystem>)subsystemRef);
        }
    }

    protected void unsetOSGiAppInfo(ServiceReference<OSGiAppInfo> osgiAppInfo) {
        ServiceReference subsystemRef = (ServiceReference)osgiAppInfo.getProperty("com.ibm.ws.http.whiteboard.context.for.subsystem");
        this.unsetSubsystem((ServiceReference<Subsystem>)subsystemRef);
    }

    @Reference
    protected void setEbaProvider(EbaProvider ebaProvider) {
        this.ebaProvider = ebaProvider;
    }

    protected void unsetEbaProvider(EbaProvider ebaProvider) {
    }

    @Reference
    protected void setRegionDigraph(RegionDigraph digraph) {
        this.digraph = digraph;
    }

    protected void unsetRegionDigraph(RegionDigraph digraph) {
    }

    @Reference(service=HttpServiceContextRoot.class)
    protected void setHttpServiceContextRoot(ServiceReference<HttpServiceContextRoot> contextRoot) {
        this.whiteboardContextPathURI = (String)contextRoot.getProperty("com.ibm.ws.http.whiteboard.context.path.uri");
    }

    protected void unsetHttpServiceContextRoot(ServiceReference<HttpServiceContextRoot> contextPath) {
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(SubsystemPathCustomizer.class);
    }
}

