/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.LogFileHeaderReadCallback;
import com.ibm.ws.recoverylog.spi.LogIncompatibleException;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LogFileHeader {
    private static final TraceComponent tc;
    static final byte[] MAGIC_NUMBER;
    static final byte[] VARIABLE_FIELD_HEADER;
    public static final int STATUS_INACTIVE = 2;
    public static final int STATUS_ACTIVE = 4;
    public static final int STATUS_KEYPOINTING = 8;
    public static final int STATUS_INVALID = 16;
    private int _status = 2;
    private int _creatorRLSVersionNumber = 0;
    private long _date = 0L;
    private long _firstRecordSequenceNumber = 0L;
    private String _serverName = null;
    private byte[] _serverNameBytes = null;
    private String _serviceName = null;
    private int _serviceVersion;
    private byte[] _serviceNameBytes = null;
    private String _logName = null;
    private byte[] _logNameBytes = null;
    private byte[] _variableFieldData = null;
    private byte[] _serviceData = null;
    private boolean _compatible = false;
    private static boolean _useVariableFieldHeader;
    private boolean _shutDownWasClean = false;
    private static LogFileHeaderReadCallback _logFileHeaderReadCallback;
    static final long serialVersionUID = -1652826660574162070L;
    private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

    public LogFileHeader(String serverName, String serviceName, int serviceVersion, String logName) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"LogFileHeader", (Object)new Object[]{serverName, serviceName, new Integer(serviceVersion), logName});
        }
        this._status = 2;
        this._creatorRLSVersionNumber = 3;
        GregorianCalendar currentCal = new GregorianCalendar();
        Date currentDate = currentCal.getTime();
        this._date = currentDate.getTime();
        this._firstRecordSequenceNumber = 0L;
        this._serverName = new String(serverName);
        this._serverNameBytes = this._serverName.getBytes();
        this._serviceName = new String(serviceName);
        this._serviceNameBytes = this._serviceName.getBytes();
        this._serviceVersion = serviceVersion;
        this._logName = new String(logName);
        this._logNameBytes = this._logName.getBytes();
        this._variableFieldData = this.initVariableFieldData();
        this._serviceData = null;
        this._compatible = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"LogFileHeader", (Object)this);
        }
    }

    public static final int headerSize() {
        int headerSize = MAGIC_NUMBER.length + 4 + 4 + 8 + 8 + 4 + 4 + 4 + 4 + 4 + (_useVariableFieldHeader ? VARIABLE_FIELD_HEADER.length + 4 : 0) + 8 + 8;
        return headerSize;
    }

    public int length() throws InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"length");
        }
        if (!this._compatible) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"length", (Object)"LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this._status == 16) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"length", (Object)"LogHeaderInvalid - throwing InternalLogException");
            }
            throw new InternalLogException(null);
        }
        int length = 4 + LogFileHeader.headerSize() + this._serverNameBytes.length + this._serviceNameBytes.length + this._logNameBytes.length + (this._variableFieldData != null ? this._variableFieldData.length : 0) + (this._serviceData != null ? this._serviceData.length : 0);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"length", (Object)new Integer(length));
        }
        return length;
    }

    /*
     * WARNING - void declaration
     */
    public void write(ByteBuffer fileBuffer, boolean maintainPosition) throws InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"write", (Object)new Object[]{fileBuffer, new Boolean(maintainPosition), this});
        }
        if (!this._compatible) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"write", (Object)"LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this._status == 16) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"write", (Object)"LogHeaderInvalid - throwing InternalLogException");
            }
            throw new InternalLogException(null);
        }
        try {
            int startPosition = 0;
            if (maintainPosition) {
                startPosition = fileBuffer.position();
            }
            fileBuffer.position(0);
            fileBuffer.putInt(LogFileHeader.headerSize() + this._serverNameBytes.length + this._serviceNameBytes.length + this._logNameBytes.length);
            fileBuffer.put(MAGIC_NUMBER);
            fileBuffer.putInt(3);
            fileBuffer.putInt(this._status);
            fileBuffer.putLong(this._date);
            fileBuffer.putLong(this._firstRecordSequenceNumber);
            fileBuffer.putInt(this._serverNameBytes.length);
            fileBuffer.put(this._serverNameBytes);
            fileBuffer.putInt(this._serviceNameBytes.length);
            fileBuffer.put(this._serviceNameBytes);
            fileBuffer.putInt(this._serviceVersion);
            fileBuffer.putInt(this._logNameBytes.length);
            fileBuffer.put(this._logNameBytes);
            int varLength = 0;
            if (this._variableFieldData != null && _useVariableFieldHeader) {
                varLength += VARIABLE_FIELD_HEADER.length;
                varLength += 4;
                varLength += this._variableFieldData.length;
            }
            if (this._serviceData != null) {
                varLength += this._serviceData.length;
            }
            fileBuffer.putInt(varLength);
            if (this._variableFieldData != null && _useVariableFieldHeader) {
                fileBuffer.put(VARIABLE_FIELD_HEADER);
                fileBuffer.putInt(this._variableFieldData.length);
                fileBuffer.put(this._variableFieldData);
            }
            if (this._serviceData != null) {
                fileBuffer.put(this._serviceData);
            }
            fileBuffer.putLong(this._date);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Writing FRSN " + this._firstRecordSequenceNumber + " at position " + fileBuffer.position() + " in log file " + this._logName));
            }
            fileBuffer.putLong(this._firstRecordSequenceNumber);
            if (maintainPosition) {
                fileBuffer.position(startPosition);
            }
        }
        catch (BufferUnderflowException startPosition) {
            void exc;
            FFDCFilter.processException((Throwable)startPosition, (String)"com.ibm.ws.recoverylog.spi.LogFileHeader", (String)"583", (Object)this, (Object[])new Object[]{fileBuffer, maintainPosition});
            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHeader.write", (String)"449", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"write", (Object)"InternalLogException");
            }
            throw new InternalLogException((Throwable)exc);
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHeader", (String)"589", (Object)this, (Object[])new Object[]{fileBuffer, maintainPosition});
            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHeader.write", (String)"455", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"write", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"write");
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean read(ByteBuffer fileBuffer) {
        boolean readOK;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"read", (Object)new Object[]{fileBuffer, this});
        }
        long checkDate = -1L;
        long checkFirstRecordSequenceNumber = -1L;
        int dataLength = -1;
        boolean valid = false;
        this._status = 16;
        this._compatible = false;
        try {
            int headerLength = fileBuffer.getInt();
            if (headerLength > 0 && headerLength <= fileBuffer.capacity() - fileBuffer.position()) {
                byte[] magicNumberBuffer = new byte[MAGIC_NUMBER.length];
                fileBuffer.get(magicNumberBuffer);
                if (this.validMagicNumber(magicNumberBuffer)) {
                    this._creatorRLSVersionNumber = fileBuffer.getInt();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Recovery log creator version is " + this._creatorRLSVersionNumber));
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Current recovery log version is 3");
                    }
                    for (int i = 0; !this._compatible && i < Configuration.COMPATIBLE_RLS_VERSIONS.length; ++i) {
                        if (this._creatorRLSVersionNumber != Configuration.COMPATIBLE_RLS_VERSIONS[i]) continue;
                        this._compatible = true;
                    }
                    if (this._compatible) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"This version of recovery log file can be parsed by this level of the RLS");
                        }
                        this._status = fileBuffer.getInt();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Recovery log file state is " + LogFileHeader.statusToString(this._status)));
                        }
                        this._date = fileBuffer.getLong();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Recovery log file date (long) is " + this._date));
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Recovery log file date (date) is " + new Date(this._date).toString()));
                        }
                        this._firstRecordSequenceNumber = fileBuffer.getLong();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Recovery log file first record sequence number is " + this._firstRecordSequenceNumber));
                        }
                        int stringLength = fileBuffer.getInt();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Reading String of length " + stringLength));
                        }
                        byte[] serverNameBytes = new byte[stringLength];
                        fileBuffer.get(serverNameBytes);
                        this._serverName = new String(serverNameBytes);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Recovery log file created on server " + this._serverName));
                        }
                        stringLength = fileBuffer.getInt();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Reading String of length " + stringLength));
                        }
                        byte[] serviceNameBytes = new byte[stringLength];
                        fileBuffer.get(serviceNameBytes);
                        this._serviceName = new String(serviceNameBytes);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Recovery log file created by service " + this._serviceName));
                        }
                        this._serviceVersion = fileBuffer.getInt();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Recovery log file created by service version" + this._serviceVersion));
                        }
                        stringLength = fileBuffer.getInt();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Reading String of length " + stringLength));
                        }
                        byte[] logNameBytes = new byte[stringLength];
                        fileBuffer.get(logNameBytes);
                        this._logName = new String(logNameBytes);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Recovery log name was " + this._logName));
                        }
                        dataLength = fileBuffer.getInt();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Recovery log file contains " + dataLength + " bytes of service specific information"));
                        }
                        if (dataLength > 0) {
                            byte[] varHeaderTest = new byte[VARIABLE_FIELD_HEADER.length];
                            int currPosition = fileBuffer.position();
                            fileBuffer.get(varHeaderTest);
                            if (_useVariableFieldHeader && Arrays.equals(varHeaderTest, VARIABLE_FIELD_HEADER)) {
                                int rlsVarFieldLength = fileBuffer.getInt();
                                if (rlsVarFieldLength > 0) {
                                    this._variableFieldData = new byte[rlsVarFieldLength];
                                    fileBuffer.get(this._variableFieldData);
                                    this.parseVariableFieldData();
                                }
                                if (dataLength - rlsVarFieldLength - VARIABLE_FIELD_HEADER.length - 4 > 0) {
                                    this._serviceData = new byte[dataLength - rlsVarFieldLength];
                                    fileBuffer.get(this._serviceData);
                                }
                            } else {
                                this._variableFieldData = null;
                                fileBuffer.position(currPosition);
                                this._serviceData = new byte[dataLength];
                                fileBuffer.get(this._serviceData);
                            }
                        } else {
                            this._variableFieldData = null;
                            this._serviceData = null;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("RLS var data Information is [" + RLSUtils.toHexString(this._variableFieldData, 32) + "]"));
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Service Specific Information is [" + RLSUtils.toHexString(this._serviceData, 32) + "]"));
                        }
                        checkDate = fileBuffer.getLong();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Recovery log file check date (long) is " + checkDate));
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Recovery log file check date (date) is " + new Date(checkDate).toString()));
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Reading FRSN from position " + fileBuffer.position()));
                        }
                        checkFirstRecordSequenceNumber = fileBuffer.getLong();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Recovery log file check first record sequence number is " + checkFirstRecordSequenceNumber));
                        }
                        if (this._date == checkDate && this._firstRecordSequenceNumber == checkFirstRecordSequenceNumber && this._date > 0L) {
                            valid = true;
                        } else {
                            this.changeStatus(16);
                            if (tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)"Error processing recovery log file header - integrity check failed");
                            }
                        }
                    } else {
                        this.reset();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"This version of recovery log file can not be parsed by this level of the RLS");
                        }
                    }
                }
            }
        }
        catch (BufferUnderflowException headerLength) {
            void exc;
            FFDCFilter.processException((Throwable)headerLength, (String)"com.ibm.ws.recoverylog.spi.LogFileHeader", (String)"828", (Object)this, (Object[])new Object[]{fileBuffer});
            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHeader.read", (String)"603", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Error processing recovery log file header", (Object)exc.toString());
            }
            this.changeStatus(16);
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHeader", (String)"834", (Object)this, (Object[])new Object[]{fileBuffer});
            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHeader.read", (String)"609", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Error processing recovery log file header", (Object)exc.toString());
            }
            this.changeStatus(16);
        }
        boolean bl = readOK = this._compatible && valid;
        if (_logFileHeaderReadCallback != null) {
            _logFileHeaderReadCallback.readComplete(this, readOK);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"read", (Object)new Boolean(readOK));
        }
        return readOK;
    }

    private boolean validMagicNumber(byte[] magicNumberBuffer) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validMagicNumber", (Object)new Object[]{RLSUtils.toHexString(magicNumberBuffer, 32), this});
        }
        boolean incorrectByteDetected = false;
        for (int currentByte = 0; !incorrectByteDetected && currentByte < MAGIC_NUMBER.length; ++currentByte) {
            if (magicNumberBuffer[currentByte] == MAGIC_NUMBER[currentByte]) continue;
            incorrectByteDetected = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validMagicNumber", (Object)new Boolean(!incorrectByteDetected));
        }
        return !incorrectByteDetected;
    }

    public long date() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"date", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"date", (Object)new Long(this._date));
        }
        return this._date;
    }

    public long firstRecordSequenceNumber() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"firstRecordSequenceNumber", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"firstRecordSequenceNumber", (Object)new Long(this._firstRecordSequenceNumber));
        }
        return this._firstRecordSequenceNumber;
    }

    public String serverName() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"serverName", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"serverName", (Object)this._serverName);
        }
        return this._serverName;
    }

    public String serviceName() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"serviceName", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"serviceName", (Object)this._serviceName);
        }
        return this._serviceName;
    }

    public int serviceVersion() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"serviceVersion", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"serviceVersion", (Object)new Integer(this._serviceVersion));
        }
        return this._serviceVersion;
    }

    public String logName() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logName", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logName", (Object)this._logName);
        }
        return this._logName;
    }

    public byte[] getServiceData() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServiceData", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServiceData", (Object)RLSUtils.toHexString(this._serviceData, 32));
        }
        return this._serviceData;
    }

    public void setServiceData(byte[] serviceData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setServiceData", (Object)new Object[]{RLSUtils.toHexString(serviceData, 32), this});
        }
        this._serviceData = serviceData;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setServiceData");
        }
    }

    public boolean compatible() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"compatible", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"compatible", (Object)new Boolean(this._compatible));
        }
        return this._compatible;
    }

    public int status() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"status", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"status", (Object)new Integer(this._status));
        }
        return this._status;
    }

    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reset", (Object)this);
        }
        this._status = 4;
        this._date = 0L;
        this._firstRecordSequenceNumber = 0L;
        this._serverName = null;
        this._serviceName = null;
        this._serviceVersion = 0;
        this._logName = null;
        this._variableFieldData = this.initVariableFieldData();
        this._serviceData = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reset");
        }
    }

    public void resetHeader(LogFileHeader validHeader) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resetHeader", (Object)this);
        }
        this._date = 0L;
        this._firstRecordSequenceNumber = 0L;
        this._serverName = validHeader.serverName();
        this._serviceName = validHeader.serviceName();
        this._logName = validHeader.logName();
        this._variableFieldData = this.initVariableFieldData();
        this._serviceData = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resetHeader");
        }
    }

    public void changeStatus(int newStatus) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"changeStatus", (Object)new Object[]{this, new Integer(newStatus)});
        }
        this._status = newStatus;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"changeStatus");
        }
    }

    public void keypointStarting(long nextRecordSequenceNumber) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"keypointStarting", (Object)new Object[]{this, new Long(nextRecordSequenceNumber)});
        }
        GregorianCalendar currentCal = new GregorianCalendar();
        Date currentDate = currentCal.getTime();
        this._date = currentDate.getTime();
        this._firstRecordSequenceNumber = nextRecordSequenceNumber;
        this._status = 8;
        this._variableFieldData = this.initVariableFieldData();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"keypointStarting");
        }
    }

    public void keypointComplete() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"keypointComplete", (Object)this);
        }
        this._status = 4;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"keypointComplete");
        }
    }

    public void setCleanShutdown() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setCleanShutdown", (Object)this);
        }
        if (this._variableFieldData != null && this._variableFieldData.length > 0) {
            this._variableFieldData[0] = 1;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setCleanShutdown");
        }
    }

    public boolean wasShutdownClean() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"wasShutdownClean", (Object)this);
        }
        boolean clean = true;
        if (_useVariableFieldHeader) {
            clean = this._shutDownWasClean;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"wasShutdownClean", (Object)clean);
        }
        return clean;
    }

    private byte[] initVariableFieldData() {
        if (_useVariableFieldHeader) {
            return new byte[1];
        }
        return null;
    }

    private void parseVariableFieldData() {
        if (this._variableFieldData != null && this._variableFieldData.length > 0 && this._variableFieldData[0] == 1) {
            this._shutDownWasClean = true;
            this._variableFieldData[0] = 0;
        }
    }

    public static void setUseVariableFieldHeader(boolean b) {
        _useVariableFieldHeader = b;
    }

    static String statusToString(int status) {
        String result = null;
        result = status == 2 ? "INACTIVE" : (status == 4 ? "ACTIVE" : (status == 8 ? "KEYPOINTING" : (status == 16 ? "INVALID" : "UNKNOWN")));
        return result;
    }

    public static void registerReadCallback(LogFileHeaderReadCallback callback) {
        _logFileHeaderReadCallback = callback;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        Boolean b;
        block2: {
            $$$tc$$$ = com.ibm.websphere.ras.Tr.register(LogFileHeader.class);
            tc = Tr.register(LogFileHeader.class, (String)"Transaction", null);
            MAGIC_NUMBER = new byte[]{87, 65, 83, 76, 79, 71};
            VARIABLE_FIELD_HEADER = new byte[]{86, 65, 82, 70, 73, 69, 76, 68};
            b = Boolean.TRUE;
            try {
                b = (Boolean)Configuration.getAccessController().doPrivileged(new PrivilegedExceptionAction(){
                    static final long serialVersionUID = 7458608347782191068L;
                    private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

                    public Boolean run() throws Exception {
                        Boolean bb = Boolean.valueOf(System.getProperty("com.ibm.ws.recoverylog.UseVariableHeader", "true"));
                        return bb;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = com.ibm.websphere.ras.Tr.register(1.class);
                    }
                });
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.LogFileHeader", (String)"292", null, (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"<clinit>", (Object)new Object[]{"Exception reading custom property", e});
            }
        }
        _useVariableFieldHeader = b;
        _logFileHeaderReadCallback = null;
    }
}

