/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class EmailAddress
extends PKCS9DerObject
implements Cloneable {
    private String[] emailaddresses;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.EmailAddress";
    private volatile int cachedHashVal = 0;

    public EmailAddress(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "EmailAddress", (Object)der);
            debug.exit(16384L, className, "EmailAddress");
        }
    }

    public EmailAddress(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "EmailAddress", der, provider);
            debug.exit(16384L, className, "EmailAddress");
        }
    }

    public EmailAddress(String emailaddress) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "EmailAddress", emailaddress);
        }
        String[] addresses = new String[]{emailaddress};
        this.emailaddresses = addresses;
        if (debug != null) {
            debug.exit(16384L, className, "EmailAddress");
        }
    }

    public EmailAddress(String emailaddress, String provider) {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "EmailAddress", emailaddress, provider);
        }
        String[] addresses = new String[]{emailaddress};
        this.emailaddresses = addresses;
        if (debug != null) {
            debug.exit(16384L, className, "EmailAddress");
        }
    }

    public EmailAddress(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "EmailAddress", filename, new Boolean(base64));
            debug.exit(16384L, className, "EmailAddress");
        }
    }

    public EmailAddress(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "EmailAddress", parms);
            debug.exit(16384L, className, "EmailAddress");
        }
    }

    public EmailAddress(String[] emailaddresses) {
        this.emailaddresses = emailaddresses;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "EmailAddress", emailaddresses);
            debug.exit(16384L, className, "EmailAddress");
        }
    }

    public EmailAddress(String[] emailaddresses, String provider) {
        super(provider);
        this.emailaddresses = emailaddresses;
        if (debug != null) {
            debug.entry(16384L, className, "EmailAddress", emailaddresses, provider);
            debug.exit(16384L, className, "EmailAddress");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            EmailAddress result = new EmailAddress(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e2);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", obj);
        }
        if (obj == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        if (obj instanceof EmailAddress) {
            boolean result = this.equals((EmailAddress)obj);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(result));
            }
            return result;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(false));
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e2) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    @Override
    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.entry(16384L, (Object)className, "getObjectIdentifier", PKCSOID.EMAIL_ADDRESS_OID);
        }
        return PKCSOID.EMAIL_ADDRESS_OID;
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        if (this.emailaddresses == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Email addresseses not specified.");
            }
            throw new IOException("Email addresseses not specified.");
        }
        DerOutputStream tmpout = new DerOutputStream();
        tmpout.putOID(this.getObjectIdentifier());
        DerEncoder[] temps = new DerOutputStream[this.emailaddresses.length];
        for (int i2 = 0; i2 < this.emailaddresses.length; ++i2) {
            temps[i2] = new DerOutputStream();
            ((DerOutputStream)temps[i2]).putIA5String(this.emailaddresses[i2]);
        }
        tmpout.putOrderedSetOf((byte)49, temps);
        DerOutputStream tmpout3 = new DerOutputStream();
        tmpout3.write((byte)48, tmpout.toByteArray());
        os.write(tmpout3.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public String[] getEmailAddresses() {
        if (debug != null) {
            debug.entry(16384L, className, "getEmailAddresses");
            debug.exit(16384L, (Object)className, "getEmailAddresses", this.emailaddresses.clone());
        }
        return (String[])this.emailaddresses.clone();
    }

    @Override
    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", this.getEmailAddresses());
        }
        return this.getEmailAddresses();
    }

    @Override
    public boolean isTagValid(byte tag) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isTagValid", new Byte(tag));
        }
        if (tag == 22) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isTagValid", new Boolean(true));
            }
            return true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isTagValid", new Boolean(false));
        }
        return false;
    }

    @Override
    public boolean isSingleValued() {
        if (debug != null) {
            debug.entry(16384L, className, "isSingleValued");
            debug.exit(16384L, (Object)className, "isSingleValued", new Boolean(false));
        }
        return false;
    }

    @Override
    public String getAttributeName() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributeName");
            debug.exit(16384L, (Object)className, "getAttributeName", "EmailAddress");
        }
        return "EmailAddress";
    }

    @Override
    public String toString() {
        int len = this.emailaddresses.length;
        String out = "PKCS9 EmailAddress:";
        for (int i2 = 0; i2 < len; ++i2) {
            out = out + " \"" + this.emailaddresses[i2] + "\"";
            if (i2 == len - 1) continue;
            out = out + ",";
        }
        out = out + "\r\n";
        return out;
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        super.decode(encoding);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        DerValue[] elems = null;
        if (encoding.getTag() == 48) {
            DerInputStream derIn = new DerInputStream(encoding.toByteArray());
            DerValue[] val = derIn.getSequence(2);
            elems = new DerInputStream(val[1].toByteArray()).getSet(1);
        } else {
            elems = new DerInputStream(encoding.toByteArray()).getSet(1);
        }
        this.emailaddresses = new String[elems.length];
        for (int i2 = 0; i2 < elems.length; ++i2) {
            this.emailaddresses[i2] = elems[i2].getAsString();
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(EmailAddress other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", other);
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            other.encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }
}

