/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.crypto.provider.PBMParameterSpec;
import com.ibm.security.cmp.PKIBody;
import com.ibm.security.cmp.PKIBodyInterface;
import com.ibm.security.cmp.PKIBodyv2;
import com.ibm.security.cmp.PKIHeader;
import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidParameterSpecException;
import java.util.Vector;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class PKIMessage
extends CMPDerObject {
    private BigInteger version;
    private PKIHeader header;
    private PKIBodyInterface body;
    private byte[] protection;
    private Certificate[] extraCerts;
    private static final String IBMPROVIDER_NAME = "IBMJCE";
    public static final int MESSAGE_BODY_IR = 0;
    public static final int MESSAGE_BODY_IP = 1;
    public static final int MESSAGE_BODY_CR = 2;
    public static final int MESSAGE_BODY_CP = 3;
    public static final int MESSAGE_BODY_P10CR = 4;
    public static final int MESSAGE_BODY_POPDECC = 5;
    public static final int MESSAGE_BODY_POPDECR = 6;
    public static final int MESSAGE_BODY_KUR = 7;
    public static final int MESSAGE_BODY_KUP = 8;
    public static final int MESSAGE_BODY_KRR = 9;
    public static final int MESSAGE_BODY_KRP = 10;
    public static final int MESSAGE_BODY_RR = 11;
    public static final int MESSAGE_BODY_RP = 12;
    public static final int MESSAGE_BODY_CCR = 13;
    public static final int MESSAGE_BODY_CCP = 14;
    public static final int MESSAGE_BODY_CKUANN = 15;
    public static final int MESSAGE_BODY_CANN = 16;
    public static final int MESSAGE_BODY_RANN = 17;
    public static final int MESSAGE_BODY_CRLANN = 18;
    public static final int MESSAGE_BODY_CONF = 19;
    public static final int MESSAGE_BODY_NESTED = 20;
    public static final int MESSAGE_BODY_GENM = 21;
    public static final int MESSAGE_BODY_GENP = 22;
    public static final int MESSAGE_BODY_ERROR = 23;
    public static final int MESSAGE_BODY_CERTCONF = 24;
    private static final byte TAG_PROTECTION = 0;
    private static final byte TAG_EXTRA_CERTS = 1;
    static /* synthetic */ Class class$com$ibm$crypto$provider$PBMParameterSpec;

    public PKIMessage(PKIHeader pKIHeader, int n2, Object object, byte[] byArray, Certificate[] certificateArray) {
        if (pKIHeader == null) {
            throw new IllegalArgumentException("PKIMessage error, header not specified");
        }
        this.header = pKIHeader;
        this.version = pKIHeader.getPvno();
        if (this.version.compareTo(BigInteger.valueOf(1L)) == 0) {
            this.body = new PKIBody(n2, object);
        } else if (this.version.compareTo(BigInteger.valueOf(2L)) == 0) {
            this.body = new PKIBodyv2(n2, object);
        }
        this.protection = byArray;
        this.extraCerts = certificateArray;
    }

    public PKIMessage(byte[] byArray) throws IOException {
        super(byArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            return new PKIMessage(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void decode(DerValue var1_1) throws IOException {
        block14: {
            block13: {
                if (var1_1.getTag() != 48) {
                    throw new IOException("PKIMessage parsing error, not a SEQUENCE");
                }
                this.header = null;
                this.body = null;
                this.protection = null;
                this.extraCerts = null;
                this.header = new PKIHeader(var1_1.getData().getDerValue().toByteArray());
                this.version = this.header.getPvno();
                try {
                    this.body = this.version.equals(BigInteger.valueOf(1L)) ? new PKIBody(var1_1.getData().getDerValue().toByteArray()) : (this.version.equals(BigInteger.valueOf(2L)) ? new PKIBodyv2(var1_1.getData().getDerValue().toByteArray()) : null);
                }
                catch (IllegalArgumentException var2_2) {
                    throw new IOException(var2_2.toString());
                }
                if (var1_1.getData().available() == 0) {
                    return;
                }
                var2_3 = var1_1.getData().getDerValue();
                if (var2_3.isContextSpecific((byte)0) && var2_3.isConstructed()) {
                    this.protection = var2_3.getData().getDerValue().getBitString();
                    if (var1_1.getData().available() != 0) {
                        var2_3 = var1_1.getData().getDerValue();
                    } else {
                        return;
                    }
                }
                if (!var2_3.isContextSpecific((byte)1) || !var2_3.isConstructed()) break block13;
                var3_4 = var2_3.getData().getDerValue();
                var4_5 = new Vector<X509CertImpl>();
                if (var3_4.getTag() == 48) ** GOTO lbl36
                throw new IOException("CertReqMsg sequence parsing error, not a SEQUENCE OF");
lbl-1000:
                // 1 sources

                {
                    var5_6 = var3_4.getData().getDerValue();
                    try {
                        var6_8 = new X509CertImpl(var5_6);
                        var4_5.add(var6_8);
                        continue;
                    }
                    catch (CertificateException v0) {
                        throw new IOException("Invalid certificate encoding");
                    }
lbl36:
                    // 2 sources

                    ** while (var3_4.getData().available() != 0)
                }
lbl37:
                // 1 sources

                if (var4_5.size() > 0) {
                    this.extraCerts = new X509CertImpl[var4_5.size()];
                    var5_7 = 0;
                    while (var5_7 < var4_5.size()) {
                        this.extraCerts[var5_7] = (X509CertImpl)var4_5.elementAt(var5_7);
                        ++var5_7;
                    }
                }
                break block14;
            }
            throw new IOException("PKIMessage parsing error, data overrun");
        }
        if (var1_1.getData().available() != 0) {
            throw new IOException("PKIMessage parsing error, data overrun");
        }
    }

    private void dhBasedMac(AlgorithmId algorithmId, byte[] byArray, byte[] byArray2) {
        this.protection = null;
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream;
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.header == null) {
            throw new IOException("PKIMessage encoding error, header not specified");
        }
        this.header.encode(derOutputStream2);
        if (this.body == null) {
            throw new IOException("PKIMessage encoding error, body not specified");
        }
        this.body.encode(derOutputStream2);
        if (this.protection != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putBitString(this.protection);
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream);
        }
        if (this.extraCerts != null) {
            derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream4 = new DerOutputStream();
            int n2 = 0;
            while (n2 < this.extraCerts.length) {
                try {
                    if (!(this.extraCerts[n2] instanceof X509Certificate)) {
                        throw new IOException("extraCerts[" + n2 + "] has a type of " + this.extraCerts[n2].getClass().getName() + ". Only instances of java.secuirty.cert.X509Certificate are supported.");
                    }
                    derOutputStream.write(((X509Certificate)this.extraCerts[n2]).getEncoded());
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw new IOException("PKIMessage encoding error, " + certificateEncodingException);
                }
                ++n2;
            }
            derOutputStream4.write((byte)48, derOutputStream);
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream4);
        }
        derOutputStream3.write((byte)48, derOutputStream2);
        outputStream.write(derOutputStream3.toByteArray());
    }

    public boolean equals(PKIMessage pKIMessage) {
        DerValue derValue;
        DerValue derValue2;
        if (pKIMessage == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            pKIMessage.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof PKIMessage) {
            return this.equals((PKIMessage)object);
        }
        return false;
    }

    public Object getBody() {
        if (this.body == null) {
            return null;
        }
        return this.body.getBody();
    }

    public int getBodyType() {
        if (this.body == null) {
            return -1;
        }
        return this.body.getBodyType();
    }

    public byte[] getEncodedBody() {
        if (this.body == null) {
            return null;
        }
        return this.body.getEncodedBody();
    }

    public PKIHeader getHeader() {
        return (PKIHeader)this.header.clone();
    }

    public byte[] getProtection() {
        if (this.protection == null) {
            return null;
        }
        return (byte[])this.protection.clone();
    }

    public int getVersion() {
        return this.version.intValue();
    }

    private byte[] passwordBasedMac(AlgorithmId algorithmId, byte[] byArray, byte[] byArray2) throws IOException, NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameters algorithmParameters = algorithmId.getAlgParameters();
        if (algorithmParameters == null) {
            throw new IllegalArgumentException("PKIMessage error, parameters not specified");
        }
        Object var5_5 = null;
        try {
            var5_5 = algorithmParameters.getParameterSpec(class$com$ibm$crypto$provider$PBMParameterSpec != null ? class$com$ibm$crypto$provider$PBMParameterSpec : (class$com$ibm$crypto$provider$PBMParameterSpec = PKIMessage.class$("com.ibm.crypto.provider.PBMParameterSpec")));
            if (!(var5_5 instanceof PBMParameterSpec)) {
                throw new InvalidParameterSpecException();
            }
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new IllegalArgumentException("PKIMessage error, invalid parameter spec");
        }
        Mac mac = Mac.getInstance("PBM");
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "PBM");
        mac.init(secretKeySpec, var5_5);
        return mac.doFinal(byArray2);
    }

    public PKIMessage protect(byte[] byArray) throws Exception {
        if (this.body == null) {
            return null;
        }
        PKIMessage pKIMessage = (PKIMessage)this.clone();
        AlgorithmId algorithmId = this.header.getProtectionAlg();
        String string = algorithmId.getName();
        ObjectIdentifier objectIdentifier = algorithmId.getOID();
        if (!objectIdentifier.equals(AlgorithmId.PasswordBasedMac_oid)) {
            throw new IllegalArgumentException("Unsupported protection algorithm, " + string + " with OID, " + objectIdentifier);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.header.encode(derOutputStream);
        this.body.encode(derOutputStream);
        derOutputStream2.write((byte)48, derOutputStream);
        byte[] byArray2 = derOutputStream2.toByteArray();
        if (objectIdentifier.equals(AlgorithmId.PasswordBasedMac_oid)) {
            byte[] byArray3 = this.passwordBasedMac(algorithmId, byArray, byArray2);
            pKIMessage.protection = byArray3;
        }
        return pKIMessage;
    }

    private void signingAlg(AlgorithmId algorithmId, byte[] byArray, byte[] byArray2) throws IOException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        ObjectIdentifier objectIdentifier = algorithmId.getOID();
        String string = algorithmId.getName();
        Object var6_6 = null;
        PrivateKey privateKey = null;
        if (!(objectIdentifier.equals(AlgorithmId.md5WithRSAEncryption_oid) || objectIdentifier.equals(AlgorithmId.md2WithRSAEncryption_oid) || objectIdentifier.equals(AlgorithmId.sha1WithRSAEncryption_oid))) {
            objectIdentifier.equals(AlgorithmId.sha1WithDSA_oid);
        }
        Signature signature = Signature.getInstance(string);
        signature.initSign(privateKey);
        signature.update(byArray2);
        this.protection = signature.sign();
    }

    public String toString() {
        String string = "PKIMessage:";
        if (this.header != null) {
            string = String.valueOf(string) + "\r\n\tHeader: " + this.header.toString();
        }
        if (this.body != null) {
            string = String.valueOf(string) + "\r\n\tBody: " + this.body.toString();
        }
        string = this.protection != null ? String.valueOf(string) + "\r\n\tProtection: exists." : String.valueOf(string) + "\r\n\tNo Protection.";
        if (this.extraCerts != null) {
            string = String.valueOf(string) + "\r\n\tExtra Certs ";
            int n2 = 0;
            while (n2 < this.extraCerts.length) {
                string = String.valueOf(string) + "\r\n\t\tCert[" + n2 + "]: " + this.extraCerts[n2];
                ++n2;
            }
        }
        return string;
    }

    public boolean verify(AlgorithmId algorithmId, byte[] byArray) throws IOException, NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        return this.verify(byArray);
    }

    public boolean verify(byte[] byArray) throws IOException, NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.body == null) {
            return false;
        }
        if (this.protection == null) {
            throw new IOException("PKIMessage verify error, protection bits not specified");
        }
        AlgorithmId algorithmId = this.header.getProtectionAlg();
        String string = algorithmId.getName();
        ObjectIdentifier objectIdentifier = algorithmId.getOID();
        if (!objectIdentifier.equals(AlgorithmId.PasswordBasedMac_oid)) {
            throw new IllegalArgumentException("Unsupported protection algorithm, " + string);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.header.encode(derOutputStream);
        this.body.encode(derOutputStream);
        derOutputStream2.write((byte)48, derOutputStream);
        byte[] byArray2 = derOutputStream2.toByteArray();
        if (objectIdentifier.equals(AlgorithmId.PasswordBasedMac_oid)) {
            byte[] byArray3 = this.passwordBasedMac(algorithmId, byArray, byArray2);
            if (byArray3.length != this.protection.length) {
                return false;
            }
            String string2 = new String(byArray3);
            return string2.equals(new String(this.protection));
        }
        return false;
    }
}

