/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.http.channel.values;

import com.ibm.wsspi.genericbnf.GenericKeys;
import com.ibm.wsspi.genericbnf.KeyMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class TransferEncodingValues
extends GenericKeys {
    private static final AtomicInteger NEXT_ORDINAL = new AtomicInteger(0);
    private static final List<TransferEncodingValues> allKeys = new ArrayList<TransferEncodingValues>();
    private static final KeyMatcher myMatcher = new KeyMatcher(false);
    public static final TransferEncodingValues UNDEF = new TransferEncodingValues("Undefined");
    public static final TransferEncodingValues NOTSET = new TransferEncodingValues("Not-Set");
    public static final TransferEncodingValues GZIP = new TransferEncodingValues("gzip");
    public static final TransferEncodingValues XGZIP = new TransferEncodingValues("x-gzip");
    public static final TransferEncodingValues COMPRESS = new TransferEncodingValues("compress");
    public static final TransferEncodingValues XCOMPRESS = new TransferEncodingValues("x-compress");
    public static final TransferEncodingValues DEFLATE = new TransferEncodingValues("deflate");
    public static final TransferEncodingValues IDENTITY = new TransferEncodingValues("identity");
    public static final TransferEncodingValues CHUNKED = new TransferEncodingValues("chunked");
    private boolean undefined = false;

    public TransferEncodingValues(String name) {
        super(name, NEXT_ORDINAL.getAndIncrement());
        allKeys.add(this);
        myMatcher.add(this);
    }

    public boolean isUndefined() {
        return this.undefined;
    }

    public static TransferEncodingValues getByOrdinal(int i) {
        return allKeys.get(i);
    }

    @Override
    public int compareTo(TransferEncodingValues val) {
        return null == val ? -1 : this.getOrdinal() - val.getOrdinal();
    }

    public static TransferEncodingValues match(String name, int offset, int length) {
        if (null == name) {
            return null;
        }
        return (TransferEncodingValues)myMatcher.match(name, offset, length);
    }

    public static TransferEncodingValues match(byte[] name, int offset, int length) {
        if (null == name) {
            return null;
        }
        return (TransferEncodingValues)myMatcher.match(name, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TransferEncodingValues find(byte[] name, int offset, int length) {
        TransferEncodingValues key = (TransferEncodingValues)myMatcher.match(name, offset, length);
        if (null != key) return key;
        Class<TransferEncodingValues> clazz = TransferEncodingValues.class;
        synchronized (TransferEncodingValues.class) {
            key = (TransferEncodingValues)myMatcher.match(name, offset, length);
            if (null != key) return key;
            key = new TransferEncodingValues(new String(name, offset, length));
            key.undefined = true;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TransferEncodingValues find(String name) {
        TransferEncodingValues key = (TransferEncodingValues)myMatcher.match(name, 0, name.length());
        if (null != key) return key;
        Class<TransferEncodingValues> clazz = TransferEncodingValues.class;
        synchronized (TransferEncodingValues.class) {
            key = (TransferEncodingValues)myMatcher.match(name, 0, name.length());
            if (null != key) return key;
            key = new TransferEncodingValues(name);
            key.undefined = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return key;
        }
    }

    public static TransferEncodingValues find(byte[] name) {
        return TransferEncodingValues.find(name, 0, name.length);
    }
}

