/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.genericbnf.internal.GenericUtils;
import com.ibm.ws.http.internal.HttpLocalFormat;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.http.HttpDateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class HttpDateFormatImpl
implements HttpDateFormat {
    private static final TraceComponent tc = Tr.register(HttpDateFormatImpl.class);
    private static final ThreadLocal<HttpLocalFormat> threadStorage = new ThreadLocal();
    static final long serialVersionUID = -7337461677975335439L;

    public static HttpDateFormat getInstance() {
        return HttpDateFormatHolder.dateFormatSvc;
    }

    private HttpLocalFormat getFormat() {
        HttpLocalFormat format = threadStorage.get();
        if (null == format) {
            format = new HttpLocalFormat();
            threadStorage.set(format);
        }
        return format;
    }

    @Override
    public byte[] getRFC1123TimeAsBytes() {
        return this.getFormat().get1123TimeAsBytes(0L);
    }

    @Override
    public byte[] getRFC1123TimeAsBytes(long range) {
        return this.getFormat().get1123TimeAsBytes(range);
    }

    @Override
    public String getRFC1123Time() {
        return this.getFormat().get1123TimeAsString(0L);
    }

    @Override
    public String getRFC1123Time(long range) {
        return this.getFormat().get1123TimeAsString(range);
    }

    @Override
    public String getRFC1123Time(Date inDate) {
        return this.getFormat().get1123Format().format(inDate);
    }

    @Override
    public byte[] getRFC1036TimeAsBytes() {
        return this.getFormat().get1036TimeAsBytes(0L);
    }

    @Override
    public byte[] getRFC1036TimeAsBytes(long range) {
        return this.getFormat().get1036TimeAsBytes(range);
    }

    @Override
    public String getRFC1036Time() {
        return this.getFormat().get1036TimeAsString(0L);
    }

    @Override
    public String getRFC1036Time(long range) {
        return this.getFormat().get1036TimeAsString(range);
    }

    @Override
    public String getRFC1036Time(Date inDate) {
        return this.getFormat().get1036Format().format(inDate);
    }

    @Override
    public byte[] getRFC2109TimeAsBytes() {
        return this.getFormat().get2109TimeAsBytes(0L);
    }

    @Override
    public byte[] getRFC2109TimeAsBytes(long range) {
        return this.getFormat().get2109TimeAsBytes(range);
    }

    @Override
    public String getRFC2109Time() {
        return this.getFormat().get2109TimeAsString(0L);
    }

    @Override
    public String getRFC2109Time(long range) {
        return this.getFormat().get2109TimeAsString(range);
    }

    @Override
    public String getRFC2109Time(Date inDate) {
        return this.getFormat().get2109Format().format(inDate);
    }

    @Override
    public byte[] getASCIITimeAsBytes() {
        return this.getFormat().getAsciiTimeAsBytes(0L);
    }

    @Override
    public byte[] getASCIITimeAsBytes(long range) {
        return this.getFormat().getAsciiTimeAsBytes(range);
    }

    @Override
    public String getASCIITime() {
        return this.getFormat().getAsciiTimeAsString(0L);
    }

    @Override
    public String getASCIITime(long range) {
        return this.getFormat().getAsciiTimeAsString(range);
    }

    @Override
    public String getASCIITime(Date inDate) {
        return this.getFormat().getAsciiFormat().format(inDate);
    }

    @Override
    public byte[] getNCSATimeAsBytes() {
        return this.getFormat().getNCSATimeAsBytes(0L);
    }

    @Override
    public byte[] getNCSATimeAsBytes(long range) {
        return this.getFormat().getNCSATimeAsBytes(range);
    }

    @Override
    public String getNCSATime() {
        return this.getFormat().getNCSATimeAsString(0L);
    }

    @Override
    public String getNCSATime(long range) {
        return this.getFormat().getNCSATimeAsString(range);
    }

    @Override
    public String getNCSATime(Date inDate) {
        return this.getFormat().getNCSAFormat().format(inDate);
    }

    private Date attemptParse(SimpleDateFormat format, String input) {
        ParsePosition pos = new ParsePosition(0);
        Date d = format.parse(input, pos);
        if (0 == pos.getIndex() || pos.getIndex() != input.length()) {
            return null;
        }
        return d;
    }

    @Override
    public Date parseRFC1123Time(String input) throws ParseException {
        Date d;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("rfc1123 parsing [" + input + "]"), (Object[])new Object[0]);
        }
        if (null == (d = this.attemptParse(this.getFormat().get1123Parse(), input))) {
            throw new ParseException("Unparseable [" + input + "]", 0);
        }
        return d;
    }

    @Override
    public Date parseRFC1036Time(String input) throws ParseException {
        Date d;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("rfc1036 parsing [" + input + "]"), (Object[])new Object[0]);
        }
        if (null == (d = this.attemptParse(this.getFormat().get1036Parse(), input))) {
            throw new ParseException("Unparseable [" + input + "]", 0);
        }
        return d;
    }

    @Override
    public Date parseRFC2109Time(String input) throws ParseException {
        Date d;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("rfc2109 parsing [" + input + "]"), (Object[])new Object[0]);
        }
        if (null == (d = this.attemptParse(this.getFormat().get2109Parse(), input))) {
            throw new ParseException("Unparseable [" + input + "]", 0);
        }
        return d;
    }

    @Override
    public Date parseASCIITime(String input) throws ParseException {
        Date d;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ascii parsing [" + input + "]"), (Object[])new Object[0]);
        }
        if (null == (d = this.attemptParse(this.getFormat().getAsciiParse(), input))) {
            throw new ParseException("Unparseable [" + input + "]", 0);
        }
        return d;
    }

    @Override
    public Date parseTime(String input) throws ParseException {
        Date parsedDate;
        String data;
        int i;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("parseTime parsing [" + input + "]"), (Object[])new Object[0]);
        }
        if (-1 != (i = (data = input).indexOf(59, 0))) {
            char c;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Ignoring excess data following semi-colon in date", (Object[])new Object[0]);
            }
            while (i > 20 && (' ' == (c = data.charAt(i - 1)) || '\t' == c)) {
                --i;
            }
            if (20 >= i) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Not enough data left to make a valid date", (Object[])new Object[0]);
                }
                throw new ParseException("Invalid date [" + input + "]", 0);
            }
            data = input.substring(0, i);
        }
        if (null == (parsedDate = this.attemptParse(this.getFormat().get1123Parse(), data)) && null == (parsedDate = this.attemptParse(this.getFormat().get1036Parse(), data)) && null == (parsedDate = this.attemptParse(this.getFormat().getAsciiParse(), data)) && null == (parsedDate = this.attemptParse(this.getFormat().get2109Parse(), data))) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Time does not match supported formats", (Object[])new Object[0]);
            }
            throw new ParseException("Unparseable [" + data + "]", 0);
        }
        return parsedDate;
    }

    @Override
    public Date parseTime(byte[] inBytes) throws ParseException {
        return this.parseTime(GenericUtils.getEnglishString(inBytes));
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class HttpDateFormatHolder {
        private static HttpDateFormat dateFormatSvc;
        static final long serialVersionUID = -7121337060516268311L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private HttpDateFormatHolder() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(HttpDateFormatHolder.class);
            dateFormatSvc = new HttpDateFormatImpl();
        }
    }
}

