/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.values;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.genericbnf.internal.GenericUtils;
import com.ibm.ws.http.channel.internal.values.CookieData;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.HttpCookie;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import java.text.ParseException;
import java.util.Date;

public class CookieExpiresData
extends CookieData {
    private static final TraceComponent tc = Tr.register(CookieExpiresData.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");

    public CookieExpiresData() {
        super("expires");
    }

    @Override
    public boolean set(HttpCookie cookie, byte[] attribValue) {
        if (null == cookie || null == attribValue || 0 == attribValue.length) {
            return false;
        }
        try {
            Date expiryDate = HttpDispatcher.getDateFormatter().parseTime(attribValue);
            long remainingTime = expiryDate.getTime() - HttpDispatcher.getApproxTime();
            if (-1L < remainingTime) {
                cookie.setMaxAge((int)(remainingTime / 1000L));
            } else {
                cookie.setMaxAge(0);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Expires/max-age set to " + cookie.getMaxAge()), (Object[])new Object[0]);
            }
            return true;
        }
        catch (ParseException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Error parsing expires date: " + GenericUtils.getEnglishString(attribValue)), (Object[])new Object[0]);
            }
            return false;
        }
    }

    @Override
    public boolean validForHeader(HeaderKeys hdr, boolean includesDollar) {
        if (HttpHeaderKeys.HDR_SET_COOKIE.equals(hdr) || HttpHeaderKeys.HDR_SET_COOKIE2.equals(hdr)) {
            return !includesDollar;
        }
        return false;
    }
}

