/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.cookies;

import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.wsspi.http.HttpCookie;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CookieCacheData
implements FFDCSelfIntrospectable {
    private List<HttpCookie> parsedList = null;
    private int hdrIndex = 0;
    private HttpHeaderKeys headerType;
    private boolean isDirty = false;

    private CookieCacheData() {
    }

    public CookieCacheData(HttpHeaderKeys header) {
        this.headerType = header;
        this.parsedList = new LinkedList<HttpCookie>();
    }

    public HttpHeaderKeys getHeaderType() {
        return this.headerType;
    }

    public int getHeaderIndex() {
        return this.hdrIndex;
    }

    public void incrementHeaderIndex() {
        ++this.hdrIndex;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setIsDirty(boolean flag) {
        this.isDirty = flag;
    }

    public HttpCookie getCookie(String name) {
        if (null == name || 0 == this.parsedList.size()) {
            return null;
        }
        for (HttpCookie cookie : this.parsedList) {
            if (!cookie.getName().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    public int getAllCookies(String name, List<HttpCookie> list) {
        int added = 0;
        if (0 < this.parsedList.size() && null != name) {
            for (HttpCookie cookie : this.parsedList) {
                if (!cookie.getName().equals(name)) continue;
                list.add(cookie.clone());
                ++added;
            }
        }
        return added;
    }

    public int getAllCookies(List<HttpCookie> list) {
        int added = 0;
        if (0 < this.parsedList.size()) {
            for (HttpCookie cookie : this.parsedList) {
                list.add(cookie.clone());
                ++added;
            }
        }
        return added;
    }

    public int getAllCookieValues(String name, List<String> list) {
        int added = 0;
        if (0 < this.parsedList.size() && null != name) {
            for (HttpCookie cookie : this.parsedList) {
                if (!name.equals(cookie.getName())) continue;
                list.add(cookie.getValue());
            }
        }
        return added;
    }

    public List<HttpCookie> getParsedList() {
        return this.parsedList;
    }

    public void addParsedCookie(HttpCookie cookie) {
        this.parsedList.add(cookie);
    }

    public void addParsedCookies(List<HttpCookie> list) {
        this.parsedList.addAll(list);
    }

    public void addNewCookie(HttpCookie cookie) {
        this.isDirty = true;
        this.parsedList.add(cookie);
    }

    public void addNewCookies(List<HttpCookie> list) {
        this.isDirty = true;
        this.parsedList.addAll(list);
    }

    public boolean removeCookie(HttpCookie cookie) {
        this.isDirty = true;
        return this.parsedList.remove(cookie);
    }

    public CookieCacheData duplicate() {
        CookieCacheData cData = new CookieCacheData();
        cData.parsedList = this.copyList(this.parsedList);
        cData.isDirty = this.isDirty;
        cData.hdrIndex = this.hdrIndex;
        cData.headerType = this.headerType;
        return cData;
    }

    private List<HttpCookie> copyList(List<HttpCookie> originalList) {
        LinkedList<HttpCookie> list = new LinkedList<HttpCookie>();
        Iterator<HttpCookie> it = originalList.iterator();
        while (it.hasNext()) {
            list.add(it.next().clone());
        }
        return list;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("headerType=").append(this.headerType.getName());
        sb.append("headerIndex=").append(this.hdrIndex);
        sb.append("isDirty =").append(this.isDirty);
        for (HttpCookie cookie : this.parsedList) {
            sb.append(" [").append(cookie.getName());
            sb.append("]=[").append(cookie.getValue());
            sb.append(" Path=").append(cookie.getPath());
            sb.append(" Version=").append(cookie.getVersion());
            sb.append(" Domain=").append(cookie.getDomain());
            sb.append(" Max-Age=").append(cookie.getMaxAge());
            sb.append(" Comment=").append(cookie.getComment());
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public String[] introspectSelf() {
        return new String[]{this.toString()};
    }
}

