/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.internal.GenericUtils;
import com.ibm.ws.genericbnf.internal.HeaderElement;
import com.ibm.ws.genericbnf.internal.TokenCodes;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import com.ibm.wsspi.genericbnf.BNFHeaders;
import com.ibm.wsspi.genericbnf.HeaderField;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.exception.MalformedMessageException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class BNFHeadersImpl
implements BNFHeaders,
Externalizable {
    private static final TraceComponent tc = Tr.register(BNFHeadersImpl.class, (String)"GenericBNF", null);
    private static final long serialVersionUID = -4154557451251031540L;
    protected static final int SERIALIZATION_V1 = -1091633151;
    protected static final int SERIALIZATION_V2 = -1091633150;
    private static final int PARSING_HEADER = 0;
    private static final int PARSING_VALUE = 1;
    private static final int PARSING_CRLF = 2;
    private static final int DEFAULT_BUFFERSIZE = 1024;
    private static final int DEFAULT_CACHESIZE = 512;
    private static final int DEFAULT_LIMIT_TOKENSIZE = 16384;
    private static final int DEFAULT_LIMIT_NUMHEADERS = 500;
    private static final int BUFFERS_INITIAL_SIZE = 2;
    private static final int BUFFERS_MIN_GROWTH = 5;
    private static final boolean FILTER_YES = true;
    private static final boolean FILTER_NO = false;
    protected static final int LOG_FULL = 0;
    protected static final int LOG_NONE = 1;
    protected static final int LOG_PARTIAL = 2;
    private static byte[] whitespace = null;
    private static final HeaderField NULL_HEADER = new EmptyHeaderField();
    private transient HeaderElement[] storage = new HeaderElement[100];
    private transient HeaderElement hdrSequence = null;
    private transient HeaderElement lastHdrInSequence = null;
    private transient HeaderElement headerElements = null;
    private transient WsByteBuffer[] parseBuffers = null;
    private transient int[] parseBuffersStartPos = null;
    private transient int parseIndex = -1;
    private transient WsByteBuffer[] myCreatedBuffers = null;
    private transient int createdIndex = -1;
    private transient int numberOfHeaders = 0;
    private transient boolean bHeaderValidation = true;
    private static transient boolean bCharacterValidation = true;
    private transient int lastCRLFBufferIndex = -1;
    private transient int lastCRLFPosition = -1;
    private transient boolean lastCRLFisCR = false;
    private transient int headerChangeLimit = -1;
    private transient int headerChangeCount = 0;
    private transient int headerAddCount = 0;
    private transient boolean bOverChangeLimit = false;
    private transient int limitTokenSize = 16384;
    private transient int limitNumHeaders = 500;
    private transient int eohPosition = -1;
    private transient WsByteBuffer currentReadBB = null;
    private transient boolean useDirectBuffer = true;
    private transient int outgoingHdrBufferSize = 1024;
    private transient int incomingBufferSize = 1024;
    private transient int byteCacheSize = 512;
    private transient byte[] parsedToken = null;
    private transient int parsedTokenLength = 0;
    private transient byte[] byteCache = new byte[this.byteCacheSize];
    private transient int bytePosition = 0;
    private transient int byteLimit = 0;
    private transient int stateOfParsing = 2;
    private transient int binaryParsingState = 1;
    private transient HeaderElement currentElem = null;
    private transient boolean bIsMultiLine = false;
    private transient int numCRLFs = 0;
    private transient Object debugContext = this;
    private transient boolean compactHeaderFlag = false;
    private transient int deserializationVersion = -1091633151;
    private boolean foundTrailingWhitespace = false;

    protected void init(boolean useDirect, int outSize, int inSize, int cacheSize) {
        this.useDirectBuffer = useDirect;
        this.outgoingHdrBufferSize = outSize;
        this.incomingBufferSize = inSize;
        if (cacheSize > this.byteCacheSize) {
            this.byteCacheSize = cacheSize;
            this.byteCache = new byte[cacheSize];
        }
    }

    public void addParseBuffer(WsByteBuffer buffer) {
        int index = ++this.parseIndex;
        if (null == this.parseBuffers) {
            this.parseBuffers = new WsByteBuffer[2];
            this.parseBuffersStartPos = new int[2];
            for (int i = 0; i < 2; ++i) {
                this.parseBuffersStartPos[i] = -1;
            }
        } else if (index == this.parseBuffers.length) {
            int size = index + 5;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Increasing parse buffer array size to " + size), (Object[])new Object[0]);
            }
            WsByteBuffer[] tempNew = new WsByteBuffer[size];
            System.arraycopy(this.parseBuffers, 0, tempNew, 0, index);
            this.parseBuffers = tempNew;
            int[] posNew = new int[size];
            System.arraycopy(this.parseBuffersStartPos, 0, posNew, 0, index);
            for (int i = index; i < size; ++i) {
                posNew[i] = -1;
            }
            this.parseBuffersStartPos = posNew;
        }
        this.parseBuffers[index] = buffer;
    }

    public void addToCreatedBuffer(WsByteBuffer buffer) {
        int index = ++this.createdIndex;
        if (null == this.myCreatedBuffers) {
            this.myCreatedBuffers = new WsByteBuffer[2];
        } else if (index == this.myCreatedBuffers.length) {
            int size = index + 5;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Increasing created buffer array size to " + size), (Object[])new Object[0]);
            }
            WsByteBuffer[] tempNew = new WsByteBuffer[size];
            System.arraycopy(this.myCreatedBuffers, 0, tempNew, 0, index);
            this.myCreatedBuffers = tempNew;
        }
        this.myCreatedBuffers[index] = buffer;
    }

    @Override
    public void appendHeader(String header, byte[] value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("appendHeader(s,b): " + header), (Object[])new Object[0]);
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, 0, value.length);
        }
        HeaderElement elem = this.getElement(this.findKey(header));
        elem.setByteArrayValue(value);
        this.addHeader(elem, true);
    }

    @Override
    public void appendHeader(String header, byte[] value, int offset, int length) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("appendHeader(s,b,i,i): " + header), (Object[])new Object[0]);
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, offset, length);
        }
        HeaderElement elem = this.getElement(this.findKey(header));
        elem.setByteArrayValue(value, offset, length);
        this.addHeader(elem, true);
    }

    @Override
    public void appendHeader(byte[] header, byte[] value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("appendHeader(b,b): " + GenericUtils.getEnglishString(header)), (Object[])new Object[0]);
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, 0, value.length);
        }
        HeaderElement elem = this.getElement(this.findKey(header));
        elem.setByteArrayValue(value);
        this.addHeader(elem, true);
    }

    @Override
    public void appendHeader(byte[] header, byte[] value, int offset, int length) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("appendHeader(b,b,i,i): " + GenericUtils.getEnglishString(header)), (Object[])new Object[0]);
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, offset, length);
        }
        HeaderElement elem = this.getElement(this.findKey(header));
        elem.setByteArrayValue(value, offset, length);
        this.addHeader(elem, true);
    }

    @Override
    public void appendHeader(HeaderKeys key, byte[] value) {
        if (null == key || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("appendHeader(h,b): " + key.getName()), (Object[])new Object[0]);
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, 0, value.length);
        }
        HeaderElement elem = this.getElement(key);
        elem.setByteArrayValue(value);
        this.addHeader(elem, true);
    }

    @Override
    public void appendHeader(HeaderKeys key, byte[] value, int offset, int length) {
        if (null == key || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("appendHeader(h,b,i,i): " + key.getName()), (Object[])new Object[0]);
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, offset, length);
        }
        HeaderElement elem = this.getElement(key);
        elem.setByteArrayValue(value, offset, length);
        this.addHeader(elem, true);
    }

    @Override
    public void appendHeader(String header, String value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided: " + header + " " + value);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("appendHeader(s,s): " + header), (Object[])new Object[0]);
        }
        if (this.bHeaderValidation) {
            if (this.getCharacterValidation().booleanValue()) {
                value = this.getValidatedCharacters(value);
            } else {
                this.checkHeaderValue(value);
            }
        }
        HeaderElement elem = this.getElement(this.findKey(header));
        elem.setStringValue(value);
        this.addHeader(elem, true);
    }

    @Override
    public void appendHeader(byte[] header, String value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("appendHeader(b,s): " + GenericUtils.getEnglishString(header)), (Object[])new Object[0]);
        }
        if (this.bHeaderValidation) {
            if (this.getCharacterValidation().booleanValue()) {
                value = this.getValidatedCharacters(value);
            } else {
                this.checkHeaderValue(value);
            }
        }
        HeaderElement elem = this.getElement(this.findKey(header));
        elem.setStringValue(value);
        this.addHeader(elem, true);
    }

    @Override
    public void appendHeader(HeaderKeys key, String value) {
        if (null == key || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("appendHeader(h,s): " + key.getName()), (Object[])new Object[0]);
        }
        if (this.bHeaderValidation) {
            if (this.getCharacterValidation().booleanValue()) {
                value = this.getValidatedCharacters(value);
            } else {
                this.checkHeaderValue(value);
            }
        }
        HeaderElement elem = this.getElement(key);
        elem.setStringValue(value);
        this.addHeader(elem, true);
    }

    public void clear() {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        if (bTrace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"clear", (Object[])new Object[0]);
        }
        this.clearAllHeaders();
        this.eohPosition = -1;
        this.currentElem = null;
        this.stateOfParsing = 2;
        this.binaryParsingState = 1;
        this.parsedToken = null;
        this.parsedTokenLength = 0;
        this.bytePosition = 0;
        this.byteLimit = 0;
        this.currentReadBB = null;
        this.clearBuffers();
        this.debugContext = this;
        this.numCRLFs = 0;
        this.bIsMultiLine = false;
        this.lastCRLFBufferIndex = -1;
        this.lastCRLFPosition = -1;
        this.lastCRLFisCR = false;
        this.headerChangeCount = 0;
        this.headerAddCount = 0;
        this.bOverChangeLimit = false;
        this.compactHeaderFlag = false;
        if (bTrace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"clear");
        }
    }

    private void clearBuffers() {
        int i;
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        for (i = 0; i <= this.parseIndex; ++i) {
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Removing reference to parse buffer: " + this.parseBuffers[i]), (Object[])new Object[0]);
            }
            this.parseBuffers[i] = null;
            this.parseBuffersStartPos[i] = -1;
        }
        this.parseIndex = -1;
        for (i = 0; i <= this.createdIndex; ++i) {
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Releasing marshall buffer: " + this.myCreatedBuffers[i]), (Object[])new Object[0]);
            }
            this.myCreatedBuffers[i].release();
            this.myCreatedBuffers[i] = null;
        }
        this.createdIndex = -1;
    }

    public void debug() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"*** Begin Header Debug ***", (Object[])new Object[0]);
            HeaderElement elem = this.hdrSequence;
            while (null != elem) {
                Tr.debug((TraceComponent)tc, (String)(elem.getName() + ": " + elem.getDebugValue()), (Object[])new Object[0]);
                elem = elem.nextSequence;
            }
            Tr.debug((TraceComponent)tc, (String)"*** End Header Debug ***", (Object[])new Object[0]);
        }
    }

    protected void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Destroying these headers: " + this), (Object[])new Object[0]);
        }
        if (null != this.hdrSequence || -1 != this.parseIndex) {
            this.clear();
        }
        this.byteCacheSize = 512;
        this.incomingBufferSize = 1024;
        this.outgoingHdrBufferSize = 1024;
        this.useDirectBuffer = true;
        this.limitNumHeaders = 500;
        this.limitTokenSize = 16384;
        this.headerChangeLimit = -1;
    }

    @Override
    public void duplicate(BNFHeaders msg) {
        this.duplicate((BNFHeadersImpl)msg);
    }

    protected void duplicate(BNFHeadersImpl msg) {
        if (null == msg) {
            throw new NullPointerException("Null object passed to duplicate");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Duplicating the headers", (Object[])new Object[0]);
        }
        HeaderElement elem = this.hdrSequence;
        while (null != elem) {
            if (!elem.wasRemoved()) {
                msg.appendHeader(elem.getKey(), elem.asBytes());
            }
            elem = elem.nextSequence;
        }
        msg.init(this.useDirectBuffer, this.outgoingHdrBufferSize, this.incomingBufferSize, this.byteCacheSize);
        msg.setDebugContext(this.debugContext);
        msg.setHeaderValidation(this.bHeaderValidation);
        msg.setLimitOfTokenSize(this.limitTokenSize);
        msg.setLimitOnNumberOfHeaders(this.limitNumHeaders);
    }

    protected int getDeserializationVersion() {
        return this.deserializationVersion;
    }

    protected byte[] readByteArray(ObjectInput input) throws IOException {
        int len = input.readInt();
        if (-1 == len) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"read byte[] found -1 length marker", (Object[])new Object[0]);
            }
            return null;
        }
        byte[] value = new byte[len];
        input.readFully(value);
        return value;
    }

    protected void writeByteArray(ObjectOutput output, byte[] data) throws IOException {
        if (null == data || 0 == data.length) {
            output.writeInt(-1);
        } else {
            output.writeInt(data.length);
            output.write(data);
        }
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        int len = input.readInt();
        if (-1091633150 == len) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Deserializing a V2 object", (Object[])new Object[0]);
            }
            this.deserializationVersion = -1091633150;
            len = input.readInt();
        }
        this.storage = new HeaderElement[len];
        int number = input.readInt();
        if (-1091633150 == this.deserializationVersion) {
            for (int i = 0; i < number; ++i) {
                this.appendHeader(this.readByteArray(input), this.readByteArray(input));
            }
        } else {
            for (int i = 0; i < number; ++i) {
                this.appendHeader((String)input.readObject(), (String)input.readObject());
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        output.writeInt(-1091633150);
        output.writeInt(this.storage.length);
        output.writeInt(this.numberOfHeaders);
        int count = 0;
        HeaderElement elem = this.hdrSequence;
        while (null != elem) {
            if (!elem.wasRemoved()) {
                ++count;
                this.writeByteArray(output, elem.getKey().getByteArray());
                this.writeByteArray(output, elem.asBytes());
            }
            elem = elem.nextSequence;
        }
        if (count != this.numberOfHeaders) {
            throw new IOException("Expected " + this.numberOfHeaders + " headers but wrote " + count);
        }
    }

    public boolean isEOHFound() {
        return -1 != this.eohPosition;
    }

    @Override
    public List<HeaderField> getAllHeaders() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAllHeaders", (Object[])new Object[0]);
        }
        ArrayList<HeaderField> vals = new ArrayList<HeaderField>();
        if (0 != this.numberOfHeaders) {
            HeaderElement elem = this.hdrSequence;
            while (null != elem) {
                if (!elem.wasRemoved()) {
                    vals.add(elem);
                }
                elem = elem.nextSequence;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getAllHeaders: size=" + vals.size()));
        }
        return vals;
    }

    @Override
    public List<String> getAllHeaderNames() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAllHeaderNames", (Object[])new Object[0]);
        }
        ArrayList<String> vals = new ArrayList<String>();
        if (0 != this.numberOfHeaders) {
            HeaderElement elem = this.hdrSequence;
            while (null != elem) {
                if (!elem.wasRemoved() && !vals.contains(elem.getName())) {
                    vals.add(elem.getName());
                }
                elem = elem.nextSequence;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getAllHeaderNames: size=" + vals.size()));
        }
        return vals;
    }

    @Override
    public HeaderField getHeader(HeaderKeys key) {
        if (null == key) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement elem = this.findHeader(key);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeader(h): " + key.getName() + " " + elem), (Object[])new Object[0]);
        }
        if (null == elem) {
            return NULL_HEADER;
        }
        return elem;
    }

    @Override
    public HeaderField getHeader(String header) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement elem = this.findHeader(this.findKey(header));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeader(s): " + header + " " + elem), (Object[])new Object[0]);
        }
        if (null == elem) {
            return NULL_HEADER;
        }
        return elem;
    }

    @Override
    public HeaderField getHeader(byte[] header) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        HeaderElement elem = this.findHeader(key);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeader(b): " + key.getName() + " " + elem), (Object[])new Object[0]);
        }
        if (null == elem) {
            return NULL_HEADER;
        }
        return elem;
    }

    @Override
    public List<HeaderField> getHeaders(byte[] header) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        ArrayList<HeaderField> list = new ArrayList<HeaderField>();
        HeaderKeys key = this.findKey(header);
        HeaderElement elem = this.findHeader(key);
        while (null != elem) {
            if (!elem.wasRemoved()) {
                list.add(elem);
            }
            elem = elem.nextInstance;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaders(b): " + key.getName() + " " + list.size()), (Object[])new Object[0]);
        }
        return list;
    }

    @Override
    public List<HeaderField> getHeaders(HeaderKeys key) {
        if (null == key) {
            throw new IllegalArgumentException("Null input provided");
        }
        ArrayList<HeaderField> list = new ArrayList<HeaderField>();
        HeaderElement elem = this.findHeader(key);
        while (null != elem) {
            if (!elem.wasRemoved()) {
                list.add(elem);
            }
            elem = elem.nextInstance;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaders(h): " + key.getName() + " " + list.size()), (Object[])new Object[0]);
        }
        return list;
    }

    @Override
    public List<HeaderField> getHeaders(String header) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        ArrayList<HeaderField> list = new ArrayList<HeaderField>();
        HeaderElement elem = this.findHeader(this.findKey(header));
        while (null != elem) {
            if (!elem.wasRemoved()) {
                list.add(elem);
            }
            elem = elem.nextInstance;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaders(s): " + header + " " + list.size()), (Object[])new Object[0]);
        }
        return list;
    }

    @Override
    public int getNumberOfHeaderInstances(String header) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.countInstances(this.findHeader(this.findKey(header)));
    }

    @Override
    public int getNumberOfHeaderInstances(byte[] header) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.countInstances(this.findHeader(this.findKey(header)));
    }

    @Override
    public int getNumberOfHeaderInstances(HeaderKeys key) {
        if (null == key) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.countInstances(this.findHeader(key));
    }

    @Override
    public boolean containsHeader(String header) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        return null != this.findHeader(this.findKey(header));
    }

    @Override
    public boolean containsHeader(byte[] header) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        return null != this.findHeader(this.findKey(header));
    }

    @Override
    public boolean containsHeader(HeaderKeys key) {
        if (null == key) {
            throw new IllegalArgumentException("Null input provided");
        }
        return null != this.findHeader(key);
    }

    @Override
    public WsByteBuffer[] marshallBinaryHeaders(WsByteBuffer[] src) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"marshallBinaryHeaders", (Object[])new Object[0]);
        }
        this.preMarshallHeaders();
        WsByteBuffer[] buffers = src;
        if (null == buffers) {
            buffers = new WsByteBuffer[]{this.allocateBuffer(this.outgoingHdrBufferSize)};
            this.bytePosition = 0;
        }
        HeaderElement elem = this.hdrSequence;
        while (null != elem) {
            buffers = this.marshallBinaryHeader(buffers, elem);
            elem = elem.nextSequence;
        }
        buffers = this.putInt(0, buffers);
        buffers = this.flushCache(buffers);
        buffers[buffers.length - 1].flip();
        this.postMarshallHeaders();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"marshallBinaryHeaders");
        }
        return buffers;
    }

    @Override
    public WsByteBuffer[] marshallHeaders(WsByteBuffer[] src) {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        if (bTrace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"marshallHeaders", (Object[])new Object[0]);
        }
        this.preMarshallHeaders();
        WsByteBuffer[] buffers = src;
        if (-1 != this.parseIndex && !this.overHeaderChangeLimit()) {
            buffers = this.marshallReuseHeaders(src);
        } else {
            if (null == buffers) {
                buffers = new WsByteBuffer[]{this.allocateBuffer(this.outgoingHdrBufferSize)};
                this.bytePosition = 0;
            }
            HeaderElement elem = this.hdrSequence;
            while (null != elem) {
                buffers = this.marshallHeader(buffers, elem);
                elem = elem.nextSequence;
            }
            buffers = this.putBytes(BNFHeaders.EOL, buffers);
            buffers = this.flushCache(buffers);
            buffers[buffers.length - 1].flip();
        }
        this.postMarshallHeaders();
        if (bTrace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"marshallHeaders");
        }
        return buffers;
    }

    protected boolean filterAdd(HeaderKeys key, byte[] value) {
        return true;
    }

    protected void filterRemove(HeaderKeys key, byte[] value) {
    }

    private void scribbleWhiteSpace(WsByteBuffer buffer, int start, int stop) {
        if (buffer.hasArray()) {
            byte[] data = buffer.array();
            int offset = buffer.arrayOffset();
            int myStart = start + offset;
            int myStop = stop + offset;
            for (int i = myStart; i < myStop; ++i) {
                data[i] = 32;
            }
        } else {
            int partial;
            byte[] localWhitespace = whitespace;
            if (null == localWhitespace) {
                localWhitespace = BNFHeadersImpl.getWhiteSpace();
            }
            buffer.position(start);
            for (int len = stop - start; len > 0; len -= partial) {
                if (localWhitespace.length >= len) {
                    buffer.put(localWhitespace, 0, len);
                    break;
                }
                partial = localWhitespace.length;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Scribbling " + partial + " bytes of whitespace"), (Object[])new Object[0]);
                }
                buffer.put(localWhitespace, 0, partial);
            }
        }
    }

    private void eraseValue(HeaderElement elem) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Erasing existing header: " + elem.getName()), (Object[])new Object[0]);
        }
        int next_index = this.lastCRLFBufferIndex;
        int next_pos = this.lastCRLFPosition;
        if (null != elem.nextSequence && !elem.nextSequence.wasAdded()) {
            next_index = elem.nextSequence.getLastCRLFBufferIndex();
            next_pos = elem.nextSequence.getLastCRLFPosition();
        }
        int start = elem.getLastCRLFPosition();
        for (int x = elem.getLastCRLFBufferIndex(); x < next_index; ++x) {
            this.parseBuffers[x].position(start);
            this.parseBuffers[x].limit(start);
            start = 0;
        }
        this.scribbleWhiteSpace(this.parseBuffers[next_index], start, next_pos);
    }

    private int overlayBytes(byte[] data, int inOffset, int inLength, int inIndex) {
        int length = inLength;
        int offset = inOffset;
        int index = inIndex;
        WsByteBuffer buffer = this.parseBuffers[index];
        if (-1 == length) {
            length = data.length;
        }
        while (index <= this.parseIndex) {
            int remaining = buffer.remaining();
            if (remaining >= length) {
                buffer.put(data, offset, length);
                return index;
            }
            buffer.put(data, offset, remaining);
            offset += remaining;
            length -= remaining;
            buffer = this.parseBuffers[++index];
            buffer.position(0);
        }
        return index;
    }

    private void overlayValue(HeaderElement elem) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Overlaying existing header: " + elem.getName()), (Object[])new Object[0]);
        }
        int next_index = this.lastCRLFBufferIndex;
        int next_pos = this.lastCRLFPosition;
        if (null != elem.nextSequence && !elem.nextSequence.wasAdded()) {
            next_index = elem.nextSequence.getLastCRLFBufferIndex();
            next_pos = elem.nextSequence.getLastCRLFPosition();
        }
        WsByteBuffer buffer = this.parseBuffers[elem.getLastCRLFBufferIndex()];
        buffer.position(elem.getLastCRLFPosition() + (elem.isLastCRLFaCR() ? 2 : 1));
        if (next_index == elem.getLastCRLFBufferIndex()) {
            buffer.put(elem.getKey().getMarshalledByteArray(this.foundCompactHeader()));
            buffer.put(elem.asRawBytes(), elem.getOffset(), elem.getValueLength());
        } else {
            int index = elem.getLastCRLFBufferIndex();
            index = this.overlayBytes(elem.getKey().getMarshalledByteArray(this.foundCompactHeader()), 0, -1, index);
            index = this.overlayBytes(elem.asRawBytes(), elem.getOffset(), elem.getValueLength(), index);
            buffer = this.parseBuffers[index];
        }
        int start = buffer.position();
        if (start < next_pos) {
            this.scribbleWhiteSpace(buffer, start, next_pos);
        }
    }

    private WsByteBuffer[] marshallAddedHeaders(WsByteBuffer[] inBuffers, int index) {
        WsByteBuffer[] buffers = inBuffers;
        buffers[index] = this.allocateBuffer(this.outgoingHdrBufferSize);
        HeaderElement elem = this.hdrSequence;
        while (null != elem) {
            if (elem.wasAdded()) {
                buffers = this.marshallHeader(buffers, elem);
            }
            elem = elem.nextSequence;
        }
        buffers = this.putBytes(BNFHeaders.EOL, buffers);
        buffers = this.flushCache(buffers);
        buffers[buffers.length - 1].flip();
        return buffers;
    }

    private WsByteBuffer[] marshallReuseHeaders(WsByteBuffer[] inBuffers) {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        WsByteBuffer[] src = inBuffers;
        if (bTrace && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Marshalling headers and re-using buffers, change=" + this.headerChangeCount + ", add=" + this.headerAddCount + ", src=" + src), (Object[])new Object[0]);
        }
        HeaderElement elem = this.hdrSequence;
        WsByteBuffer[] buffers = src;
        int size = this.parseIndex + (0 < this.headerAddCount ? 2 : 1);
        int output = 0;
        int input = 0;
        if (null == src || 0 == src.length) {
            buffers = new WsByteBuffer[size];
        } else {
            src = this.flushCache(src);
            src[src.length - 1].flip();
            int firstHeaderBuffer = elem.getLastCRLFBufferIndex();
            for (int i = 0; i < firstHeaderBuffer; ++i) {
                if (bTrace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Trimming first line data from " + this.parseBuffers[i]), (Object[])new Object[0]);
                }
                this.parseBuffersStartPos[i] = this.parseBuffers[i].limit();
            }
            int firstHeaderPos = elem.getLastCRLFPosition() + (elem.isLastCRLFaCR() ? 2 : 1);
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Setting first buffer with headers pos to " + firstHeaderPos), (Object[])new Object[0]);
            }
            this.parseBuffersStartPos[firstHeaderBuffer] = firstHeaderPos;
            size = size - firstHeaderBuffer + src.length;
            buffers = new WsByteBuffer[size];
            System.arraycopy(src, 0, buffers, 0, src.length);
            output = src.length;
            input = firstHeaderBuffer;
        }
        if (0 < this.headerChangeCount) {
            elem = this.hdrSequence;
            int i = 0;
            while (i < this.headerChangeCount && null != elem && -1 != elem.getLastCRLFBufferIndex()) {
                if (elem.wasRemoved()) {
                    this.eraseValue(elem);
                    ++i;
                } else if (elem.wasChanged()) {
                    this.overlayValue(elem);
                    ++i;
                }
                elem = elem.nextSequence;
            }
        }
        while (input < this.parseIndex) {
            buffers[output] = this.parseBuffers[input];
            buffers[output].position(this.parseBuffersStartPos[input]);
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Copying existing parse buffer: " + buffers[output]), (Object[])new Object[0]);
            }
            ++input;
            ++output;
        }
        int endPos = this.eohPosition;
        if (0 < this.headerAddCount) {
            endPos = this.lastCRLFPosition + 1;
            if (this.lastCRLFisCR) {
                ++endPos;
            }
        }
        WsByteBuffer buffer = this.parseBuffers[input];
        int pos = buffer.position();
        int lim = buffer.limit();
        buffer.position(this.parseBuffersStartPos[input]);
        buffer.limit(endPos);
        buffers[output] = buffer.slice();
        this.addToCreatedBuffer(buffers[output]);
        buffer.limit(lim);
        buffer.position(pos);
        if (bTrace && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Sliced last header buffer: " + buffers[output]), (Object[])new Object[0]);
        }
        if (0 < this.headerAddCount) {
            buffers = this.marshallAddedHeaders(buffers, ++output);
        }
        return buffers;
    }

    @Override
    public boolean parseBinaryHeaders(WsByteBuffer buff, HeaderKeys keys) throws MalformedMessageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Parsing binary headers with input buff: " + buff), (Object[])new Object[0]);
        }
        if (null == this.parsedToken) {
            this.createCacheToken(4);
        }
        boolean complete = false;
        block8: while (!complete) {
            if (!this.fillCacheToken(buff)) {
                return false;
            }
            switch (this.binaryParsingState) {
                case 1: {
                    int value = GenericUtils.asInt(this.parsedToken);
                    if (0 == value) {
                        complete = true;
                        continue block8;
                    }
                    if (1 == value) {
                        this.binaryParsingState = 2;
                        this.resetCacheToken(4);
                        continue block8;
                    }
                    if (2 != value) continue block8;
                    this.binaryParsingState = 3;
                    this.resetCacheToken(4);
                    continue block8;
                }
                case 2: {
                    HeaderKeys key = (HeaderKeys)keys.getEnumByOrdinal(GenericUtils.asInt(this.parsedToken));
                    this.currentElem = this.getElement(key);
                    this.binaryParsingState = 5;
                    this.resetCacheToken(4);
                    continue block8;
                }
                case 3: {
                    this.binaryParsingState = 4;
                    this.resetCacheToken(GenericUtils.asInt(this.parsedToken));
                    continue block8;
                }
                case 4: {
                    this.currentElem = this.getElement(this.findKey(this.parsedToken));
                    this.binaryParsingState = 5;
                    this.resetCacheToken(4);
                    continue block8;
                }
                case 5: {
                    this.binaryParsingState = 6;
                    this.resetCacheToken(GenericUtils.asInt(this.parsedToken));
                    continue block8;
                }
                case 6: {
                    this.setHeaderValue();
                    this.binaryParsingState = 1;
                    this.createCacheToken(4);
                    continue block8;
                }
            }
            throw new MalformedMessageException("Invalid state in headers: " + this.binaryParsingState);
        }
        this.eohPosition = this.findCurrentBufferPosition(buff);
        buff.position(this.eohPosition);
        this.resetByteCache();
        this.clearCacheToken();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("End of binary headers at pos: " + this.eohPosition), (Object[])new Object[0]);
        }
        return true;
    }

    @Override
    public boolean parseHeaders(WsByteBuffer buff, boolean bExtractValue) throws MalformedMessageException {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        if (bTrace && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Parsing headers with input buff: " + buff), (Object[])new Object[0]);
        }
        boolean rc = false;
        while (-1 == this.eohPosition) {
            switch (this.stateOfParsing) {
                case 0: {
                    rc = this.parseHeaderName(buff);
                    break;
                }
                case 1: {
                    rc = bExtractValue || this.bIsMultiLine ? this.parseHeaderValueExtract(buff) : this.parseHeaderValueNonExtract(buff);
                    break;
                }
                case 2: {
                    rc = this.parseCRLFs(buff);
                    break;
                }
                default: {
                    if (!bTrace || !tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)("Found invalid parsing ID of " + this.stateOfParsing), (Object[])new Object[0]);
                }
            }
            if (rc) continue;
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Need more data", (Object[])new Object[0]);
            }
            this.resetByteCache();
            return false;
        }
        this.resetByteCache();
        this.headerChangeCount = 0;
        this.headerAddCount = 0;
        if (bTrace && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("End of headers found at position " + this.eohPosition), (Object[])new Object[0]);
        }
        return true;
    }

    @Override
    public void postMarshallHeaders() {
    }

    @Override
    public void preMarshallHeaders() {
    }

    @Override
    public void removeAllHeaders() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeAllHeaders()", (Object[])new Object[0]);
        }
        HeaderElement elem = this.hdrSequence;
        while (null != elem) {
            if (elem.getKey().useFilters()) {
                this.filterRemove(elem.getKey(), null);
            }
            elem.remove();
            elem = elem.nextSequence;
        }
        this.numberOfHeaders = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeAllHeaders()");
        }
    }

    private void clearAllHeaders() {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        if (bTrace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"clearAllHeaders()", (Object[])new Object[0]);
        }
        HeaderElement elem = this.hdrSequence;
        while (null != elem) {
            HeaderElement next = elem.nextSequence;
            HeaderKeys key = elem.getKey();
            int ord = key.getOrdinal();
            if (null != this.storage[ord]) {
                if (key.useFilters()) {
                    this.filterRemove(key, null);
                }
                this.storage[ord] = null;
            }
            elem.destroy();
            elem = next;
        }
        this.hdrSequence = null;
        this.lastHdrInSequence = null;
        this.numberOfHeaders = 0;
        if (bTrace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"clearAllHeaders()");
        }
    }

    @Override
    public void removeHeader(HeaderKeys key) {
        if (null == key) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeHeader(h): " + key.getName()), (Object[])new Object[0]);
        }
        this.removeHdrInstances(this.findHeader(key), true);
    }

    @Override
    public void removeHeader(String header) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeHeader(s): " + header), (Object[])new Object[0]);
        }
        this.removeHdrInstances(this.findHeader(this.findKey(header)), true);
    }

    @Override
    public void removeHeader(byte[] header) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeHeader(b): " + key.getName()), (Object[])new Object[0]);
        }
        this.removeHdrInstances(this.findHeader(key), true);
    }

    @Override
    public void removeHeader(HeaderKeys key, int instance) {
        if (null == key) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeHeader(h,i): " + key.getName() + " " + instance), (Object[])new Object[0]);
        }
        this.removeHdr(this.findHeader(key, instance));
    }

    @Override
    public void removeHeader(String header, int instance) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeHeader(s,i): " + header + " " + instance), (Object[])new Object[0]);
        }
        this.removeHdr(this.findHeader(this.findKey(header), instance));
    }

    @Override
    public void removeHeader(byte[] header, int instance) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeHeader(b,i): " + key.getName() + " " + instance), (Object[])new Object[0]);
        }
        this.removeHdr(this.findHeader(key, instance));
    }

    public void removeSpecialHeader(HeaderKeys key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeSpecialHeader(h): " + key.getName()), (Object[])new Object[0]);
        }
        this.removeHdrInstances(this.findHeader(key), false);
    }

    public WsByteBuffer returnCurrentBuffer() {
        WsByteBuffer buff = null;
        if (-1 != this.parseIndex) {
            buff = this.parseBuffers[this.parseIndex];
            --this.parseIndex;
        }
        return buff;
    }

    @Override
    public void setHeader(String header, byte[] value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setHeader(s,b): " + header), (Object[])new Object[0]);
        }
        this.setHeader(this.findKey(header), value);
    }

    @Override
    public void setHeader(String header, byte[] value, int offset, int length) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setHeader(s,b,i,i): " + header), (Object[])new Object[0]);
        }
        this.setHeader(this.findKey(header), value, offset, length);
    }

    @Override
    public void setHeader(byte[] header, byte[] value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setHeader(b,b): " + key.getName()), (Object[])new Object[0]);
        }
        this.setHeader(key, value);
    }

    @Override
    public void setHeader(byte[] header, byte[] value, int offset, int length) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setHeader(b,b,i,i): " + key.getName()), (Object[])new Object[0]);
        }
        this.setHeader(key, value, offset, length);
    }

    @Override
    public void setHeader(HeaderKeys key, byte[] value) {
        if (null == key || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setHeader(h,b): " + key.getName()), (Object[])new Object[0]);
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, 0, value.length);
        }
        if (key.useFilters()) {
            HeaderElement elem = this.findHeader(key);
            if (null != elem) {
                this.filterRemove(key, null);
            }
            if (!this.filterAdd(key, value)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("New value disallowed: " + GenericUtils.getEnglishString(value)), (Object[])new Object[0]);
                }
                if (null != elem) {
                    this.removeHdrInstances(elem, false);
                }
                return;
            }
        }
        this.createSingleHeader(key, value, 0, value.length);
    }

    @Override
    public void setHeader(HeaderKeys key, byte[] value, int offset, int length) {
        if (null == key || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setHeader(h,b,i,i): " + key.getName()), (Object[])new Object[0]);
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, offset, length);
        }
        if (key.useFilters()) {
            HeaderElement elem = this.findHeader(key);
            if (null != elem) {
                this.filterRemove(key, null);
            }
            byte[] temp = new byte[length];
            System.arraycopy(value, offset, temp, 0, length);
            if (!this.filterAdd(key, temp)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("New value disallowed: " + GenericUtils.getEnglishString(temp)), (Object[])new Object[0]);
                }
                if (null != elem) {
                    this.removeHdrInstances(elem, false);
                }
                return;
            }
        }
        this.createSingleHeader(key, value, offset, length);
    }

    @Override
    public void setHeader(HeaderKeys key, String value) {
        HeaderElement elem;
        if (null == key || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setHeader(h,s): " + key.getName()), (Object[])new Object[0]);
        }
        if (this.bHeaderValidation) {
            if (this.getCharacterValidation().booleanValue()) {
                value = this.getValidatedCharacters(value);
            } else {
                this.checkHeaderValue(value);
            }
        }
        if (key.useFilters()) {
            elem = this.findHeader(key);
            if (null != elem) {
                this.filterRemove(key, null);
            }
            if (!this.filterAdd(key, GenericUtils.getEnglishBytes(value))) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("New value disallowed: " + value), (Object[])new Object[0]);
                }
                if (null != elem) {
                    this.removeHdrInstances(elem, false);
                }
                return;
            }
        }
        if (null != (elem = this.findHeader(key))) {
            if (null != elem.nextInstance) {
                HeaderElement temp = elem.nextInstance;
                while (null != temp) {
                    temp.remove();
                    temp = temp.nextInstance;
                }
            }
            if (-1 != this.headerChangeLimit) {
                if (value.length() <= elem.getValueLength()) {
                    ++this.headerChangeCount;
                    elem.setStringValue(value);
                } else {
                    elem.remove();
                    elem = null;
                }
            } else {
                elem.setStringValue(value);
            }
        }
        if (null == elem) {
            elem = this.getElement(key);
            elem.setStringValue(value);
            this.addHeader(elem, false);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Replacing header " + key.getName() + " [" + elem.getDebugValue() + "]"), (Object[])new Object[0]);
        }
    }

    @Override
    public void setHeader(String header, String value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setHeader(s,s): " + header), (Object[])new Object[0]);
        }
        this.setHeader(this.findKey(header), value);
    }

    @Override
    public void setHeader(byte[] header, String value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setHeader(b,s): " + key.getName()), (Object[])new Object[0]);
        }
        this.setHeader(key, value);
    }

    private void createSingleHeader(HeaderKeys key, byte[] value, int offset, int length) {
        HeaderElement elem = this.findHeader(key);
        if (null != elem) {
            if (null != elem.nextInstance) {
                HeaderElement temp = elem.nextInstance;
                while (null != temp) {
                    temp.remove();
                    temp = temp.nextInstance;
                }
            }
            if (-1 != this.headerChangeLimit) {
                if (length <= elem.getValueLength()) {
                    ++this.headerChangeCount;
                    elem.setByteArrayValue(value, offset, length);
                } else {
                    elem.remove();
                    elem = null;
                }
            } else {
                elem.setByteArrayValue(value, offset, length);
            }
        }
        if (null == elem) {
            elem = this.getElement(key);
            elem.setByteArrayValue(value, offset, length);
            this.addHeader(elem, false);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Replacing header " + key.getName() + " [" + elem.getDebugValue() + "]"), (Object[])new Object[0]);
        }
    }

    private void addHeader(HeaderElement elem, boolean bFilter) {
        HeaderKeys key = elem.getKey();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Adding header [" + key.getName() + "] with value [" + elem.getDebugValue() + "]"), (Object[])new Object[0]);
        }
        if (bFilter && key.useFilters() && !this.filterAdd(key, elem.asBytes())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("filter disallowed: " + elem.getDebugValue()), (Object[])new Object[0]);
            }
            return;
        }
        this.incrementHeaderCounter();
        HeaderElement root = this.findHeader(key);
        boolean rc = this.addInstanceOfElement(root, elem);
        if (rc) {
            int ord = key.getOrdinal();
            if (ord >= this.storage.length) {
                HeaderElement[] temp = new HeaderElement[ord + 10];
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Increasing header storage to " + temp.length), (Object[])new Object[0]);
                }
                for (int i = 0; i < this.storage.length; ++i) {
                    temp[i] = this.storage[i];
                }
                this.storage = temp;
            }
            this.storage[ord] = elem;
        }
    }

    private HeaderElement getElement(HeaderKeys key) {
        HeaderElement elem = this.headerElements;
        if (null != elem) {
            this.headerElements = elem.nextInstance;
            elem.nextInstance = null;
            elem.init(key);
        } else {
            elem = new HeaderElement(key, this);
        }
        return elem;
    }

    protected void freeElement(HeaderElement elem) {
        elem.nextInstance = this.headerElements;
        this.headerElements = elem;
    }

    protected abstract HeaderKeys findKey(String var1);

    protected abstract HeaderKeys findKey(byte[] var1);

    protected abstract HeaderKeys findKey(byte[] var1, int var2, int var3);

    private HeaderElement findHeader(HeaderKeys key, int instance) {
        int ord = key.getOrdinal();
        if (ord >= this.storage.length) {
            return null;
        }
        HeaderElement elem = this.storage[ord];
        int i = -1;
        while (null != elem) {
            if (!elem.wasRemoved() && ++i == instance) {
                return elem;
            }
            elem = elem.nextInstance;
        }
        return null;
    }

    private HeaderElement findHeader(HeaderKeys key) {
        int ord = key.getOrdinal();
        if (ord >= this.storage.length) {
            return null;
        }
        HeaderElement elem = this.storage[ord];
        while (null != elem && elem.wasRemoved()) {
            elem = elem.nextInstance;
        }
        return elem;
    }

    private void removeHdr(HeaderElement elem) {
        if (null == elem) {
            return;
        }
        HeaderKeys key = elem.getKey();
        elem.remove();
        if (key.useFilters()) {
            this.filterRemove(key, elem.asBytes());
        }
    }

    private void removeHdrInstances(HeaderElement root, boolean bFilter) {
        if (null == root) {
            return;
        }
        HeaderKeys key = root.getKey();
        if (bFilter && key.useFilters()) {
            this.filterRemove(key, null);
        }
        HeaderElement elem = root;
        while (null != elem) {
            elem.remove();
            elem = elem.nextInstance;
        }
    }

    protected void setSpecialHeader(HeaderKeys key, byte[] value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setSpecialHeader(h,b[]): " + key.getName()), (Object[])new Object[0]);
        }
        this.removeHdrInstances(this.findHeader(key), false);
        HeaderElement elem = this.getElement(key);
        elem.setByteArrayValue(value);
        this.addHeader(elem, false);
    }

    protected void setSpecialHeader(HeaderKeys key, String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setSpecialHeader(h,s): " + key.getName()), (Object[])new Object[0]);
        }
        this.removeHdrInstances(this.findHeader(key), false);
        HeaderElement elem = this.getElement(key);
        elem.setStringValue(value);
        this.addHeader(elem, false);
    }

    protected boolean overHeaderChangeLimit() {
        if (this.bOverChangeLimit || -1 == this.parseIndex) {
            return true;
        }
        this.bOverChangeLimit = this.headerChangeCount >= this.headerChangeLimit;
        return this.bOverChangeLimit;
    }

    public void setHeaderChangeLimit(int limit) {
        this.headerChangeLimit = limit;
        this.bOverChangeLimit = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Setting header change limit to " + limit), (Object[])new Object[0]);
        }
    }

    public int getHeaderChangeLimit() {
        return this.headerChangeLimit;
    }

    protected WsByteBuffer[] marshallHeader(WsByteBuffer[] inBuffers, HeaderElement elem) {
        if (elem.wasRemoved()) {
            return inBuffers;
        }
        WsByteBuffer[] buffers = inBuffers;
        byte[] value = elem.asRawBytes();
        if (null != value) {
            buffers = this.putBytes(elem.getKey().getMarshalledByteArray(this.foundCompactHeader()), buffers);
            buffers = this.putBytes(value, elem.getOffset(), elem.getValueLength(), buffers);
            buffers = this.putBytes(BNFHeaders.EOL, buffers);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Marshalling: " + elem.getKey() + " [" + elem.getDebugValue() + "]"), (Object[])new Object[0]);
            }
        }
        return buffers;
    }

    protected WsByteBuffer[] marshallBinaryHeader(WsByteBuffer[] inBuffers, HeaderElement elem) {
        if (elem.wasRemoved()) {
            return inBuffers;
        }
        WsByteBuffer[] buffers = inBuffers;
        byte[] value = elem.asRawBytes();
        if (null != value) {
            HeaderKeys key = elem.getKey();
            if (!key.isUndefined()) {
                buffers = this.putInt(1, buffers);
                buffers = this.putInt(elem.getKey().getOrdinal(), buffers);
            } else {
                buffers = this.putInt(2, buffers);
                buffers = this.putInt(key.getByteArray().length, buffers);
                buffers = this.putBytes(key.getByteArray(), buffers);
            }
            buffers = this.putInt(elem.getValueLength(), buffers);
            buffers = this.putBytes(value, elem.getOffset(), elem.getValueLength(), buffers);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Marshalling: " + elem.getName() + " [" + elem.getDebugValue() + "]"), (Object[])new Object[0]);
            }
        }
        return buffers;
    }

    protected final int getBinaryParseState() {
        return this.binaryParsingState;
    }

    protected final void setBinaryParseState(int state) {
        this.binaryParsingState = state;
    }

    public WsByteBuffer allocateBuffer(int size) {
        WsByteBufferPoolManager mgr = HttpDispatcher.getBufferManager();
        WsByteBuffer wsbb = this.useDirectBuffer ? mgr.allocateDirect(size) : mgr.allocate(size);
        this.addToCreatedBuffer(wsbb);
        return wsbb;
    }

    public final WsByteBuffer getCurrentBuffer() {
        return this.currentReadBB;
    }

    public final void setCurrentBuffer(WsByteBuffer b) {
        this.currentReadBB = b;
    }

    @Override
    public void setDebugContext(Object o) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("debugContext set to " + o + " for " + this), (Object[])new Object[0]);
        }
        if (null != o) {
            this.debugContext = o;
        }
    }

    protected final Object getDebugContext() {
        return this.debugContext;
    }

    protected final int getIncomingBufferSize() {
        return this.incomingBufferSize;
    }

    protected final int getOutgoingBufferSize() {
        return this.outgoingHdrBufferSize;
    }

    protected final boolean shouldAllocateDirectBuffer() {
        return this.useDirectBuffer;
    }

    protected final void setParsedToken(byte[] token) {
        this.parsedToken = token;
    }

    protected final byte[] getParsedToken() {
        return this.parsedToken;
    }

    protected final int getByteCacheSize() {
        return this.byteCacheSize;
    }

    protected WsByteBuffer getParseBuffer(int index) {
        if (0 > index || index >= this.parseIndex) {
            return null;
        }
        return this.parseBuffers[index];
    }

    public final int getBuffersIndex() {
        return this.parseIndex;
    }

    @Override
    public void setLimitOfTokenSize(int size) {
        if (0 >= size) {
            throw new IllegalArgumentException("Invalid limit on token size: " + size);
        }
        this.limitTokenSize = size;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Limit on token size now: " + this.limitTokenSize), (Object[])new Object[0]);
        }
    }

    @Override
    public int getLimitOfTokenSize() {
        return this.limitTokenSize;
    }

    public int getNumberOfHeaders() {
        return this.numberOfHeaders;
    }

    private void incrementHeaderCounter() {
        ++this.numberOfHeaders;
        ++this.headerAddCount;
        if (this.limitNumHeaders < this.numberOfHeaders) {
            String msg = "Too many headers in storage: " + this.numberOfHeaders;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            }
            throw new IllegalArgumentException(msg);
        }
    }

    protected void decrementHeaderCounter() {
        --this.numberOfHeaders;
        ++this.headerChangeCount;
    }

    @Override
    public void setLimitOnNumberOfHeaders(int size) {
        if (0 >= size) {
            throw new IllegalArgumentException("Invalid limit on number headers: " + size);
        }
        this.limitNumHeaders = size;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Limit on number of headers now: " + this.limitNumHeaders), (Object[])new Object[0]);
        }
    }

    @Override
    public int getLimitOnNumberOfHeaders() {
        return this.limitNumHeaders;
    }

    protected final void setHeaderValidation(boolean flag) {
        this.bHeaderValidation = flag;
    }

    private void checkHeaderValue(byte[] data, int offset, int length) {
        int index = offset + length - 1;
        if (index < 0) {
            return;
        }
        String error = null;
        if (10 == data[index] || 13 == data[index]) {
            error = "Illegal trailing EOL";
        }
        for (int i = offset; null == error && i < index; ++i) {
            if (13 == data[i]) {
                if (10 != data[i + 1]) {
                    error = "Invalid CR not followed by LF";
                    continue;
                }
                if (!this.getCharacterValidation().booleanValue()) continue;
                data[i] = 32;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Found a CR replacing it with a SP", (Object[])new Object[0]);
                continue;
            }
            if (10 != data[i]) continue;
            if (9 != data[i + 1] && 32 != data[i + 1]) {
                error = "Invalid LF not followed by whitespace";
                continue;
            }
            if (!this.getCharacterValidation().booleanValue()) continue;
            data[i] = 32;
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"Found a LF replacing it with a SP", (Object[])new Object[0]);
        }
        if (null != error) {
            IllegalArgumentException iae = new IllegalArgumentException(error);
            FFDCFilter.processException((Throwable)iae, (String)(this.getClass().getName() + ".checkHeaderValue(byte[])"), (String)"1", (Object)this);
            throw iae;
        }
    }

    public static void setCharacterValidation(Boolean value) {
        bCharacterValidation = value;
    }

    public Boolean getCharacterValidation() {
        return bCharacterValidation;
    }

    private String getValidatedCharacters(String data) {
        if (this.isGoodCharacters(data).booleanValue()) {
            return data;
        }
        return this.checkHeaderCharacters(data);
    }

    private Boolean isGoodCharacters(String data) {
        int index = data.length() - 1;
        if (index < 0) {
            return true;
        }
        String error = null;
        char c = data.charAt(index);
        if ('\n' == c || '\r' == c) {
            error = "Illegal trailing EOL";
        }
        for (int i = 0; null == error && i <= index; ++i) {
            int maskedCodePoint;
            c = data.charAt(i);
            if (i < index) {
                if ('\r' == c) {
                    if ('\n' != data.charAt(i + 1)) {
                        error = "Invalid CR not followed by LF";
                    }
                } else if ('\n' == c) {
                    char x = data.charAt(i + 1);
                    if ('\t' != x && ' ' != x) {
                        error = "Invalid LF not followed by whitespace";
                    } else {
                        return false;
                    }
                }
            }
            if (c >= ' ' && c < '\u007f') continue;
            if (c == '\n' || c == '\r') {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Found a CR or LF", (Object[])new Object[0]);
                }
                return false;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The Character: " + c + " is not printable"), (Object[])new Object[0]);
            }
            if ((maskedCodePoint = c & 0xFF) == 10 || maskedCodePoint == 13) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Character: " + c + " unicode ends with a 0a or 0d"), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("The Unicode is: " + (char)maskedCodePoint), (Object[])new Object[0]);
                }
                return false;
            }
            return false;
        }
        if (null != error) {
            IllegalArgumentException iae = new IllegalArgumentException(error);
            FFDCFilter.processException((Throwable)iae, (String)(this.getClass().getName() + ".isGoodCharacters(String)"), (String)"1", (Object)this);
            throw iae;
        }
        return true;
    }

    private String checkHeaderCharacters(String data) {
        int index = data.length() - 1;
        if (index < 0) {
            return data;
        }
        String error = null;
        char c = data.charAt(index);
        if ('\n' == c || '\r' == c) {
            error = "Illegal trailing EOL";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; null == error && i <= index; ++i) {
            int maskedCodePoint;
            c = data.charAt(i);
            if (i < index) {
                char x;
                if ('\r' == c) {
                    if ('\n' != data.charAt(i + 1)) {
                        error = "Invalid CR not followed by LF";
                    }
                } else if ('\n' == c && '\t' != (x = data.charAt(i + 1)) && ' ' != x) {
                    error = "Invalid LF not followed by whitespace";
                }
            }
            if (c >= ' ' && c < '\u007f') {
                sb.append(c);
                continue;
            }
            if (c == '\n' || c == '\r') {
                sb.append(' ');
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Found a CR or LF, replacing it with SP", (Object[])new Object[0]);
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The Character: " + c + " is not printable"), (Object[])new Object[0]);
            }
            if ((maskedCodePoint = c & 0xFF) == 10 || maskedCodePoint == 13) {
                sb.append('?');
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Character: " + c + " unicode ends with a 0a or 0d, replacing it with ?"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("The Unicode is: " + (char)maskedCodePoint), (Object[])new Object[0]);
                continue;
            }
            sb.append(c);
        }
        if (null != error) {
            IllegalArgumentException iae = new IllegalArgumentException(error);
            FFDCFilter.processException((Throwable)iae, (String)(this.getClass().getName() + ".checkHeaderValue(String)"), (String)"1", (Object)this);
            throw iae;
        }
        return sb.toString();
    }

    private void checkHeaderValue(String data) {
        int index = data.length() - 1;
        if (index < 0) {
            return;
        }
        String error = null;
        char c = data.charAt(index);
        if ('\n' == c || '\r' == c) {
            error = "Illegal trailing EOL";
        }
        for (int i = 0; null == error && i < index; ++i) {
            c = data.charAt(i);
            if ('\r' == c) {
                if ('\n' == data.charAt(i + 1)) continue;
                error = "Invalid CR not followed by LF";
                continue;
            }
            if ('\n' != c || '\t' == (c = data.charAt(++i)) || ' ' == c) continue;
            error = "Invalid LF not followed by whitespace";
        }
        if (null != error) {
            IllegalArgumentException iae = new IllegalArgumentException(error);
            FFDCFilter.processException((Throwable)iae, (String)(this.getClass().getName() + ".checkHeaderValue(String)"), (String)"1", (Object)this);
            throw iae;
        }
    }

    private int countInstances(HeaderElement root) {
        int count = 0;
        HeaderElement elem = root;
        while (null != elem) {
            if (!elem.wasRemoved()) {
                ++count;
            }
            elem = elem.nextInstance;
        }
        return count;
    }

    private boolean skipWhiteSpace(WsByteBuffer buff) {
        byte b;
        do {
            if (this.bytePosition < this.byteLimit || this.fillByteCache(buff)) continue;
            return false;
        } while (32 == (b = this.byteCache[this.bytePosition++]) || 9 == b);
        --this.bytePosition;
        return true;
    }

    private boolean addInstanceOfElement(HeaderElement root, HeaderElement elem) {
        if (null == this.hdrSequence) {
            this.hdrSequence = elem;
            this.lastHdrInSequence = elem;
        } else {
            this.lastHdrInSequence.nextSequence = elem;
            elem.prevSequence = this.lastHdrInSequence;
            this.lastHdrInSequence = elem;
        }
        if (null == root) {
            return true;
        }
        HeaderElement prev = root;
        while (null != prev.nextInstance) {
            prev = prev.nextInstance;
        }
        prev.nextInstance = elem;
        return false;
    }

    protected WsByteBuffer[] putInt(int data, WsByteBuffer[] buffers) {
        return this.putBytes(GenericUtils.asBytes(data), buffers);
    }

    protected WsByteBuffer[] putByte(byte data, WsByteBuffer[] inBuffers) {
        WsByteBuffer[] buffers = inBuffers;
        this.byteCache[this.bytePosition] = data;
        ++this.bytePosition;
        if (this.bytePosition >= this.byteCacheSize) {
            buffers = this.flushFullCache(buffers);
        }
        return buffers;
    }

    protected WsByteBuffer[] putBytes(byte[] data, WsByteBuffer[] inBuffers) {
        WsByteBuffer[] buffers = inBuffers;
        int space_left = this.byteCacheSize - this.bytePosition;
        if (data.length <= space_left) {
            System.arraycopy(data, 0, this.byteCache, this.bytePosition, data.length);
            this.bytePosition += data.length;
        } else {
            buffers = this.flushCache(buffers);
            return GenericUtils.putByteArray(buffers, data, 0, data.length, this);
        }
        if (this.bytePosition == this.byteCacheSize) {
            buffers = this.flushFullCache(buffers);
        }
        return buffers;
    }

    protected WsByteBuffer[] putBytes(byte[] data, int offset, int length, WsByteBuffer[] inBuffers) {
        WsByteBuffer[] buffers = inBuffers;
        int space_left = this.byteCacheSize - this.bytePosition;
        if (length <= space_left) {
            System.arraycopy(data, offset, this.byteCache, this.bytePosition, length);
            this.bytePosition += length;
        } else {
            buffers = this.flushCache(buffers);
            return GenericUtils.putByteArray(buffers, data, offset, length, this);
        }
        if (this.bytePosition == this.byteCacheSize) {
            buffers = this.flushFullCache(buffers);
        }
        return buffers;
    }

    protected WsByteBuffer[] flushFullCache(WsByteBuffer[] buffers) {
        this.bytePosition = 0;
        return GenericUtils.putByteArray(buffers, this.byteCache, this);
    }

    protected WsByteBuffer[] flushCache(WsByteBuffer[] buffers) {
        int pos = this.bytePosition;
        if (0 == pos) {
            return buffers;
        }
        this.bytePosition = 0;
        return GenericUtils.putByteArray(buffers, this.byteCache, 0, pos, this);
    }

    protected final void resetByteCache() {
        this.bytePosition = 0;
        this.byteLimit = 0;
    }

    protected final void decrementBytePositionIgnoringLFs() {
        --this.bytePosition;
        if (10 == this.byteCache[this.bytePosition]) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"decrementILF found an LF character", (Object[])new Object[0]);
            }
            ++this.bytePosition;
        }
    }

    protected final void clearCacheToken() {
        this.parsedToken = null;
        this.parsedTokenLength = 0;
    }

    protected final void createCacheToken(int len) {
        this.parsedToken = new byte[len];
        this.parsedTokenLength = 0;
    }

    protected final void resetCacheToken(int len) {
        if (null == this.parsedToken || len != this.parsedToken.length) {
            this.parsedToken = new byte[len];
        }
        this.parsedTokenLength = 0;
    }

    protected final boolean fillCacheToken(WsByteBuffer buff) {
        int need_len;
        int curr_len = this.parsedTokenLength;
        int copy_len = need_len = this.parsedToken.length - curr_len;
        while (0 < need_len) {
            if (this.bytePosition >= this.byteLimit && !this.fillByteCache(buff)) {
                this.parsedTokenLength = curr_len;
                return false;
            }
            int available = this.byteLimit - this.bytePosition;
            copy_len = available < need_len ? available : need_len;
            System.arraycopy(this.byteCache, this.bytePosition, this.parsedToken, curr_len, copy_len);
            need_len -= copy_len;
            curr_len += copy_len;
            this.bytePosition += copy_len;
        }
        return true;
    }

    protected boolean fillByteCache(WsByteBuffer buff) {
        if (this.bytePosition < this.byteLimit) {
            return false;
        }
        int size = buff.remaining();
        if (size > this.byteCacheSize) {
            size = this.byteCacheSize;
        }
        this.bytePosition = 0;
        this.byteLimit = size;
        if (0 == this.byteLimit) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"fillByteCache: no data", (Object[])new Object[0]);
            }
            return false;
        }
        if (-1 != this.headerChangeLimit && -1 != this.parseIndex && -1 == this.parseBuffersStartPos[this.parseIndex]) {
            this.parseBuffersStartPos[this.parseIndex] = buff.position();
        }
        buff.get(this.byteCache, this.bytePosition, this.byteLimit);
        return true;
    }

    private int findCurrentBufferPosition(WsByteBuffer buffer) {
        return buffer.position() - (this.byteLimit - this.bytePosition);
    }

    protected TokenCodes findCRLFTokenLength(WsByteBuffer buff) throws MalformedMessageException {
        TokenCodes rc = TokenCodes.TOKEN_RC_MOREDATA;
        if (null == buff) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Null buffer provided", (Object[])new Object[0]);
            }
            return rc;
        }
        int length = this.parsedTokenLength;
        while (this.bytePosition < this.byteLimit || this.fillByteCache(buff)) {
            byte b;
            if (13 == (b = this.byteCache[this.bytePosition++])) {
                rc = TokenCodes.TOKEN_RC_DELIM;
                if (-1 == this.headerChangeLimit) break;
                this.lastCRLFPosition = this.findCurrentBufferPosition(buff) - 1;
                this.lastCRLFBufferIndex = this.parseIndex;
                this.lastCRLFisCR = true;
                break;
            }
            if (10 == b) {
                rc = TokenCodes.TOKEN_RC_DELIM;
                this.numCRLFs = 1;
                if (-1 == this.headerChangeLimit) break;
                this.lastCRLFPosition = this.findCurrentBufferPosition(buff) - 1;
                this.lastCRLFBufferIndex = this.parseIndex;
                this.lastCRLFisCR = false;
                break;
            }
            if (++length <= this.limitTokenSize) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("findCRLFTokenLength: length is too big: " + length), (Object[])new Object[0]);
            }
            throw new MalformedMessageException("Token length: " + length);
        }
        this.parsedTokenLength = length;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("findCRLFTokenLength returning " + rc.getName() + "; len=" + length), (Object[])new Object[0]);
        }
        return rc;
    }

    protected TokenCodes findTokenLength(WsByteBuffer buff, byte delimiter, boolean bApproveCRLF) throws MalformedMessageException {
        TokenCodes rc = TokenCodes.TOKEN_RC_MOREDATA;
        if (null == buff) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"findTokenLength: null buffer provided", (Object[])new Object[0]);
            }
            return rc;
        }
        int length = this.parsedTokenLength;
        while (this.bytePosition < this.byteLimit || this.fillByteCache(buff)) {
            byte b;
            if (delimiter == (b = this.byteCache[this.bytePosition++])) {
                rc = TokenCodes.TOKEN_RC_DELIM;
                break;
            }
            if (13 == b) {
                if (!bApproveCRLF) {
                    throw new MalformedMessageException("Invalid CR found in token");
                }
                rc = TokenCodes.TOKEN_RC_CRLF;
                if (-1 == this.headerChangeLimit) break;
                this.lastCRLFPosition = this.findCurrentBufferPosition(buff) - 1;
                this.lastCRLFBufferIndex = this.parseIndex;
                this.lastCRLFisCR = true;
                break;
            }
            if (10 == b) {
                if (!bApproveCRLF) {
                    throw new MalformedMessageException("Invalid LF found in token");
                }
                rc = TokenCodes.TOKEN_RC_CRLF;
                this.numCRLFs = 1;
                if (-1 == this.headerChangeLimit) break;
                this.lastCRLFPosition = this.findCurrentBufferPosition(buff) - 1;
                this.lastCRLFBufferIndex = this.parseIndex;
                this.lastCRLFisCR = false;
                break;
            }
            if (++length <= this.limitTokenSize) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("findTokenLength: length is too big: " + length), (Object[])new Object[0]);
            }
            throw new MalformedMessageException("Token length: " + length);
        }
        this.parsedTokenLength = length;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("findTokenLength: [" + (char)delimiter + "] " + rc.getName() + "; len=" + length), (Object[])new Object[0]);
        }
        return rc;
    }

    protected TokenCodes skipCRLFs(WsByteBuffer buffer) {
        int maxCRLFs = 33;
        if (this.bytePosition >= this.byteLimit && !this.fillByteCache(buffer)) {
            return TokenCodes.TOKEN_RC_MOREDATA;
        }
        byte b = this.byteCache[this.bytePosition++];
        for (int i = 0; i < maxCRLFs; ++i) {
            if (-1 == b) {
                return TokenCodes.TOKEN_RC_MOREDATA;
            }
            if (13 != b && 10 != b) {
                --this.bytePosition;
                return TokenCodes.TOKEN_RC_DELIM;
            }
            if (this.bytePosition >= this.byteLimit) {
                return TokenCodes.TOKEN_RC_MOREDATA;
            }
            b = this.byteCache[this.bytePosition++];
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Too many leading CRLFs found", (Object[])new Object[0]);
        }
        return TokenCodes.TOKEN_RC_CRLF;
    }

    private boolean parseCRLFs(WsByteBuffer buff) throws MalformedMessageException {
        for (int i = 0; i < 4; ++i) {
            byte b;
            if (this.bytePosition >= this.byteLimit && !this.fillByteCache(buff)) {
                return false;
            }
            if (13 == (b = this.byteCache[this.bytePosition++])) continue;
            if (10 == b) {
                ++this.numCRLFs;
            } else {
                if (32 == b || 9 == b) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Multiline header follows", (Object[])new Object[0]);
                    }
                    this.bIsMultiLine = true;
                    if (null == this.lastHdrInSequence) {
                        throw new MalformedMessageException("Incorrect multiline header value");
                    }
                    this.currentElem = this.lastHdrInSequence;
                    this.stateOfParsing = 1;
                    this.numCRLFs = 0;
                    return true;
                }
                --this.bytePosition;
                break;
            }
            if (2 > this.numCRLFs) continue;
            this.eohPosition = this.findCurrentBufferPosition(buff);
            buff.position(this.eohPosition);
            break;
        }
        this.bIsMultiLine = false;
        this.stateOfParsing = 0;
        this.numCRLFs = 0;
        return true;
    }

    protected TokenCodes parseCRLFTokenExtract(WsByteBuffer buff, int log) throws MalformedMessageException {
        if (null == this.parsedToken && !this.skipWhiteSpace(buff)) {
            return TokenCodes.TOKEN_RC_MOREDATA;
        }
        int start = this.findCurrentBufferPosition(buff);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("parseCRLFTokenExtract: start:" + start + " lim:" + this.byteLimit + " pos:" + this.bytePosition), (Object[])new Object[0]);
        }
        TokenCodes rc = this.findCRLFTokenLength(buff);
        this.saveParsedToken(buff, start, TokenCodes.TOKEN_RC_DELIM.equals(rc), log);
        return rc;
    }

    protected int parseCRLFTokenNonExtract(WsByteBuffer buff) throws MalformedMessageException {
        this.findCRLFTokenLength(buff);
        return this.parsedTokenLength;
    }

    protected TokenCodes findHeaderLength(WsByteBuffer buff) throws MalformedMessageException {
        TokenCodes rc = TokenCodes.TOKEN_RC_MOREDATA;
        if (null == buff) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"findHeaderLength: null buffer provided", (Object[])new Object[0]);
            }
            return rc;
        }
        int numSpaces = 0;
        int length = this.parsedTokenLength;
        while (this.bytePosition < this.byteLimit || this.fillByteCache(buff)) {
            byte b;
            if (58 == (b = this.byteCache[this.bytePosition++])) {
                length -= numSpaces;
                if (numSpaces > 0) {
                    this.foundTrailingWhitespace = true;
                }
                rc = TokenCodes.TOKEN_RC_DELIM;
                break;
            }
            numSpaces = 32 == b || 9 == b ? ++numSpaces : 0;
            if (13 == b || 10 == b) {
                throw new MalformedMessageException("Invalid CRLF found in header name");
            }
            if (++length <= this.limitTokenSize) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("findTokenLength: length is too big: " + length), (Object[])new Object[0]);
            }
            throw new MalformedMessageException("Token length: " + length);
        }
        this.parsedTokenLength = length;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("findHeaderLength: " + rc.getName() + "; len=" + length), (Object[])new Object[0]);
        }
        return rc;
    }

    private boolean parseHeaderName(WsByteBuffer buff) throws MalformedMessageException {
        byte[] data;
        if (null == this.parsedToken && !this.skipWhiteSpace(buff)) {
            return false;
        }
        int start = this.findCurrentBufferPosition(buff);
        int cachestart = this.bytePosition;
        TokenCodes rc = this.findHeaderLength(buff);
        if (TokenCodes.TOKEN_RC_MOREDATA.equals(rc)) {
            this.saveParsedToken(buff, start, false, 0);
            return false;
        }
        int length = this.parsedTokenLength;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("length=" + length + " pos=" + this.bytePosition + ", cachestart=" + cachestart + ", start=" + start + ", trailingWhitespace=" + this.foundTrailingWhitespace), (Object[])new Object[0]);
        }
        if (!this.foundTrailingWhitespace && null == this.parsedToken && length < this.bytePosition) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Using bytecache", (Object[])new Object[0]);
            }
            data = this.byteCache;
            start = cachestart;
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Using bytebuffer", (Object[])new Object[0]);
            }
            this.saveParsedToken(buff, start, true, 0);
            data = this.parsedToken;
            start = 0;
            length = data.length;
        }
        this.currentElem = this.getElement(this.findKey(data, start, length));
        if (-1 != this.headerChangeLimit) {
            this.currentElem.updateLastCRLFInfo(this.lastCRLFBufferIndex, this.lastCRLFPosition, this.lastCRLFisCR);
        }
        this.stateOfParsing = 1;
        this.parsedToken = null;
        this.parsedTokenLength = 0;
        this.foundTrailingWhitespace = false;
        return true;
    }

    private boolean parseHeaderValueExtract(WsByteBuffer buff) throws MalformedMessageException {
        TokenCodes tcRC;
        int log = 0;
        HeaderKeys key = this.currentElem.getKey();
        if (null != key && !key.shouldLogValue()) {
            log = 1;
        }
        if (!(tcRC = this.parseCRLFTokenExtract(buff, log)).equals(TokenCodes.TOKEN_RC_MOREDATA)) {
            this.setHeaderValue();
            this.parsedToken = null;
            this.currentElem = null;
            this.stateOfParsing = 2;
            return true;
        }
        return false;
    }

    private boolean parseHeaderValueNonExtract(WsByteBuffer buff) throws MalformedMessageException {
        if (0 == this.parsedTokenLength) {
            if (!this.skipWhiteSpace(buff)) {
                return false;
            }
            int start = this.findCurrentBufferPosition(buff);
            this.currentElem.setParseInformation(this.parseIndex, start);
        }
        if (TokenCodes.TOKEN_RC_MOREDATA.equals(this.findCRLFTokenLength(buff))) {
            return false;
        }
        this.currentElem.setValueLength(this.parsedTokenLength);
        this.addHeader(this.currentElem, true);
        this.parsedTokenLength = 0;
        this.currentElem = null;
        this.stateOfParsing = 2;
        return true;
    }

    protected TokenCodes parseTokenExtract(WsByteBuffer buff, byte bDelimiter, boolean bApproveCRLF, int log) throws MalformedMessageException {
        TokenCodes rc;
        if (null == this.parsedToken && !this.skipWhiteSpace(buff)) {
            return TokenCodes.TOKEN_RC_MOREDATA;
        }
        int start = this.findCurrentBufferPosition(buff);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("parseTokenExtract: start:" + start + " lim:" + this.byteLimit + " pos:" + this.bytePosition), (Object[])new Object[0]);
        }
        this.saveParsedToken(buff, start, !TokenCodes.TOKEN_RC_MOREDATA.equals(rc = this.findTokenLength(buff, bDelimiter, bApproveCRLF)), log);
        return rc;
    }

    protected int parseTokenNonExtract(WsByteBuffer buff, byte bDelimiter, boolean bApproveCRLF) throws MalformedMessageException {
        TokenCodes rc = this.findTokenLength(buff, bDelimiter, bApproveCRLF);
        return TokenCodes.TOKEN_RC_MOREDATA.equals(rc) ? -1 : this.parsedTokenLength;
    }

    protected void setHeaderValue() throws MalformedMessageException {
        if (null == this.parsedToken) {
            this.parsedToken = new byte[]{32};
        }
        if (this.bIsMultiLine) {
            byte[] oldValue = this.currentElem.asBytes();
            int size = oldValue.length + this.parsedToken.length + 1;
            if (size > this.limitTokenSize) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Multiline header value too large: " + size), (Object[])new Object[0]);
                }
                throw new MalformedMessageException("Multiline value length: " + size);
            }
            byte[] newValue = new byte[oldValue.length + this.parsedToken.length + 1];
            System.arraycopy(oldValue, 0, newValue, 0, oldValue.length);
            newValue[oldValue.length] = 32;
            System.arraycopy(this.parsedToken, 0, newValue, oldValue.length + 1, this.parsedToken.length);
            this.currentElem.setByteArrayValue(newValue);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Saved multiline header value [" + this.currentElem.getDebugValue() + "]"), (Object[])new Object[0]);
            }
        } else {
            this.currentElem.setByteArrayValue(this.parsedToken);
            this.addHeader(this.currentElem, true);
        }
        this.currentElem.startTracking();
    }

    private void saveParsedToken(WsByteBuffer buff, int start, boolean delim, int log) {
        byte[] temp;
        int offset;
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        int length = this.parsedTokenLength;
        this.parsedTokenLength = 0;
        if (0 > length) {
            throw new IllegalArgumentException("Negative token length: " + length);
        }
        if (bTrace && tc.isDebugEnabled()) {
            String value = GenericUtils.getEnglishString(this.parsedToken);
            if (null != value) {
                if (2 == log) {
                    value = GenericUtils.nullOutPasswords(value, (byte)10);
                } else if (1 == log) {
                    value = GenericUtils.blockContents(value);
                }
            }
            Tr.debug((TraceComponent)tc, (String)("Saving token: " + value + " len:" + length + " start:" + start + " pos:" + this.bytePosition + " delim:" + delim), (Object[])new Object[0]);
        }
        if (null != this.parsedToken) {
            offset = this.parsedToken.length;
            temp = new byte[offset + length];
            System.arraycopy(this.parsedToken, 0, temp, 0, offset);
        } else {
            offset = 0;
            temp = new byte[length];
        }
        if (!this.foundTrailingWhitespace && this.bytePosition > length) {
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"savedParsedToken - using bytecache", (Object[])new Object[0]);
            }
            int cacheStart = this.bytePosition - length;
            if (delim) {
                --cacheStart;
            }
            System.arraycopy(this.byteCache, cacheStart, temp, offset, length);
        } else {
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"savedParsedToken - pulling from buffer", (Object[])new Object[0]);
            }
            int orig = buff.position();
            buff.position(start);
            buff.get(temp, offset, length);
            buff.position(orig);
        }
        this.parsedToken = temp;
        if (bTrace && tc.isDebugEnabled()) {
            String value = GenericUtils.getEnglishString(this.parsedToken);
            if (2 == log) {
                value = GenericUtils.nullOutPasswords(value, (byte)10);
            } else if (1 == log) {
                value = GenericUtils.blockContents(value);
            }
            Tr.debug((TraceComponent)tc, (String)("Saved token [" + value + "]"), (Object[])new Object[0]);
        }
    }

    public void parsedCompactHeader(boolean flag) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("parsedCompactHeader: " + flag), (Object[])new Object[0]);
        }
        this.compactHeaderFlag = flag;
    }

    public boolean foundCompactHeader() {
        return this.compactHeaderFlag;
    }

    private static synchronized byte[] getWhiteSpace() {
        byte[] localWhitespace = whitespace;
        if (localWhitespace == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Allocating static whitespace data", (Object[])new Object[0]);
            }
            localWhitespace = new byte[1024];
            for (int i = 0; i < 1024; ++i) {
                localWhitespace[i] = 32;
            }
            whitespace = localWhitespace;
        }
        return localWhitespace;
    }

    private static class EmptyHeaderField
    implements HeaderField {
        protected EmptyHeaderField() {
        }

        public String toString() {
            return "null header";
        }

        @Override
        public byte[] asBytes() {
            return null;
        }

        @Override
        public Date asDate() throws ParseException {
            return null;
        }

        @Override
        public int asInteger() throws NumberFormatException {
            return 0;
        }

        @Override
        public String asString() {
            return null;
        }

        @Override
        public List<byte[]> asTokens(byte delimiter) {
            return new ArrayList<byte[]>();
        }

        @Override
        public HeaderKeys getKey() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }
    }
}

