/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.bundle.repository.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.aries.util.filesystem.FileSystem;
import org.apache.aries.util.filesystem.IDirectory;
import org.apache.aries.util.filesystem.IFile;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleCollisionHook;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.container.ModuleDatabase;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleRevisionBuilder;
import org.eclipse.osgi.container.SystemModule;
import org.eclipse.osgi.container.builders.OSGiManifestBuilderFactory;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.repository.Repository;
import org.osgi.service.repository.RepositoryContent;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Utils {
    private static final String HASH_TYPE = "SHA";
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    static final long serialVersionUID = 608589956844449045L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static String generateHash(TraceComponent tc, byte[] input) {
        try {
            MessageDigest digest = MessageDigest.getInstance(HASH_TYPE);
            digest.update(input);
            byte[] result = digest.digest();
            StringBuffer buff = new StringBuffer(result.length * 2);
            for (byte b : result) {
                buff.append(String.format("%02x", b));
            }
            return buff.toString();
        }
        catch (NoSuchAlgorithmException digest) {
            FFDCFilter.processException((Throwable)digest, (String)"com.ibm.ws.eba.bundle.repository.internal.Utils", (String)"89", null, (Object[])new Object[]{tc, input});
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"warn.hash.missing", (Object[])new Object[]{HASH_TYPE});
            }
            return null;
        }
    }

    public static void close(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.eba.bundle.repository.internal.Utils", (String)"106", null, (Object[])new Object[]{c});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getContents(WsResource resource) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (resource.exists()) {
            byte[] buffer = new byte[4096];
            int read = 0;
            InputStream in = null;
            try {
                in = resource.get();
                while ((read = in.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.eba.bundle.repository.internal.Utils", (String)"128", null, (Object[])new Object[]{resource});
            }
            finally {
                Utils.close(in);
            }
        }
        return out.toByteArray();
    }

    public static Collection<IFile> convertFilesetToIFiles(Collection<File> filesetFiles) {
        ArrayList<IDirectory> iFiles = new ArrayList<IDirectory>(filesetFiles.size());
        for (File f : filesetFiles) {
            IDirectory dir = FileSystem.getFSRoot((File)f);
            if (dir == null) continue;
            iFiles.add(dir);
        }
        return Collections.unmodifiableCollection(iFiles);
    }

    public static String getFileName(URL url) {
        String path = url.getPath().replace('\\', '/');
        int slashpos = path.lastIndexOf(47);
        if (slashpos == -1) {
            return path;
        }
        return path.substring(slashpos + 1, path.length());
    }

    public static String removeTrailingSlash(String str) {
        if (str != null && str.length() > 0 && str.charAt(str.length() - 1) == '/') {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static Repository createRepository(Collection<IFile> resources) {
        ModuleContainerRepository repo = new ModuleContainerRepository(new ModuleContainerAdaptorImpl().getContainer());
        for (IFile resource : resources) {
            ModuleRevisionBuilder builder = Utils.getBuilder(resource);
            if (builder == null) continue;
            try {
                URL url = resource.toURL();
                String location = url.toExternalForm();
                repo.container.install(null, location, builder, (Object)url);
            }
            catch (BundleException url) {
                FFDCFilter.processException((Throwable)url, (String)"com.ibm.ws.eba.bundle.repository.internal.Utils", (String)"176", null, (Object[])new Object[]{resources});
            }
            catch (MalformedURLException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.eba.bundle.repository.internal.Utils", (String)"178", null, (Object[])new Object[]{resources});
            }
        }
        return repo;
    }

    private static ModuleRevisionBuilder getBuilder(IFile resource) {
        IFile manFile = resource.convert().getFile(MANIFEST_PATH);
        if (manFile != null) {
            try {
                return OSGiManifestBuilderFactory.createBuilder((Map)ManifestElement.parseBundleManifest((InputStream)manFile.open(), new TreeMap(String.CASE_INSENSITIVE_ORDER)));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                FFDCFilter.processException((Throwable)unsupportedOperationException, (String)"com.ibm.ws.eba.bundle.repository.internal.Utils", (String)"191", null, (Object[])new Object[]{resource});
            }
            catch (BundleException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.eba.bundle.repository.internal.Utils", (String)"193", null, (Object[])new Object[]{resource});
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.eba.bundle.repository.internal.Utils", (String)"195", null, (Object[])new Object[]{resource});
            }
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(Utils.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class ModuleContainerAdaptorImpl
    extends ModuleContainerAdaptor {
        private final ModuleContainer container;
        static final long serialVersionUID = 7530309978818709855L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ModuleContainerAdaptorImpl() {
            ModuleDatabase moduleDatabase = new ModuleDatabase((ModuleContainerAdaptor)this);
            this.container = new ModuleContainer((ModuleContainerAdaptor)this, moduleDatabase);
        }

        ModuleContainer getContainer() {
            return this.container;
        }

        public ModuleCollisionHook getModuleCollisionHook() {
            return new ModuleCollisionHook(){
                static final long serialVersionUID = -8319376379428771022L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public void filterCollisions(int operationType, Module target, Collection<Module> collisionCandidates) {
                    collisionCandidates.clear();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            };
        }

        public ResolverHookFactory getResolverHookFactory() {
            return new ResolverHookFactory(){
                static final long serialVersionUID = 8597936207972751873L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public ResolverHook begin(Collection<BundleRevision> triggers) {
                    return new ResolverHook(){
                        static final long serialVersionUID = -2326873589932139197L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
                            collisionCandidates.clear();
                        }

                        public void filterResolvable(Collection<BundleRevision> candidates) {
                        }

                        public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
                        }

                        public void end() {
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(ModuleContainerAdaptorImpl.1.class);
                        }
                    };
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            };
        }

        public void publishContainerEvent(ModuleContainerAdaptor.ContainerEvent type, Module module, Throwable error, FrameworkListener ... listeners) {
        }

        public void publishModuleEvent(ModuleContainerAdaptor.ModuleEvent type, Module module, Module origin) {
        }

        public Module createModule(String location, long id, EnumSet<Module.Settings> settings, int startlevel) {
            return new Module(id, location, this.container, settings, startlevel){
                static final long serialVersionUID = 5021753905786455263L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public Bundle getBundle() {
                    return null;
                }

                protected void cleanup(ModuleRevision revision) {
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(3.class);
                }
            };
        }

        public SystemModule createSystemModule() {
            return new SystemModule(this.container){
                static final long serialVersionUID = 6379153072299898067L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public Bundle getBundle() {
                    return null;
                }

                protected void cleanup(ModuleRevision revision) {
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(4.class);
                }
            };
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ModuleContainerAdaptorImpl.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class WrappedContent
    implements Resource,
    RepositoryContent {
        private final String toString;
        private final List<Capability> wrappedCapabilities;
        private final List<Requirement> wrappedRequirements;
        private final URL url;
        static final long serialVersionUID = -6715015581185490828L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public WrappedContent(Resource wrapped) {
            this.toString = wrapped.toString();
            this.url = (URL)((ModuleRevision)wrapped).getRevisionInfo();
            ArrayList<WrappedCapability> caps = new ArrayList<WrappedCapability>();
            for (Capability capability : wrapped.getCapabilities(null)) {
                caps.add(new WrappedCapability(capability, this));
            }
            this.wrappedCapabilities = Collections.unmodifiableList(caps);
            ArrayList<WrappedRequirement> reqs = new ArrayList<WrappedRequirement>();
            for (Requirement requirement : wrapped.getRequirements(null)) {
                reqs.add(new WrappedRequirement(requirement, this));
            }
            this.wrappedRequirements = Collections.unmodifiableList(reqs);
        }

        public String toString() {
            return this.toString;
        }

        public List<Capability> getCapabilities(String namespace) {
            if (namespace == null) {
                return this.wrappedCapabilities;
            }
            ArrayList<Capability> caps = new ArrayList<Capability>();
            for (Capability capability : this.wrappedCapabilities) {
                if (!namespace.equals(capability.getNamespace())) continue;
                caps.add(capability);
            }
            return Collections.unmodifiableList(caps);
        }

        public List<Requirement> getRequirements(String namespace) {
            if (namespace == null) {
                return this.wrappedRequirements;
            }
            ArrayList<Requirement> reqs = new ArrayList<Requirement>();
            for (Requirement requirement : this.wrappedRequirements) {
                if (!namespace.equals(requirement.getNamespace())) continue;
                reqs.add(requirement);
            }
            return Collections.unmodifiableList(reqs);
        }

        /*
         * WARNING - void declaration
         */
        public InputStream getContent() {
            try {
                return this.url.openStream();
            }
            catch (IOException iOException) {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.eba.bundle.repository.internal.Utils$WrappedContent", (String)"387", (Object)this, (Object[])new Object[0]);
                throw new IllegalStateException((Throwable)e);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(WrappedContent.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class WrappedRequirement
    implements Requirement {
        private final Requirement wrapped;
        private final Resource contentResource;
        static final long serialVersionUID = 1545617154576291052L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        WrappedRequirement(Requirement wrapped, Resource contentResource) {
            this.wrapped = wrapped;
            this.contentResource = contentResource;
        }

        public String toString() {
            return this.wrapped.toString();
        }

        public String getNamespace() {
            return this.wrapped.getNamespace();
        }

        public Map<String, String> getDirectives() {
            return this.wrapped.getDirectives();
        }

        public Map<String, Object> getAttributes() {
            return this.wrapped.getAttributes();
        }

        public Resource getResource() {
            return this.contentResource;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(WrappedRequirement.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class WrappedCapability
    implements Capability {
        private final Capability wrapped;
        private final Resource contentResource;
        static final long serialVersionUID = -3236934305668910375L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public WrappedCapability(Capability wrapped, Resource contentResource) {
            this.wrapped = wrapped;
            this.contentResource = contentResource;
        }

        public String toString() {
            return this.wrapped.toString();
        }

        public String getNamespace() {
            return this.wrapped.getNamespace();
        }

        public Map<String, String> getDirectives() {
            return this.wrapped.getDirectives();
        }

        public Map<String, Object> getAttributes() {
            return this.wrapped.getAttributes();
        }

        public Resource getResource() {
            return this.contentResource;
        }

        Capability getWrapped() {
            return this.wrapped;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(WrappedCapability.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class ModuleContainerRepository
    implements Repository {
        final ModuleContainer container;
        static final long serialVersionUID = 163913034241849904L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ModuleContainerRepository(ModuleContainer container) {
            this.container = container;
        }

        public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> reqs) {
            FrameworkWiring frameworkWiring = this.container.getFrameworkWiring();
            HashMap<Capability, WrappedCapability> wrappedMap = new HashMap<Capability, WrappedCapability>();
            HashMap<Requirement, Collection<Capability>> result = new HashMap<Requirement, Collection<Capability>>();
            for (Requirement requirement : reqs) {
                result.put(requirement, this.wrapCapabilities(frameworkWiring.findProviders(requirement), wrappedMap));
            }
            return result;
        }

        private Collection<Capability> wrapCapabilities(Collection<BundleCapability> capabilities, Map<Capability, WrappedCapability> wrappedMap) {
            ArrayList<Capability> wrapped = new ArrayList<Capability>();
            for (Capability capability : capabilities) {
                WrappedCapability wrappedCapability = wrappedMap.get(capability);
                if (wrappedCapability == null) {
                    this.wrapResource(capability.getResource(), wrappedMap);
                    wrappedCapability = wrappedMap.get(capability);
                }
                wrapped.add(wrappedCapability);
            }
            return wrapped;
        }

        private void wrapResource(Resource resource, Map<Capability, WrappedCapability> wrappedMap) {
            WrappedContent wrappedContent = new WrappedContent(resource);
            for (Capability capability : wrappedContent.getCapabilities(null)) {
                WrappedCapability wrappedCapability = (WrappedCapability)capability;
                wrappedMap.put(wrappedCapability.getWrapped(), wrappedCapability);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ModuleContainerRepository.class);
        }
    }
}

