/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.bundle.repository.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.eba.bundle.repository.internal.blueprint.RepositoryGeneratorReady;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.obr.RepositoryAdmin;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Services {
    private final AtomicServiceReference<RepositoryAdmin> repoAdminRef = new AtomicServiceReference("repositoryAdmin");
    private final AtomicReference<RepositoryGeneratorReady> repoGeneratorRef = new AtomicReference();
    private final AtomicServiceReference<WsLocationAdmin> locationServiceRef = new AtomicServiceReference("locationService");
    private final AtomicServiceReference<org.apache.felix.bundlerepository.RepositoryAdmin> felixAdminRef = new AtomicServiceReference("felixAdmin");
    private final AtomicServiceReference<ExecutorService> executorService = new AtomicServiceReference("executorService");
    static final long serialVersionUID = -5777296239899381420L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void init(ComponentContext cctx) {
        this.repoAdminRef.activate(cctx);
        this.locationServiceRef.activate(cctx);
        this.executorService.activate(cctx);
        this.felixAdminRef.activate(cctx);
    }

    public void cleanup(ComponentContext cctx) {
        this.executorService.deactivate(cctx);
        this.locationServiceRef.deactivate(cctx);
        this.repoAdminRef.deactivate(cctx);
        this.felixAdminRef.deactivate(cctx);
    }

    public RepositoryAdmin getRepoAdmin() {
        return (RepositoryAdmin)this.repoAdminRef.getService();
    }

    public Object getRepoGenerator() {
        RepositoryGeneratorReady ready = this.repoGeneratorRef.get();
        return ready == null ? null : ready.getRepositoryGenerator();
    }

    public WsLocationAdmin getLocationService() {
        return (WsLocationAdmin)this.locationServiceRef.getService();
    }

    public org.apache.felix.bundlerepository.RepositoryAdmin getFelixAdmin() {
        return (org.apache.felix.bundlerepository.RepositoryAdmin)this.felixAdminRef.getService();
    }

    public AtomicServiceReference<RepositoryAdmin> getRepoAdminRef() {
        return this.repoAdminRef;
    }

    public AtomicServiceReference<WsLocationAdmin> getLocationServiceRef() {
        return this.locationServiceRef;
    }

    public ExecutorService getExecutorService() {
        return (ExecutorService)this.executorService.getService();
    }

    public void setRepositoryGenerator(RepositoryGeneratorReady repositoryGeneratorReady) {
        this.repoGeneratorRef.set(repositoryGeneratorReady);
    }

    public void unsetRepositoryGenerator() {
        this.repoGeneratorRef.set(null);
    }

    public void setRepositoryAdmin(ServiceReference<RepositoryAdmin> reference) {
        this.repoAdminRef.setReference(reference);
    }

    public void unsetRepositoryAdmin(ServiceReference<RepositoryAdmin> reference) {
        this.repoAdminRef.unsetReference(reference);
    }

    public void setLocationService(ServiceReference<WsLocationAdmin> reference) {
        this.locationServiceRef.setReference(reference);
    }

    public void unsetLocationService(ServiceReference<WsLocationAdmin> reference) {
        this.locationServiceRef.unsetReference(reference);
    }

    public void setExecutorService(ServiceReference<ExecutorService> reference) {
        this.executorService.setReference(reference);
    }

    public void unsetExecutorService(ServiceReference<ExecutorService> reference) {
        this.executorService.unsetReference(reference);
    }

    public void setFelixAdmin(ServiceReference<org.apache.felix.bundlerepository.RepositoryAdmin> reference) {
        this.felixAdminRef.setReference(reference);
    }

    public void unsetFelixAdmin(ServiceReference<org.apache.felix.bundlerepository.RepositoryAdmin> reference) {
        this.felixAdminRef.unsetReference(reference);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(Services.class);
    }
}

