/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.bundle.repository.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.eba.bundle.repository.BundleRepositoryHelper;
import com.ibm.ws.eba.bundle.repository.WsBundleRepositoryFactory;
import com.ibm.ws.eba.bundle.repository.WsBundleRepositoryInfo;
import com.ibm.ws.eba.bundle.repository.internal.BundleRepositoryImpl;
import com.ibm.ws.eba.bundle.repository.internal.DescriptiveFutureTask;
import com.ibm.ws.eba.bundle.repository.internal.LocalCacheRepository;
import com.ibm.ws.eba.bundle.repository.internal.ProtocolResolver;
import com.ibm.ws.eba.bundle.repository.internal.Services;
import com.ibm.ws.eba.bundle.repository.internal.WsBundleRepository;
import com.ibm.ws.eba.bundle.repository.internal.WsBundleRepositoryInfoMbeanImpl;
import com.ibm.ws.eba.bundle.repository.internal.blueprint.RepositoryGeneratorReady;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.obr.RepositoryAdmin;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BundleRepositoryFactory
implements ManagedServiceFactory,
BundleRepositoryHelper,
WsBundleRepositoryFactory {
    private static final TraceComponent tc = Tr.register(BundleRepositoryFactory.class);
    private static final long TIMEOUT_DURATION_MS = 300000L;
    static final String LOCATION_ATTRIB = "location";
    static final String PROPERTY_FILESETREF = "filesetRef";
    private final AtomicReference<BundleContext> ctx = new AtomicReference();
    private final Services services = new Services();
    private ConfigurationAdmin configAdmin;
    private final Set<String> expectedConfigurations = new HashSet<String>();
    private ServiceRegistration<ManagedServiceFactory> managedServiceFactoryReg;
    private ServiceRegistration<BundleRepositoryHelper> bundleRepositoryHelperReg;
    private final Queue<DescriptiveFutureTask<?>> pendingFutures = new LinkedBlockingQueue();
    private final UUID uid = UUID.randomUUID();
    private static final Object repoLock = new Object();
    private static final Map<String, WsBundleRepository> repoTracker = new HashMap<String, WsBundleRepository>();
    private static final Map<String, Lock> repoInstanceLocks = new HashMap<String, Lock>();
    static final long serialVersionUID = 8784429155490826424L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void computeExpectedConfigurations() {
        DescriptiveFutureTask<Void> future;
        Configuration[] configs = null;
        try {
            configs = this.configAdmin.listConfigurations("(service.factoryPid=com.ibm.ws.eba.bundle.repository)");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.eba.bundle.repository.internal.BundleRepositoryFactory", (String)"97", (Object)this, (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"List configurations error", (Object[])new Object[]{e});
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Number of configurations", (Object[])new Object[]{configs == null ? 0 : configs.length});
        }
        if (configs == null) {
            return;
        }
        Set<String> e = this.expectedConfigurations;
        synchronized (e) {
            for (Configuration config : configs) {
                this.expectedConfigurations.add(config.getPid());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Expected configurations", (Object[])new Object[]{this.expectedConfigurations});
        }
        if (this.execute(future = new DescriptiveFutureTask<Void>(new Callable<Void>(){
            static final long serialVersionUID = 8705218061902699605L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                long duration = 300000000000L;
                long until = System.nanoTime() + duration;
                Set set = BundleRepositoryFactory.this.expectedConfigurations;
                synchronized (set) {
                    while (!BundleRepositoryFactory.this.expectedConfigurations.isEmpty() && System.nanoTime() < until) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Waiting for expected configurations", (Object[])new Object[]{300000L});
                        }
                        BundleRepositoryFactory.this.expectedConfigurations.wait(300000L);
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Done waiting for expected configurations", (Object[])new Object[]{BundleRepositoryFactory.this.expectedConfigurations});
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        }, "Waiting for " + this.expectedConfigurations.size() + " expected configurations"))) {
            this.pendingFutures.add(future);
        }
    }

    private void cleanCaches() {
        for (ProtocolResolver.Protocol protocol : ProtocolResolver.Protocol.values()) {
            protocol.clean(this.services);
        }
    }

    protected void activate(ComponentContext cctx) {
        this.ctx.set(cctx.getBundleContext());
        this.services.init(cctx);
        this.cleanCaches();
        this.computeExpectedConfigurations();
        this.registerManagedServiceFactory();
        this.registerBundleRepositoryHelper();
        WsBundleRepositoryInfoMbeanImpl.setFactory(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate(ComponentContext cctx) {
        this.unregisterBundleRepositoryHelper();
        this.unregisterManagedServiceFactory();
        Object object = repoLock;
        synchronized (object) {
            for (String id : repoTracker.keySet()) {
                this.deleted(id);
            }
        }
        this.services.cleanup(cctx);
        WsBundleRepositoryInfoMbeanImpl.setFactory(null);
        this.ctx.set(null);
    }

    private void registerManagedServiceFactory() {
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        ((Dictionary)properties).put("service.pid", "com.ibm.ws.eba.bundle.repository");
        ((Dictionary)properties).put("service.vendor", "IBM");
        this.managedServiceFactoryReg = this.ctx.get().registerService(ManagedServiceFactory.class, (Object)this, properties);
    }

    /*
     * WARNING - void declaration
     */
    private void unregisterManagedServiceFactory() {
        block3: {
            if (this.managedServiceFactoryReg == null) {
                return;
            }
            try {
                this.managedServiceFactoryReg.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                void e;
                FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.eba.bundle.repository.internal.BundleRepositoryFactory", (String)"193", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"Unregister managed service factory error", (Object[])new Object[]{e});
            }
        }
    }

    private void registerBundleRepositoryHelper() {
        Hashtable<String, String> properties = new Hashtable<String, String>(1);
        ((Dictionary)properties).put("service.vendor", "IBM");
        this.bundleRepositoryHelperReg = this.ctx.get().registerService(BundleRepositoryHelper.class, (Object)this, properties);
    }

    /*
     * WARNING - void declaration
     */
    private void unregisterBundleRepositoryHelper() {
        block3: {
            if (this.bundleRepositoryHelperReg == null) {
                return;
            }
            try {
                this.bundleRepositoryHelperReg.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                void e;
                FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.eba.bundle.repository.internal.BundleRepositoryFactory", (String)"213", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"Unregister bundle repository helper error", (Object[])new Object[]{e});
            }
        }
    }

    public void deleted(String id) {
        DescriptiveFutureTask<Object> future;
        final WsBundleRepository instance = BundleRepositoryFactory.removeRepository(this.uid, id);
        if (instance != null && this.execute(future = new DescriptiveFutureTask<Object>(new Callable<Object>(){
            static final long serialVersionUID = -7069213861791848210L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object call() {
                instance.delete();
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        }, "Deleting repository " + instance.getLocation()))) {
            this.pendingFutures.add(future);
        }
    }

    public String getName() {
        return "BundleRepository";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        if (pid != null && properties != null) {
            Set<String> set;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Received configuration", (Object[])new Object[]{pid, properties});
            }
            BundleContext context = this.ctx.get();
            try {
                if (context != null) {
                    List<WsBundleRepository> repos = this.getRepositoryImpls(pid, context, properties);
                    for (WsBundleRepository repo : repos) {
                        try {
                            repo.validateConfig(properties);
                            WsBundleRepository instance = BundleRepositoryFactory.getRepository(this.uid, repo);
                            this.updateRepositoryConfig(instance, properties);
                        }
                        catch (ConfigurationException instance) {
                            void e;
                            FFDCFilter.processException((Throwable)instance, (String)"com.ibm.ws.eba.bundle.repository.internal.BundleRepositoryFactory", (String)"261", (Object)this, (Object[])new Object[]{pid, properties});
                            repo.delete();
                            throw e;
                        }
                    }
                }
                set = this.expectedConfigurations;
            }
            catch (Throwable throwable) {
                Set<String> set2 = this.expectedConfigurations;
                synchronized (set2) {
                    if (this.expectedConfigurations.remove(pid) && this.expectedConfigurations.isEmpty()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Notifying all waiting for expected configurations", (Object[])new Object[]{this.expectedConfigurations});
                        }
                        this.expectedConfigurations.notifyAll();
                    }
                }
                throw throwable;
            }
            synchronized (set) {
                if (this.expectedConfigurations.remove(pid) && this.expectedConfigurations.isEmpty()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Notifying all waiting for expected configurations", (Object[])new Object[]{this.expectedConfigurations});
                    }
                    this.expectedConfigurations.notifyAll();
                }
            }
        }
    }

    private List<WsBundleRepository> getRepositoryImpls(String pid, BundleContext context, Dictionary properties) throws ConfigurationException {
        ArrayList<WsBundleRepository> repos = new ArrayList<WsBundleRepository>();
        String url = (String)properties.get(LOCATION_ATTRIB);
        ProtocolResolver.Protocol protocol = ProtocolResolver.getProtocol(url);
        if (!protocol.equals((Object)ProtocolResolver.Protocol.notsupported)) {
            repos.add(new LocalCacheRepository(context, this.services));
        }
        if (properties.get(PROPERTY_FILESETREF) != null) {
            repos.add(new BundleRepositoryImpl(context, pid, this.services));
        }
        return repos;
    }

    private void updateRepositoryConfig(final WsBundleRepository repo, final Dictionary<String, Object> props) {
        DescriptiveFutureTask<Void> future = new DescriptiveFutureTask<Void>(new Callable<Void>(){
            static final long serialVersionUID = -6541593802137793898L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Void call() {
                repo.updateConfig(props);
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class);
            }
        }, "Updating repository " + repo.getLocation());
        if (this.execute(future)) {
            this.pendingFutures.add(future);
        }
    }

    public void setRepositoryGenerator(RepositoryGeneratorReady repositoryGeneratorReady) {
        this.services.setRepositoryGenerator(repositoryGeneratorReady);
    }

    public void unsetRepositoryGenerator(RepositoryGeneratorReady repositoryGeneratorReady) {
        this.services.unsetRepositoryGenerator();
    }

    public void setRepositoryAdmin(ServiceReference<RepositoryAdmin> reference) {
        this.services.setRepositoryAdmin(reference);
    }

    public void unsetRepositoryAdmin(ServiceReference<RepositoryAdmin> reference) {
        this.services.unsetRepositoryAdmin(reference);
    }

    public void setLocationService(ServiceReference<WsLocationAdmin> reference) {
        this.services.setLocationService(reference);
    }

    public void unsetLocationService(ServiceReference<WsLocationAdmin> reference) {
        this.services.unsetLocationService(reference);
    }

    public void setConfigurationAdmin(ConfigurationAdmin service) {
        this.configAdmin = service;
    }

    public void unsetConfigurationAdmin(ConfigurationAdmin service) {
        this.configAdmin = null;
    }

    public void setExecutorService(ServiceReference<ExecutorService> reference) {
        this.services.setExecutorService(reference);
    }

    public void unsetExecutorService(ServiceReference<ExecutorService> reference) {
        this.services.unsetExecutorService(reference);
    }

    public void setFelixAdmin(ServiceReference<org.apache.felix.bundlerepository.RepositoryAdmin> reference) {
        this.services.setFelixAdmin(reference);
    }

    public void unsetFelixAdmin(ServiceReference<org.apache.felix.bundlerepository.RepositoryAdmin> reference) {
        this.services.unsetFelixAdmin(reference);
    }

    @Override
    public void waitForConfiguredRepositories() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Waiting for repositories to be configured ", (Object[])new Object[]{this.pendingFutures.size()});
            for (DescriptiveFutureTask descriptiveFutureTask : this.pendingFutures) {
                Tr.debug((TraceComponent)tc, (String)"Future description : ", (Object[])new Object[]{descriptiveFutureTask.getMessage()});
            }
        }
        Future f = this.pendingFutures.peek();
        while (f != null) {
            try {
                f.get();
                this.pendingFutures.remove(f);
                f = this.pendingFutures.peek();
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.eba.bundle.repository.internal.BundleRepositoryFactory", (String)"379", (Object)this, (Object[])new Object[0]);
            }
            catch (ExecutionException executionException) {
                FFDCFilter.processException((Throwable)executionException, (String)"com.ibm.ws.eba.bundle.repository.internal.BundleRepositoryFactory", (String)"380", (Object)this, (Object[])new Object[0]);
            }
        }
    }

    private boolean execute(FutureTask<?> task) {
        ExecutorService executor = this.services.getExecutorService();
        if (executor != null) {
            executor.execute(task);
            return true;
        }
        Tr.error((TraceComponent)tc, (String)"error.executor.missing", (Object[])new Object[0]);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, WsBundleRepositoryInfo> getRepositories() {
        HashMap<String, WsBundleRepository> list = new HashMap<String, WsBundleRepository>();
        Object object = repoLock;
        synchronized (object) {
            for (Map.Entry<String, WsBundleRepository> entry : repoTracker.entrySet()) {
                list.put(entry.getKey(), entry.getValue());
            }
        }
        return Collections.unmodifiableMap(list);
    }

    @Override
    public String getFactoryID() {
        return this.uid.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WsBundleRepository removeRepository(UUID factoryID, String repoID) {
        String id = factoryID.toString() + "-" + repoID;
        Object object = repoLock;
        synchronized (object) {
            WsBundleRepository repo = repoTracker.get(id);
            repoTracker.remove(id);
            return repo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WsBundleRepository getRepository(UUID factoryID, WsBundleRepository repo) {
        Object object = repoLock;
        synchronized (object) {
            String id = factoryID.toString() + "-" + repo.getID();
            WsBundleRepository existing = repoTracker.get(id);
            if (existing != null) {
                return existing;
            }
            Lock lock = repoInstanceLocks.get(repo.getID());
            if (lock == null) {
                lock = new ReentrantLock();
                repoInstanceLocks.put(repo.getID(), lock);
            }
            repo.setXMLLock(lock);
            repoTracker.put(id, repo);
            return repo;
        }
    }
}

