/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.bundle.repository.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.eba.bundle.repository.internal.EmptyRepository;
import com.ibm.ws.eba.bundle.repository.internal.Services;
import com.ibm.ws.eba.bundle.repository.internal.Utils;
import com.ibm.ws.eba.bundle.repository.internal.WsBundleRepository;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.felix.bundlerepository.DataModelHelper;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Resource;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class AbstractFileRepository
implements WsBundleRepository {
    protected static final TraceComponent tc = Tr.register(AbstractFileRepository.class);
    protected final Services services;
    static final long serialVersionUID = 417507792238683669L;

    public AbstractFileRepository(Services services) {
        this.services = services;
    }

    public abstract String getName();

    protected Repository createRepository(WsResource repoXml) {
        DataModelHelper helper = this.getDataModelHelper();
        if (helper == null) {
            return new EmptyRepository();
        }
        try {
            return helper.repository(repoXml.toExternalURI().toURL());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.eba.bundle.repository.internal.AbstractFileRepository", (String)"68", (Object)this, (Object[])new Object[]{repoXml});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Failed to create repository from XML file", (Object[])new Object[]{repoXml});
            }
            return new EmptyRepository();
        }
    }

    private DataModelHelper getDataModelHelper() {
        DataModelHelper helper;
        RepositoryAdmin admin = this.services.getFelixAdmin();
        if (admin != null && (helper = admin.getHelper()) != null) {
            return helper;
        }
        Tr.warning((TraceComponent)tc, (String)"warn.missing.service", (Object[])new Object[]{"Felix RepositoryAdmin"});
        return null;
    }

    protected Repository createRepository(List<WsResource> wsresources) {
        DataModelHelper helper = this.getDataModelHelper();
        if (helper == null) {
            return new EmptyRepository();
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (WsResource wsr : wsresources) {
            try {
                Resource r = helper.createResource(wsr.toExternalURI().toURL());
                resources.add(r);
            }
            catch (MalformedURLException r) {
                FFDCFilter.processException((Throwable)r, (String)"com.ibm.ws.eba.bundle.repository.internal.AbstractFileRepository", (String)"107", (Object)this, (Object[])new Object[]{wsresources});
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.eba.bundle.repository.internal.AbstractFileRepository", (String)"108", (Object)this, (Object[])new Object[]{wsresources});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Failed to process a resource when creating a local repository", (Object[])new Object[]{wsr});
            }
        }
        Resource[] results = new Resource[resources.size()];
        resources.toArray(results);
        Repository repo = helper.repository(results);
        return repo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document loadXML(WsResource file) {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            FFDCFilter.processException((Throwable)parserConfigurationException, (String)"com.ibm.ws.eba.bundle.repository.internal.AbstractFileRepository", (String)"128", (Object)this, (Object[])new Object[]{file});
            return null;
        }
        InputStream is = null;
        try {
            is = file.get();
            Document document = builder.parse(is);
            return document;
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.eba.bundle.repository.internal.AbstractFileRepository", (String)"135", (Object)this, (Object[])new Object[]{file});
            Document document = null;
            return document;
        }
        catch (SAXException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.eba.bundle.repository.internal.AbstractFileRepository", (String)"137", (Object)this, (Object[])new Object[]{file});
            Document document = null;
            return document;
        }
        finally {
            if (is != null) {
                Utils.close(is);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean saveXML(WsResource file, Document xml) {
        Transformer trans;
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            trans = factory.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            FFDCFilter.processException((Throwable)transformerConfigurationException, (String)"com.ibm.ws.eba.bundle.repository.internal.AbstractFileRepository", (String)"155", (Object)this, (Object[])new Object[]{file, xml});
            return false;
        }
        DOMSource src = new DOMSource(xml);
        OutputStream out = null;
        try {
            out = file.putStream();
            StreamResult stream = new StreamResult(out);
            trans.transform(src, stream);
            boolean bl = true;
            return bl;
        }
        catch (TransformerException stream) {
            FFDCFilter.processException((Throwable)stream, (String)"com.ibm.ws.eba.bundle.repository.internal.AbstractFileRepository", (String)"165", (Object)this, (Object[])new Object[]{file, xml});
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.eba.bundle.repository.internal.AbstractFileRepository", (String)"167", (Object)this, (Object[])new Object[]{file, xml});
            boolean bl = false;
            return bl;
        }
        finally {
            Utils.close(out);
        }
    }
}

