/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.transport.client;

import com.ibm.ws.repository.common.enums.AttachmentLinkType;
import com.ibm.ws.repository.common.enums.AttachmentType;
import com.ibm.ws.repository.common.enums.FilterableAttribute;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.common.utils.internal.RepositoryCommonUtils;
import com.ibm.ws.repository.transport.client.AbstractRepositoryClient;
import com.ibm.ws.repository.transport.client.JSONAssetConverter;
import com.ibm.ws.repository.transport.client.RepositoryReadableClient;
import com.ibm.ws.repository.transport.exceptions.BadVersionException;
import com.ibm.ws.repository.transport.exceptions.RequestFailureException;
import com.ibm.ws.repository.transport.model.AppliesToFilterInfo;
import com.ibm.ws.repository.transport.model.Asset;
import com.ibm.ws.repository.transport.model.Attachment;
import com.ibm.ws.repository.transport.model.WlpInformation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public abstract class AbstractFileClient
extends AbstractRepositoryClient
implements RepositoryReadableClient {
    public static final String LA_HEADER_PRODUCT = "License-Agreement";
    public static final String LI_HEADER_PRODUCT = "License-Information";
    public static final String LA_HEADER_FEATURE = "IBM-License-Agreement";
    public static final String LI_HEADER_FEATURE = "IBM-License-Information";

    public List<Asset> getAllAssets() throws IOException, RequestFailureException {
        return this.readAssetsRelative("");
    }

    @Override
    public Asset getAsset(String assetId) throws IOException, BadVersionException, RequestFailureException {
        return this.getAsset(assetId, true);
    }

    @Override
    public Collection<Asset> getFilteredAssets(Map<FilterableAttribute, Collection<String>> filters) throws IOException, RequestFailureException {
        if (filters == null || this.allFiltersAreEmpty(filters)) {
            return this.getAllAssets();
        }
        Collection allAssets = this.getAllAssets();
        ArrayList<Asset> filtered = new ArrayList<Asset>();
        block0: for (Asset asset : allAssets) {
            block1: for (Map.Entry<FilterableAttribute, Collection<String>> entry : filters.entrySet()) {
                FilterableAttribute attrib = entry.getKey();
                Collection<String> values = entry.getValue();
                Collection<String> assetValues = this.getValues(attrib, asset);
                if (values == null || values.size() == 0) continue;
                for (String filterValue : values) {
                    if (!assetValues.contains(filterValue)) continue;
                    continue block1;
                }
                continue block0;
            }
            filtered.add(asset);
        }
        return filtered;
    }

    @Override
    public List<Asset> findAssets(String searchString, Collection<ResourceType> types) throws IOException, RequestFailureException {
        Collection<Asset> assets = this.getAssets(types, null, null, null);
        ArrayList<Asset> foundAssets = new ArrayList<Asset>();
        for (Asset ass : assets) {
            if (!(ass.getName() != null && ass.getName().contains(searchString) || ass.getDescription() != null && ass.getDescription().contains(searchString)) && (ass.getShortDescription() == null || !ass.getShortDescription().contains(searchString))) continue;
            foundAssets.add(ass);
        }
        return foundAssets;
    }

    protected Asset processJSON(InputStream jsonInputStream) throws FileNotFoundException, IOException, BadVersionException {
        Asset ass = JSONAssetConverter.readValue(jsonInputStream);
        return ass;
    }

    protected Asset getAsset(String assetId, boolean includeAttachments) throws FileNotFoundException, IOException, BadVersionException {
        Asset ass = this.readJson(assetId);
        ass.set_id(assetId);
        WlpInformation wlpInfo = ass.getWlpInformation();
        if (wlpInfo == null) {
            wlpInfo = new WlpInformation();
            ass.setWlpInformation(wlpInfo);
        }
        if (wlpInfo.getAppliesToFilterInfo() == null) {
            wlpInfo.setAppliesToFilterInfo(Collections.<AppliesToFilterInfo>emptyList());
        }
        if (includeAttachments && this.exists(assetId)) {
            Attachment at = new Attachment();
            at.set_id(assetId);
            at.setLinkType(AttachmentLinkType.DIRECT);
            at.setType(AttachmentType.CONTENT);
            at.setName(this.getName(assetId));
            at.setSize(this.getSize(assetId));
            at.setUrl(at.get_id());
            ass.addAttachement(at);
            if ((assetId.toLowerCase().endsWith(".jar") || assetId.toLowerCase().endsWith(".esa")) && this.hasLicenses(assetId)) {
                Map<String, Long> licensesMap = this.getLicenses(assetId);
                for (Map.Entry<String, Long> e : licensesMap.entrySet()) {
                    String lic = e.getKey();
                    String name = this.getName(lic);
                    String licId = assetId.concat(String.format("#licenses" + File.separator + "%s", name));
                    Attachment licAt = new Attachment();
                    licAt.set_id(licId);
                    licAt.setLinkType(AttachmentLinkType.DIRECT);
                    licAt.setName(name);
                    licAt.setSize(e.getValue());
                    String locString = name.substring(3);
                    if (name.startsWith("LI")) {
                        licAt.setType(AttachmentType.LICENSE_INFORMATION);
                    } else if (name.startsWith("LA")) {
                        licAt.setType(AttachmentType.LICENSE_AGREEMENT);
                    } else if (name.endsWith(".html")) {
                        licAt.setType(AttachmentType.LICENSE);
                        locString = name.substring(0, name.lastIndexOf("."));
                    }
                    if (licAt.getType() == null) continue;
                    Locale locale = RepositoryCommonUtils.localeForString(locString);
                    licAt.setLocale(locale);
                    ass.addAttachement(licAt);
                    licAt.setUrl(licAt.get_id());
                }
            }
        }
        return ass;
    }

    protected List<Asset> readAssetsRelative(String relative) throws IOException, RequestFailureException {
        Collection<String> relativePaths = this.getChildren(relative);
        ArrayList<Asset> results = new ArrayList<Asset>();
        for (String s : relativePaths) {
            if (!this.isJson(s)) continue;
            try {
                Asset ass = this.getAsset(this.getAssetIdFromJson(s), false);
                results.add(ass);
            }
            catch (BadVersionException e) {}
        }
        return results;
    }

    protected String getAssetIdFromJson(String json) {
        return json.substring(0, json.length() - 5);
    }

    protected boolean hasLicenses(String assetId) throws IOException {
        return this.getHeader(assetId, LA_HEADER_FEATURE) != null || this.getHeader(assetId, LA_HEADER_PRODUCT) != null || this.getHeader(assetId, LI_HEADER_FEATURE) != null || this.getHeader(assetId, LI_HEADER_PRODUCT) != null;
    }

    protected String getName(String relative) {
        return relative.substring(relative.lastIndexOf(File.separator) + 1);
    }

    protected boolean isJson(String relative) {
        return relative.endsWith(".json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getInputStreamToLicenseInsideZip(ZipInputStream zis, String assetId, String attachmentId) throws IOException {
        ByteArrayInputStream is = null;
        try {
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                if (!ze.isDirectory()) {
                    String name = this.getName(ze.getName().replace("/", File.separator));
                    String licId = assetId.concat(String.format("#licenses" + File.separator + "%s", name));
                    if (licId.equals(attachmentId)) {
                        int read;
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        byte[] buffer = new byte[1024];
                        int total = 0;
                        while ((read = zis.read(buffer)) != -1) {
                            baos.write(buffer, 0, read);
                            total += read;
                        }
                        if (ze.getSize() != -1L && (long)total != ze.getSize()) {
                            throw new IOException("The size of the retrieved license was wrong. Expected : " + ze.getSize() + " bytes, but actually was " + total + " bytes.");
                        }
                        byte[] content = baos.toByteArray();
                        is = new ByteArrayInputStream(content);
                    }
                }
                ze = zis.getNextEntry();
            }
        }
        finally {
            zis.closeEntry();
            zis.close();
        }
        return is;
    }

    protected abstract String getHeader(String var1, String var2) throws IOException;

    protected abstract Map<String, Long> getLicenses(String var1) throws IOException;

    protected abstract Asset readJson(String var1) throws IOException, BadVersionException;

    protected abstract boolean exists(String var1);

    protected abstract boolean hasChildren(String var1) throws IOException;

    protected abstract Collection<String> getChildren(String var1) throws IOException;

    protected abstract long getSize(String var1);
}

