/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.strategies.writeable;

import com.ibm.ws.repository.common.enums.State;
import com.ibm.ws.repository.exceptions.RepositoryBackendException;
import com.ibm.ws.repository.exceptions.RepositoryBadDataException;
import com.ibm.ws.repository.exceptions.RepositoryResourceException;
import com.ibm.ws.repository.exceptions.RepositoryResourceUpdateException;
import com.ibm.ws.repository.exceptions.RepositoryResourceValidationException;
import com.ibm.ws.repository.resources.internal.RepositoryResourceImpl;
import com.ibm.ws.repository.strategies.writeable.BaseStrategy;
import java.util.Collections;
import java.util.List;

public class AssetOnlyReplacementStrategy
extends BaseStrategy {
    private RepositoryResourceImpl _matchingResource;
    private boolean _forceReplace = false;

    public AssetOnlyReplacementStrategy() {
    }

    public AssetOnlyReplacementStrategy(RepositoryResourceImpl matching, boolean forceReplace) {
        this._matchingResource = matching;
        this._forceReplace = forceReplace;
    }

    @Override
    public void uploadAsset(RepositoryResourceImpl resource, List<RepositoryResourceImpl> matchingResources) throws RepositoryBackendException, RepositoryResourceException {
        RepositoryResourceImpl firstMatch;
        RepositoryResourceImpl repositoryResourceImpl = firstMatch = matchingResources == null || matchingResources.isEmpty() ? null : matchingResources.get(0);
        if (firstMatch == null) {
            throw new RepositoryResourceUpdateException("No matching resource found when one should have been for " + resource.getName(), null);
        }
        State initialState = firstMatch.getState();
        if (firstMatch.getState() == State.PUBLISHED) {
            firstMatch.unpublish();
        }
        if (this._forceReplace) {
            this.update(resource, firstMatch);
        } else {
            switch (resource.updateRequired(firstMatch)) {
                case UPDATE: {
                    this.update(resource, firstMatch);
                    break;
                }
                case NOTHING: {
                    break;
                }
            }
        }
        resource.moveToState(initialState);
    }

    private void update(RepositoryResourceImpl resource, RepositoryResourceImpl firstMatch) throws RepositoryBackendException, RepositoryResourceException {
        resource.overWriteAssetData(firstMatch, true);
        resource.updateAsset();
        resource.refreshFromMassive();
    }

    @Override
    public List<RepositoryResourceImpl> findMatchingResources(RepositoryResourceImpl resource) throws RepositoryResourceValidationException, RepositoryBackendException, RepositoryBadDataException {
        if (this._matchingResource != null) {
            return Collections.singletonList(this._matchingResource);
        }
        return resource.findMatchingResource();
    }
}

