/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.strategies.writeable;

import com.ibm.ws.repository.common.enums.State;
import com.ibm.ws.repository.exceptions.RepositoryBackendException;
import com.ibm.ws.repository.exceptions.RepositoryBadDataException;
import com.ibm.ws.repository.exceptions.RepositoryResourceException;
import com.ibm.ws.repository.exceptions.RepositoryResourceValidationException;
import com.ibm.ws.repository.resources.RepositoryResource;
import com.ibm.ws.repository.resources.internal.RepositoryResourceImpl;
import com.ibm.ws.repository.strategies.writeable.AddNewStrategy;
import java.util.ArrayList;
import java.util.List;

public class AddThenDeleteStrategy
extends AddNewStrategy {
    private boolean _forceReplace;
    private List<RepositoryResourceImpl> _matchingResources = null;
    private List<RepositoryResource> _deletedResources = null;

    public AddThenDeleteStrategy() {
    }

    public AddThenDeleteStrategy(State desiredStateIfMatchingFound, State desiredStateIfNoMatchingFound, boolean forceReplace) {
        this(desiredStateIfMatchingFound, desiredStateIfNoMatchingFound, forceReplace, null);
    }

    public AddThenDeleteStrategy(State desiredStateIfMatchingFound, State desiredStateIfNoMatchingFound, boolean forceReplace, RepositoryResourceImpl matchingResource) {
        this(desiredStateIfMatchingFound, desiredStateIfNoMatchingFound, forceReplace, matchingResource, null);
    }

    public AddThenDeleteStrategy(State desiredStateIfMatchingFound, State desiredStateIfNoMatchingFound, boolean forceReplace, RepositoryResourceImpl matchingResource, List<RepositoryResource> deletedResources) {
        super(desiredStateIfMatchingFound, desiredStateIfNoMatchingFound);
        this._forceReplace = forceReplace;
        if (matchingResource != null) {
            this._matchingResources = new ArrayList<RepositoryResourceImpl>();
            this._matchingResources.add(matchingResource);
        }
        this._deletedResources = deletedResources;
    }

    @Override
    public void uploadAsset(RepositoryResourceImpl resource, List<RepositoryResourceImpl> matchingResources) throws RepositoryBackendException, RepositoryResourceException {
        RepositoryResourceImpl firstMatch;
        boolean doUpdate = false;
        boolean deleteOriginal = false;
        RepositoryResourceImpl repositoryResourceImpl = firstMatch = matchingResources == null || matchingResources.isEmpty() ? null : matchingResources.get(0);
        if (this._forceReplace) {
            doUpdate = true;
            deleteOriginal = firstMatch != null;
        } else {
            switch (resource.updateRequired(firstMatch)) {
                case UPDATE: {
                    deleteOriginal = true;
                }
                case ADD: {
                    doUpdate = true;
                    break;
                }
            }
            if (!doUpdate) {
                block7: for (RepositoryResourceImpl.AttachmentResourceImpl attachment : resource.getAttachmentImpls()) {
                    switch (attachment.updateRequired(firstMatch)) {
                        case UPDATE: 
                        case ADD: {
                            deleteOriginal = true;
                            doUpdate = true;
                            break block7;
                        }
                        default: {
                            continue block7;
                        }
                    }
                }
            }
        }
        if (doUpdate) {
            super.uploadAsset(resource, matchingResources);
            if (deleteOriginal) {
                for (RepositoryResourceImpl massiveResource : matchingResources) {
                    massiveResource.delete();
                    if (this._deletedResources == null) continue;
                    this._deletedResources.add(massiveResource);
                }
            }
        } else {
            resource.copyAsset(firstMatch);
            if (matchingResources.size() > 1) {
                for (int i = 1; i < matchingResources.size(); ++i) {
                    RepositoryResourceImpl res = matchingResources.get(i);
                    res.delete();
                    if (this._deletedResources == null) continue;
                    this._deletedResources.add(res);
                }
            }
        }
        resource.refreshFromMassive();
    }

    @Override
    public List<RepositoryResourceImpl> findMatchingResources(RepositoryResourceImpl resource) throws RepositoryResourceValidationException, RepositoryBackendException, RepositoryBadDataException {
        if (this._matchingResources != null) {
            return this._matchingResources;
        }
        return resource.findMatchingResource();
    }

    @Override
    protected State getTargetState(RepositoryResourceImpl matchingResource) {
        return this.calculateTargetState(matchingResource);
    }
}

