/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.auth.data;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.auth.data.AuthData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import javax.security.auth.login.LoginException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={AuthDataProvider.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class AuthDataProvider {
    protected static final String CFG_KEY_ID = "id";
    protected static final String CFG_KEY_DISPLAY_ID = "config.displayId";
    protected static final String CFG_KEY_USER = "user";
    protected static final String CFG_KEY_PASSWORD = "password";
    private static final TraceComponent tc = Tr.register(AuthDataProvider.class, (String)"AuthData", (String)"com.ibm.ws.security.auth.data.common.internal.resources.AuthDataMessages");
    private static final String AUTH_DATA_REF_NAME = "authData";
    private static final ConcurrentServiceReferenceMap<String, AuthData> authDataMap = new ConcurrentServiceReferenceMap("authData");
    private static final ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
    private static final ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
    private static final ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
    private static final Pattern DEFAULT_NESTED_PATTERN = Pattern.compile(".*(\\[default-\\d*\\])$");
    private static final Pattern DEFAULT_PATTERN = Pattern.compile("(default-\\d*)$");
    static final long serialVersionUID = -8843995143814799858L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(name="authData", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setAuthData(ServiceReference<AuthData> authDataRef) {
        writeLock.lock();
        try {
            authDataMap.putReference((Object)this.getKey(authDataRef), authDataRef);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetAuthData(ServiceReference<AuthData> authDataRef) {
        writeLock.lock();
        try {
            authDataMap.removeReference((Object)this.getKey(authDataRef), authDataRef);
        }
        finally {
            writeLock.unlock();
        }
    }

    private String getKey(ServiceReference<AuthData> authDataRef) {
        String key = (String)authDataRef.getProperty(CFG_KEY_ID);
        if (DEFAULT_PATTERN.matcher(key).matches() || DEFAULT_NESTED_PATTERN.matcher(key).matches()) {
            key = (String)authDataRef.getProperty(CFG_KEY_DISPLAY_ID);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(ComponentContext cc) {
        writeLock.lock();
        try {
            authDataMap.activate(cc);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate(ComponentContext cc) {
        writeLock.lock();
        try {
            authDataMap.deactivate(cc);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuthData getAuthData(String authDataAlias) throws LoginException {
        readLock.lock();
        try {
            AuthData authDataConfig = (AuthData)authDataMap.getService((Object)authDataAlias);
            AuthDataProvider.validateAuthDataConfig(authDataAlias, authDataConfig);
            AuthData authData = authDataConfig;
            return authData;
        }
        finally {
            readLock.unlock();
        }
    }

    private static void validateAuthDataConfig(String authDataAlias, AuthData authDataConfig) throws LoginException {
        AuthDataProvider.validateAuthDataExists(authDataAlias, authDataConfig);
        AuthDataProvider.validateAuthDataAttribute(CFG_KEY_USER, authDataConfig.getUserName());
        AuthDataProvider.validateAuthDataAttribute(CFG_KEY_PASSWORD, authDataConfig.getPassword());
    }

    private static void validateAuthDataExists(String authDataAlias, AuthData authDataConfig) throws LoginException {
        if (authDataConfig == null) {
            Object[] traceObjects = new Object[]{authDataAlias};
            Tr.error((TraceComponent)tc, (String)"AUTH_DATA_CONFIG_ERROR_NO_SUCH_ALIAS", (Object[])traceObjects);
            throw new LoginException(TraceNLS.getFormattedMessage(AuthDataProvider.class, (String)"com.ibm.ws.security.auth.data.common.internal.resources.AuthDataMessages", (String)"AUTH_DATA_CONFIG_ERROR_NO_SUCH_ALIAS", (Object[])traceObjects, (String)"CWWKS1300E: A configuration exception has occurred. The requested authentication data alias {0} could not be found."));
        }
    }

    private static void validateAuthDataAttribute(String attribute, @Sensitive Object value) throws LoginException {
        String currentValue = null;
        currentValue = value instanceof char[] ? String.valueOf((char[])value) : (String)value;
        if (currentValue == null || currentValue.trim().length() == 0) {
            Object[] traceObjects = new Object[]{attribute};
            Tr.error((TraceComponent)tc, (String)"AUTH_DATA_CONFIG_ERROR_INCOMPLETE", (Object[])traceObjects);
            throw new LoginException(TraceNLS.getFormattedMessage(AuthDataProvider.class, (String)"com.ibm.ws.security.auth.data.common.internal.resources.AuthDataMessages", (String)"AUTH_DATA_CONFIG_ERROR_INCOMPLETE", (Object[])traceObjects, (String)"CWWKS1301E: A configuration error has occurred. The attribute {0} must be defined."));
        }
    }
}

