/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.resolver.obr.ext;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.aries.application.modelling.Consumer;
import org.apache.aries.application.modelling.ExportedPackage;
import org.apache.aries.application.modelling.ExportedService;
import org.apache.aries.application.modelling.ImportedBundle;
import org.apache.aries.application.modelling.ModelledResource;
import org.apache.aries.application.modelling.Provider;
import org.apache.aries.application.resolver.obr.impl.OBRCapability;
import org.apache.aries.application.resolver.obr.impl.RequirementImpl;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resource;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleResource
implements Resource {
    private final ModelledResource _modelledBundle;
    private final Collection<Capability> _capabilities;
    private final Collection<Requirement> _requirements;
    private final String _displayName;
    private Logger logger = LoggerFactory.getLogger(BundleResource.class);

    public BundleResource(BundleResource br, Collection<Capability> extraCapabilities, Collection<Requirement> extraRequirements) {
        this._modelledBundle = br._modelledBundle;
        this._capabilities = new ArrayList<Capability>(br._capabilities);
        this._requirements = new ArrayList<Requirement>(br._requirements);
        this._displayName = new String(br._displayName);
        if (extraCapabilities != null) {
            this._capabilities.addAll(extraCapabilities);
        }
        if (extraRequirements != null) {
            this._requirements.addAll(extraRequirements);
        }
    }

    public BundleResource(ModelledResource mb, RepositoryAdmin repositoryAdmin) {
        String possibleDisplayName;
        this.logger.debug("Method entry: {}, args {}", (Object)"BundleResource", (Object)mb);
        this._modelledBundle = mb;
        this._capabilities = new ArrayList<Capability>();
        this._capabilities.add(new OBRCapability((Provider)this._modelledBundle.getExportedBundle(), repositoryAdmin));
        for (ExportedPackage pkg : this._modelledBundle.getExportedPackages()) {
            this._capabilities.add(new OBRCapability((Provider)pkg, repositoryAdmin));
        }
        for (ExportedService svc : this._modelledBundle.getExportedServices()) {
            this._capabilities.add(new OBRCapability((Provider)svc, repositoryAdmin));
        }
        this._requirements = new ArrayList<Requirement>();
        for (ExportedPackage pkg : this._modelledBundle.getImportedPackages()) {
            this._requirements.add(new RequirementImpl((Consumer)pkg));
        }
        for (ExportedService svc : this._modelledBundle.getImportedServices()) {
            this._requirements.add(new RequirementImpl((Consumer)svc));
        }
        for (ImportedBundle requiredBundle : this._modelledBundle.getRequiredBundles()) {
            this._requirements.add(new RequirementImpl((Consumer)requiredBundle));
        }
        if (mb.isFragment()) {
            this._requirements.add(new RequirementImpl((Consumer)mb.getFragmentHost()));
        }
        this._displayName = (possibleDisplayName = (String)mb.getExportedBundle().getAttributes().get("presentationname")) == null ? mb.getSymbolicName() : possibleDisplayName;
        this.logger.debug("Method exit: {}, returning {}", (Object)"BundleResource");
    }

    public ModelledResource getModelledResource() {
        return this._modelledBundle;
    }

    public Capability[] getCapabilities() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getCapabilities");
        Capability[] result = this._capabilities.toArray(new Capability[this._capabilities.size()]);
        this.logger.debug("Method exit: {}, returning {}", (Object)"getCapabilities", (Object)result);
        return result;
    }

    public String[] getCategories() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getCategories");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getCategories", null);
        return null;
    }

    public String getId() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getId");
        String id = this._modelledBundle.getSymbolicName() + '/' + this._modelledBundle.getVersion();
        this.logger.debug("Method exit: {}, returning {}", (Object)"getId", (Object)id);
        return id;
    }

    public String getPresentationName() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getPresentationName");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getPresentationName", (Object)this._displayName);
        return this._displayName;
    }

    public Map getProperties() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getProperties");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getProperties", null);
        return null;
    }

    public Requirement[] getRequirements() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getRequirements");
        Requirement[] result = this._requirements.toArray(new Requirement[this._requirements.size()]);
        this.logger.debug("Method exit: {}, returning {}", (Object)"getRequirements", (Object)result);
        return result;
    }

    public String getSymbolicName() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getSymbolicName");
        String result = this._modelledBundle.getSymbolicName();
        this.logger.debug("Method exit: {}, returning {}", (Object)"getSymbolicName", (Object)result);
        return result;
    }

    public URL getURL() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getURL");
        URL url = null;
        try {
            URI uri = new URI(this._modelledBundle.getLocation());
            url = uri.toURL();
        }
        catch (URISyntaxException e) {
            this.logger.error(e.getMessage());
        }
        catch (MalformedURLException e) {
            this.logger.error(e.getMessage());
        }
        this.logger.debug("Method exit: {}, returning {}", (Object)"getURL", (Object)url);
        return url;
    }

    public Version getVersion() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getVersion");
        Version v = new Version(this._modelledBundle.getVersion());
        this.logger.debug("Method exit: {}, returning {}", (Object)"getVersion", (Object)v);
        return v;
    }

    public Long getSize() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getSize");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getSize", (Object)5L);
        return 5L;
    }

    public String getURI() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getURI");
        String uri = this._modelledBundle.getLocation();
        this.logger.debug("Method exit: {}, returning {}", (Object)"getURI", (Object)uri);
        return uri;
    }

    public boolean isLocal() {
        this.logger.debug("Method entry: {}, args {}", (Object)"isLocal");
        this.logger.debug("Method exit: {}, returning {}", (Object)"isLocal", (Object)false);
        return false;
    }
}

