/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.store.db;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.serialization.SerializationService;
import com.ibm.ws.session.store.common.BackedSession;
import com.ibm.ws.session.store.common.LoggingUtil;
import com.ibm.ws.session.store.db.DatabaseHashMap;
import com.ibm.ws.session.store.db.DatabaseStoreService;
import com.ibm.wsspi.session.IStoreCallback;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.transaction.UserTransaction;

public class DatabaseSession
extends BackedSession {
    private static final long serialVersionUID = 3831254703056795406L;
    private static final String methodClassName = "DatabaseSession";
    private boolean populatedAppData = false;
    protected boolean usingMultirow = false;
    private static final int GET_SWAPPABLE_DATA = 0;
    private static final int GET_SWAPPABLE_LISTENERS = 1;
    private static final int GET_SINGLE_ROW_APP_DATA = 2;
    private static final int GET_MULTI_ROW_APP_DATA = 3;
    private static final String[] methodNames = new String[]{"getSwappableData", "getSwappableListeners", "getSingleRowAppData", "getMultiRowAppData"};

    public DatabaseSession(DatabaseHashMap sessions, String id, IStoreCallback storeCallback) {
        super(sessions, id, storeCallback);
        this.usingMultirow = this._smc.isUsingMultirow();
    }

    public DatabaseSession() {
    }

    protected DatabaseStoreService getDatabaseStoreService() {
        return ((DatabaseHashMap)this._sessions).getDatabaseStoreService();
    }

    @Override
    protected SerializationService getSerializationService() {
        return this.getDatabaseStoreService().getSerializationService();
    }

    @Override
    protected UserTransaction getUserTransaction() {
        return this.getDatabaseStoreService().getUserTransaction();
    }

    @Override
    public Hashtable getSwappableData() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[0]);
        }
        if (this.mSwappableData == null) {
            if (!(this.isNew() || this.usingMultirow || this.populatedAppData)) {
                this.getSingleRowAppData();
            }
            if (this.mSwappableData == null) {
                this.mSwappableData = new Hashtable();
                if (this.isNew()) {
                    this.populatedAppData = true;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[0]);
        }
        return this.mSwappableData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getSwappableListeners(short requestedListener) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[1]);
        }
        short thisListenerFlag = this.getListenerFlag();
        boolean rc = false;
        if (thisListenerFlag == requestedListener || thisListenerFlag == 3) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[1], "loading db data because we have listener match for " + requestedListener);
            }
            rc = true;
            if (!this.populatedAppData) {
                try {
                    this._sessions.getIStore().setThreadContext();
                    if (this.usingMultirow) {
                        this.getMultiRowAppData();
                    } else {
                        this.getSingleRowAppData();
                    }
                }
                finally {
                    this._sessions.getIStore().unsetThreadContext();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[1]);
        }
        return rc;
    }

    public synchronized Enumeration getAttributeNames() {
        if (!this.populatedAppData) {
            if (this.usingMultirow) {
                this.getMultiRowAppData();
            } else {
                this.getSingleRowAppData();
            }
        }
        return super.getAttributeNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSingleRowAppData() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[2]);
        }
        this.populatedAppData = true;
        Hashtable swappable = (Hashtable)((DatabaseHashMap)this._sessions).getValue(this.getId(), this);
        this.setSwappableData(swappable);
        Hashtable hashtable = this._attributeNames;
        synchronized (hashtable) {
            this.refillAttrNames(swappable);
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[2]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMultiRowAppData() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[3]);
        }
        this.populatedAppData = true;
        Hashtable swappable = this.getSwappableData();
        Hashtable props = (Hashtable)((DatabaseHashMap)this._sessions).getAllValues(this);
        if (props != null) {
            Enumeration kys = props.keys();
            while (kys.hasMoreElements()) {
                Object key = kys.nextElement();
                swappable.put(key, props.get(key));
            }
            Hashtable hashtable = this._attributeNames;
            synchronized (hashtable) {
                this.refillAttrNames(swappable);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[3]);
        }
    }

    public synchronized void invalidate() {
        this.invalidate(true);
    }

    public boolean getPopulatedAppData() {
        return this.populatedAppData;
    }
}

