/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.JSSEProvider;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.internal.GenericSSLConfigService;
import com.ibm.ws.ssl.internal.KeystoreConfig;
import com.ibm.ws.ssl.internal.RepertoireConfigService;
import com.ibm.ws.ssl.optional.SSLSupportOptional;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, configurationPid={"com.ibm.ws.ssl.default"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM"}, xmlns="http://felix.apache.org/xmlns/scr/v1.2.0-felix")
public class SSLComponent
extends GenericSSLConfigService
implements SSLSupportOptional {
    private static final TraceComponent tc = Tr.register(SSLComponent.class);
    protected static final String MY_ALIAS = "sslDefault";
    private final Map<String, RepertoireConfigService> repertoireMap = new HashMap<String, RepertoireConfigService>();
    private final Map<String, Map<String, String>> repertoirePropertiesMap = new HashMap<String, Map<String, String>>();
    private final Map<String, WSKeyStore> keystoreIdMap = new HashMap<String, WSKeyStore>();
    private final Map<String, WSKeyStore> keystorePidMap = new HashMap<String, WSKeyStore>();
    private volatile WsLocationAdmin locSvc;
    private boolean activated;

    @Activate
    protected synchronized Map<String, Object> activate(Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Activated: " + properties), (Object[])new Object[0]);
        }
        super.activate(MY_ALIAS, properties);
        this.activated = true;
        Map<String, Object> ret = this.processConfig(true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("activate return: " + ret), (Object[])new Object[0]);
        }
        return ret;
    }

    @Deactivate
    protected synchronized Map<String, Object> deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Deactivated: " + reason), (Object[])new Object[0]);
        }
        super.deactivate(MY_ALIAS, reason);
        this.repertoireMap.clear();
        this.keystoreIdMap.clear();
        this.keystorePidMap.clear();
        Map<String, Object> props = this.processConfig(true);
        this.activated = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("deactivate return: " + props), (Object[])new Object[0]);
        }
        return props;
    }

    @Modified
    protected synchronized Map<String, Object> modified(Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Modified: " + properties), (Object[])new Object[0]);
        }
        super.modified(MY_ALIAS, properties);
        Map<String, Object> ret = this.processConfig(true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("modified return: " + ret), (Object[])new Object[0]);
        }
        return ret;
    }

    @Reference(service=KeystoreConfig.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, target="(id=*)")
    protected synchronized Map<String, Object> setKeyStore(KeystoreConfig config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Adding keystore: " + config.getId()), (Object[])new Object[0]);
        }
        Map<String, Object> ret = this.addKeyStores(false, config);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("setKeyStore return: " + ret), (Object[])new Object[0]);
        }
        return ret;
    }

    protected synchronized void updatedKeyStore(KeystoreConfig config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Updating keystore: " + config.getId()), (Object[])new Object[0]);
        }
        this.addKeyStores(false, config);
    }

    protected synchronized Map<String, Object> unsetKeyStore(KeystoreConfig config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Removing keystore: " + config.getId()), (Object[])new Object[0]);
        }
        this.keystoreIdMap.remove(config.getId());
        this.keystorePidMap.remove(config.getPid());
        KeyStoreManager.getInstance().clearKeyStoreFromMap(config.getId());
        Iterator<Map.Entry<String, RepertoireConfigService>> it = this.repertoireMap.entrySet().iterator();
        while (it.hasNext()) {
            RepertoireConfigService rep = it.next().getValue();
            if (rep.getKeyStore() != config && rep.getTrustStore() != config) continue;
            it.remove();
            this.repertoirePropertiesMap.remove(rep.getAlias());
        }
        Map<String, Object> ret = this.processConfig(true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("unsetKeyStore return: " + ret), (Object[])new Object[0]);
        }
        return ret;
    }

    private Map<String, Object> addKeyStores(boolean updateSSLConfigManager, KeystoreConfig ... keystores) {
        for (KeystoreConfig config : keystores) {
            WSKeyStore keystore = config.getKeyStore();
            if (keystore == this.keystoreIdMap.put(config.getId(), keystore)) continue;
            updateSSLConfigManager = true;
            this.keystorePidMap.put(config.getPid(), keystore);
        }
        return this.processConfig(updateSSLConfigManager);
    }

    @Reference(service=RepertoireConfigService.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, target="(id=*)")
    protected synchronized Map<String, Object> setRepertoire(RepertoireConfigService config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Adding repertoire: " + config.getAlias()), (Object[])new Object[0]);
        }
        Map<String, String> properties = config.getProperties();
        this.repertoireMap.put(config.getAlias(), config);
        this.repertoirePropertiesMap.put(config.getAlias(), properties);
        Map<String, Object> ret = this.addKeyStores(true, config.getKeyStore(), config.getTrustStore());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("setRepertoire return: " + ret), (Object[])new Object[0]);
        }
        return ret;
    }

    protected synchronized Map<String, Object> updatedRepertoire(RepertoireConfigService config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Updating repertoire: " + config.getAlias()), (Object[])new Object[0]);
        }
        Map<String, String> properties = config.getProperties();
        this.repertoirePropertiesMap.put(properties.get("id"), properties);
        Map<String, Object> ret = this.addKeyStores(true, config.getKeyStore(), config.getTrustStore());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("updatedRepertoire return: " + ret), (Object[])new Object[0]);
        }
        return ret;
    }

    protected synchronized Map<String, Object> unsetRepertoire(RepertoireConfigService config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Removing repertoire: " + config.getAlias()), (Object[])new Object[0]);
        }
        this.repertoireMap.remove(config.getAlias());
        this.repertoirePropertiesMap.remove(config.getAlias());
        Map<String, Object> ret = this.processConfig(this.repertoirePropertiesMap.remove(config.getAlias()) != null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("unsetRepertoire return: " + ret), (Object[])new Object[0]);
        }
        return ret;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setLocMgr(WsLocationAdmin locSvc) {
        this.locSvc = locSvc;
    }

    protected void unsetLocMgr(ServiceReference<WsLocationAdmin> ref) {
    }

    private Map<String, Object> processConfig(boolean updateSSLConfigManager) {
        HashMap<String, Object> serviceProps;
        block7: {
            if (!this.activated) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Not yet activated, can not process config", (Object[])new Object[0]);
                }
                return null;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Processing configuration", (Object[])new Object[0]);
            }
            boolean isServer = this.locSvc.resolveString("${wlp.process.type}").equals("server");
            serviceProps = new HashMap<String, Object>(this.config);
            serviceProps.put("repertoireIds", this.repertoireMap.keySet().toArray(new String[this.repertoireMap.size()]));
            serviceProps.put("keystoreIds", this.keystoreIdMap.keySet().toArray(new String[this.keystoreIdMap.size()]));
            if (updateSSLConfigManager) {
                try {
                    SSLConfigManager.getInstance().initializeSSL(this.getGlobalProps(), this.getRepertoireProps(), this.getKeyStores(), true, isServer);
                }
                catch (SSLException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block7;
                    Tr.event((TraceComponent)tc, (String)("Exception processing SSL configuration; " + e), (Object[])new Object[0]);
                }
            }
        }
        if (!this.repertoireMap.isEmpty() && !this.keystoreIdMap.isEmpty()) {
            serviceProps.put("SSLSupport", "active");
        }
        return serviceProps;
    }

    Map<String, String> getGlobalProps() {
        Map<String, String> props = this.getProperties();
        String repertoire = props.get("sslRef");
        if (repertoire != null) {
            props.put("com.ibm.ssl.defaultAlias", repertoire);
        } else {
            props.put("com.ibm.ssl.defaultAlias", "defaultSSLConfig");
        }
        return props;
    }

    Map<String, Map<String, String>> getRepertoireProps() {
        return this.repertoirePropertiesMap;
    }

    Map<String, WSKeyStore> getKeyStores() {
        HashMap<String, WSKeyStore> ret = new HashMap<String, WSKeyStore>(this.keystoreIdMap);
        ret.putAll(this.keystorePidMap);
        return ret;
    }

    @Override
    public synchronized JSSEHelper getJSSEHelper() {
        return JSSEHelper.getInstance();
    }

    @Override
    public JSSEProvider getJSSEProvider() {
        return JSSEProviderFactory.getInstance();
    }

    @Override
    public JSSEProvider getJSSEProvider(String providerName) {
        return JSSEProviderFactory.getInstance(providerName);
    }
}

