/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ssl.KeyStoreService;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.wsspi.ssl.SSLSupport;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(service={KeyStoreService.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class KeyStoreServiceImpl
implements KeyStoreService {
    KeyStoreManager ksMgr;
    private static final TraceComponent tc = Tr.register(KeyStoreServiceImpl.class);

    public KeyStoreServiceImpl() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"<init>", (Object[])new Object[0]);
        }
    }

    @Reference(service=SSLSupport.class)
    protected void setSSLSupport(SSLSupport ssl2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("setSSLSupport: " + ssl2), (Object[])new Object[0]);
        }
    }

    protected void unsetSSLSupport(SSLSupport ssl2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("unsetSSLSupport: " + ssl2), (Object[])new Object[0]);
        }
    }

    protected void activate() {
        this.ksMgr = KeyStoreManager.getInstance();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"activate", (Object[])new Object[0]);
        }
    }

    protected void deactivate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"deactivate", (Object[])new Object[0]);
        }
    }

    @Override
    public String getKeyStoreLocation(String keyStoreName) throws KeyStoreException {
        WSKeyStore ks = this.ksMgr.getKeyStore(keyStoreName);
        if (ks != null) {
            return ks.getLocation();
        }
        throw new KeyStoreException("The keystore [" + keyStoreName + "] is not present in the configuration");
    }

    @Override
    public Collection<String> getTrustedCertEntriesInKeyStore(String keyStoreName) throws KeyStoreException {
        try {
            KeyStore ks = this.ksMgr.getJavaKeyStore(keyStoreName);
            if (ks != null) {
                HashSet<String> trustedCerts = new HashSet<String>();
                Enumeration<String> aliases = ks.aliases();
                if (aliases != null) {
                    while (aliases.hasMoreElements()) {
                        String alias = aliases.nextElement();
                        if (!ks.isCertificateEntry(alias)) continue;
                        trustedCerts.add(alias);
                    }
                }
                return trustedCerts;
            }
            throw new KeyStoreException("The keystore [" + keyStoreName + "] is not present in the configuration");
        }
        catch (KeyStoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KeyStoreException("Unexpected error while loading the request trusted certificate entries from keystore: " + keyStoreName, e);
        }
    }

    @Override
    public Certificate getCertificateFromKeyStore(String keyStoreName, String alias) throws KeyStoreException, CertificateException {
        try {
            KeyStore ks = this.ksMgr.getJavaKeyStore(keyStoreName);
            if (ks == null) {
                throw new KeyStoreException("The keystore [" + keyStoreName + "] is not present in the configuration");
            }
            if (!ks.isCertificateEntry(alias) && !ks.isKeyEntry(alias)) {
                throw new CertificateException("The alias [" + alias + "] is not present in the KeyStore as a certificate entry");
            }
            return ks.getCertificate(alias);
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (KeyStoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KeyStoreException("Unexpected error while loading the request Certificate for alias [" + alias + "] from keystore: " + keyStoreName, e);
        }
    }

    @Override
    public X509Certificate getX509CertificateFromKeyStore(String keyStoreName, String alias) throws KeyStoreException, CertificateException {
        try {
            KeyStore ks = this.ksMgr.getJavaKeyStore(keyStoreName);
            if (ks == null) {
                throw new KeyStoreException("The keystore [" + keyStoreName + "] is not present in the configuration");
            }
            if (!ks.isCertificateEntry(alias) && !ks.isKeyEntry(alias)) {
                throw new CertificateException("The alias [" + alias + "] is not present in the KeyStore as a certificate entry");
            }
            Certificate cert = ks.getCertificate(alias);
            if (cert instanceof X509Certificate) {
                return (X509Certificate)cert;
            }
            throw new CertificateException("The alias [" + alias + "] is not an instance of X509Certificate");
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (KeyStoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KeyStoreException("Unexpected error while loading the request X509Certificate for alias [" + alias + "] from keystore: " + keyStoreName, e);
        }
    }

    @Override
    public PrivateKey getPrivateKeyFromKeyStore(String keyStoreName, String alias, @Sensitive String keyPassword) throws KeyStoreException, CertificateException {
        try {
            WSKeyStore wsKS = this.ksMgr.getKeyStore(keyStoreName);
            if (wsKS == null) {
                throw new KeyStoreException("The WSKeyStore [" + keyStoreName + "] is not present in the configuration");
            }
            Key key = wsKS.getKey(alias, keyPassword);
            if (key instanceof PrivateKey) {
                return (PrivateKey)key;
            }
            throw new CertificateException("The alias [" + alias + "] is not an instance of PrivateKey");
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (KeyStoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KeyStoreException("Unexpected error while loading the requested private key for alias [" + alias + "] from keystore: " + keyStoreName, e);
        }
    }

    @Override
    public PrivateKey getPrivateKeyFromKeyStore(String keyStoreName) throws KeyStoreException, CertificateException {
        try {
            WSKeyStore wsKS = this.ksMgr.getKeyStore(keyStoreName);
            if (wsKS == null) {
                throw new KeyStoreException("The WSKeyStore [" + keyStoreName + "] is not present in the configuration");
            }
            String keyAlias = null;
            Enumeration<String> aliases = wsKS.aliases();
            if (aliases != null) {
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    if (!wsKS.isKeyEntry(alias)) continue;
                    if (keyAlias != null) {
                        return null;
                    }
                    keyAlias = alias;
                }
            }
            if (keyAlias != null) {
                Key key = wsKS.getKey(keyAlias, null);
                if (key instanceof PrivateKey) {
                    return (PrivateKey)key;
                }
                throw new CertificateException("The alias [" + keyAlias + "] is not an instance of PrivateKey");
            }
            return null;
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (KeyStoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KeyStoreException("Unexpected error while loading the private key for alias from keystore: " + keyStoreName, e);
        }
    }

    @Override
    public X509Certificate getX509CertificateFromKeyStore(String keyStoreName) throws KeyStoreException, CertificateException {
        try {
            KeyStore ks = this.ksMgr.getJavaKeyStore(keyStoreName);
            if (ks == null) {
                throw new KeyStoreException("The keystore [" + keyStoreName + "] is not present in the configuration");
            }
            String keyAlias = null;
            Enumeration<String> aliases = ks.aliases();
            if (aliases != null) {
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    if (!ks.isKeyEntry(alias)) continue;
                    if (keyAlias != null) {
                        return null;
                    }
                    keyAlias = alias;
                }
            }
            if (keyAlias != null) {
                WSKeyStore wsKS = this.ksMgr.getKeyStore(keyStoreName);
                if (wsKS == null) {
                    throw new CertificateException("The WSKeyStore [" + keyStoreName + "] is not present in the configuration");
                }
                Certificate cert = ks.getCertificate(keyAlias);
                if (cert instanceof X509Certificate) {
                    return (X509Certificate)cert;
                }
                throw new CertificateException("The alias [" + keyAlias + "] is not an instance of X509Certificate");
            }
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (KeyStoreException e) {
            throw e;
        }
        catch (SSLException e) {
            throw new KeyStoreException(e.getLocalizedMessage(), e);
        }
        catch (Exception e) {
            throw new KeyStoreException("Unexpected error while loading the private key for alias from keystore: " + keyStoreName, e);
        }
        return null;
    }

    @Override
    public void addCertificateToKeyStore(String keyStoreName, String alias, Certificate certificate) throws KeyStoreException, CertificateException {
        try {
            WSKeyStore wks = this.ksMgr.getKeyStore(keyStoreName);
            if (wks == null) {
                throw new KeyStoreException("The keystore [" + keyStoreName + "] is not present in the configuration");
            }
            wks.setCertificateEntry(alias, certificate);
            wks.store();
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (KeyStoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KeyStoreException("Unexpected error while adding the Certificate for alias [" + alias + "] to keystore: " + keyStoreName, e);
        }
    }
}

