/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.util.HashMap;
import java.util.Map;

public abstract class GenericSSLConfigService {
    private static final TraceComponent tc = Tr.register(GenericSSLConfigService.class);
    protected volatile Map<String, Object> config = null;
    private volatile Map<String, String> myProps = null;

    protected void activate(String id, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("activate " + id), (Object[])new Object[]{properties});
        }
        this.config = properties;
    }

    protected void deactivate(String id, int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("deactivate " + id + ", reason=" + reason), (Object[])new Object[0]);
        }
    }

    protected void modified(String id, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("modified " + id), (Object[])new Object[]{properties});
        }
        this.config = properties;
        this.myProps = null;
    }

    public Map<String, String> getProperties() {
        Map<String, String> localProps = this.myProps;
        if (localProps == null) {
            localProps = new HashMap<String, String>();
            if (this.config != null && !this.config.isEmpty()) {
                for (Map.Entry<String, Object> entry : this.config.entrySet()) {
                    if (entry.getValue() instanceof String) {
                        localProps.put(entry.getKey(), (String)entry.getValue());
                        continue;
                    }
                    if (!(entry.getValue() instanceof Boolean)) continue;
                    Boolean boolVal = (Boolean)entry.getValue();
                    localProps.put(entry.getKey(), boolVal.toString());
                }
            }
            this.myProps = localProps;
        }
        return localProps;
    }
}

