/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.core;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLConfig;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.ConsoleWrapper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.ThreadManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import com.ibm.ws.ssl.provider.AbstractJSSEProvider;
import com.ibm.wsspi.ssl.TrustManagerExtendedInfo;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class WSX509TrustManager
implements X509TrustManager {
    private static final TraceComponent tc = Tr.register(WSX509TrustManager.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");
    private static final int MAX_MSG_LEN = 79;
    private static final String INDENT = "           ";
    private final TrustManager[] tm;
    private final String tsCfgAlias;
    private final String tsFile;
    private Map<String, Object> extendedInfo;
    private String peerHost;
    private final SSLConfig config;
    boolean isDoubleByteSystem = false;
    boolean isServer = true;
    boolean autoAccept = false;
    private final ConsoleWrapper stdin;
    private final PrintStream stdout;

    protected WSX509TrustManager(TrustManager[] tmArray, ConsoleWrapper stdin, PrintStream stdout, boolean isServer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"WSX509TrustManager", (Object[])new Object[0]);
        }
        this.isServer = isServer;
        this.stdin = stdin;
        this.stdout = stdout;
        this.config = null;
        this.tsCfgAlias = null;
        this.tsFile = null;
        this.tm = (TrustManager[])tmArray.clone();
        this.autoAccept = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"WSX509TrustManager");
        }
    }

    public WSX509TrustManager(TrustManager[] tmArray, Map<String, Object> connectionInfo, SSLConfig sslConfig, String trustStoreAlias, String trustStoreFilename) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"WSX509TrustManager", (Object[])new Object[]{connectionInfo, trustStoreFilename});
        }
        this.tm = (TrustManager[])tmArray.clone();
        this.tsFile = trustStoreFilename;
        this.tsCfgAlias = trustStoreAlias;
        this.config = sslConfig;
        this.extendedInfo = connectionInfo;
        this.isServer = SSLConfigManager.getInstance().isServerProcess();
        this.stdin = new ConsoleWrapper(System.console(), System.err);
        this.stdout = System.out;
        this.autoAccept = this.getAutoAccept();
        if (this.extendedInfo != null) {
            this.peerHost = (String)this.extendedInfo.get("com.ibm.ssl.remoteHost");
            for (TrustManager tmgr : tmArray) {
                if (!(tmgr instanceof TrustManagerExtendedInfo)) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Adding extended info to TrustManager " + tmgr.getClass().getName()), (Object[])new Object[0]);
                }
                ((TrustManagerExtendedInfo)((Object)tmgr)).setExtendedInfo(this.extendedInfo);
                ((TrustManagerExtendedInfo)((Object)tmgr)).setSSLConfig(sslConfig);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"WSX509TrustManager");
        }
    }

    private boolean getAutoAccept() {
        boolean acceptCert = false;
        String acceptProperty = System.getProperty("autoAcceptSignerCertificate");
        if (acceptProperty != null) {
            acceptCert = Boolean.valueOf(acceptProperty);
        }
        return acceptCert;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkClientTrusted", (Object[])new Object[0]);
        }
        this.extendedInfo = JSSEHelper.getInstance().getInboundConnectionInfo();
        if (this.extendedInfo != null) {
            this.peerHost = (String)this.extendedInfo.get("com.ibm.ssl.remoteHost");
        }
        if (this.peerHost == null || this.peerHost.equals("")) {
            this.peerHost = "unknown";
        }
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                for (int j = 0; j < chain.length; ++j) {
                    Tr.debug((TraceComponent)tc, (String)("chain[" + j + "]: " + chain[j].getSubjectDN()), (Object[])new Object[0]);
                }
            }
            for (int i = 0; i < this.tm.length; ++i) {
                if (this.tm[i] == null || !(this.tm[i] instanceof X509TrustManager)) continue;
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Delegating to X509TrustManager: " + this.tm[i].getClass().getName()), (Object[])new Object[0]);
                    }
                    ((X509TrustManager)this.tm[i]).checkClientTrusted(chain, authType);
                    continue;
                }
                catch (Exception e) {
                    Exception excpt;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Certificate Exception occurred: " + e.getMessage()), (Object[])new Object[0]);
                    }
                    if ((excpt = e).getClass().toString().startsWith("class com.ibm.jsse2")) {
                        excpt = (Exception)excpt.getCause();
                    }
                    FFDCFilter.processException((Throwable)excpt, (String)this.getClass().getName(), (String)"checkClientTrusted", (Object)this, (Object[])new Object[]{chain, authType});
                    this.printClientHandshakeError(this.config, this.tsFile, e, chain);
                    if (excpt instanceof CertificateException) {
                        throw (CertificateException)excpt;
                    }
                    throw new CertificateException(excpt.getMessage());
                }
            }
        }
        catch (Throwable t) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught exception in checkClientTrusted.", (Object[])new Object[]{t});
            }
            FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"checkClientTrusted", (Object)this, (Object[])new Object[]{chain, authType});
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof CertificateException) {
                throw (CertificateException)t;
            }
            throw new CertificateException(t);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkClientTrusted");
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        Map<String, Object> currentConnectionInfo;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkServerTrusted", (Object[])new Object[0]);
        }
        if ((currentConnectionInfo = ThreadManager.getInstance().getOutboundConnectionInfoInternal()) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("original peerHost: " + this.peerHost), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("currentConnectionInfo: " + currentConnectionInfo), (Object[])new Object[0]);
            }
            this.peerHost = (String)currentConnectionInfo.get("com.ibm.ssl.remoteHost");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("current peerHost: " + this.peerHost), (Object[])new Object[0]);
            }
        } else {
            currentConnectionInfo = this.extendedInfo;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("currentConnectionInfo from extendedInfo: " + currentConnectionInfo), (Object[])new Object[0]);
            }
        }
        this.extendedInfo = JSSEHelper.getInstance().getOutboundConnectionInfo();
        if (this.extendedInfo != null) {
            this.peerHost = (String)this.extendedInfo.get("com.ibm.ssl.remoteHost");
        }
        if (this.peerHost == null || 0 == this.peerHost.length()) {
            this.peerHost = "unknown";
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Target host: " + this.peerHost), (Object[])new Object[0]);
            for (int j = 0; j < chain.length; ++j) {
                Tr.debug((TraceComponent)tc, (String)"Certificate information:", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  Subject DN: " + chain[j].getSubjectDN()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  Issuer DN: " + chain[j].getIssuerDN()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  Serial number: " + chain[j].getSerialNumber()), (Object[])new Object[0]);
            }
        }
        for (int i = 0; i < this.tm.length; ++i) {
            if (this.tm[i] == null || !(this.tm[i] instanceof X509TrustManager)) continue;
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Delegating to X509TrustManager: " + this.tm[i].getClass().getName()), (Object[])new Object[0]);
                }
                ((X509TrustManager)this.tm[i]).checkServerTrusted(chain, authType);
                continue;
            }
            catch (CertificateException e) {
                boolean dateValid;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Certificate Exception occurred: " + e.getMessage()), (Object[])new Object[0]);
                }
                if (!(dateValid = this.checkIfExpiredBeforeOrAfter(chain))) {
                    throw e;
                }
                try {
                    if (!this.isServer) {
                        if (!this.autoAccept) {
                            if (this.userAcceptedPrompt(chain)) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"prompt user - adding certificate to the truststore.", (Object[])new Object[0]);
                                }
                                this.setCertificateToTruststore(chain);
                                continue;
                            }
                            this.printClientHandshakeError(this.config, this.tsFile, e, chain);
                            throw e;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"autoacceptsigner - adding certificate to the truststore.", (Object[])new Object[0]);
                        }
                        this.setCertificateToTruststore(chain);
                        continue;
                    }
                    Exception excpt = e;
                    if (excpt.getClass().toString().startsWith("class com.ibm.jsse2")) {
                        excpt = (Exception)excpt.getCause();
                    }
                    FFDCFilter.processException((Throwable)excpt, (String)this.getClass().getName(), (String)"checkServerTrusted", (Object)this, (Object[])new Object[]{chain, authType});
                    this.printClientHandshakeError(this.config, this.tsFile, e, chain);
                    throw excpt;
                }
                catch (Exception ex) {
                    throw new CertificateException(ex.getMessage());
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Server is trusted by all X509TrustManagers.", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkServerTrusted");
        }
    }

    protected boolean userAcceptedPrompt(X509Certificate[] chain) {
        boolean accepted;
        block10: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"userAcceptedPrompt", (Object[])new Object[0]);
            }
            accepted = false;
            try {
                this.stdout.println("");
                this.stdout.println(TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0100I", "*** SSL SIGNER EXCHANGE PROMPT ***"));
                this.stdout.println(TraceNLSHelper.getInstance().getFormattedMessage("ssl.trustmanager.signer.prompt.CWPKI0101I", new Object[]{this.tsFile}, "SSL signer from target host is not found in trust store " + this.tsFile + ".\n\nHere's the signer information (verify the digest value matches what is displayed at the server):"));
                for (int j = 0; j < chain.length; ++j) {
                    this.stdout.println("");
                    String shaDigest = KeyStoreManager.getInstance().generateDigest("SHA-1", chain[j]);
                    this.stdout.println(TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0102I", "  Subject DN:    ") + chain[j].getSubjectDN());
                    this.stdout.println(TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0103I", "  Issuer DN:     ") + chain[j].getIssuerDN());
                    this.stdout.println(TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0104I", "  Serial number: ") + chain[j].getSerialNumber());
                    this.stdout.println(TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0109I", "  Expires: ") + chain[j].getNotAfter());
                    this.stdout.println(TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0105I", "  SHA-1 digest:  ") + shaDigest);
                    this.stdout.println("");
                }
                String prompt = TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0107I", "Add signer to the trust store now? (y/n) ");
                String answer = this.stdin.readText(prompt);
                if (answer != null) {
                    answer = answer.trim().toLowerCase();
                }
                if (this.isYes(answer)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"User accepted the certificate, certificate added to the truststore.", (Object[])new Object[0]);
                    }
                    accepted = true;
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"User did not accept the certificate so do not store it to the truststore.", (Object[])new Object[0]);
                }
            }
            catch (Exception ex) {
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug((TraceComponent)tc, (String)"Received the following while prompting user.", (Object[])new Object[]{ex});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"userAcceptedPrompt", (Object)accepted);
        }
        return accepted;
    }

    boolean isYes(String read) {
        boolean isItYes;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isYes", (Object[])new Object[]{read});
        }
        String expectedYesShortResponse = TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.answer.yes", "y");
        String expectedYesFullResponse = TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.answer.full.yes", "yes");
        boolean bl = isItYes = expectedYesShortResponse != null && expectedYesShortResponse.length() > 0 && expectedYesShortResponse.equalsIgnoreCase(read) || expectedYesFullResponse != null && expectedYesFullResponse.length() > 0 && expectedYesFullResponse.equalsIgnoreCase(read);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isYes", (Object)isItYes);
        }
        return isItYes;
    }

    void setCertificateToTruststore(X509Certificate[] chain) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setCertificateToTruststore", (Object[])new Object[0]);
        }
        try {
            WSKeyStore wsks = KeyStoreManager.getInstance().getKeyStore(this.tsCfgAlias);
            if (wsks == null) {
                throw new Exception("Keystore " + this.tsCfgAlias + " does not exist in the configuration.");
            }
            if (wsks.getReadOnly().booleanValue()) {
                this.issueMessage("ssl.keystore.readonly.CWPKI0810I", new Object[]{this.tsCfgAlias}, "The " + this.tsCfgAlias + " keystore is read only and the certificate will not be written to the keystore file.  Trust will be accepted only for this connection.");
            } else {
                for (int j = 0; j < chain.length; ++j) {
                    String alias = chain[j].getSubjectDN().getName();
                    alias = alias.trim();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Adding alias \"" + alias + "\" to truststore \"" + this.tsFile + "\"."), (Object[])new Object[0]);
                    }
                    wsks.setCertificateEntry(alias, chain[chain.length - 1]);
                    String shaDigest = KeyStoreManager.getInstance().generateDigest("SHA-1", chain[chain.length - 1]);
                    this.issueMessage("ssl.signer.add.to.local.truststore.CWPKI0308I", new Object[]{alias, this.tsFile, shaDigest}, "CWPKI0308I: Adding signer alias \"" + alias + "\" to local keystore \"" + this.tsFile + "\" with the following SHA digest: " + shaDigest);
                    String trigger = wsks.getTrigger();
                    if (trigger.equalsIgnoreCase("disabled")) continue;
                    this.clearSSLCachesAndResetDefault();
                }
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception while trying to write certificate to the truststore. Exception is " + e.getMessage()), (Object[])new Object[0]);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setCertificateToTruststore");
        }
    }

    private String incrementAlias(KeyStore jKeyStore, String alias) throws KeyStoreException {
        String base;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("incrementAlias: " + alias), (Object[])new Object[0]);
        }
        int num = 0;
        int index = alias.lastIndexOf(95);
        if (-1 == index) {
            base = alias + '_';
        } else if (index == alias.length() - 1) {
            base = alias;
        } else {
            try {
                num = Integer.parseInt(alias.substring(++index));
                base = alias.substring(0, index);
            }
            catch (NumberFormatException nfe) {
                base = alias + '_';
            }
        }
        String newAlias = base + Integer.toString(++num);
        while (jKeyStore.containsAlias(newAlias)) {
            newAlias = base + Integer.toString(++num);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("incrementAlias: " + newAlias));
        }
        return newAlias;
    }

    private void clearSSLCachesAndResetDefault() {
        block2: {
            HashSet<File> fileCol = new HashSet<File>();
            File f = new File(this.tsFile);
            fileCol.add(f);
            try {
                AbstractJSSEProvider.clearSSLContextCache();
                KeyStoreManager.getInstance().clearJavaKeyStoresFromKeyStoreMap();
                SSLConfigManager.getInstance().resetDefaultSSLContextIfNeeded(fileCol);
                Tr.audit((TraceComponent)tc, (String)"ssl.keystore.modified.CWPKI0811I", (Object[])fileCol.toArray());
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Exception while trying to reload keystore file, exception is: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    protected boolean checkIfExpiredBeforeOrAfter(X509Certificate[] chain) {
        if (chain != null && chain[0] != null) {
            long currentTime = System.currentTimeMillis();
            long notBefore = chain[0].getNotBefore().getTime();
            long notAfter = chain[0].getNotAfter().getTime();
            if (notBefore > currentTime) {
                Tr.error((TraceComponent)tc, (String)"ssl.certificate.before.date.invalid.CWPKI0311E", (Object[])new Object[]{chain[0].getSubjectDN(), new Date(notBefore)});
                return false;
            }
            if (notAfter < currentTime) {
                Tr.error((TraceComponent)tc, (String)"ssl.certificate.end.date.invalid.CWPKI0312E", (Object[])new Object[]{chain[0].getSubjectDN(), new Date(notAfter)});
                return false;
            }
            return true;
        }
        return false;
    }

    private void printClientHandshakeError(SSLConfig cfg, String file, Exception e, X509Certificate[] chain) {
        String extendedMessage = e.getMessage();
        String subjectDN = "unknown";
        if (chain[0] != null) {
            subjectDN = chain[0].getSubjectDN().toString();
        }
        String alias = this.getProperty("com.ibm.ssl.alias", cfg, SSLConfigManager.getInstance().isServerProcess());
        Tr.error((TraceComponent)tc, (String)"ssl.client.handshake.error.CWPKI0022E", (Object[])new Object[]{subjectDN, file, alias, extendedMessage});
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAcceptedIssuers", (Object[])new Object[0]);
        }
        X509Certificate[] allIssuers = null;
        ArrayList<X509Certificate> allIssuersList = new ArrayList<X509Certificate>();
        for (int i = 0; i < this.tm.length; ++i) {
            if (!(this.tm[i] instanceof X509TrustManager)) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Delegating to X509TrustManager: " + this.tm[i].getClass().getName()), (Object[])new Object[0]);
            }
            if ((allIssuers = ((X509TrustManager)this.tm[i]).getAcceptedIssuers()) == null) continue;
            for (int j = 0; j < allIssuers.length; ++j) {
                if (allIssuersList.contains(allIssuers[j])) continue;
                allIssuersList.add(allIssuers[j]);
            }
        }
        X509Certificate[] rc = new X509Certificate[]{};
        if (allIssuersList.size() > 0) {
            rc = allIssuersList.toArray(new X509Certificate[allIssuersList.size()]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAcceptedIssuers", (Object)rc);
        }
        return rc;
    }

    protected void issueMessage(String key, Object[] args, String defaultMsg) {
        String msg = TraceNLSHelper.getInstance().getFormattedMessage(key, args, defaultMsg);
        this.printMessage(msg);
    }

    protected void printMessage(String msg) {
        int maxLength = 79;
        if (this.isDoubleByteSystem(msg)) {
            maxLength /= 2;
        }
        this.printMessage(msg, maxLength, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDoubleByteSystem(String sampleStr) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeUTF(sampleStr);
            dos.flush();
        }
        catch (IOException exc) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                dos.close();
            }
            catch (IOException exc) {}
        }
        byte[] bytes = baos.toByteArray();
        this.isDoubleByteSystem = (double)bytes.length > (double)sampleStr.length() + (double)sampleStr.length() * 0.1;
        return this.isDoubleByteSystem;
    }

    private void printMessage(String msg, int maxLength, boolean indent) {
        int maxLocalLength = maxLength;
        if (indent) {
            System.out.print(INDENT);
            maxLocalLength -= INDENT.length();
        }
        if (msg.length() <= maxLocalLength) {
            System.out.println(msg);
        } else {
            int i = msg.lastIndexOf(32, maxLocalLength);
            if (i == -1 && (i = msg.indexOf(32)) == -1) {
                System.out.println(msg);
                return;
            }
            this.printMessage(msg.substring(0, i), maxLength, false);
            this.printMessage(msg.substring(i + 1), maxLength, true);
        }
    }

    private String getProperty(String propertyName, Properties prop, boolean processIsServer) {
        String value = null;
        if (prop != null) {
            if (!processIsServer && (value = System.getProperty(propertyName)) == null) {
                value = SSLConfigManager.getInstance().getGlobalProperty(propertyName);
            }
            if (value == null) {
                value = prop.getProperty(propertyName);
            }
        } else {
            value = System.getProperty(propertyName);
            if (value == null) {
                value = SSLConfigManager.getInstance().getGlobalProperty(propertyName);
            }
        }
        return value;
    }
}

