/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ssl.Constants;
import com.ibm.websphere.ssl.SSLConfig;
import com.ibm.websphere.ssl.SSLConfigChangeEvent;
import com.ibm.websphere.ssl.SSLConfigChangeListener;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.provider.AbstractJSSEProvider;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

public class SSLConfigManager {
    private static final TraceComponent tc = Tr.register(SSLConfigManager.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");
    private boolean isServerProcess = false;
    private final Properties globalConfigProperties = new Properties();
    private final Map<String, SSLConfig> sslConfigMap = new HashMap<String, SSLConfig>();
    private final Map<String, List<SSLConfigChangeListener>> sslConfigListenerMap = new HashMap<String, List<SSLConfigChangeListener>>();
    private final Map<SSLConfigChangeListener, SSLConfigChangeEvent> sslConfigListenerEventMap = new HashMap<SSLConfigChangeListener, SSLConfigChangeEvent>();

    private SSLConfigManager() {
        JSSEProviderFactory.getInstance();
    }

    public static SSLConfigManager getInstance() {
        return Singleton.INSTANCE;
    }

    public synchronized void initializeSSL(Map<String, String> globalProps, Map<String, Map<String, String>> repertoires, Map<String, WSKeyStore> keystores, boolean reinitialize, boolean isServer) throws SSLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeSSL", (Object[])new Object[0]);
        }
        try {
            if (reinitialize) {
                AbstractJSSEProvider.clearSSLContextCache();
            }
            this.isServerProcess = isServer;
            this.loadGlobalProperties(globalProps);
            KeyStoreManager.getInstance().loadKeyStores(keystores);
            String[] existingAliases = null;
            HashSet<String> newAliases = null;
            if (reinitialize) {
                newAliases = new HashSet<String>();
                Set<String> existing = this.sslConfigMap.keySet();
                existingAliases = existing.toArray(new String[existing.size()]);
            }
            for (Map.Entry<String, Map<String, String>> repertoire : repertoires.entrySet()) {
                String alias = repertoire.getKey();
                SSLConfig config = this.parseSSLConfig(repertoire, reinitialize);
                if (config == null || !config.requiredPropertiesArePresent()) continue;
                config.setProperty("com.ibm.ssl.alias", alias);
                config.decodePasswords();
                if (reinitialize) {
                    newAliases.add(alias);
                    SSLConfig oldConfig = this.sslConfigMap.get(alias);
                    if (oldConfig == null) {
                        this.addSSLConfigToMap(alias, config);
                        continue;
                    }
                    if (!oldConfig.equals(config)) {
                        this.removeSSLConfigFromMap(alias, oldConfig);
                        this.addSSLConfigToMap(alias, config);
                        this.notifySSLConfigChangeListener(alias, "changed");
                        continue;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("New SSL config equals old SSL config for alias: " + alias), (Object[])new Object[0]);
                    continue;
                }
                this.addSSLConfigToMap(alias, config);
            }
            if (reinitialize) {
                for (int i = 0; i < existingAliases.length; ++i) {
                    String oldAlias = existingAliases[i];
                    SSLConfig oldConfig = this.sslConfigMap.get(oldAlias);
                    if (newAliases.contains(oldAlias)) continue;
                    this.removeSSLConfigFromMap(oldAlias, oldConfig);
                    this.notifySSLConfigChangeListener(oldAlias, "deleted");
                }
            }
            this.setDefaultSSLContext();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"initializeServerSSL", (Object)this);
            throw new SSLException(e);
        }
        this.checkURLHostNameVerificationProperty(reinitialize);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Total Number of SSLConfigs: " + this.sslConfigMap.size()), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeSSL");
        }
    }

    public synchronized void setDefaultSSLContext() throws Exception {
        SSLConfig defaultSSLConfig;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setDefaultSSLContext", (Object[])new Object[0]);
        }
        if ((defaultSSLConfig = this.getDefaultSSLConfig()) != null) {
            JSSEProviderFactory.getInstance(null).setServerDefaultSSLContext(defaultSSLConfig);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"There is no default SSLConfig.", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setDefaultSSLContext");
        }
    }

    public synchronized void resetDefaultSSLContextIfNeeded(Collection<File> modifiedFiles) throws Exception {
        SSLConfig defaultSSLConfig;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resetDefaultSSLContext", (Object[])new Object[0]);
        }
        if ((defaultSSLConfig = this.getDefaultSSLConfig()) != null && this.keyStoreModified(defaultSSLConfig, modifiedFiles)) {
            JSSEProviderFactory.getInstance(null).setServerDefaultSSLContext(defaultSSLConfig);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Modified keystore file are not part of the default SSL configuration.", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resetDefaultSSLContext");
        }
    }

    private boolean keyStoreModified(SSLConfig defaultSSLConfig, Collection<File> modifiedFiles) {
        block6: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"keyStoreModified", (Object[])new Object[0]);
            }
            try {
                String ksPropValue = defaultSSLConfig.getProperty("com.ibm.ssl.keyStore", null);
                String tsPropValue = defaultSSLConfig.getProperty("com.ibm.ssl.trustStore", null);
                for (File file : modifiedFiles) {
                    String path = file.getCanonicalPath();
                    if ((ksPropValue == null || !ksPropValue.replace('/', '\\').equals(path)) && (tsPropValue == null || !tsPropValue.replace('/', '\\').equals(path))) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"keyStoreModified true");
                    }
                    return true;
                }
            }
            catch (IOException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"Exception comparing file path.", (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"keyStoreModified false");
        }
        return false;
    }

    private String getSystemProperty(final String key) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key);
            }
        });
    }

    private SSLConfig parseSSLConfig(Map.Entry<String, Map<String, String>> config, boolean reinitialize) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("parseSSLConfig: " + config.getKey()), (Object[])new Object[0]);
        }
        SSLConfig rc = this.parseSecureSocketLayer(config.getValue(), reinitialize);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parseSSLConfig");
        }
        return rc;
    }

    private SSLConfig parseDefaultSecureSocketLayer() throws Exception {
        String enabledCiphers;
        String serverKeyAlias;
        String clientKeyAlias;
        String securityLevel;
        String clientAuthenticationSupported;
        String clientAuthentication;
        String contextProvider;
        String sslProtocol;
        String defaultTrustManager;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parseDefaultSecureSocketLayer", (Object[])new Object[0]);
        }
        SSLConfig sslprops = new SSLConfig();
        String defaultkeyManager = JSSEProviderFactory.getKeyManagerFactoryAlgorithm();
        if (defaultkeyManager != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Setting default KeyManager: " + defaultkeyManager), (Object[])new Object[0]);
            }
            sslprops.setProperty("com.ibm.ssl.keyManager", defaultkeyManager);
        }
        if ((defaultTrustManager = JSSEProviderFactory.getTrustManagerFactoryAlgorithm()) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Setting default TrustManager: " + defaultTrustManager), (Object[])new Object[0]);
            }
            sslprops.setProperty("com.ibm.ssl.trustManager", defaultTrustManager);
        }
        if ((sslProtocol = this.getSystemProperty("com.ibm.ssl.protocol")) != null && !sslProtocol.equals("")) {
            sslprops.setProperty("com.ibm.ssl.protocol", sslProtocol);
        }
        if ((contextProvider = this.getSystemProperty("com.ibm.ssl.contextProvider")) != null && !contextProvider.equals("")) {
            if (contextProvider.equalsIgnoreCase("IBMJSSE") || contextProvider.equalsIgnoreCase("IBMJSSEFIPS")) {
                contextProvider = "IBMJSSE2";
            }
            sslprops.setProperty("com.ibm.ssl.contextProvider", contextProvider);
        }
        if ((clientAuthentication = this.getSystemProperty("com.ibm.CSI.performTLClientAuthenticationRequired")) != null && !clientAuthentication.equals("")) {
            sslprops.setProperty("com.ibm.ssl.clientAuthentication", clientAuthentication);
        }
        if ((clientAuthenticationSupported = this.getSystemProperty("com.ibm.CSI.performTLClientAuthenticationSupported")) != null && !clientAuthenticationSupported.equals("")) {
            sslprops.setProperty("com.ibm.ssl.clientAuthenticationSupported", clientAuthenticationSupported);
        }
        if ((securityLevel = this.getSystemProperty("com.ibm.ssl.securityLevel")) != null && !securityLevel.equals("")) {
            sslprops.setProperty("com.ibm.ssl.securityLevel", securityLevel);
        }
        if ((clientKeyAlias = this.getSystemProperty("com.ibm.ssl.keyStoreClientAlias")) != null && !clientKeyAlias.equals("")) {
            sslprops.setProperty("com.ibm.ssl.keyStoreClientAlias", clientKeyAlias);
        }
        if ((serverKeyAlias = this.getSystemProperty("com.ibm.ssl.keyStoreServerAlias")) != null && 0 < serverKeyAlias.length()) {
            sslprops.setProperty("com.ibm.ssl.keyStoreServerAlias", serverKeyAlias);
        }
        if ((enabledCiphers = this.getSystemProperty("com.ibm.ssl.enabledCipherSuites")) != null && 0 < enabledCiphers.length()) {
            sslprops.setProperty("com.ibm.ssl.enabledCipherSuites", enabledCiphers);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Saving SSLConfig." + sslprops.toString()), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parseDefaultSecureSocketLayer");
        }
        return sslprops;
    }

    private SSLConfig parseSecureSocketLayer(Map<String, String> config, boolean reinitialize) throws Exception {
        String prop;
        String contextProvider;
        String sslProtocol;
        String defaultTrustManager;
        String defaultkeyManager;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parseSecureSocketLayer", (Object[])new Object[0]);
        }
        SSLConfig sslprops = new SSLConfig();
        WSKeyStore wsks_key = null;
        String keyStoreName = config.get("keyStoreRef");
        if (null != keyStoreName) {
            wsks_key = KeyStoreManager.getInstance().getKeyStore(keyStoreName);
        }
        if (wsks_key != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Adding keystore properties from KeyStore object.", (Object[])new Object[0]);
            }
            sslprops.setProperty("com.ibm.ssl.keyStoreName", keyStoreName);
            this.addSSLPropertiesFromKeyStore(wsks_key, sslprops);
        }
        String trustStoreName = config.get("trustStoreRef");
        WSKeyStore wsks_trust = null;
        if (null != trustStoreName) {
            wsks_trust = KeyStoreManager.getInstance().getKeyStore(trustStoreName);
        }
        if (wsks_trust != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Adding truststore properties from KeyStore object.", (Object[])new Object[0]);
            }
            sslprops.setProperty("com.ibm.ssl.trustStoreName", trustStoreName);
            this.addSSLPropertiesFromTrustStore(wsks_trust, sslprops);
        }
        if ((defaultkeyManager = JSSEProviderFactory.getKeyManagerFactoryAlgorithm()) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Setting default KeyManager: " + defaultkeyManager), (Object[])new Object[0]);
            }
            sslprops.setProperty("com.ibm.ssl.keyManager", defaultkeyManager);
        }
        if ((defaultTrustManager = JSSEProviderFactory.getTrustManagerFactoryAlgorithm()) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Setting default TrustManager: " + defaultTrustManager), (Object[])new Object[0]);
            }
            sslprops.setProperty("com.ibm.ssl.trustManager", defaultTrustManager);
        }
        if ((sslProtocol = config.get("sslProtocol")) != null && !sslProtocol.isEmpty()) {
            sslprops.setProperty("com.ibm.ssl.protocol", sslProtocol);
        }
        if ((contextProvider = config.get("jsseProvider")) != null && !contextProvider.isEmpty()) {
            if (contextProvider.equalsIgnoreCase("IBMJSSE") || contextProvider.equalsIgnoreCase("IBMJSSEFIPS")) {
                contextProvider = "IBMJSSE2";
            }
            sslprops.setProperty("com.ibm.ssl.contextProvider", contextProvider);
        }
        if (null != (prop = config.get("clientAuthentication")) && !prop.isEmpty()) {
            sslprops.setProperty("com.ibm.ssl.clientAuthentication", Boolean.valueOf(prop).toString());
        }
        if (null != (prop = config.get("clientAuthenticationSupported")) && !prop.isEmpty()) {
            sslprops.setProperty("com.ibm.ssl.clientAuthenticationSupported", Boolean.valueOf(prop).toString());
        }
        if (null != (prop = config.get("securityLevel")) && !prop.isEmpty()) {
            sslprops.setProperty("com.ibm.ssl.securityLevel", prop);
        }
        if (null != (prop = config.get("clientKeyAlias")) && !prop.isEmpty()) {
            sslprops.setProperty("com.ibm.ssl.keyStoreClientAlias", prop);
        }
        if (null != (prop = config.get("serverKeyAlias")) && !prop.isEmpty()) {
            sslprops.setProperty("com.ibm.ssl.keyStoreServerAlias", prop);
        }
        if (null != (prop = config.get("enabledCiphers")) && !prop.isEmpty()) {
            sslprops.setProperty("com.ibm.ssl.enabledCipherSuites", prop);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Saving SSLConfig: " + sslprops), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parseSecureSocketLayer");
        }
        return sslprops;
    }

    public synchronized void addSSLPropertiesFromKeyStore(WSKeyStore wsks, SSLConfig sslprops) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addSSLPropertiesFromKeyStore", (Object[])new Object[0]);
        }
        Enumeration<?> e = wsks.propertyNames();
        while (e.hasMoreElements()) {
            String property = (String)e.nextElement();
            String value = wsks.getProperty(property);
            sslprops.setProperty(property, value);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addSSLPropertiesFromKeyStore");
        }
    }

    public synchronized void addSSLPropertiesFromTrustStore(WSKeyStore wsts, SSLConfig sslprops) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addSSLPropertiesFromTrustStore", (Object[])new Object[0]);
        }
        Enumeration<?> e = wsts.propertyNames();
        while (e.hasMoreElements()) {
            String property = (String)e.nextElement();
            String value = wsts.getProperty(property);
            String trustManagerProperty = null;
            if (property.startsWith("com.ibm.ssl.keyStore")) {
                trustManagerProperty = property.length() == "com.ibm.ssl.keyStore".length() ? "com.ibm.ssl.trustStore" : "com.ibm.ssl.trustStore" + property.substring("com.ibm.ssl.keyStore".length());
            }
            if (trustManagerProperty == null || value == null) continue;
            sslprops.setProperty(trustManagerProperty, value);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addSSLPropertiesFromTrustStore");
        }
    }

    public synchronized String[] getSSLConfigAliases() {
        return this.sslConfigMap.keySet().toArray(new String[this.sslConfigMap.size()]);
    }

    public synchronized SSLConfig getSSLConfig(String alias) throws IllegalArgumentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getSSLConfig: " + alias), (Object[])new Object[0]);
        }
        SSLConfig rc = null;
        rc = alias == null || alias.equals("") ? this.getDefaultSSLConfig() : this.sslConfigMap.get(alias);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSSLConfig", (Object)rc);
        }
        return rc;
    }

    public synchronized void loadGlobalProperties(Map<String, String> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadGlobalProperties", (Object[])new Object[0]);
        }
        this.globalConfigProperties.clear();
        for (Map.Entry<String, String> prop : properties.entrySet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Setting global property: " + prop.getKey() + "=" + prop.getValue()), (Object[])new Object[0]);
            }
            this.globalConfigProperties.setProperty(prop.getKey(), prop.getValue());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadGlobalProperties");
        }
    }

    public synchronized Properties determineIfCSIv2SettingsApply(Properties config, Map<String, Object> connectionInfo) throws SSLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"determineIfCSIv2SettingsApply", (Object[])new Object[]{connectionInfo});
        }
        Properties newConfig = null;
        if (connectionInfo != null) {
            String endPointName = (String)connectionInfo.get("com.ibm.ssl.endPointName");
            String direction = (String)connectionInfo.get("com.ibm.ssl.direction");
            if (endPointName != null && (endPointName.equals("ORB_SSL_LISTENER_ADDRESS") || endPointName.equals("CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS") || endPointName.equals("CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS")) && direction != null && direction.equals("inbound")) {
                String sslAlias = this.globalConfigProperties.getProperty("com.ibm.ssl.csi.inbound.alias");
                if (sslAlias != null && sslAlias.length() > 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Getting inbound SSL config with alias: " + sslAlias), (Object[])new Object[0]);
                    }
                    newConfig = this.getProperties(sslAlias);
                }
                if (newConfig != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Cloning CSIv2 alias reference configuration.", (Object[])new Object[0]);
                    }
                    newConfig = (Properties)newConfig.clone();
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Cloning JSSEHelper configuration.", (Object[])new Object[0]);
                    }
                    newConfig = (Properties)config.clone();
                }
                if (newConfig != null) {
                    String claimSSLClientAuthSupported = this.globalConfigProperties.getProperty("com.ibm.CSI.claimTLClientAuthenticationSupported");
                    String claimSSLClientAuthRequired = this.globalConfigProperties.getProperty("com.ibm.CSI.claimTLClientAuthenticationRequired");
                    if (claimSSLClientAuthSupported != null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Setting client auth supported: " + claimSSLClientAuthSupported), (Object[])new Object[0]);
                        }
                        newConfig.setProperty("com.ibm.ssl.clientAuthenticationSupported", claimSSLClientAuthSupported);
                    }
                    if (claimSSLClientAuthRequired != null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Setting client auth required: " + claimSSLClientAuthRequired), (Object[])new Object[0]);
                        }
                        newConfig.setProperty("com.ibm.ssl.clientAuthentication", claimSSLClientAuthRequired);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"determineIfCSIv2SettingsApply (settings applied)");
                    }
                    return newConfig;
                }
            } else if ("IIOP".equals(endPointName) && "outbound".equals(direction)) {
                String sslAlias = this.globalConfigProperties.getProperty("com.ibm.ssl.csi.outbound.alias");
                if (sslAlias != null && sslAlias.length() > 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Getting outbound SSL config with alias: " + sslAlias), (Object[])new Object[0]);
                    }
                    newConfig = this.getProperties(sslAlias);
                }
                if (newConfig != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Cloning CSIv2 alias reference configuration.", (Object[])new Object[0]);
                    }
                    newConfig = (Properties)newConfig.clone();
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Cloning JSSEHelper configuration.", (Object[])new Object[0]);
                    }
                    newConfig = (Properties)config.clone();
                }
                if (newConfig != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"determineIfCSIv2SettingsApply (settings applied)");
                    }
                    return newConfig;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"determineIfCSIv2SettingsApply (original settings)");
        }
        return config;
    }

    public synchronized Properties getDefaultSystemProperties(boolean reinitialize) throws Exception {
        SSLConfig rc;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDefaultSystemProperties", (Object[])new Object[0]);
        }
        if (!reinitialize && null != (rc = this.sslConfigMap.get("DefaultSystemProperties"))) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getDefaultSystemProperties -> already present.");
            }
            return rc;
        }
        SSLConfig config = this.parseDefaultSecureSocketLayer();
        if (config != null && config.requiredPropertiesArePresent()) {
            config.setProperty("com.ibm.ssl.alias", "DefaultSystemProperties");
            config.setProperty("com.ibm.ssl.configURLLoadedFrom", "System Properties");
            config.decodePasswords();
            SSLConfig oldConfig = this.sslConfigMap.get("DefaultSystemProperties");
            if (oldConfig == null) {
                this.addSSLConfigToMap("DefaultSystemProperties", config);
            } else if (!oldConfig.equals(config)) {
                this.removeSSLConfigFromMap("DefaultSystemProperties", oldConfig);
                this.addSSLConfigToMap("DefaultSystemProperties", config);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"New SSL config equals old SSL config for alias: DefaultSystemProperties", (Object[])new Object[0]);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getDefaultSystemProperties -> found valid system properties");
            }
            return config;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDefaultSystemProperties -> null");
        }
        return null;
    }

    public synchronized SSLConfig getDefaultSSLConfig() throws IllegalArgumentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDefaultSSLConfig", (Object[])new Object[0]);
        }
        SSLConfig defaultSSLConfig = null;
        String defaultAlias = this.getGlobalProperty("com.ibm.ssl.defaultAlias");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("defaultAlias: " + defaultAlias), (Object[])new Object[0]);
        }
        if (defaultAlias != null && (defaultSSLConfig = this.sslConfigMap.get(defaultAlias)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("defaultAlias not null, getDefaultSSLConfig for: " + defaultAlias));
            }
            return defaultSSLConfig;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"defaultAlias is null");
        }
        return null;
    }

    public synchronized Properties getProperties(String alias) throws IllegalArgumentException {
        return this.getSSLConfig(alias);
    }

    public synchronized String getGlobalProperty(String name) {
        String value = this.getSystemProperty(name);
        if (null == value && this.globalConfigProperties != null) {
            value = this.globalConfigProperties.getProperty(name);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && value != null) {
            Tr.debug((TraceComponent)tc, (String)("getGlobalProperty -> " + name + "=" + value), (Object[])new Object[0]);
        }
        return value;
    }

    public synchronized String getGlobalProperty(String name, String defaultValue) {
        String value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGlobalProperty", (Object[])new Object[]{name, defaultValue});
        }
        if ((value = this.getGlobalProperty(name)) == null) {
            value = defaultValue;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getGlobalProperty -> " + value));
        }
        return value;
    }

    public synchronized String[] parseEnabledCiphers(String enabledCiphers) {
        if (enabledCiphers != null) {
            return enabledCiphers.split("\\s");
        }
        return null;
    }

    public synchronized String[] adjustSupportedCiphersToSecurityLevel(String[] supportedCiphers, String securityLevel) {
        return Constants.adjustSupportedCiphersToSecurityLevel(supportedCiphers, securityLevel);
    }

    public synchronized String convertCipherListToString(String[] cipherList) {
        if (cipherList == null || cipherList.length == 0) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cipherList.length; ++i) {
            if (0 < sb.length()) {
                sb.append(' ');
            }
            sb.append(cipherList[i]);
        }
        return sb.toString();
    }

    public static synchronized String mask(String inString) {
        String outString = null;
        if (inString != null) {
            char[] outStringBuffer = new char[inString.length()];
            for (int i = 0; i < inString.length(); ++i) {
                outStringBuffer[i] = 42;
            }
            outString = new String(outStringBuffer);
        }
        return outString;
    }

    public synchronized void removeSSLConfigFromMap(String alias, SSLConfig sslConfig) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeSSLConfigFromMap", (Object[])new Object[]{alias});
        }
        this.sslConfigMap.remove(alias);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeSSLConfigFromMap");
        }
    }

    public synchronized void addSSLConfigToMap(String alias, SSLConfig sslConfig) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addSSLConfigToMap: alias=" + alias), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)sslConfig.toString(), (Object[])new Object[0]);
        }
        if (this.validationEnabled()) {
            sslConfig.validateSSLConfig();
        }
        this.sslConfigMap.put(alias, sslConfig);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addSSLConfigToMap");
        }
    }

    public synchronized String toString() {
        if (this.sslConfigMap.size() > 0) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("SSLConfigManager configuration: \n");
            for (Map.Entry<String, SSLConfig> current : this.sslConfigMap.entrySet()) {
                sb.append(current.getKey());
                sb.append("===");
                sb.append(current.getValue().toString());
            }
            return sb.toString();
        }
        return "SSLConfigManager does not contain any SSL configurations.";
    }

    public synchronized boolean validationEnabled() {
        String validate = this.getGlobalProperty("com.ibm.ssl.validationEnabled");
        return validate != null && (validate.equalsIgnoreCase("true") || validate.equalsIgnoreCase("yes"));
    }

    public synchronized void checkURLHostNameVerificationProperty(boolean reinitialize) {
        String urlHostNameVerification = this.getGlobalProperty("com.ibm.ssl.performURLHostNameVerification");
        if (urlHostNameVerification == null || urlHostNameVerification.equalsIgnoreCase("false") || urlHostNameVerification.equalsIgnoreCase("no")) {
            HostnameVerifier verifier = new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(verifier);
            if (!reinitialize) {
                Tr.info((TraceComponent)tc, (String)"ssl.disable.url.hostname.verification.CWPKI0027I", (Object[])new Object[0]);
            }
        }
    }

    public synchronized void notifySSLConfigChangeListener(String alias, String state) {
        List<SSLConfigChangeListener> listenerList;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"notifySSLConfigChangeListener", (Object[])new Object[]{alias, state});
        }
        if (alias != null && (listenerList = this.sslConfigListenerMap.get(alias)) != null && listenerList.size() > 0) {
            SSLConfigChangeListener[] listenerArray = listenerList.toArray(new SSLConfigChangeListener[listenerList.size()]);
            for (int i = 0; i < listenerArray.length; ++i) {
                SSLConfigChangeEvent event = null;
                event = this.sslConfigListenerEventMap.get(listenerArray[i]);
                if (event == null) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Notifying listener[" + i + "]: " + listenerArray[i].getClass().getName()), (Object[])new Object[0]);
                }
                event.setState(state);
                SSLConfig changedConfig = this.sslConfigMap.get(alias);
                event.setChangedSSLConfig(changedConfig);
                listenerArray[i].stateChanged(event);
                if (!state.equals("deleted")) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Deregistering event for listener.", (Object[])new Object[0]);
                }
                this.sslConfigListenerEventMap.remove(listenerArray[i]);
            }
            if (state.equals("deleted")) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Deregistering all listeners for this alias due to alias deletion.", (Object[])new Object[0]);
                }
                this.sslConfigListenerMap.remove(alias);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"notifySSLConfigChangeListener");
        }
    }

    public synchronized void registerSSLConfigChangeListener(SSLConfigChangeListener listener, SSLConfigChangeEvent event) {
        List<SSLConfigChangeListener> listenerList;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerSSLConfigChangeListener", (Object[])new Object[]{listener, event});
        }
        if ((listenerList = this.sslConfigListenerMap.get(event.getAlias())) != null) {
            listenerList.add(listener);
            this.sslConfigListenerMap.put(event.getAlias(), listenerList);
        } else {
            listenerList = new ArrayList<SSLConfigChangeListener>();
            listenerList.add(listener);
            this.sslConfigListenerMap.put(event.getAlias(), listenerList);
        }
        this.sslConfigListenerEventMap.put(listener, event);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerSSLConfigChangeListener");
        }
    }

    public synchronized void deregisterSSLConfigChangeListener(SSLConfigChangeListener listener) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deregisterSSLConfigChangeListener", (Object[])new Object[]{listener});
        }
        if (null == listener) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"deregisterSSLConfigChangeListener");
            }
            return;
        }
        SSLConfigChangeEvent event = null;
        if (this.sslConfigListenerEventMap.containsKey(listener)) {
            event = this.sslConfigListenerEventMap.get(listener);
        }
        if (event != null) {
            int index;
            List<SSLConfigChangeListener> listenerList;
            String alias;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Removing listener: " + listener.getClass().getName()), (Object[])new Object[0]);
            }
            if (this.sslConfigListenerMap.containsKey(alias = event.getAlias()) && (listenerList = this.sslConfigListenerMap.get(alias)) != null && (index = listenerList.indexOf(listener)) != -1) {
                listenerList.remove(index);
            }
            this.sslConfigListenerEventMap.remove(listener);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deregisterSSLConfigChangeListener");
        }
    }

    public synchronized boolean isServerProcess() {
        return this.isServerProcess;
    }

    public synchronized boolean isClientAuthenticationEnabled() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isClientAuthenticationEnabled", (Object[])new Object[0]);
        }
        boolean auth = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isClientAuthenticationEnabled", (Object)auth);
        }
        return auth;
    }

    private static class Singleton {
        static final SSLConfigManager INSTANCE = new SSLConfigManager();

        private Singleton() {
        }
    }
}

